/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.util.EnumSet;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeInfo;
import org.vertexium.EdgeVertexPair;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.Vertex;
import org.vertexium.inmemory.InMemoryElement;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.InMemoryTableVertex;
import org.vertexium.inmemory.util.EdgeToEdgeIdIterable;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.mutation.ExistingElementMutationImpl;
import org.vertexium.query.VertexQuery;
import org.vertexium.search.IndexHint;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IterableUtils;

public class InMemoryVertex
extends InMemoryElement<InMemoryVertex>
implements Vertex {
    public InMemoryVertex(InMemoryGraph graph, String id, InMemoryTableVertex inMemoryTableElement, boolean includeHidden, Long endTime, Authorizations authorizations) {
        super(graph, id, inMemoryTableElement, includeHidden, endTime, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, Authorizations authorizations) {
        return this.getEdges(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, Authorizations authorizations) {
        String[] labels = null;
        return this.getEdgeInfos(direction, labels, authorizations);
    }

    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeInfos(direction, new String[]{label}, authorizations);
    }

    public Iterable<EdgeInfo> getEdgeInfos(Direction direction, final String[] labels, Authorizations authorizations) {
        Object results = new ConvertingIterable<Edge, EdgeInfo>(this.getEdges(direction, authorizations)){

            protected EdgeInfo convert(final Edge o) {
                return new EdgeInfo(){

                    public String getEdgeId() {
                        return o.getId();
                    }

                    public String getLabel() {
                        return o.getLabel();
                    }

                    public String getVertexId() {
                        return o.getOtherVertexId(InMemoryVertex.this.getId());
                    }
                };
            }
        };
        if (labels != null) {
            results = new FilterIterable<EdgeInfo>((Iterable)results){

                protected boolean isIncluded(EdgeInfo o) {
                    for (String label : labels) {
                        if (!o.getLabel().equals(label)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }
        return results;
    }

    public Iterable<Edge> getEdges(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(direction, fetchHints, null, authorizations);
    }

    public Iterable<Edge> getEdges(final Direction direction, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getGraph().getEdgesFromVertex(this.getId(), fetchHints, endTime, authorizations)){

            protected boolean isIncluded(Edge edge) {
                switch (direction) {
                    case IN: {
                        return edge.getVertexId(Direction.IN).equals(InMemoryVertex.this.getId());
                    }
                    case OUT: {
                        return edge.getVertexId(Direction.OUT).equals(InMemoryVertex.this.getId());
                    }
                }
                return true;
            }
        };
    }

    public Iterable<String> getEdgeIds(Direction direction, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, authorizations));
    }

    public Iterable<Edge> getEdges(Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdges(direction, InMemoryVertex.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<String> getEdgeIds(Direction direction, String label, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, label, authorizations));
    }

    public Iterable<Edge> getEdges(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(Direction direction, final String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            protected boolean isIncluded(Edge edge) {
                if (labels == null) {
                    return true;
                }
                for (String label : labels) {
                    if (!label.equals(edge.getLabel())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public Iterable<String> getEdgeIds(Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(direction, labels, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, label, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String label, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, label, authorizations));
    }

    public Iterable<Edge> getEdges(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdges(otherVertex, direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Edge> getEdges(final Vertex otherVertex, Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return new FilterIterable<Edge>(this.getEdges(direction, labels, authorizations)){

            protected boolean isIncluded(Edge edge) {
                return edge.getOtherVertexId(InMemoryVertex.this.getId()).equals(otherVertex.getId());
            }
        };
    }

    public Iterable<String> getEdgeIds(Vertex otherVertex, Direction direction, String[] labels, Authorizations authorizations) {
        return new EdgeToEdgeIdIterable(this.getEdges(otherVertex, direction, labels, authorizations));
    }

    public int getEdgeCount(Direction direction, Authorizations authorizations) {
        return IterableUtils.count(this.getEdgeIds(direction, authorizations));
    }

    public Iterable<String> getEdgeLabels(Direction direction, Authorizations authorizations) {
        return IterableUtils.toSet((Iterable)new ConvertingIterable<Edge, String>(this.getEdges(direction, authorizations)){

            protected String convert(Edge o) {
                return o.getLabel();
            }
        });
    }

    public Iterable<Vertex> getVertices(Direction direction, Authorizations authorizations) {
        return this.getVertices(direction, FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        return new ConvertingIterable<Edge, Vertex>(this.getEdges(direction, authorizations)){

            protected Vertex convert(Edge edge) {
                return InMemoryVertex.this.getOtherVertexFromEdge(edge, authorizations);
            }
        };
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, Authorizations authorizations) {
        return this.getVertices(direction, label, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getVertices(direction, InMemoryVertex.labelToArrayOrNull(label), authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getVertices(direction, labels, (EnumSet<FetchHint>)FetchHint.ALL, authorizations);
    }

    public Iterable<Vertex> getVertices(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, final Authorizations authorizations) {
        return new ConvertingIterable<Edge, Vertex>(this.getEdges(direction, labels, authorizations)){

            protected Vertex convert(Edge edge) {
                return InMemoryVertex.this.getOtherVertexFromEdge(edge, authorizations);
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, String label, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, label, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, String[] labels, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, labels, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    public Iterable<String> getVertexIds(Direction direction, Authorizations authorizations) {
        return new ConvertingIterable<Vertex, String>(this.getVertices(direction, authorizations)){

            protected String convert(Vertex o) {
                return o.getId();
            }
        };
    }

    private Vertex getOtherVertexFromEdge(Edge edge, Authorizations authorizations) {
        if (edge.getVertexId(Direction.IN).equals(this.getId())) {
            return edge.getVertex(Direction.OUT, authorizations);
        }
        if (edge.getVertexId(Direction.OUT).equals(this.getId())) {
            return edge.getVertex(Direction.IN, authorizations);
        }
        throw new IllegalStateException("Edge does not contain vertex on either end");
    }

    public VertexQuery query(Authorizations authorizations) {
        return this.query(null, authorizations);
    }

    public VertexQuery query(String queryString, Authorizations authorizations) {
        return this.getGraph().getSearchIndex().queryVertex((Graph)this.getGraph(), (Vertex)this, queryString, authorizations);
    }

    @Override
    public ExistingElementMutation<Vertex> prepareMutation() {
        return new ExistingElementMutationImpl<Vertex>((Vertex)this){

            public Vertex save(Authorizations authorizations) {
                InMemoryVertex.this.saveExistingElementMutation(this, authorizations);
                Vertex vertex = (Vertex)this.getElement();
                if (this.getIndexHint() != IndexHint.DO_NOT_INDEX) {
                    InMemoryVertex.this.saveMutationToSearchIndex((Element)vertex, this.getAlterPropertyVisibilities(), authorizations);
                }
                return vertex;
            }
        };
    }

    private static String[] labelToArrayOrNull(String label) {
        String[] stringArray;
        if (label == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = label;
        }
        return stringArray;
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), (EnumSet<FetchHint>)FetchHint.ALL, null, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), fetchHints, null, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, authorizations), fetchHints, endTime, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String label, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, label, authorizations), (EnumSet<FetchHint>)FetchHint.ALL, null, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String label, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, label, authorizations), fetchHints, null, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String[] labels, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, labels, authorizations), (EnumSet<FetchHint>)FetchHint.ALL, null, authorizations);
    }

    public Iterable<EdgeVertexPair> getEdgeVertexPairs(Direction direction, String[] labels, EnumSet<FetchHint> fetchHints, Authorizations authorizations) {
        return this.getEdgeVertexPairs(this.getEdgeInfos(direction, labels, authorizations), fetchHints, null, authorizations);
    }

    private Iterable<EdgeVertexPair> getEdgeVertexPairs(Iterable<EdgeInfo> edgeInfos, EnumSet<FetchHint> fetchHints, Long endTime, Authorizations authorizations) {
        return EdgeVertexPair.getEdgeVertexPairs((Graph)this.getGraph(), (String)this.getId(), edgeInfos, fetchHints, (Long)endTime, (Authorizations)authorizations);
    }
}

