/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.flow.rdf.ranking;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.fortytwo.flow.rdf.ranking.Handler;
import net.fortytwo.flow.rdf.ranking.WeightedValue;

public class WeightedVector<T> {
    protected Map<T, WeightedValue<T>> valueToWeightedValue;

    public WeightedVector() {
        this.valueToWeightedValue = new HashMap<T, WeightedValue<T>>();
    }

    public WeightedVector(WeightedVector<T> other) {
        this.valueToWeightedValue = new HashMap<T, WeightedValue<T>>(other.valueToWeightedValue);
    }

    protected WeightedVector(Map<T, WeightedValue<T>> map) {
        this.valueToWeightedValue = map;
    }

    public int size() {
        return this.valueToWeightedValue.size();
    }

    public Set<T> keySet() {
        return this.valueToWeightedValue.keySet();
    }

    public Collection<WeightedValue<T>> values() {
        return this.valueToWeightedValue.values();
    }

    public double getWeight(T v) {
        WeightedValue<T> wv = this.valueToWeightedValue.get(v);
        return null == wv ? 0.0 : wv.weight;
    }

    public void setWeight(T v, double weight) {
        if (0.0 == weight) {
            this.valueToWeightedValue.remove(v);
        } else {
            WeightedValue<T> wv = this.valueToWeightedValue.get(v);
            if (null == wv) {
                wv = new WeightedValue();
                wv.value = v;
                this.valueToWeightedValue.put(v, wv);
            }
            wv.weight = weight;
        }
    }

    public void addWeight(T v, double weight) {
        WeightedValue<T> wv = this.valueToWeightedValue.get(v);
        if (null == wv) {
            wv = new WeightedValue();
            wv.value = v;
            wv.weight = weight;
            this.valueToWeightedValue.put(v, wv);
        } else {
            wv.weight += weight;
            if (0.0 == wv.weight) {
                this.valueToWeightedValue.remove(v);
            }
        }
    }

    public Handler<WeightedValue<T>, Exception> createAddValueHandler() {
        return new Handler<WeightedValue<T>, Exception>(){

            @Override
            public boolean handle(WeightedValue<T> wv) throws Exception {
                Object v = wv.value;
                double w1 = WeightedVector.this.getWeight(v);
                double w2 = wv.weight;
                WeightedVector.this.setWeight(v, w1 + w2);
                return true;
            }
        };
    }

    public Handler<WeightedValue<T>, Exception> createSubtractValueHandler() {
        return new Handler<WeightedValue<T>, Exception>(){

            @Override
            public boolean handle(WeightedValue<T> wv) throws Exception {
                Object v = wv.value;
                double w1 = WeightedVector.this.getWeight(v);
                double w2 = wv.weight;
                WeightedVector.this.setWeight(v, w1 - w2);
                return true;
            }
        };
    }

    public WeightedValue<T>[] toArray() {
        WeightedValue[] wvalues = new WeightedValue[this.valueToWeightedValue.size()];
        this.valueToWeightedValue.values().toArray(wvalues);
        return wvalues;
    }

    public WeightedValue<T>[] toSortedArray() {
        WeightedValue[] wvalues = new WeightedValue[this.valueToWeightedValue.size()];
        this.valueToWeightedValue.values().toArray(wvalues);
        Comparator<WeightedValue> comp = new Comparator<WeightedValue>(){

            @Override
            public int compare(WeightedValue wv1, WeightedValue wv2) {
                return wv1.weight < wv2.weight ? 1 : (wv1.weight == wv2.weight ? 0 : -1);
            }
        };
        Arrays.sort(wvalues, comp);
        return wvalues;
    }

    public void clear() {
        this.valueToWeightedValue.clear();
    }

    public double getMagnitude() {
        double sumOfSquares = 0.0;
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            sumOfSquares += wv.weight * wv.weight;
        }
        return Math.sqrt(sumOfSquares);
    }

    public WeightedVector<T> multiplyBy(double c) {
        WeightedVector result = new WeightedVector(this);
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            result.setWeight(wv.value, wv.weight * c);
        }
        return result;
    }

    public WeightedVector<T> add(WeightedVector<T> other) {
        WeightedVector result = new WeightedVector(this);
        for (WeightedValue<T> wv : other.valueToWeightedValue.values()) {
            Object v = wv.value;
            double w1 = this.getWeight(v);
            double w2 = wv.weight;
            result.setWeight(v, w1 + w2);
        }
        return result;
    }

    public WeightedVector<T> subtract(WeightedVector<T> other) {
        WeightedVector result = new WeightedVector(this);
        for (WeightedValue<T> wv : other.valueToWeightedValue.values()) {
            Object v = wv.value;
            double w1 = this.getWeight(v);
            double w2 = wv.weight;
            result.setWeight(v, w1 - w2);
        }
        return result;
    }

    public double dotMultiplyBy(WeightedVector<T> other) {
        double result = 0.0;
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            Object v = wv.value;
            double w1 = wv.weight;
            double w2 = other.getWeight(v);
            result += w1 * w2;
        }
        return result;
    }

    public WeightedVector<T> multiplyByTransposeOf(WeightedVector<T> other) {
        WeightedVector result = new WeightedVector(this);
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            Object v = wv.value;
            double w1 = wv.weight;
            double w2 = other.getWeight(v);
            result.setWeight(v, w1 * w2);
        }
        return result;
    }

    public WeightedVector<T> positiveClip() {
        WeightedVector clipped = new WeightedVector();
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            if (!(0.0 < wv.weight)) continue;
            clipped.setWeight(wv.value, wv.weight);
        }
        return clipped;
    }

    public void normalize() {
        double m = this.getMagnitude();
        if (0.0 != m) {
            for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
                wv.weight /= m;
            }
        }
    }

    public WeightedVector<T> normalized() {
        WeightedVector<T> copy = new WeightedVector<T>(this);
        copy.normalize();
        return copy;
    }

    public void normalizeAsDist() {
        double sum = 0.0;
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            sum += wv.weight;
        }
        if (0.0 == sum) {
            return;
        }
        for (WeightedValue<T> wv : this.valueToWeightedValue.values()) {
            wv.weight /= sum;
        }
    }

    public WeightedVector<T> normalizedAsDist() {
        WeightedVector<T> copy = new WeightedVector<T>(this);
        copy.normalizeAsDist();
        return copy;
    }
}

