/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.elasticsearch;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.geo.builders.CircleBuilder;
import org.elasticsearch.common.geo.builders.PolygonBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.ExistsFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.GeoShapeFilterBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryBuilder;
import org.elasticsearch.index.query.OrFilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ExtendedStatsBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.vertexium.Authorizations;
import org.vertexium.DateOnly;
import org.vertexium.Edge;
import org.vertexium.Element;
import org.vertexium.FetchHint;
import org.vertexium.Graph;
import org.vertexium.GraphBaseWithSearchIndex;
import org.vertexium.PropertyDefinition;
import org.vertexium.TextIndexHint;
import org.vertexium.Vertex;
import org.vertexium.VertexiumException;
import org.vertexium.elasticsearch.ElasticSearchElementType;
import org.vertexium.elasticsearch.ElasticSearchGraphQueryIterable;
import org.vertexium.elasticsearch.ElasticsearchSingleDocumentSearchIndex;
import org.vertexium.elasticsearch.EmptyElasticSearchGraphQueryIterable;
import org.vertexium.elasticsearch.IndexSelectionStrategy;
import org.vertexium.elasticsearch.VertexiumNoMatchingPropertiesException;
import org.vertexium.elasticsearch.score.ScoringStrategy;
import org.vertexium.elasticsearch.utils.PagingIterable;
import org.vertexium.query.Aggregation;
import org.vertexium.query.Compare;
import org.vertexium.query.Contains;
import org.vertexium.query.GeoCompare;
import org.vertexium.query.GeohashAggregation;
import org.vertexium.query.GraphQueryWithGeohashAggregation;
import org.vertexium.query.GraphQueryWithHistogramAggregation;
import org.vertexium.query.GraphQueryWithStatisticsAggregation;
import org.vertexium.query.GraphQueryWithTermsAggregation;
import org.vertexium.query.HistogramAggregation;
import org.vertexium.query.Query;
import org.vertexium.query.QueryBase;
import org.vertexium.query.QueryParameters;
import org.vertexium.query.QueryResultsIterable;
import org.vertexium.query.QueryStringQueryParameters;
import org.vertexium.query.SimilarToTextQueryParameters;
import org.vertexium.query.SortDirection;
import org.vertexium.query.StatisticsAggregation;
import org.vertexium.query.TermsAggregation;
import org.vertexium.query.TextPredicate;
import org.vertexium.type.GeoCircle;
import org.vertexium.type.GeoHash;
import org.vertexium.type.GeoPoint;
import org.vertexium.type.GeoRect;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.IterableUtils;
import org.vertexium.util.JoinIterable;
import org.vertexium.util.VertexiumLogger;
import org.vertexium.util.VertexiumLoggerFactory;

public class ElasticSearchSingleDocumentSearchQueryBase
extends QueryBase
implements GraphQueryWithHistogramAggregation,
GraphQueryWithTermsAggregation,
GraphQueryWithGeohashAggregation,
GraphQueryWithStatisticsAggregation {
    private static final VertexiumLogger LOGGER = VertexiumLoggerFactory.getLogger(ElasticSearchSingleDocumentSearchQueryBase.class);
    public static final VertexiumLogger QUERY_LOGGER = VertexiumLoggerFactory.getQueryLogger(Query.class);
    private final Client client;
    private final boolean evaluateHasContainers;
    private final boolean evaluateQueryString;
    private final boolean evaluateSortContainers;
    private final StandardAnalyzer analyzer;
    private final ScoringStrategy scoringStrategy;
    private final IndexSelectionStrategy indexSelectionStrategy;
    private final int pageSize;

    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String queryString, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, int pageSize, Authorizations authorizations) {
        super(graph, queryString, authorizations);
        this.client = client;
        this.evaluateQueryString = false;
        this.evaluateHasContainers = true;
        this.evaluateSortContainers = false;
        this.pageSize = pageSize;
        this.scoringStrategy = scoringStrategy;
        this.analyzer = new StandardAnalyzer();
        this.indexSelectionStrategy = indexSelectionStrategy;
    }

    public ElasticSearchSingleDocumentSearchQueryBase(Client client, Graph graph, String[] similarToFields, String similarToText, ScoringStrategy scoringStrategy, IndexSelectionStrategy indexSelectionStrategy, int pageSize, Authorizations authorizations) {
        super(graph, similarToFields, similarToText, authorizations);
        this.client = client;
        this.evaluateQueryString = false;
        this.evaluateHasContainers = true;
        this.evaluateSortContainers = false;
        this.pageSize = pageSize;
        this.scoringStrategy = scoringStrategy;
        this.analyzer = new StandardAnalyzer();
        this.indexSelectionStrategy = indexSelectionStrategy;
    }

    @Deprecated
    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval, Long minDocumentCount) {
        this.addAggregation((Aggregation)new HistogramAggregation(aggregationName, fieldName, interval, minDocumentCount));
        return this;
    }

    @Deprecated
    public GraphQueryWithHistogramAggregation addHistogramAggregation(String aggregationName, String fieldName, String interval) {
        return this.addHistogramAggregation(aggregationName, fieldName, interval, null);
    }

    @Deprecated
    public GraphQueryWithTermsAggregation addTermsAggregation(String aggregationName, String fieldName) {
        this.addAggregation((Aggregation)new TermsAggregation(aggregationName, fieldName));
        return this;
    }

    @Deprecated
    public GraphQueryWithGeohashAggregation addGeohashAggregation(String aggregationName, String fieldName, int precision) {
        this.addAggregation((Aggregation)new GeohashAggregation(aggregationName, fieldName, precision));
        return this;
    }

    @Deprecated
    public GraphQueryWithStatisticsAggregation addStatisticsAggregation(String aggregationName, String field) {
        this.addAggregation((Aggregation)new StatisticsAggregation(aggregationName, field));
        return this;
    }

    public boolean isAggregationSupported(Aggregation agg) {
        if (agg instanceof HistogramAggregation) {
            return true;
        }
        if (agg instanceof TermsAggregation) {
            return true;
        }
        if (agg instanceof GeohashAggregation) {
            return true;
        }
        return agg instanceof StatisticsAggregation;
    }

    protected SearchRequestBuilder getSearchRequestBuilder(List<FilterBuilder> filters, QueryBuilder queryBuilder, ElasticSearchElementType elementType, int skip, int limit, boolean includeAggregations) {
        AndFilterBuilder filterBuilder = this.getFilterBuilder(filters);
        Object[] indicesToQuery = this.getIndexSelectionStrategy().getIndicesToQuery(this, elementType);
        if (QUERY_LOGGER.isTraceEnabled()) {
            QUERY_LOGGER.trace("indicesToQuery: %s", new Object[]{Joiner.on((String)", ").join(indicesToQuery)});
        }
        SearchRequestBuilder searchRequestBuilder = this.getClient().prepareSearch((String[])indicesToQuery).setTypes(new String[]{"element"}).setQuery((QueryBuilder)QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder)).addField("__elementType").setFrom(skip).setSize(limit);
        if (includeAggregations) {
            List<AbstractAggregationBuilder> aggs = this.getElasticsearchAggregations(this.getAggregations());
            for (AbstractAggregationBuilder aggregationBuilder : aggs) {
                searchRequestBuilder.addAggregation(aggregationBuilder);
            }
        }
        return searchRequestBuilder;
    }

    protected QueryBuilder createQueryStringQuery(QueryStringQueryParameters queryParameters) {
        String queryString = queryParameters.getQueryString();
        if (queryString == null || queryString.equals("*")) {
            return QueryBuilders.matchAllQuery();
        }
        ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
        Collection<String> fields = es.getQueryablePropertyNames(this.getGraph(), false, this.getParameters().getAuthorizations());
        QueryStringQueryBuilder qs = QueryBuilders.queryString((String)queryString);
        for (String field : fields) {
            qs = qs.field(field);
        }
        return qs;
    }

    protected List<FilterBuilder> getFilters(ElasticSearchElementType elementType) {
        String queryString;
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        if (elementType != null) {
            this.addElementTypeFilter(filters, elementType);
        }
        for (QueryBase.HasContainer has : this.getParameters().getHasContainers()) {
            if (has instanceof QueryBase.HasValueContainer) {
                filters.add(this.getFiltersForHasValueContainer((QueryBase.HasValueContainer)has));
                continue;
            }
            if (has instanceof QueryBase.HasPropertyContainer) {
                filters.add(this.getFilterForHasPropertyContainer((QueryBase.HasPropertyContainer)has));
                continue;
            }
            if (has instanceof QueryBase.HasNotPropertyContainer) {
                filters.add(this.getFilterForHasNotPropertyContainer((QueryBase.HasNotPropertyContainer)has));
                continue;
            }
            throw new VertexiumException("Unexpected type " + has.getClass().getName());
        }
        if (this.getParameters().getEdgeLabels().size() > 0) {
            String[] edgeLabelsArray = this.getParameters().getEdgeLabels().toArray(new String[this.getParameters().getEdgeLabels().size()]);
            filters.add((FilterBuilder)FilterBuilders.inFilter((String)"__edgeLabel", (String[])edgeLabelsArray));
        }
        if (this.getParameters() instanceof QueryStringQueryParameters && ((queryString = ((QueryStringQueryParameters)this.getParameters()).getQueryString()) == null || queryString.equals("*"))) {
            ElasticsearchSingleDocumentSearchIndex es = (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
            Collection<String> fields = es.getQueryableElementTypeVisibilityPropertyNames(this.getGraph(), this.getParameters().getAuthorizations());
            OrFilterBuilder atLeastOneFieldExistsFilter = new OrFilterBuilder(new FilterBuilder[0]);
            for (String field : fields) {
                atLeastOneFieldExistsFilter.add((FilterBuilder)new ExistsFilterBuilder(field));
            }
            filters.add((FilterBuilder)atLeastOneFieldExistsFilter);
        }
        return filters;
    }

    protected void applySort(SearchRequestBuilder q) {
        for (QueryBase.SortContainer sortContainer : this.getParameters().getSortContainers()) {
            SortOrder esOrder;
            SortOrder sortOrder = esOrder = sortContainer.direction == SortDirection.ASCENDING ? SortOrder.ASC : SortOrder.DESC;
            if ("__ID__".equals(sortContainer.propertyName)) {
                q.addSort("_uid", esOrder);
                continue;
            }
            if ("__edgeLabel".equals(sortContainer.propertyName)) {
                q.addSort("__edgeLabel", esOrder);
                continue;
            }
            PropertyDefinition propertyDefinition = this.getGraph().getPropertyDefinition(sortContainer.propertyName);
            if (propertyDefinition == null) continue;
            if (!propertyDefinition.isSortable()) {
                throw new VertexiumException("Cannot sort on non-sortable fields");
            }
            q.addSort(propertyDefinition.getPropertyName(), esOrder);
        }
    }

    public QueryResultsIterable<Vertex> vertices(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Vertex>(this.getParameters().getSkip(), this.getParameters().getLimit(), this.pageSize){

            @Override
            protected ElasticSearchGraphQueryIterable<Vertex> getPageIterable(int skip, int limit, boolean includeAggregations) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchSingleDocumentSearchQueryBase.this.getSearchResponse(ElasticSearchElementType.VERTEX, skip, limit, includeAggregations);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s (returning empty iterable)", new Object[]{ex.getMessage()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property: %s (returning empty iterable)", new Object[]{ex.getPropertyName()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

                    protected String convert(SearchHit searchHit) {
                        return searchHit.getId();
                    }
                });
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results %d of %d (time: %dms)", new Object[]{ids.size(), hits.getTotalHits(), searchTime / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchSingleDocumentSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable vertices = ElasticSearchSingleDocumentSearchQueryBase.this.getGraph().getVertices((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
                vertices = ElasticSearchSingleDocumentSearchQueryBase.this.sortByResultOrder(vertices, ids);
                return ElasticSearchSingleDocumentSearchQueryBase.this.createIterable(response, filterParameters, vertices, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateQueryString, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateHasContainers, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    public QueryResultsIterable<Edge> edges(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Edge>(this.getParameters().getSkip(), this.getParameters().getLimit(), this.pageSize){

            @Override
            protected ElasticSearchGraphQueryIterable<Edge> getPageIterable(int skip, int limit, boolean includeAggregations) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchSingleDocumentSearchQueryBase.this.getSearchResponse(ElasticSearchElementType.EDGE, skip, limit, includeAggregations);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s (returning empty iterable)", new Object[]{ex.getMessage()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property: %s (returning empty iterable)", new Object[]{ex.getPropertyName()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                List ids = IterableUtils.toList((Iterable)new ConvertingIterable<SearchHit, String>((Iterable)hits){

                    protected String convert(SearchHit searchHit) {
                        return searchHit.getId();
                    }
                });
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results %d of %d (time: %dms)", new Object[]{ids.size(), hits.getTotalHits(), (endTime - startTime) / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchSingleDocumentSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable edges = ElasticSearchSingleDocumentSearchQueryBase.this.getGraph().getEdges((Iterable)ids, fetchHints, filterParameters.getAuthorizations());
                edges = ElasticSearchSingleDocumentSearchQueryBase.this.sortByResultOrder(edges, ids);
                return ElasticSearchSingleDocumentSearchQueryBase.this.createIterable(response, filterParameters, edges, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateQueryString, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateHasContainers, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    public QueryResultsIterable<Element> elements(final EnumSet<FetchHint> fetchHints) {
        return new PagingIterable<Element>(this.getParameters().getSkip(), this.getParameters().getLimit(), this.pageSize){

            @Override
            protected ElasticSearchGraphQueryIterable<Element> getPageIterable(int skip, int limit, boolean includeAggregations) {
                SearchResponse response;
                long startTime = System.nanoTime();
                try {
                    response = ElasticSearchSingleDocumentSearchQueryBase.this.getSearchResponse(null, skip, limit, includeAggregations);
                }
                catch (IndexMissingException ex) {
                    LOGGER.debug("Index missing: %s (returning empty iterable)", new Object[]{ex.getMessage()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                catch (VertexiumNoMatchingPropertiesException ex) {
                    LOGGER.debug("Could not find property: %s (returning empty iterable)", new Object[]{ex.getPropertyName()});
                    return ElasticSearchSingleDocumentSearchQueryBase.this.createEmptyIterable();
                }
                SearchHits hits = response.getHits();
                ArrayList<String> vertexIds = new ArrayList<String>();
                ArrayList<String> edgeIds = new ArrayList<String>();
                ArrayList<String> ids = new ArrayList<String>();
                block7: for (SearchHit hit : hits) {
                    SearchHitField elementType = (SearchHitField)hit.getFields().get("__elementType");
                    if (elementType == null) continue;
                    ElasticSearchElementType et = ElasticSearchElementType.parse(elementType.getValue().toString());
                    ids.add(hit.getId());
                    switch (et) {
                        case VERTEX: {
                            vertexIds.add(hit.getId());
                            continue block7;
                        }
                        case EDGE: {
                            edgeIds.add(hit.getId());
                            continue block7;
                        }
                    }
                    LOGGER.warn("Unhandled element type returned: %s", new Object[]{elementType});
                }
                long endTime = System.nanoTime();
                long searchTime = endTime - startTime;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("elastic search results (vertices: %d, edges: %d = %d) of %d (time: %dms)", new Object[]{vertexIds.size(), edgeIds.size(), vertexIds.size() + edgeIds.size(), hits.getTotalHits(), (endTime - startTime) / 1000L / 1000L});
                }
                QueryParameters filterParameters = ElasticSearchSingleDocumentSearchQueryBase.this.getParameters().clone();
                filterParameters.setSkip(0L);
                Iterable vertices = IterableUtils.toElementIterable((Iterable)ElasticSearchSingleDocumentSearchQueryBase.this.getGraph().getVertices(vertexIds, fetchHints, filterParameters.getAuthorizations()));
                Iterable edges = IterableUtils.toElementIterable((Iterable)ElasticSearchSingleDocumentSearchQueryBase.this.getGraph().getEdges(edgeIds, fetchHints, filterParameters.getAuthorizations()));
                Object elements = new JoinIterable(new Iterable[]{vertices, edges});
                elements = ElasticSearchSingleDocumentSearchQueryBase.this.sortByResultOrder((Iterable)elements, ids);
                return ElasticSearchSingleDocumentSearchQueryBase.this.createIterable(response, filterParameters, elements, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateQueryString, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateHasContainers, ElasticSearchSingleDocumentSearchQueryBase.this.evaluateSortContainers, searchTime, hits);
            }
        };
    }

    private <T extends Element> Iterable<T> sortByResultOrder(Iterable<T> elements, List<String> ids) {
        ImmutableMap elementsMap = Maps.uniqueIndex(elements, (Function)new Function<T, String>(){

            public String apply(T e) {
                return e.getId();
            }
        });
        ArrayList<Element> results = new ArrayList<Element>();
        for (String id : ids) {
            Element element = (Element)elementsMap.get((Object)id);
            if (element == null) continue;
            results.add(element);
        }
        return results;
    }

    private <T extends Element> EmptyElasticSearchGraphQueryIterable<T> createEmptyIterable() {
        return new EmptyElasticSearchGraphQueryIterable(this, this.getParameters());
    }

    protected <T extends Element> ElasticSearchGraphQueryIterable<T> createIterable(SearchResponse response, QueryParameters filterParameters, Iterable<T> elements, boolean evaluateQueryString, boolean evaluateHasContainers, boolean evaluateSortContainers, long searchTime, SearchHits hits) {
        return new ElasticSearchGraphQueryIterable<T>(this, response, filterParameters, elements, evaluateQueryString, evaluateHasContainers, evaluateSortContainers, hits.getTotalHits(), searchTime, hits);
    }

    private SearchResponse getSearchResponse(ElasticSearchElementType elementType, int skip, int limit, boolean includeAggregations) {
        if (QUERY_LOGGER.isTraceEnabled()) {
            QUERY_LOGGER.trace("searching for: " + this.toString(), new Object[0]);
        }
        List<FilterBuilder> filters = this.getFilters(elementType);
        QueryBuilder query = this.createQuery(this.getParameters());
        query = this.scoringStrategy.updateQuery(query);
        SearchRequestBuilder q = this.getSearchRequestBuilder(filters, query, elementType, skip, limit, includeAggregations);
        this.applySort(q);
        if (QUERY_LOGGER.isTraceEnabled()) {
            QUERY_LOGGER.trace("query: %s", new Object[]{q});
        }
        return (SearchResponse)q.execute().actionGet();
    }

    protected FilterBuilder getFilterForHasNotPropertyContainer(QueryBase.HasNotPropertyContainer hasNotProperty) {
        String[] propertyNames;
        try {
            propertyNames = this.getPropertyNames(hasNotProperty.getKey());
            if (propertyNames.length == 0) {
                throw new VertexiumNoMatchingPropertiesException(hasNotProperty.getKey());
            }
        }
        catch (VertexiumNoMatchingPropertiesException ex) {
            return FilterBuilders.matchAllFilter();
        }
        PropertyDefinition propDef = this.getPropertyDefinition(hasNotProperty.getKey());
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        for (String propertyName : propertyNames) {
            filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.existsFilter((String)propertyName)));
            if (propDef.getDataType().equals(GeoPoint.class)) {
                filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.existsFilter((String)(propertyName + "_g"))));
                continue;
            }
            if (!this.isExactMatchPropertyDefinition(propDef)) continue;
            filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.existsFilter((String)(propertyName + "_e"))));
        }
        return this.getSingleFilterOrAndTheFilters(filters, (QueryBase.HasContainer)hasNotProperty);
    }

    protected FilterBuilder getFilterForHasPropertyContainer(QueryBase.HasPropertyContainer hasProperty) {
        String[] propertyNames = this.getPropertyNames(hasProperty.getKey());
        if (propertyNames.length == 0) {
            throw new VertexiumNoMatchingPropertiesException(hasProperty.getKey());
        }
        PropertyDefinition propDef = this.getPropertyDefinition(hasProperty.getKey());
        if (propDef == null) {
            throw new VertexiumException("Could not find property definition for property name: " + hasProperty.getKey());
        }
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        for (String propertyName : propertyNames) {
            filters.add((FilterBuilder)FilterBuilders.existsFilter((String)propertyName));
            if (propDef.getDataType().equals(GeoPoint.class)) {
                filters.add((FilterBuilder)FilterBuilders.existsFilter((String)(propertyName + "_g")));
                continue;
            }
            if (!this.isExactMatchPropertyDefinition(propDef)) continue;
            filters.add((FilterBuilder)FilterBuilders.existsFilter((String)(propertyName + "_e")));
        }
        return this.getSingleFilterOrOrTheFilters(filters, (QueryBase.HasContainer)hasProperty);
    }

    protected FilterBuilder getFiltersForHasValueContainer(QueryBase.HasValueContainer has) {
        if (has.predicate instanceof Compare) {
            return this.getFilterForComparePredicate((Compare)has.predicate, has);
        }
        if (has.predicate instanceof Contains) {
            return this.getFilterForContainsPredicate((Contains)has.predicate, has);
        }
        if (has.predicate instanceof TextPredicate) {
            return this.getFilterForTextPredicate((TextPredicate)has.predicate, has);
        }
        if (has.predicate instanceof GeoCompare) {
            return this.getFilterForGeoComparePredicate((GeoCompare)has.predicate, has);
        }
        throw new VertexiumException("Unexpected predicate type " + has.predicate.getClass().getName());
    }

    protected FilterBuilder getFilterForGeoComparePredicate(GeoCompare compare, QueryBase.HasValueContainer has) {
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block3: for (String key : keys) {
            String propertyName = key + "_g";
            switch (compare) {
                case WITHIN: {
                    Object value = has.value;
                    if (value instanceof GeoHash) {
                        value = ((GeoHash)value).toGeoRect();
                    }
                    if (value instanceof GeoCircle) {
                        GeoCircle geoCircle = (GeoCircle)value;
                        double lat = geoCircle.getLatitude();
                        double lon = geoCircle.getLongitude();
                        double distance = geoCircle.getRadius();
                        String inflatedPropertyName = this.getSearchIndex().inflatePropertyName(propertyName);
                        PropertyDefinition propertyDefinition = this.getGraph().getPropertyDefinition(inflatedPropertyName);
                        if (propertyDefinition != null && propertyDefinition.getDataType() == GeoCircle.class) {
                            CircleBuilder shapeBuilder = ShapeBuilder.newCircleBuilder().center(lon, lat).radius(distance, DistanceUnit.KILOMETERS);
                            filters.add((FilterBuilder)new GeoShapeFilterBuilder(propertyName, (ShapeBuilder)shapeBuilder));
                            continue block3;
                        }
                        filters.add((FilterBuilder)FilterBuilders.geoDistanceFilter((String)propertyName).point(lat, lon).distance(distance, DistanceUnit.KILOMETERS));
                        continue block3;
                    }
                    if (value instanceof GeoRect) {
                        GeoRect geoRect = (GeoRect)value;
                        double nwLat = geoRect.getNorthWest().getLatitude();
                        double nwLon = geoRect.getNorthWest().getLongitude();
                        double seLat = geoRect.getSouthEast().getLatitude();
                        double seLon = geoRect.getSouthEast().getLongitude();
                        String inflatedPropertyName = this.getSearchIndex().inflatePropertyName(propertyName);
                        PropertyDefinition propertyDefinition = this.getGraph().getPropertyDefinition(inflatedPropertyName);
                        if (propertyDefinition != null && propertyDefinition.getDataType() == GeoCircle.class) {
                            PolygonBuilder shapeBuilder = ((PolygonBuilder)((PolygonBuilder)((PolygonBuilder)((PolygonBuilder)ShapeBuilder.newPolygon().point(nwLon, nwLat)).point(seLon, nwLat)).point(seLon, seLat)).point(nwLon, seLat)).close();
                            filters.add((FilterBuilder)new GeoShapeFilterBuilder(propertyName, (ShapeBuilder)shapeBuilder));
                            continue block3;
                        }
                        filters.add((FilterBuilder)FilterBuilders.geoBoundingBoxFilter((String)propertyName).topLeft(nwLat, nwLon).bottomRight(seLat, seLon));
                        continue block3;
                    }
                    throw new VertexiumException("Unexpected has value type " + value.getClass().getName());
                }
                default: {
                    throw new VertexiumException("Unexpected GeoCompare predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters, (QueryBase.HasContainer)has);
    }

    private FilterBuilder getSingleFilterOrOrTheFilters(List<FilterBuilder> filters, QueryBase.HasContainer has) {
        if (filters.size() > 1) {
            return FilterBuilders.orFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        throw new VertexiumException("Unexpected filter count, expected at least 1 filter for: " + has);
    }

    private FilterBuilder getSingleFilterOrAndTheFilters(List<FilterBuilder> filters, QueryBase.HasContainer has) {
        if (filters.size() > 1) {
            return FilterBuilders.andFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        throw new VertexiumException("Unexpected filter count, expected at least 1 filter for: " + has);
    }

    protected FilterBuilder getFilterForTextPredicate(TextPredicate compare, QueryBase.HasValueContainer has) {
        Object value = has.value;
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block3: for (String key : keys) {
            if (value instanceof String) {
                value = ((String)value).toLowerCase();
            }
            switch (compare) {
                case CONTAINS: {
                    if (value instanceof String) {
                        filters.add((FilterBuilder)FilterBuilders.termsFilter((String)key, (String[])this.splitStringIntoTerms((String)value)).execution("and"));
                        continue block3;
                    }
                    filters.add((FilterBuilder)FilterBuilders.termFilter((String)key, (Object)value));
                    continue block3;
                }
                default: {
                    throw new VertexiumException("Unexpected text predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters, (QueryBase.HasContainer)has);
    }

    protected FilterBuilder getFilterForContainsPredicate(Contains contains, QueryBase.HasValueContainer has) {
        String[] keys = this.getPropertyNames(has.key);
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block4: for (String key : keys) {
            if (has.value instanceof Iterable) {
                has.value = IterableUtils.toArray((Iterable)((Iterable)has.value), Object.class);
            }
            if (has.value instanceof String || has.value instanceof String[] || has.value instanceof Object[] && ((Object[])has.value).length > 0 && ((Object[])has.value)[0] instanceof String) {
                key = key + "_e";
            }
            switch (contains) {
                case IN: {
                    filters.add((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])((Object[])has.value)));
                    continue block4;
                }
                case NOT_IN: {
                    filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])((Object[])has.value))));
                    continue block4;
                }
                default: {
                    throw new VertexiumException("Unexpected Contains predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters, (QueryBase.HasContainer)has);
    }

    protected FilterBuilder getFilterForComparePredicate(Compare compare, QueryBase.HasValueContainer has) {
        Object value = has.value;
        String[] keys = this.getPropertyNames(has.key);
        if (keys.length == 0) {
            if (compare.equals((Object)Compare.NOT_EQUAL)) {
                return FilterBuilders.matchAllFilter();
            }
            throw new VertexiumNoMatchingPropertiesException(has.key);
        }
        ArrayList<FilterBuilder> filters = new ArrayList<FilterBuilder>();
        block8: for (String key : keys) {
            if (value instanceof String || value instanceof String[]) {
                key = key + "_e";
            }
            switch (compare) {
                case EQUAL: {
                    if (value instanceof DateOnly) {
                        DateOnly dateOnlyValue = (DateOnly)value;
                        filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).from((Object)dateOnlyValue.toString()).to((Object)dateOnlyValue.toString()));
                        continue block8;
                    }
                    filters.add((FilterBuilder)FilterBuilders.termFilter((String)key, (Object)value));
                    continue block8;
                }
                case GREATER_THAN_EQUAL: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gte(value));
                    continue block8;
                }
                case GREATER_THAN: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).gt(value));
                    continue block8;
                }
                case LESS_THAN_EQUAL: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lte(value));
                    continue block8;
                }
                case LESS_THAN: {
                    filters.add((FilterBuilder)FilterBuilders.rangeFilter((String)key).lt(value));
                    continue block8;
                }
                case NOT_EQUAL: {
                    this.addNotFilter(filters, key, value);
                    continue block8;
                }
                default: {
                    throw new VertexiumException("Unexpected Compare predicate " + has.predicate);
                }
            }
        }
        return this.getSingleFilterOrOrTheFilters(filters, (QueryBase.HasContainer)has);
    }

    protected String[] getPropertyNames(String propertyName) {
        return this.getSearchIndex().getAllMatchingPropertyNames(this.getGraph(), propertyName, this.getParameters().getAuthorizations());
    }

    protected ElasticsearchSingleDocumentSearchIndex getSearchIndex() {
        return (ElasticsearchSingleDocumentSearchIndex)((GraphBaseWithSearchIndex)this.getGraph()).getSearchIndex();
    }

    protected void addElementTypeFilter(List<FilterBuilder> filters, ElasticSearchElementType elementType) {
        if (elementType != null) {
            filters.add((FilterBuilder)this.createElementTypeFilter(elementType));
        }
    }

    protected TermsFilterBuilder createElementTypeFilter(ElasticSearchElementType elementType) {
        return FilterBuilders.inFilter((String)"__elementType", (String[])new String[]{elementType.getKey()});
    }

    protected void addNotFilter(List<FilterBuilder> filters, String key, Object value) {
        filters.add((FilterBuilder)FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)key, (Object[])new Object[]{value})));
    }

    protected AndFilterBuilder getFilterBuilder(List<FilterBuilder> filters) {
        return FilterBuilders.andFilter((FilterBuilder[])filters.toArray(new FilterBuilder[filters.size()]));
    }

    private String[] splitStringIntoTerms(String value) {
        try {
            ArrayList<String> results = new ArrayList<String>();
            try (TokenStream tokens = this.analyzer.tokenStream("", value);){
                CharTermAttribute term = (CharTermAttribute)tokens.getAttribute(CharTermAttribute.class);
                tokens.reset();
                while (tokens.incrementToken()) {
                    String t = term.toString().trim();
                    if (t.length() <= 0) continue;
                    results.add(t);
                }
            }
            return results.toArray(new String[results.size()]);
        }
        catch (IOException e) {
            throw new VertexiumException("Could not tokenize string: " + value, (Throwable)e);
        }
    }

    protected QueryBuilder createQuery(QueryParameters queryParameters) {
        if (queryParameters instanceof QueryStringQueryParameters) {
            return this.createQueryStringQuery((QueryStringQueryParameters)queryParameters);
        }
        if (queryParameters instanceof SimilarToTextQueryParameters) {
            return this.createSimilarToTextQuery((SimilarToTextQueryParameters)queryParameters);
        }
        throw new VertexiumException("Query parameters not supported of type: " + queryParameters.getClass().getName());
    }

    protected QueryBuilder createSimilarToTextQuery(SimilarToTextQueryParameters queryParameters) {
        String[] fields;
        SimilarToTextQueryParameters similarTo = queryParameters;
        ArrayList allFields = new ArrayList();
        for (String field : fields = similarTo.getFields()) {
            Collections.addAll(allFields, this.getPropertyNames(field));
        }
        MoreLikeThisQueryBuilder q = QueryBuilders.moreLikeThisQuery((String[])allFields.toArray(new String[allFields.size()])).likeText(similarTo.getText());
        if (similarTo.getPercentTermsToMatch() != null) {
            q.percentTermsToMatch(similarTo.getPercentTermsToMatch().floatValue());
        }
        if (similarTo.getMinTermFrequency() != null) {
            q.minTermFreq(similarTo.getMinTermFrequency().intValue());
        }
        if (similarTo.getMaxQueryTerms() != null) {
            q.maxQueryTerms(similarTo.getMaxQueryTerms().intValue());
        }
        if (similarTo.getMinDocFrequency() != null) {
            q.minDocFreq(similarTo.getMinDocFrequency().intValue());
        }
        if (similarTo.getMaxDocFrequency() != null) {
            q.maxDocFreq(similarTo.getMaxDocFrequency().intValue());
        }
        if (similarTo.getBoost() != null) {
            q.boost(similarTo.getBoost().floatValue());
        }
        return q;
    }

    public Client getClient() {
        return this.client;
    }

    protected List<AbstractAggregationBuilder> getElasticsearchAggregations(Iterable<Aggregation> aggregations) {
        ArrayList<AbstractAggregationBuilder> aggs = new ArrayList<AbstractAggregationBuilder>();
        for (Aggregation agg : aggregations) {
            if (agg instanceof HistogramAggregation) {
                aggs.addAll(this.getElasticsearchHistogramAggregations((HistogramAggregation)agg));
                continue;
            }
            if (agg instanceof TermsAggregation) {
                aggs.addAll(this.getElasticsearchTermsAggregations((TermsAggregation)agg));
                continue;
            }
            if (agg instanceof GeohashAggregation) {
                aggs.addAll(this.getElasticsearchGeohashAggregations((GeohashAggregation)agg));
                continue;
            }
            if (agg instanceof StatisticsAggregation) {
                aggs.addAll(this.getElasticsearchStatisticsAggregations((StatisticsAggregation)agg));
                continue;
            }
            throw new VertexiumException("Could not add aggregation of type: " + agg.getClass().getName());
        }
        return aggs;
    }

    protected List<AggregationBuilder> getElasticsearchGeohashAggregations(GeohashAggregation agg) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        for (String propertyName : this.getPropertyNames(agg.getFieldName())) {
            String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
            String aggName = this.createAggregationName(agg.getAggregationName(), visibilityHash);
            GeoHashGridBuilder geoHashAgg = AggregationBuilders.geohashGrid((String)aggName);
            geoHashAgg.field(propertyName + "_g");
            geoHashAgg.precision(agg.getPrecision());
            aggs.add((AggregationBuilder)geoHashAgg);
        }
        return aggs;
    }

    protected List<AbstractAggregationBuilder> getElasticsearchStatisticsAggregations(StatisticsAggregation agg) {
        ArrayList<AbstractAggregationBuilder> aggs = new ArrayList<AbstractAggregationBuilder>();
        for (String propertyName : this.getPropertyNames(agg.getFieldName())) {
            String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
            String aggName = this.createAggregationName(agg.getAggregationName(), visibilityHash);
            ExtendedStatsBuilder statsAgg = AggregationBuilders.extendedStats((String)aggName);
            statsAgg.field(propertyName);
            aggs.add((AbstractAggregationBuilder)statsAgg);
        }
        return aggs;
    }

    private String createAggregationName(String aggName, String visibilityHash) {
        if (visibilityHash != null && visibilityHash.length() > 0) {
            return aggName + "_" + visibilityHash;
        }
        return aggName;
    }

    protected List<AggregationBuilder> getElasticsearchTermsAggregations(TermsAggregation agg) {
        ArrayList<AggregationBuilder> termsAggs = new ArrayList<AggregationBuilder>();
        String fieldName = agg.getPropertyName();
        if ("__edgeLabel".equals(fieldName)) {
            TermsBuilder termsAgg = AggregationBuilders.terms((String)this.createAggregationName(agg.getAggregationName(), "0"));
            termsAgg.field(fieldName);
            termsAggs.add((AggregationBuilder)termsAgg);
        } else {
            PropertyDefinition propertyDefinition = this.getPropertyDefinition(fieldName);
            for (String propertyName : this.getPropertyNames(fieldName)) {
                if (this.isExactMatchPropertyDefinition(propertyDefinition)) {
                    propertyName = propertyName + "_e";
                }
                String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
                TermsBuilder termsAgg = AggregationBuilders.terms((String)this.createAggregationName(agg.getAggregationName(), visibilityHash));
                termsAgg.field(propertyName);
                for (AbstractAggregationBuilder subAgg : this.getElasticsearchAggregations(agg.getNestedAggregations())) {
                    termsAgg.subAggregation(subAgg);
                }
                termsAggs.add((AggregationBuilder)termsAgg);
            }
        }
        return termsAggs;
    }

    private boolean isExactMatchPropertyDefinition(PropertyDefinition propertyDefinition) {
        return propertyDefinition != null && propertyDefinition.getDataType().equals(String.class) && propertyDefinition.getTextIndexHints().contains(TextIndexHint.EXACT_MATCH);
    }

    protected List<AggregationBuilder> getElasticsearchHistogramAggregations(HistogramAggregation agg) {
        ArrayList<AggregationBuilder> aggs = new ArrayList<AggregationBuilder>();
        PropertyDefinition propertyDefinition = this.getPropertyDefinition(agg.getFieldName());
        if (propertyDefinition == null) {
            throw new VertexiumException("Could not find mapping for property: " + agg.getFieldName());
        }
        Class propertyDataType = propertyDefinition.getDataType();
        for (String propertyName : this.getPropertyNames(agg.getFieldName())) {
            String visibilityHash = this.getSearchIndex().getPropertyVisibilityHashFromDeflatedPropertyName(propertyName);
            String aggName = this.createAggregationName(agg.getAggregationName(), visibilityHash);
            if (propertyDataType == Date.class) {
                DateHistogramBuilder dateAgg = AggregationBuilders.dateHistogram((String)aggName);
                dateAgg.field(propertyName);
                dateAgg.interval(new DateHistogram.Interval(agg.getInterval()));
                if (agg.getMinDocumentCount() != null) {
                    dateAgg.minDocCount(agg.getMinDocumentCount().longValue());
                }
                aggs.add((AggregationBuilder)dateAgg);
                continue;
            }
            HistogramBuilder histogramAgg = AggregationBuilders.histogram((String)aggName);
            histogramAgg.field(propertyName);
            histogramAgg.interval(Long.parseLong(agg.getInterval()));
            if (agg.getMinDocumentCount() != null) {
                histogramAgg.minDocCount(agg.getMinDocumentCount().longValue());
            }
            aggs.add((AggregationBuilder)histogramAgg);
        }
        return aggs;
    }

    protected PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.getGraph().getPropertyDefinition(propertyName);
    }

    protected IndexSelectionStrategy getIndexSelectionStrategy() {
        return this.indexSelectionStrategy;
    }

    public String getAggregationName(String name) {
        return this.getSearchIndex().getAggregationName(name);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "{" + "parameters=" + this.getParameters() + ", evaluateHasContainers=" + this.evaluateHasContainers + ", evaluateQueryString=" + this.evaluateQueryString + ", evaluateSortContainers=" + this.evaluateSortContainers + ", pageSize=" + this.pageSize + '}';
    }
}

