/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.mapred;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mrunit.internal.output.OutputCollectable;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class MockMapredOutputFormat<K, V>
implements OutputCollectable<K, V> {
    private static final String ATTEMPT = "attempt_000000000000_0000_m_000000_0";
    private static final TaskAttemptID TASK_ID = TaskAttemptID.forName((String)"attempt_000000000000_0000_m_000000_0");
    private final JobConf outputFormatConf;
    private final JobConf inputFormatConf;
    private final File outputPath = new File(System.getProperty("java.io.tmpdir"), "mrunit-" + Math.random());
    private final File outputFile = new File(this.outputPath, "part-00000");
    private RecordWriter recordWriter;
    private final InputFormat inputFormat;
    private final OutputFormat outputFormat;
    private final List<Pair<K, V>> outputs = new ArrayList<Pair<K, V>>();

    public MockMapredOutputFormat(JobConf outputFormatConf, Class<? extends OutputFormat> outputFormatClass, Class<? extends InputFormat> inputFormatClass, JobConf inputFormatConf) throws IOException {
        this.outputFormatConf = outputFormatConf;
        this.inputFormatConf = inputFormatConf;
        this.outputFormat = (OutputFormat)ReflectionUtils.newInstance(outputFormatClass, (Configuration)outputFormatConf);
        this.inputFormat = (InputFormat)ReflectionUtils.newInstance(inputFormatClass, (Configuration)inputFormatConf);
        if (this.outputPath.exists()) {
            throw new IllegalStateException("Generated the same random dir name twice: " + this.outputPath);
        }
        if (!this.outputPath.mkdir()) {
            throw new IOException("Failed to create output dir " + this.outputPath);
        }
        FileOutputFormat.setOutputPath((JobConf)outputFormatConf, (Path)new Path(this.outputPath.toString()));
        outputFormatConf.set("mapred.task.id", TASK_ID.toString());
        FileSystem.getLocal((Configuration)outputFormatConf).mkdirs(new Path(this.outputPath.toString(), "_temporary"));
    }

    private void setClassIfUnset(String name, Class<?> classType) {
        this.outputFormatConf.setIfUnset(name, classType.getName());
    }

    public void collect(K key, V value) throws IOException {
        if (this.recordWriter == null) {
            this.setClassIfUnset("mapred.output.key.class", key.getClass());
            this.setClassIfUnset("mapred.output.value.class", value.getClass());
            this.recordWriter = this.outputFormat.getRecordWriter((FileSystem)FileSystem.getLocal((Configuration)this.outputFormatConf), this.outputFormatConf, this.outputFile.getName(), (Progressable)Reporter.NULL);
        }
        this.recordWriter.write(key, value);
    }

    @Override
    public List<Pair<K, V>> getOutputs() throws IOException {
        this.recordWriter.close(Reporter.NULL);
        FileInputFormat.setInputPaths((JobConf)this.inputFormatConf, (String)(this.outputPath + "/*/*/*/*"));
        for (InputSplit inputSplit : this.inputFormat.getSplits(this.inputFormatConf, 1)) {
            RecordReader recordReader = this.inputFormat.getRecordReader(inputSplit, this.inputFormatConf, Reporter.NULL);
            Object key = recordReader.createKey();
            Object value = recordReader.createValue();
            while (recordReader.next(key, value)) {
                this.outputs.add(new Pair<Object, Object>(key, value));
                key = recordReader.createKey();
                value = recordReader.createValue();
            }
        }
        FileUtil.fullyDelete((File)this.outputPath);
        return this.outputs;
    }
}

