/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.testutil;

import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class TemporaryPath
extends ExternalResource {
    private final TemporaryFolder tmp = new TemporaryFolder();
    private final Set<String> confKeys;

    public TemporaryPath(String ... confKeys) {
        this.confKeys = confKeys != null ? ImmutableSet.copyOf((Object[])confKeys) : ImmutableSet.of();
    }

    public Statement apply(Statement base, Description description) {
        return this.tmp.apply(base, description);
    }

    public File getRootFile() {
        return this.tmp.getRoot();
    }

    public Path getRootPath() {
        return TemporaryPath.toPath(this.tmp.getRoot());
    }

    public String getRootFileName() {
        return this.tmp.getRoot().getAbsolutePath();
    }

    public File getFile(String fileName) {
        return new File(this.getRootFile(), fileName);
    }

    public Path getPath(String fileName) {
        return TemporaryPath.toPath(this.getFile(fileName));
    }

    public String getFileName(String fileName) {
        return this.getFile(fileName).getAbsolutePath();
    }

    public File copyResourceFile(String resourceName) throws IOException {
        File dest = new File(this.tmp.getRoot(), new File(resourceName).getName());
        this.copy(resourceName, dest);
        return dest;
    }

    public Path copyResourcePath(String resourceName) throws IOException {
        return TemporaryPath.toPath(this.copyResourceFile(resourceName));
    }

    public Configuration getDefaultConfiguration() {
        return this.overridePathProperties(new Configuration());
    }

    public Configuration overridePathProperties(Configuration conf) {
        for (String name : this.confKeys) {
            conf.set(name, this.getFileName("tmp-" + name));
        }
        return conf;
    }

    public String copyResourceFileName(String resourceName) throws IOException {
        return this.copyResourceFile(resourceName).getAbsolutePath();
    }

    private void copy(String resourceName, File dest) throws IOException {
        Files.copy((InputSupplier)Resources.newInputStreamSupplier((URL)Resources.getResource((String)resourceName)), (File)dest);
    }

    private static Path toPath(File file) {
        return new Path(file.getAbsolutePath());
    }
}

