/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.verify;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportVerifyRepositoryAction
extends TransportMasterNodeOperationAction<VerifyRepositoryRequest, VerifyRepositoryResponse> {
    private final RepositoriesService repositoriesService;
    protected final ClusterName clusterName;

    @Inject
    public TransportVerifyRepositoryAction(Settings settings, ClusterName clusterName, TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "cluster:admin/repository/verify", transportService, clusterService, threadPool, actionFilters);
        this.repositoriesService = repositoriesService;
        this.clusterName = clusterName;
    }

    @Override
    protected String executor() {
        return "management";
    }

    @Override
    protected VerifyRepositoryRequest newRequest() {
        return new VerifyRepositoryRequest();
    }

    @Override
    protected VerifyRepositoryResponse newResponse() {
        return new VerifyRepositoryResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(VerifyRepositoryRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, "");
    }

    @Override
    protected void masterOperation(final VerifyRepositoryRequest request, ClusterState state, final ActionListener<VerifyRepositoryResponse> listener) throws ElasticsearchException {
        this.repositoriesService.verifyRepository(request.name(), new ActionListener<RepositoriesService.VerifyResponse>(){

            @Override
            public void onResponse(RepositoriesService.VerifyResponse verifyResponse) {
                if (verifyResponse.failed()) {
                    listener.onFailure(new RepositoryVerificationException(request.name(), verifyResponse.failureDescription()));
                } else {
                    listener.onResponse(new VerifyRepositoryResponse(TransportVerifyRepositoryAction.this.clusterName, verifyResponse.nodes()));
                }
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }
}

