/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.component;

import org.elasticsearch.ElasticsearchIllegalStateException;

public class Lifecycle {
    private volatile State state = State.INITIALIZED;

    public State state() {
        return this.state;
    }

    public boolean initialized() {
        return this.state == State.INITIALIZED;
    }

    public boolean started() {
        return this.state == State.STARTED;
    }

    public boolean stopped() {
        return this.state == State.STOPPED;
    }

    public boolean closed() {
        return this.state == State.CLOSED;
    }

    public boolean stoppedOrClosed() {
        State state = this.state;
        return state == State.STOPPED || state == State.CLOSED;
    }

    public boolean canMoveToStarted() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new ElasticsearchIllegalStateException("Can't move to started state when closed");
        }
        throw new ElasticsearchIllegalStateException("Can't move to started with unknown state");
    }

    public boolean moveToStarted() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            this.state = State.STARTED;
            return true;
        }
        if (localState == State.STARTED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new ElasticsearchIllegalStateException("Can't move to started state when closed");
        }
        throw new ElasticsearchIllegalStateException("Can't move to started with unknown state");
    }

    public boolean canMoveToStopped() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            return true;
        }
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new ElasticsearchIllegalStateException("Can't move to started state when closed");
        }
        throw new ElasticsearchIllegalStateException("Can't move to started with unknown state");
    }

    public boolean moveToStopped() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.STARTED) {
            this.state = State.STOPPED;
            return true;
        }
        if (localState == State.INITIALIZED || localState == State.STOPPED) {
            return false;
        }
        if (localState == State.CLOSED) {
            throw new ElasticsearchIllegalStateException("Can't move to started state when closed");
        }
        throw new ElasticsearchIllegalStateException("Can't move to started with unknown state");
    }

    public boolean canMoveToClosed() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.CLOSED) {
            return false;
        }
        if (localState == State.STARTED) {
            throw new ElasticsearchIllegalStateException("Can't move to closed before moving to stopped mode");
        }
        return true;
    }

    public boolean moveToClosed() throws ElasticsearchIllegalStateException {
        State localState = this.state;
        if (localState == State.CLOSED) {
            return false;
        }
        if (localState == State.STARTED) {
            throw new ElasticsearchIllegalStateException("Can't move to closed before moving to stopped mode");
        }
        this.state = State.CLOSED;
        return true;
    }

    public String toString() {
        return this.state.toString();
    }

    public static enum State {
        INITIALIZED,
        STOPPED,
        STARTED,
        CLOSED;

    }
}

