/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;

public interface IndexFieldDataCache {
    public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(AtomicReaderContext var1, IFD var2) throws Exception;

    public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(IndexReader var1, IFD var2) throws Exception;

    public void clear();

    public void clear(String var1);

    public void clear(Object var1);

    public static class Soft
    extends FieldBased {
        public Soft(ESLogger logger, IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
            super(logger, indexService, fieldNames, fieldDataType, CacheBuilder.newBuilder().softValues(), indicesFieldDataCacheListener);
        }
    }

    public static class Resident
    extends FieldBased {
        public Resident(ESLogger logger, IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
            super(logger, indexService, fieldNames, fieldDataType, CacheBuilder.newBuilder(), indicesFieldDataCacheListener);
        }
    }

    public static abstract class FieldBased
    implements IndexFieldDataCache,
    AtomicReader.CoreClosedListener,
    RemovalListener<Key, Accountable>,
    IndexReader.ReaderClosedListener {
        private final IndexService indexService;
        private final FieldMapper.Names fieldNames;
        private final FieldDataType fieldDataType;
        private final Cache<Key, Accountable> cache;
        private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
        private final ESLogger logger;

        protected FieldBased(ESLogger logger, IndexService indexService, FieldMapper.Names fieldNames, FieldDataType fieldDataType, CacheBuilder cache, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
            assert (indexService != null);
            this.logger = logger;
            this.indexService = indexService;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
            this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
            cache.removalListener(this);
            this.cache = cache.build();
        }

        @Override
        public void onRemoval(RemovalNotification<Key, Accountable> notification) {
            Key key = notification.getKey();
            assert (key != null && key.listeners != null);
            Accountable value = notification.getValue();
            long sizeInBytes = key.sizeInBytes;
            assert (sizeInBytes >= 0L || value != null) : "Expected size [" + sizeInBytes + "] to be positive or value [" + value + "] to be non-null";
            if (sizeInBytes == -1L && value != null) {
                sizeInBytes = value.ramBytesUsed();
            }
            for (Listener listener : key.listeners) {
                try {
                    listener.onUnload(this.fieldNames, this.fieldDataType, notification.wasEvicted(), sizeInBytes);
                }
                catch (Throwable e) {
                    this.logger.error("Failed to call listener on field data cache unloading", e, new Object[0]);
                }
            }
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final AtomicReaderContext context, final IFD indexFieldData) throws Exception {
            final Key key = new Key(context.reader().getCoreCacheKey());
            Accountable accountable = this.cache.get(key, new Callable<FD>(){

                @Override
                public FD call() throws Exception {
                    IndexShard shard;
                    SegmentReaderUtils.registerCoreListener(context.reader(), FieldBased.this);
                    key.listeners.add(FieldBased.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(context.reader());
                    if (shardId != null && (shard = FieldBased.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    Object fieldData = indexFieldData.loadDirect(context);
                    for (Listener listener : key.listeners) {
                        try {
                            listener.onLoad(FieldBased.this.fieldNames, FieldBased.this.fieldDataType, (Accountable)fieldData);
                        }
                        catch (Throwable e) {
                            FieldBased.this.logger.error("Failed to call listener on atomic field data loading", e, new Object[0]);
                        }
                    }
                    key.sizeInBytes = fieldData.ramBytesUsed();
                    return fieldData;
                }
            });
            return (FD)((AtomicFieldData)accountable);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(final IndexReader indexReader, final IFD indexFieldData) throws Exception {
            final Key key = new Key(indexReader.getCoreCacheKey());
            Accountable accountable = this.cache.get(key, new Callable<Accountable>(){

                @Override
                public Accountable call() throws Exception {
                    IndexShard shard;
                    indexReader.addReaderClosedListener((IndexReader.ReaderClosedListener)FieldBased.this);
                    key.listeners.add(FieldBased.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(indexReader);
                    if (shardId != null && (shard = FieldBased.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    Accountable ifd = (Accountable)indexFieldData.localGlobalDirect(indexReader);
                    for (Listener listener : key.listeners) {
                        try {
                            listener.onLoad(FieldBased.this.fieldNames, FieldBased.this.fieldDataType, ifd);
                        }
                        catch (Throwable e) {
                            FieldBased.this.logger.error("Failed to call listener on global ordinals loading", e, new Object[0]);
                        }
                    }
                    key.sizeInBytes = ifd.ramBytesUsed();
                    return ifd;
                }
            });
            return (IFD)((IndexFieldData.Global)accountable);
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }

        @Override
        public void clear(String fieldName) {
            this.cache.invalidateAll();
        }

        @Override
        public void clear(Object coreCacheKey) {
            this.cache.invalidate(new Key(coreCacheKey));
        }

        public void onClose(Object coreCacheKey) {
            this.cache.invalidate(new Key(coreCacheKey));
        }

        public void onClose(IndexReader reader) {
            this.cache.invalidate(reader.getCoreCacheKey());
        }

        static class Key {
            final Object readerKey;
            final List<Listener> listeners = new ArrayList<Listener>();
            long sizeInBytes = -1L;

            Key(Object readerKey) {
                this.readerKey = readerKey;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                Key key = (Key)o;
                return this.readerKey.equals(key.readerKey);
            }

            public int hashCode() {
                return this.readerKey.hashCode();
            }
        }
    }

    public static class None
    implements IndexFieldDataCache {
        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(AtomicReaderContext context, IFD indexFieldData) throws Exception {
            return indexFieldData.loadDirect(context);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(IndexReader indexReader, IFD indexFieldData) throws Exception {
            return (IFD)((IndexFieldData.Global)indexFieldData.localGlobalDirect(indexReader));
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(String fieldName) {
        }

        @Override
        public void clear(Object coreCacheKey) {
        }
    }

    public static interface Listener {
        public void onLoad(FieldMapper.Names var1, FieldDataType var2, Accountable var3);

        public void onUnload(FieldMapper.Names var1, FieldDataType var2, boolean var3, long var4);
    }
}

