/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class NestedFilterBuilder
extends BaseFilterBuilder {
    private final QueryBuilder queryBuilder;
    private final FilterBuilder filterBuilder;
    private final String path;
    private Boolean join;
    private Boolean cache;
    private String cacheKey;
    private String filterName;

    public NestedFilterBuilder(String path, QueryBuilder queryBuilder) {
        this.path = path;
        this.queryBuilder = queryBuilder;
        this.filterBuilder = null;
    }

    public NestedFilterBuilder(String path, FilterBuilder filterBuilder) {
        this.path = path;
        this.queryBuilder = null;
        this.filterBuilder = filterBuilder;
    }

    public NestedFilterBuilder join(boolean join) {
        this.join = join;
        return this;
    }

    public NestedFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    public NestedFilterBuilder cacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
        return this;
    }

    public NestedFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nested");
        if (this.queryBuilder != null) {
            builder.field("query");
            this.queryBuilder.toXContent(builder, params);
        } else {
            builder.field("filter");
            this.filterBuilder.toXContent(builder, params);
        }
        if (this.join != null) {
            builder.field("join", (Object)this.join);
        }
        builder.field("path", this.path);
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        if (this.cacheKey != null) {
            builder.field("_cache_key", this.cacheKey);
        }
        builder.endObject();
    }
}

