/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.fielddata.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;
import org.elasticsearch.threadpool.ThreadPool;

public class IndicesFieldDataCache
extends AbstractComponent
implements RemovalListener<Key, Accountable> {
    public static final String FIELDDATA_CLEAN_INTERVAL_SETTING = "indices.fielddata.cache.cleanup_interval";
    public static final String FIELDDATA_CACHE_CONCURRENCY_LEVEL = "indices.fielddata.cache.concurrency_level";
    private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
    private final Cache<Key, Accountable> cache;
    private final TimeValue cleanInterval;
    private final ThreadPool threadPool;
    private volatile boolean closed = false;

    @Inject
    public IndicesFieldDataCache(Settings settings, IndicesFieldDataCacheListener indicesFieldDataCacheListener, ThreadPool threadPool) {
        super(settings);
        int concurrencyLevel;
        this.threadPool = threadPool;
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
        String size = this.componentSettings.get("size", "-1");
        long sizeInBytes = this.componentSettings.getAsMemory("size", "-1").bytes();
        TimeValue expire = this.componentSettings.getAsTime("expire", null);
        CacheBuilder<Key, Accountable> cacheBuilder = CacheBuilder.newBuilder().removalListener(this);
        if (sizeInBytes > 0L) {
            cacheBuilder.maximumWeight(sizeInBytes).weigher(new FieldDataWeigher());
        }
        if ((concurrencyLevel = settings.getAsInt(FIELDDATA_CACHE_CONCURRENCY_LEVEL, (Integer)16).intValue()) <= 0) {
            throw new ElasticsearchIllegalArgumentException("concurrency_level must be > 0 but was: " + concurrencyLevel);
        }
        cacheBuilder.concurrencyLevel(concurrencyLevel);
        if (expire != null && expire.millis() > 0L) {
            cacheBuilder.expireAfterAccess(expire.millis(), TimeUnit.MILLISECONDS);
        }
        this.logger.debug("using size [{}] [{}], expire [{}]", size, new ByteSizeValue(sizeInBytes), expire);
        this.cache = cacheBuilder.build();
        this.cleanInterval = settings.getAsTime(FIELDDATA_CLEAN_INTERVAL_SETTING, TimeValue.timeValueMinutes(1L));
        threadPool.schedule(this.cleanInterval, "same", new FieldDataCacheCleaner(this.cache, this.logger, this.threadPool, this.cleanInterval));
    }

    public void close() {
        this.cache.invalidateAll();
        this.closed = true;
    }

    public IndexFieldDataCache buildIndexFieldDataCache(IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        return new IndexFieldCache(this.logger, this.cache, this.indicesFieldDataCacheListener, indexService, index, fieldNames, fieldDataType);
    }

    public Cache<Key, Accountable> getCache() {
        return this.cache;
    }

    @Override
    public void onRemoval(RemovalNotification<Key, Accountable> notification) {
        Key key = notification.getKey();
        assert (key != null && key.listeners != null);
        IndexFieldCache indexCache = key.indexCache;
        long sizeInBytes = key.sizeInBytes;
        Accountable value = notification.getValue();
        assert (sizeInBytes >= 0L || value != null) : "Expected size [" + sizeInBytes + "] to be positive or value [" + value + "] to be non-null";
        if (sizeInBytes == -1L && value != null) {
            sizeInBytes = value.ramBytesUsed();
        }
        for (IndexFieldDataCache.Listener listener : key.listeners) {
            try {
                listener.onUnload(indexCache.fieldNames, indexCache.fieldDataType, notification.wasEvicted(), sizeInBytes);
            }
            catch (Throwable e) {
                this.logger.error("Failed to call listener on field data cache unloading", e, new Object[0]);
            }
        }
    }

    public class FieldDataCacheCleaner
    implements Runnable {
        private final Cache<Key, Accountable> cache;
        private final ESLogger logger;
        private final ThreadPool threadPool;
        private final TimeValue interval;

        public FieldDataCacheCleaner(Cache cache, ESLogger logger, ThreadPool threadPool, TimeValue interval) {
            this.cache = cache;
            this.logger = logger;
            this.threadPool = threadPool;
            this.interval = interval;
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("running periodic field data cache cleanup", new Object[0]);
            }
            try {
                this.cache.cleanUp();
            }
            catch (Exception e) {
                this.logger.warn("Exception during periodic field data cache cleanup:", e, new Object[0]);
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("periodic field data cache cleanup finished in {} milliseconds", System.currentTimeMillis() - startTime);
            }
            if (!IndicesFieldDataCache.this.closed) {
                this.threadPool.schedule(this.interval, "same", this);
            }
        }
    }

    public static class Key {
        public final IndexFieldCache indexCache;
        public final Object readerKey;
        public final List<IndexFieldDataCache.Listener> listeners = new ArrayList<IndexFieldDataCache.Listener>();
        long sizeInBytes = -1L;

        Key(IndexFieldCache indexCache, Object readerKey) {
            this.indexCache = indexCache;
            this.readerKey = readerKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Key key = (Key)o;
            if (!this.indexCache.equals(key.indexCache)) {
                return false;
            }
            return this.readerKey.equals(key.readerKey);
        }

        public int hashCode() {
            int result = this.indexCache.hashCode();
            result = 31 * result + this.readerKey.hashCode();
            return result;
        }
    }

    static class IndexFieldCache
    implements IndexFieldDataCache,
    AtomicReader.CoreClosedListener,
    IndexReader.ReaderClosedListener {
        private final ESLogger logger;
        private final IndexService indexService;
        final Index index;
        final FieldMapper.Names fieldNames;
        final FieldDataType fieldDataType;
        private final Cache<Key, Accountable> cache;
        private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;

        IndexFieldCache(ESLogger logger, Cache<Key, Accountable> cache, IndicesFieldDataCacheListener indicesFieldDataCacheListener, IndexService indexService, Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
            this.logger = logger;
            this.indexService = indexService;
            this.index = index;
            this.fieldNames = fieldNames;
            this.fieldDataType = fieldDataType;
            this.cache = cache;
            this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
            assert (indexService != null);
        }

        public void cleanUp() {
            this.cache.cleanUp();
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData<FD>> FD load(final AtomicReaderContext context, final IFD indexFieldData) throws Exception {
            final Key key = new Key(this, context.reader().getCoreCacheKey());
            Accountable accountable = this.cache.get(key, (Callable<Accountable>)new Callable<AtomicFieldData>(){

                @Override
                public AtomicFieldData call() throws Exception {
                    IndexShard shard;
                    SegmentReaderUtils.registerCoreListener(context.reader(), IndexFieldCache.this);
                    key.listeners.add(IndexFieldCache.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(context.reader());
                    if (shardId != null && (shard = IndexFieldCache.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    Object fieldData = indexFieldData.loadDirect(context);
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onLoad(IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, (Accountable)fieldData);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on atomic field data loading", e, new Object[0]);
                        }
                    }
                    key.sizeInBytes = fieldData.ramBytesUsed();
                    return fieldData;
                }
            });
            return (FD)((AtomicFieldData)accountable);
        }

        @Override
        public <FD extends AtomicFieldData, IFD extends IndexFieldData.Global<FD>> IFD load(final IndexReader indexReader, final IFD indexFieldData) throws Exception {
            final Key key = new Key(this, indexReader.getCoreCacheKey());
            Accountable accountable = this.cache.get(key, new Callable<Accountable>(){

                @Override
                public Accountable call() throws Exception {
                    IndexShard shard;
                    indexReader.addReaderClosedListener((IndexReader.ReaderClosedListener)IndexFieldCache.this);
                    key.listeners.add(IndexFieldCache.this.indicesFieldDataCacheListener);
                    ShardId shardId = ShardUtils.extractShardId(indexReader);
                    if (shardId != null && (shard = IndexFieldCache.this.indexService.shard(shardId.id())) != null) {
                        key.listeners.add(shard.fieldData());
                    }
                    Accountable ifd = (Accountable)indexFieldData.localGlobalDirect(indexReader);
                    for (IndexFieldDataCache.Listener listener : key.listeners) {
                        try {
                            listener.onLoad(IndexFieldCache.this.fieldNames, IndexFieldCache.this.fieldDataType, ifd);
                        }
                        catch (Throwable e) {
                            IndexFieldCache.this.logger.error("Failed to call listener on global ordinals loading", e, new Object[0]);
                        }
                    }
                    return ifd;
                }
            });
            return (IFD)((IndexFieldData.Global)accountable);
        }

        public void onClose(Object coreKey) {
            this.cache.invalidate(new Key(this, coreKey));
        }

        public void onClose(IndexReader reader) {
            this.cache.invalidate(new Key(this, reader.getCoreCacheKey()));
        }

        @Override
        public void clear() {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index)) continue;
                this.cache.invalidate(key);
            }
            this.cache.cleanUp();
        }

        @Override
        public void clear(String fieldName) {
            for (Key key : this.cache.asMap().keySet()) {
                if (!key.indexCache.index.equals(this.index) || !key.indexCache.fieldNames.fullName().equals(fieldName)) continue;
                this.cache.invalidate(key);
            }
        }

        @Override
        public void clear(Object coreCacheKey) {
            this.cache.invalidate(new Key(this, coreCacheKey));
        }
    }

    public static class FieldDataWeigher
    implements Weigher<Key, Accountable> {
        @Override
        public int weigh(Key key, Accountable ramUsage) {
            int weight = (int)Math.min(ramUsage.ramBytesUsed(), Integer.MAX_VALUE);
            return weight == 0 ? 1 : weight;
        }
    }
}

