/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.TimeoutClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.service.InternalIndexShard;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryCleanFilesRequest;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryFileChunkRequest;
import org.elasticsearch.indices.recovery.RecoveryFilesInfoRequest;
import org.elasticsearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.elasticsearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class RecoverySource
extends AbstractComponent {
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final ClusterService clusterService;
    private final TimeValue internalActionTimeout;
    private final TimeValue internalActionLongTimeout;

    @Inject
    public RecoverySource(Settings settings, TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings, MappingUpdatedAction mappingUpdatedAction, ClusterService clusterService) {
        super(settings);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        transportService.registerHandler("internal:index/shard/recovery/start_recovery", new StartRecoveryTransportRequestHandler());
        this.internalActionTimeout = this.componentSettings.getAsTime("internal_action_timeout", TimeValue.timeValueMinutes(15L));
        this.internalActionLongTimeout = new TimeValue(this.internalActionTimeout.millis() * 2L);
    }

    private RecoveryResponse recover(final StartRecoveryRequest request) {
        final IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().index().name());
        final InternalIndexShard shard = (InternalIndexShard)indexService.shardSafe(request.shardId().id());
        RoutingNode node = this.clusterService.state().readOnlyRoutingNodes().node(request.targetNode().id());
        if (node == null) {
            this.logger.debug("delaying recovery of {} as source node {} is unknown", request.shardId(), request.targetNode());
            throw new DelayRecoveryException("source node does not have the node [" + request.targetNode() + "] in its state yet..");
        }
        ShardRouting targetShardRouting = null;
        for (ShardRouting shardRouting : node) {
            if (!shardRouting.shardId().equals(request.shardId())) continue;
            targetShardRouting = shardRouting;
            break;
        }
        if (targetShardRouting == null) {
            this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", request.shardId(), request.targetNode());
            throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
        }
        if (!targetShardRouting.initializing()) {
            this.logger.debug("delaying recovery of {} as it is not listed as initializing on the target node {}. known shards state is [{}]", new Object[]{request.shardId(), request.targetNode(), targetShardRouting.state()});
            throw new DelayRecoveryException("source node has the state of the target shard to be [" + (Object)((Object)targetShardRouting.state()) + "], expecting to be [initializing]");
        }
        this.logger.trace("[{}][{}] starting recovery to {}, mark_as_relocated {}", request.shardId().index().name(), request.shardId().id(), request.targetNode(), request.markAsRelocated());
        final RecoveryResponse response = new RecoveryResponse();
        shard.recover(new Engine.RecoveryHandler(){

            @Override
            public void phase1(SnapshotIndexCommit snapshot) throws ElasticsearchException {
                long totalSize = 0L;
                long existingTotalSize = 0L;
                final Store store = shard.store();
                store.incRef();
                try {
                    StopWatch stopWatch = new StopWatch().start();
                    final Store.MetadataSnapshot recoverySourceMetadata = store.getMetadata(snapshot);
                    for (String name : snapshot.getFiles()) {
                        StoreFileMetaData md = recoverySourceMetadata.get(name);
                        if (md != null) continue;
                        RecoverySource.this.logger.info("Snapshot differs from actual index for file: {} meta: {}", name, recoverySourceMetadata.asMap());
                        throw new CorruptIndexException("Snapshot differs from actual index - maybe index was removed metadata has " + recoverySourceMetadata.asMap().size() + " files");
                    }
                    Store.RecoveryDiff diff = recoverySourceMetadata.recoveryDiff(new Store.MetadataSnapshot(request.existingFiles()));
                    for (StoreFileMetaData md : diff.identical) {
                        response.phase1ExistingFileNames.add(md.name());
                        response.phase1ExistingFileSizes.add(md.length());
                        existingTotalSize += md.length();
                        if (RecoverySource.this.logger.isTraceEnabled()) {
                            RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: not recovering [{}], exists in local store and has checksum [{}], size [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), md.name(), md.checksum(), md.length());
                        }
                        totalSize += md.length();
                    }
                    for (StoreFileMetaData md : Iterables.concat(diff.different, diff.missing)) {
                        if (request.existingFiles().containsKey(md.name())) {
                            RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], exists in local store, but is different: remote [{}], local [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), md.name(), request.existingFiles().get(md.name()), md);
                        } else {
                            RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering [{}], does not exists in remote", request.shardId().index().name(), request.shardId().id(), request.targetNode(), md.name());
                        }
                        response.phase1FileNames.add(md.name());
                        response.phase1FileSizes.add(md.length());
                        totalSize += md.length();
                    }
                    response.phase1TotalSize = totalSize;
                    response.phase1ExistingTotalSize = existingTotalSize;
                    RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: recovering_files [{}] with total_size [{}], reusing_files [{}] with total_size [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), response.phase1FileNames.size(), new ByteSizeValue(totalSize), response.phase1ExistingFileNames.size(), new ByteSizeValue(existingTotalSize));
                    RecoveryFilesInfoRequest recoveryInfoFilesRequest = new RecoveryFilesInfoRequest(request.recoveryId(), request.shardId(), response.phase1FileNames, response.phase1FileSizes, response.phase1ExistingFileNames, response.phase1ExistingFileSizes, response.phase1TotalSize, response.phase1ExistingTotalSize);
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/filesInfo", recoveryInfoFilesRequest, TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                    final CountDownLatch latch = new CountDownLatch(response.phase1FileNames.size());
                    final CopyOnWriteArrayList exceptions = new CopyOnWriteArrayList();
                    final AtomicReference corruptedEngine = new AtomicReference();
                    int fileIndex = 0;
                    for (final String name : response.phase1FileNames) {
                        long fileSize = response.phase1FileSizes.get(fileIndex);
                        RecoverySource.this.recoverySettings;
                        ThreadPoolExecutor pool = fileSize > RecoverySettings.SMALL_FILE_CUTOFF_BYTES ? RecoverySource.this.recoverySettings.concurrentStreamPool() : RecoverySource.this.recoverySettings.concurrentSmallFileStreamPool();
                        pool.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             * Loose catch block
                             */
                            @Override
                            public void run() {
                                IndexInput indexInput = null;
                                store.incRef();
                                StoreFileMetaData md = recoverySourceMetadata.get(name);
                                int BUFFER_SIZE = (int)RecoverySource.this.recoverySettings.fileChunkSize().bytes();
                                byte[] buf = new byte[BUFFER_SIZE];
                                indexInput = store.directory().openInput(name, IOContext.READONCE);
                                boolean shouldCompressRequest = RecoverySource.this.recoverySettings.compress();
                                if (CompressorFactory.isCompressed(indexInput)) {
                                    shouldCompressRequest = false;
                                }
                                long len = indexInput.length();
                                long readCount = 0L;
                                while (readCount < len) {
                                    if (shard.state() == IndexShardState.CLOSED) {
                                        throw new IndexShardClosedException(shard.shardId());
                                    }
                                    int toRead = readCount + (long)BUFFER_SIZE > len ? (int)(len - readCount) : BUFFER_SIZE;
                                    long position = indexInput.getFilePointer();
                                    if (RecoverySource.this.recoverySettings.rateLimiter() != null) {
                                        RecoverySource.this.recoverySettings.rateLimiter().pause((long)toRead);
                                    }
                                    indexInput.readBytes(buf, 0, toRead, false);
                                    BytesArray content = new BytesArray(buf, 0, toRead);
                                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/file_chunk", new RecoveryFileChunkRequest(request.recoveryId(), request.shardId(), md, position, content, (readCount += (long)toRead) == len), TransportRequestOptions.options().withCompress(shouldCompressRequest).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                                }
                                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexInput});
                                try {
                                    store.decRef();
                                }
                                finally {
                                    latch.countDown();
                                }
                                catch (Throwable e) {
                                    block21: {
                                        try {
                                            CorruptIndexException corruptIndexException = ExceptionsHelper.unwrap(e, CorruptIndexException.class);
                                            if (corruptIndexException != null) {
                                                if (!store.checkIntegrity(md)) {
                                                    RecoverySource.this.logger.warn("{} Corrupted file detected {} checksum mismatch", shard.shardId(), md);
                                                    if (!corruptedEngine.compareAndSet(null, corruptIndexException)) {
                                                        ((CorruptIndexException)corruptedEngine.get()).addSuppressed(e);
                                                    }
                                                } else {
                                                    RemoteTransportException exception = new RemoteTransportException("File corruption occured on recovery but checksums are ok", null);
                                                    exception.addSuppressed(e);
                                                    exceptions.add(0, exception);
                                                    RecoverySource.this.logger.warn("{} File corruption on recovery {} local checksum OK", (Throwable)corruptIndexException, shard.shardId(), md);
                                                }
                                                break block21;
                                            }
                                            exceptions.add(0, e);
                                        }
                                        catch (Throwable throwable) {
                                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexInput});
                                            try {
                                                store.decRef();
                                            }
                                            finally {
                                                latch.countDown();
                                            }
                                            throw throwable;
                                        }
                                    }
                                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexInput});
                                    try {
                                        store.decRef();
                                    }
                                    finally {
                                        latch.countDown();
                                    }
                                }
                            }
                        });
                        ++fileIndex;
                    }
                    latch.await();
                    if (corruptedEngine.get() != null) {
                        throw (CorruptIndexException)corruptedEngine.get();
                    }
                    ExceptionsHelper.rethrowAndSuppress(exceptions);
                    HashSet<String> snapshotFiles = Sets.newHashSet(snapshot.getFiles());
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/clean_files", new RecoveryCleanFilesRequest(request.recoveryId(), shard.shardId(), snapshotFiles), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                    stopWatch.stop();
                    RecoverySource.this.logger.trace("[{}][{}] recovery [phase1] to {}: took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                    response.phase1Time = stopWatch.totalTime().millis();
                }
                catch (Throwable e) {
                    throw new RecoverFilesRecoveryException(request.shardId(), response.phase1FileNames.size(), new ByteSizeValue(totalSize), e);
                }
                finally {
                    store.decRef();
                }
            }

            @Override
            public void phase2(Translog.Snapshot snapshot) throws ElasticsearchException {
                if (shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(request.shardId());
                }
                RecoverySource.this.logger.trace("{} recovery [phase2] to {}: start", request.shardId(), request.targetNode());
                StopWatch stopWatch = new StopWatch().start();
                RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/prepare_translog", new RecoveryPrepareForTranslogOperationsRequest(request.recoveryId(), request.shardId()), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                stopWatch.stop();
                response.startTime = stopWatch.totalTime().millis();
                RecoverySource.this.logger.trace("{} recovery [phase2] to {}: start took [{}]", request.shardId(), request.targetNode(), request.targetNode(), stopWatch.totalTime());
                RecoverySource.this.logger.trace("{} recovery [phase2] to {}: updating current mapping to master", request.shardId(), request.targetNode());
                this.updateMappingOnMaster();
                RecoverySource.this.logger.trace("{} recovery [phase2] to {}: sending transaction log operations", request.shardId(), request.targetNode());
                stopWatch = new StopWatch().start();
                int totalOperations = this.sendSnapshot(snapshot);
                stopWatch.stop();
                RecoverySource.this.logger.trace("{} recovery [phase2] to {}: took [{}]", request.shardId(), request.targetNode(), stopWatch.totalTime());
                response.phase2Time = stopWatch.totalTime().millis();
                response.phase2Operations = totalOperations;
            }

            private void updateMappingOnMaster() {
                BlockingQueue<DocumentMapper> documentMappersToUpdate = ConcurrentCollections.newBlockingQueue();
                CountDownLatch latch = new CountDownLatch(1);
                AtomicReference<Throwable> mappingCheckException = new AtomicReference<Throwable>();
                RecoverySource.this.clusterService.submitStateUpdateTask("recovery_mapping_check", Priority.IMMEDIATE, new MappingUpdateTask(RecoverySource.this.clusterService, RecoverySource.this.internalActionTimeout, latch, indexService, documentMappersToUpdate, mappingCheckException));
                try {
                    latch.await();
                    if (mappingCheckException.get() != null) {
                        RecoverySource.this.logger.warn("{} error during mapping check, failing recovery", mappingCheckException.get(), request.shardId());
                        throw new RecoveryFailedException(request, mappingCheckException.get());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (documentMappersToUpdate.isEmpty()) {
                    return;
                }
                final CountDownLatch updatedOnMaster = new CountDownLatch(documentMappersToUpdate.size());
                MappingUpdatedAction.MappingUpdateListener listener = new MappingUpdatedAction.MappingUpdateListener(){

                    @Override
                    public void onMappingUpdate() {
                        updatedOnMaster.countDown();
                    }

                    @Override
                    public void onFailure(Throwable t) {
                        RecoverySource.this.logger.debug("{} recovery to {}: failed to update mapping on master", request.shardId(), request.targetNode(), t);
                        updatedOnMaster.countDown();
                    }
                };
                for (DocumentMapper documentMapper : documentMappersToUpdate) {
                    RecoverySource.this.mappingUpdatedAction.updateMappingOnMaster(indexService.index().getName(), documentMapper, indexService.indexUUID(), listener);
                }
                try {
                    if (!updatedOnMaster.await(RecoverySource.this.internalActionTimeout.millis(), TimeUnit.MILLISECONDS)) {
                        RecoverySource.this.logger.debug("{} recovery [phase2] to {}: waiting on pending mapping update timed out. waited [{}]", request.shardId(), request.targetNode(), RecoverySource.this.internalActionTimeout);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    RecoverySource.this.logger.debug("interrupted while waiting for mapping to update on master", new Object[0]);
                }
            }

            @Override
            public void phase3(Translog.Snapshot snapshot) throws ElasticsearchException {
                if (shard.state() == IndexShardState.CLOSED) {
                    throw new IndexShardClosedException(request.shardId());
                }
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase3] to {}: sending transaction log operations", request.shardId().index().name(), request.shardId().id(), request.targetNode());
                StopWatch stopWatch = new StopWatch().start();
                int totalOperations = this.sendSnapshot(snapshot);
                RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/finalize", new RecoveryFinalizeRecoveryRequest(request.recoveryId(), request.shardId()), TransportRequestOptions.options().withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                if (request.markAsRelocated()) {
                    try {
                        shard.relocated("to " + request.targetNode());
                    }
                    catch (IllegalIndexShardStateException e) {
                        // empty catch block
                    }
                }
                stopWatch.stop();
                RecoverySource.this.logger.trace("[{}][{}] recovery [phase3] to {}: took [{}]", request.shardId().index().name(), request.shardId().id(), request.targetNode(), stopWatch.totalTime());
                response.phase3Time = stopWatch.totalTime().millis();
                response.phase3Operations = totalOperations;
            }

            private int sendSnapshot(Translog.Snapshot snapshot) throws ElasticsearchException {
                RecoveryTranslogOperationsRequest translogOperationsRequest;
                int ops = 0;
                long size = 0L;
                int totalOperations = 0;
                ArrayList<Translog.Operation> operations = Lists.newArrayList();
                Translog.Operation operation = snapshot.next();
                while (operation != null) {
                    if (shard.state() == IndexShardState.CLOSED) {
                        throw new IndexShardClosedException(request.shardId());
                    }
                    operations.add(operation);
                    ++totalOperations;
                    if (++ops >= RecoverySource.this.recoverySettings.translogOps() || (size += operation.estimateSize()) >= RecoverySource.this.recoverySettings.translogSize().bytes()) {
                        translogOperationsRequest = new RecoveryTranslogOperationsRequest(request.recoveryId(), request.shardId(), operations);
                        RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/translog_ops", translogOperationsRequest, TransportRequestOptions.options().withCompress(RecoverySource.this.recoverySettings.compress()).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                        ops = 0;
                        size = 0L;
                        operations.clear();
                    }
                    operation = snapshot.next();
                }
                if (!operations.isEmpty()) {
                    translogOperationsRequest = new RecoveryTranslogOperationsRequest(request.recoveryId(), request.shardId(), operations);
                    RecoverySource.this.transportService.submitRequest(request.targetNode(), "internal:index/shard/recovery/translog_ops", translogOperationsRequest, TransportRequestOptions.options().withCompress(RecoverySource.this.recoverySettings.compress()).withType(TransportRequestOptions.Type.RECOVERY).withTimeout(RecoverySource.this.internalActionLongTimeout), EmptyTransportResponseHandler.INSTANCE_SAME).txGet();
                }
                return totalOperations;
            }
        });
        return response;
    }

    private static class MappingUpdateTask
    extends TimeoutClusterStateUpdateTask {
        private final CountDownLatch latch;
        private final IndexService indexService;
        private final BlockingQueue<DocumentMapper> documentMappersToUpdate;
        private final AtomicReference<Throwable> mappingCheckException;
        private ClusterService clusterService;
        private TimeValue internalActionTimeout;

        public MappingUpdateTask(ClusterService clusterService, TimeValue internalActionTimeout, CountDownLatch latch, IndexService indexService, BlockingQueue<DocumentMapper> documentMappersToUpdate, AtomicReference<Throwable> mappingCheckException) {
            this.latch = latch;
            this.indexService = indexService;
            this.documentMappersToUpdate = documentMappersToUpdate;
            this.mappingCheckException = mappingCheckException;
            this.clusterService = clusterService;
            this.internalActionTimeout = internalActionTimeout;
        }

        @Override
        public boolean runOnlyOnMaster() {
            return false;
        }

        @Override
        public TimeValue timeout() {
            return this.internalActionTimeout;
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.latch.countDown();
        }

        @Override
        public ClusterState execute(ClusterState currentState) throws Exception {
            IndexMetaData indexMetaData = this.clusterService.state().metaData().getIndices().get(this.indexService.index().getName());
            ImmutableOpenMap<String, MappingMetaData> metaDataMappings = null;
            if (indexMetaData != null) {
                metaDataMappings = indexMetaData.getMappings();
            }
            for (DocumentMapper documentMapper : this.indexService.mapperService().docMappers(false)) {
                MappingMetaData mappingMetaData;
                MappingMetaData mappingMetaData2 = mappingMetaData = metaDataMappings == null ? null : metaDataMappings.get(documentMapper.type());
                if (mappingMetaData != null && documentMapper.refreshSource().equals(mappingMetaData.source())) continue;
                this.documentMappersToUpdate.add(documentMapper);
            }
            return currentState;
        }

        @Override
        public void onFailure(String source, Throwable t) {
            this.mappingCheckException.set(t);
            this.latch.countDown();
        }
    }

    class StartRecoveryTransportRequestHandler
    extends BaseTransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public StartRecoveryRequest newInstance() {
            return new StartRecoveryRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryResponse response = RecoverySource.this.recover(request);
            channel.sendResponse(response);
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
    }
}

