/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.builder;

import java.io.OutputStream;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.json.JacksonJsonGenerator;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.FastByteArrayOutputStream;

public class ContentBuilder {
    private final Generator generator;
    private final ValueWriter writer;

    private ContentBuilder(Generator generator, ValueWriter writer) {
        Assert.notNull(generator);
        this.generator = generator;
        this.writer = writer;
    }

    public static ContentBuilder generate(ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(new FastByteArrayOutputStream()), writer);
    }

    public static ContentBuilder generate(OutputStream bos, ValueWriter writer) {
        return new ContentBuilder(new JacksonJsonGenerator(bos), writer);
    }

    public ContentBuilder nullValue() {
        this.generator.writeNull();
        return this;
    }

    public ContentBuilder field(String name, String value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeString(value);
        }
        return this;
    }

    public ContentBuilder field(String name, byte[] value) {
        this.field(name);
        this.generator.writeBinary(value);
        return this;
    }

    public ContentBuilder field(String name, byte[] value, int offset, int len) {
        this.field(name);
        this.generator.writeBinary(value, offset, len);
        return this;
    }

    public ContentBuilder field(String name, boolean value) {
        this.field(name);
        this.generator.writeBoolean(value);
        return this;
    }

    public ContentBuilder field(String name, Boolean value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeBoolean(value);
        }
        return this;
    }

    public ContentBuilder field(String name, short value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Short value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public ContentBuilder field(String name, byte value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Byte value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public ContentBuilder field(String name, int value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Integer value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public ContentBuilder field(String name, long value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Long value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public ContentBuilder field(String name, float value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Float value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value.floatValue());
        }
        return this;
    }

    public ContentBuilder field(String name, double value) {
        this.field(name);
        this.generator.writeNumber(value);
        return this;
    }

    public ContentBuilder field(String name, Double value) {
        this.field(name);
        if (value == null) {
            this.generator.writeNull();
        } else {
            this.generator.writeNumber(value);
        }
        return this;
    }

    public ContentBuilder field(String name, Iterable<?> value) {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public ContentBuilder field(String name, Object ... value) {
        this.startArray(name);
        for (Object o : value) {
            this.value(o);
        }
        this.endArray();
        return this;
    }

    public ContentBuilder startObject() {
        this.generator.writeBeginObject();
        return this;
    }

    public ContentBuilder endObject() {
        this.generator.writeEndObject();
        return this;
    }

    public ContentBuilder startArray() {
        this.generator.writeBeginArray();
        return this;
    }

    public ContentBuilder endArray() {
        this.generator.writeEndArray();
        return this;
    }

    public ContentBuilder startArray(String name) {
        this.field(name);
        this.startArray();
        return this;
    }

    public ContentBuilder field(String name) {
        this.generator.writeFieldName(name);
        return this;
    }

    public ContentBuilder field(String name, Object value) {
        this.field(name);
        this.value(value);
        return this;
    }

    public ContentBuilder value(Object value) {
        if (!this.writer.write(value, this.generator)) {
            throw new EsHadoopSerializationException(String.format("Cannot handle type [%s], instance [%s] using writer [%s]", value.getClass(), value, this.writer));
        }
        return this;
    }

    public ContentBuilder flush() {
        this.generator.flush();
        return this;
    }

    public OutputStream content() {
        return (OutputStream)this.generator.getOutputTarget();
    }

    public void close() {
        this.generator.close();
    }
}

