/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.rdfjson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Model;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.TreeModel;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.RioSetting;
import org.openrdf.rio.WriterConfig;
import org.openrdf.rio.helpers.BasicWriterSettings;
import org.openrdf.rio.helpers.RDFWriterBase;
import org.openrdf.rio.rdfjson.RDFJSONUtility;

public class RDFJSONWriter
extends RDFWriterBase
implements RDFWriter {
    private Writer writer;
    private OutputStream outputStream;
    private Model graph;
    private final RDFFormat actualFormat;

    public RDFJSONWriter(OutputStream out, RDFFormat actualFormat) {
        this.outputStream = out;
        this.actualFormat = actualFormat;
    }

    public RDFJSONWriter(Writer writer, RDFFormat actualFormat) {
        this.writer = writer;
        this.actualFormat = actualFormat;
    }

    public void endRDF() throws RDFHandlerException {
        block4: {
            try {
                if (this.writer != null) {
                    JsonGenerator jg = RDFJSONUtility.JSON_FACTORY.createJsonGenerator(this.writer);
                    RDFJSONWriter.modelToRdfJsonInternal(this.graph, this.getWriterConfig(), jg);
                    jg.close();
                    this.writer.flush();
                    break block4;
                }
                if (this.outputStream != null) {
                    JsonGenerator jg = RDFJSONUtility.JSON_FACTORY.createJsonGenerator(this.outputStream);
                    RDFJSONWriter.modelToRdfJsonInternal(this.graph, this.getWriterConfig(), jg);
                    jg.close();
                    this.outputStream.flush();
                    break block4;
                }
                throw new IllegalStateException("The output stream and the writer were both null.");
            }
            catch (IOException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    public RDFFormat getRDFFormat() {
        return this.actualFormat;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet results = new HashSet(super.getSupportedSettings());
        results.add(BasicWriterSettings.PRETTY_PRINT);
        return results;
    }

    public void handleComment(String comment) throws RDFHandlerException {
    }

    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
    }

    public void handleStatement(Statement statement) throws RDFHandlerException {
        this.graph.add((Object)statement);
    }

    public void startRDF() throws RDFHandlerException {
        this.graph = new TreeModel();
    }

    public static void writeObject(Value object, Set<Resource> contexts, JsonGenerator jg) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        if (object instanceof Literal) {
            jg.writeObjectField("value", (Object)object.stringValue());
            jg.writeObjectField("type", (Object)"literal");
            Literal l = (Literal)object;
            if (l.getLanguage() != null) {
                jg.writeObjectField("lang", (Object)l.getLanguage());
            }
            if (l.getDatatype() != null) {
                jg.writeObjectField("datatype", (Object)l.getDatatype().stringValue());
            }
        } else if (object instanceof BNode) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((BNode)object)));
            jg.writeObjectField("type", (Object)"bnode");
        } else if (object instanceof URI) {
            jg.writeObjectField("value", (Object)RDFJSONWriter.resourceToString((Resource)((URI)object)));
            jg.writeObjectField("type", (Object)"uri");
        }
        if (!(contexts == null || contexts.isEmpty() || contexts.size() == 1 && contexts.iterator().next() == null)) {
            jg.writeArrayFieldStart("graphs");
            for (Resource nextContext : contexts) {
                if (nextContext == null) {
                    jg.writeNull();
                    continue;
                }
                jg.writeString(nextContext.stringValue());
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    public static String resourceToString(Resource uriOrBnode) {
        if (uriOrBnode instanceof URI) {
            return uriOrBnode.stringValue();
        }
        return "_:" + ((BNode)uriOrBnode).getID();
    }

    public static void modelToRdfJsonInternal(Model graph, WriterConfig writerConfig, JsonGenerator jg) throws IOException, JsonGenerationException {
        if (((Boolean)writerConfig.get(BasicWriterSettings.PRETTY_PRINT)).booleanValue()) {
            jg.useDefaultPrettyPrinter();
        }
        jg.writeStartObject();
        for (Resource nextSubject : graph.subjects()) {
            jg.writeObjectFieldStart(RDFJSONWriter.resourceToString(nextSubject));
            for (URI nextPredicate : graph.filter(nextSubject, null, null, new Resource[0]).predicates()) {
                jg.writeArrayFieldStart(nextPredicate.stringValue());
                for (Value nextObject : graph.filter(nextSubject, nextPredicate, null, new Resource[0]).objects()) {
                    Set contexts = graph.filter(nextSubject, nextPredicate, nextObject, new Resource[0]).contexts();
                    RDFJSONWriter.writeObject(nextObject, contexts, jg);
                }
                jg.writeEndArray();
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }
}

