/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.format;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.log4j.Logger;

public class DeleterFormatter
extends DefaultFormatter {
    private static final Logger log = Logger.getLogger(DeleterFormatter.class);
    private BatchWriter writer;
    private Shell shellState;
    private boolean printTimestamps;
    private boolean force;
    private boolean more;

    public DeleterFormatter(BatchWriter writer, Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, Shell shellState, boolean force) {
        super.initialize(scanner, printTimestamps);
        this.writer = writer;
        this.shellState = shellState;
        this.printTimestamps = printTimestamps;
        this.force = force;
        this.more = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.getScannerIterator().hasNext() || !this.more) {
            block4: {
                try {
                    this.writer.close();
                }
                catch (MutationsRejectedException e) {
                    log.error((Object)e.toString());
                    if (!Shell.isDebuggingEnabled()) break block4;
                    for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                        log.trace((Object)cvs.toString());
                    }
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        Map.Entry<Key, Value> next = this.getScannerIterator().next();
        Key key = next.getKey();
        Mutation m = new Mutation(key.getRow());
        String entryStr = DeleterFormatter.formatEntry(next, this.printTimestamps);
        boolean delete = this.force;
        try {
            block7: {
                if (!this.force) {
                    this.shellState.getReader().flush();
                    String line = this.shellState.getReader().readLine("Delete { " + entryStr + " } ? ");
                    this.more = line != null;
                    boolean bl = delete = line != null && (line.equalsIgnoreCase("y") || line.equalsIgnoreCase("yes"));
                }
                if (delete) {
                    m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibility()), key.getTimestamp());
                    try {
                        this.writer.addMutation(m);
                    }
                    catch (MutationsRejectedException e) {
                        log.error((Object)e.toString());
                        if (!Shell.isDebuggingEnabled()) break block7;
                        for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                            log.trace((Object)cvs.toString());
                        }
                    }
                }
            }
            this.shellState.getReader().print((CharSequence)String.format("[%s] %s%n", delete ? "DELETED" : "SKIPPED", entryStr));
        }
        catch (IOException e) {
            log.error((Object)"Cannot write to console", (Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }
}

