/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public abstract class ShellPluginConfigurationCommand
extends Shell.Command {
    private Option removePluginOption;
    private Option pluginClassOption;
    private Option listPluginOption;
    private String pluginType;
    private Property tableProp;
    private String classOpt;

    ShellPluginConfigurationCommand(String typeName, Property tableProp, String classOpt) {
        this.pluginType = typeName;
        this.tableProp = tableProp;
        this.classOpt = classOpt;
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        if (cl.hasOption(this.removePluginOption.getOpt())) {
            this.removePlugin(cl, shellState, tableName);
            shellState.getReader().println((CharSequence)("Removed " + this.pluginType + " on " + tableName));
        } else if (cl.hasOption(this.listPluginOption.getOpt())) {
            for (Map.Entry<String, String> ent : shellState.getConnector().tableOperations().getProperties(tableName)) {
                if (!ent.getKey().startsWith(this.tableProp.toString())) continue;
                shellState.getReader().println((CharSequence)(ent.getKey() + ": " + ent.getValue()));
            }
        } else {
            String className = cl.getOptionValue(this.pluginClassOption.getOpt());
            this.setPlugin(cl, shellState, tableName, className);
        }
        return 0;
    }

    protected void setPlugin(CommandLine cl, Shell shellState, String tableName, String className) throws AccumuloException, AccumuloSecurityException {
        shellState.getConnector().tableOperations().setProperty(tableName, this.tableProp.toString(), className);
    }

    protected void removePlugin(CommandLine cl, Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        shellState.getConnector().tableOperations().removeProperty(tableName, this.tableProp.toString());
    }

    public static <T> Class<? extends T> getPluginClass(String tableName, Shell shellState, Class<T> clazz, Property pluginProp) {
        Iterator<Map.Entry<String, String>> props;
        try {
            props = shellState.getConnector().tableOperations().getProperties(tableName).iterator();
        }
        catch (AccumuloException e) {
            return null;
        }
        catch (TableNotFoundException e) {
            return null;
        }
        while (props.hasNext()) {
            Class<T> pluginClazz;
            Map.Entry<String, String> ent = props.next();
            if (!ent.getKey().equals(pluginProp.toString())) continue;
            Object[] args = new String[2];
            try {
                Options o = new Options();
                o.addOption(OptUtil.tableOpt());
                args[0] = "-t";
                args[1] = tableName;
                CommandLine cl = new BasicParser().parse(o, (String[])args);
                pluginClazz = shellState.getClassLoader(cl, shellState).loadClass(ent.getValue()).asSubclass(clazz);
            }
            catch (ClassNotFoundException e) {
                Logger.getLogger(ShellPluginConfigurationCommand.class).error((Object)("Class not found" + e.getMessage()));
                return null;
            }
            catch (ParseException e) {
                Logger.getLogger(ShellPluginConfigurationCommand.class).error((Object)("Error parsing table: " + Arrays.toString(args) + e.getMessage()));
                return null;
            }
            catch (TableNotFoundException e) {
                Logger.getLogger(ShellPluginConfigurationCommand.class).error((Object)("Table not found: " + tableName + e.getMessage()));
                return null;
            }
            catch (Exception e) {
                Logger.getLogger(ShellPluginConfigurationCommand.class).error((Object)("Error: " + e.getMessage()));
                return null;
            }
            return pluginClazz;
        }
        return null;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup actionGroup = new OptionGroup();
        this.pluginClassOption = new Option(this.classOpt, this.pluginType, true, "fully qualified name of the " + this.pluginType + " class to use");
        this.pluginClassOption.setArgName("className");
        this.removePluginOption = new Option("r", "remove", false, "remove the current " + this.pluginType + "");
        this.listPluginOption = new Option("l", "list", false, "display the current " + this.pluginType + "");
        actionGroup.addOption(this.pluginClassOption);
        actionGroup.addOption(this.removePluginOption);
        actionGroup.addOption(this.listPluginOption);
        actionGroup.setRequired(true);
        o.addOptionGroup(actionGroup);
        o.addOption(OptUtil.tableOpt("table to set the " + this.pluginType + " on"));
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

