/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.SortedSet;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.impl.ScannerOptions;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.hadoop.io.Text;
import org.vertexium.util.VertexiumLogger;

public class AccumuloGraphLogger {
    private final VertexiumLogger queryLogger;

    public AccumuloGraphLogger(VertexiumLogger queryLogger) {
        this.queryLogger = queryLogger;
    }

    public void logStartIterator(ScannerBase scanner) {
        block12: {
            if (!this.queryLogger.isTraceEnabled()) {
                return;
            }
            SortedSet fetchedColumns = null;
            if (scanner instanceof ScannerOptions) {
                fetchedColumns = ((ScannerOptions)scanner).getFetchedColumns();
            }
            String table = null;
            try {
                Field tableField = scanner.getClass().getDeclaredField("table");
                tableField.setAccessible(true);
                Object tableObj = tableField.get(scanner);
                table = tableObj instanceof String ? (String)tableObj : tableObj.toString();
            }
            catch (Exception e) {
                this.queryLogger.trace("Could not get table name from scanner", (Throwable)e);
            }
            if (scanner instanceof BatchScanner) {
                try {
                    Field rangesField = scanner.getClass().getDeclaredField("ranges");
                    rangesField.setAccessible(true);
                    ArrayList ranges = (ArrayList)rangesField.get(scanner);
                    if (ranges.size() == 0) {
                        this.logStartIterator(table, (Range)null, (SortedSet<Column>)fetchedColumns);
                        break block12;
                    }
                    if (ranges.size() == 1) {
                        this.logStartIterator(table, (Range)ranges.iterator().next(), (SortedSet<Column>)fetchedColumns);
                        break block12;
                    }
                    this.logStartIterator(table, ranges, (SortedSet<Column>)fetchedColumns);
                }
                catch (Exception e) {
                    this.queryLogger.trace("Could not get ranges from BatchScanner", (Throwable)e);
                }
            } else if (scanner instanceof Scanner) {
                Range range = ((Scanner)scanner).getRange();
                this.logStartIterator(table, range, (SortedSet<Column>)fetchedColumns);
            } else {
                this.queryLogger.trace("begin accumulo iterator: %s", new Object[]{scanner.getClass().getName()});
            }
        }
    }

    private void logStartIterator(String table, Range range, SortedSet<Column> fetchedColumns) {
        String fetchedColumnsString = this.fetchedColumnsToString(fetchedColumns);
        if (range == null || range.getStartKey() == null && range.getEndKey() == null) {
            this.queryLogger.trace("begin accumulo iterator %s: (%s): all items", new Object[]{table, fetchedColumnsString});
        } else {
            this.queryLogger.trace("begin accumulo iterator %s: (%s): %s - %s", new Object[]{table, fetchedColumnsString, this.keyToString(range.getStartKey()), this.keyToString(range.getEndKey())});
        }
    }

    private void logStartIterator(String table, ArrayList<Range> ranges, SortedSet<Column> fetchedColumns) {
        String fetchedColumnsString = this.fetchedColumnsToString(fetchedColumns);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Range r : ranges) {
            if (!first) {
                sb.append("\n");
            }
            sb.append("  ").append(this.keyToString(r.getStartKey())).append(" - ").append(this.keyToString(r.getEndKey()));
            first = false;
        }
        this.queryLogger.trace("begin accumulo iterator %s: (%s):\n%s", new Object[]{table, fetchedColumnsString, sb.toString()});
    }

    private String keyToString(Key key) {
        StringBuilder sb = new StringBuilder();
        this.appendText(sb, key.getRow());
        if (key.getColumnFamily() != null && key.getColumnFamily().getLength() > 0) {
            sb.append(":");
            this.appendText(sb, key.getColumnFamily());
        }
        if (key.getColumnQualifier() != null && key.getColumnQualifier().getLength() > 0) {
            sb.append(":");
            this.appendText(sb, key.getColumnQualifier());
        }
        if (key.getColumnVisibility() != null && key.getColumnVisibility().getLength() > 0) {
            sb.append(":");
            this.appendText(sb, key.getColumnVisibility());
        }
        if (key.getTimestamp() != Long.MAX_VALUE) {
            sb.append(":");
            sb.append(key.getTimestamp());
        }
        return sb.toString();
    }

    private String fetchedColumnsToString(SortedSet<Column> fetchedColumns) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Column fetchedColumn : fetchedColumns) {
            if (!first) {
                sb.append(",");
            }
            sb.append(this.fetchedColumnToString(fetchedColumn));
            first = false;
        }
        return sb.toString();
    }

    private String fetchedColumnToString(Column fetchedColumn) {
        StringBuilder sb = new StringBuilder();
        this.appendBytes(sb, fetchedColumn.getColumnFamily());
        if (fetchedColumn.getColumnQualifier() != null) {
            sb.append(":");
            this.appendBytes(sb, fetchedColumn.getColumnQualifier());
        }
        if (fetchedColumn.getColumnVisibility() != null) {
            sb.append(":");
            this.appendBytes(sb, fetchedColumn.getColumnVisibility());
        }
        return sb.toString();
    }

    private void appendText(StringBuilder sb, Text text) {
        String str = text.toString();
        for (char c : str.toCharArray()) {
            if (c >= ' ' && c <= '~') {
                sb.append(c);
                continue;
            }
            sb.append("\\x");
            String hexString = "00" + Integer.toHexString(c);
            sb.append(hexString.substring(hexString.length() - 2));
        }
    }

    private void appendBytes(StringBuilder sb, byte[] bytes) {
        sb.append(new String(bytes));
    }

    public void logEndIterator(long time) {
        this.queryLogger.trace("accumulo iterator closed (time %dms)", new Object[]{time});
    }
}

