/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.graphdb.query.BaseQuery;
import org.apache.commons.lang.StringUtils;

public class RawQuery
extends BaseQuery {
    private final String store;
    private final String query;
    private final Parameter[] parameters;
    private int offset;

    public RawQuery(String store, String query, Parameter[] parameters) {
        Preconditions.checkNotNull((Object)store);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)query));
        Preconditions.checkNotNull((Object)parameters);
        this.store = store;
        this.query = query;
        this.parameters = parameters;
        this.offset = 0;
    }

    public RawQuery setOffset(int offset) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (String)"Invalid offset: %s", (Object[])new Object[]{offset});
        this.offset = offset;
        return this;
    }

    @Override
    public RawQuery setLimit(int limit) {
        super.setLimit(limit);
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getStore() {
        return this.store;
    }

    public String getQuery() {
        return this.query;
    }

    public Parameter[] getParameters() {
        return this.parameters;
    }

    public static class Result<O> {
        private final O result;
        private final double score;

        public Result(O result, double score) {
            this.result = result;
            this.score = score;
        }

        public O getResult() {
            return this.result;
        }

        public double getScore() {
            return this.score;
        }
    }
}

