/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.thinkaurelius.titan.hadoop.FaunusElement;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.GenericWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class Holder<T extends FaunusPathElement>
extends GenericWritable
implements WritableComparable<Holder<T>> {
    protected char tag;
    private static Class[] CLASSES;

    protected Class<T>[] getTypes() {
        return CLASSES;
    }

    public Holder() {
    }

    public Holder(DataInput in) throws IOException {
        this();
        this.readFields(in);
    }

    public Holder(char tag, T element) {
        this();
        this.set((Writable)element);
        this.tag = tag;
    }

    public int hashCode() {
        return super.get().hashCode();
    }

    public char getTag() {
        return this.tag;
    }

    public T get() {
        return (T)((FaunusPathElement)super.get());
    }

    public Holder<T> set(char tag, T element) {
        this.set((Writable)element);
        this.tag = tag;
        return this;
    }

    public void write(DataOutput out) throws IOException {
        out.writeChar(this.tag);
        super.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.tag = in.readChar();
        super.readFields(in);
    }

    public boolean equals(Object object) {
        return object.getClass().equals(Holder.class) && ((Holder)((Object)object)).getTag() == this.tag && ((FaunusElement)((Holder)((Object)object)).get()).equals(this.get());
    }

    public int compareTo(Holder<T> holder) {
        T e1 = holder.get();
        T e2 = this.get();
        if (e1 instanceof FaunusVertex && e2 instanceof FaunusVertex) {
            return ((FaunusElement)e1).compareTo((FaunusElement)e2);
        }
        return 0;
    }

    static {
        WritableComparator.define(Holder.class, (WritableComparator)new Comparator());
        CLASSES = new Class[]{FaunusVertex.class, StandardFaunusEdge.class};
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(Holder.class);
        }

        public int compare(byte[] holder1, int start1, int length1, byte[] holder2, int start2, int length2) {
            try {
                return Long.valueOf(Comparator.readVLong((byte[])holder1, (int)3)).compareTo(Comparator.readVLong((byte[])holder2, (int)3));
            }
            catch (IOException e) {
                return -1;
            }
        }

        public int compare(WritableComparable a, WritableComparable b) {
            if (a instanceof Holder && b instanceof Holder) {
                return Long.valueOf(((FaunusElement)((Holder)a).get()).getLongId()).compareTo(((FaunusElement)((Holder)b).get()).getLongId());
            }
            return super.compare(a, b);
        }
    }
}

