/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.edgelist.rdf;

public class Crc64 {
    private static final long POLY64 = 4823603603198064275L;
    private static final long[] LOOKUPTABLE = new long[256];

    public static long digest(byte[] data) {
        long checksum = 0L;
        for (int i = 0; i < data.length; ++i) {
            int lookupidx = ((int)checksum ^ data[i]) & 0xFF;
            checksum = checksum >>> 8 ^ LOOKUPTABLE[lookupidx];
        }
        return checksum;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long crc = i;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1L) == 1L) {
                    crc = crc >>> 1 ^ 0x42F0E1EBA9EA3693L;
                    continue;
                }
                crc >>>= 1;
            }
            Crc64.LOOKUPTABLE[i] = crc;
        }
    }
}

