/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.graphson;

import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.VertexQueryFilter;
import com.thinkaurelius.titan.hadoop.formats.graphson.HadoopGraphSONUtility;
import java.io.IOException;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;

public class GraphSONRecordReader
extends RecordReader<NullWritable, FaunusVertex> {
    private final LineRecordReader lineRecordReader = new LineRecordReader();
    private final VertexQueryFilter vertexQuery;
    private FaunusVertex vertex = null;
    private HadoopGraphSONUtility graphsonUtil;

    public GraphSONRecordReader(VertexQueryFilter vertexQuery) {
        this.vertexQuery = vertexQuery;
    }

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
        org.apache.hadoop.conf.Configuration c = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration(context);
        ModifiableHadoopConfiguration configuration = ModifiableHadoopConfiguration.of(c);
        this.graphsonUtil = new HadoopGraphSONUtility((Configuration)configuration);
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.lineRecordReader.nextKeyValue()) {
            return false;
        }
        this.vertex = this.graphsonUtil.fromJSON(this.lineRecordReader.getCurrentValue().toString());
        this.vertexQuery.defaultFilter(this.vertex);
        return true;
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public FaunusVertex getCurrentValue() {
        return this.vertex;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
    }
}

