/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.transform;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class VertexMap {
    public static final String IDS = Tokens.makeNamespace(VertexMap.class) + ".ids";

    public static Configuration createConfiguration(long ... ids) {
        String[] idStrings = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            idStrings[i] = String.valueOf(ids[i]);
        }
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setStrings(IDS, idStrings);
        return configuration;
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, FaunusVertex> {
        private Collection<Long> ids;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.ids = Map.getLongCollection(HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context), IDS, new HashSet<Long>());
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.ids.contains(value.getLongId())) {
                value.startPath();
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_PROCESSED, 1L);
            } else {
                value.clearPaths();
            }
            context.write((Object)NullWritable.get(), (Object)value);
        }

        private static Collection<Long> getLongCollection(Configuration conf, String key, Collection<Long> collection) {
            for (String value : conf.getStrings(key)) {
                collection.add(Long.valueOf(value));
            }
            return collection;
        }
    }

    public static enum Counters {
        VERTICES_PROCESSED;

    }
}

