/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompiler;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.output.MultipleOutputs;

public class SafeReducerOutputs {
    private final MultipleOutputs outputs;
    private final Reducer.Context context;
    private final boolean testing;

    public SafeReducerOutputs(Reducer.Context context) {
        this.context = context;
        this.outputs = new MultipleOutputs((TaskInputOutputContext)this.context);
        this.testing = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getBoolean(HadoopCompiler.TESTING, false);
    }

    public void write(String type, Writable key, Writable value) throws IOException, InterruptedException {
        if (this.testing) {
            if (type.equals("sideeffect")) {
                this.context.write((Object)key, (Object)value);
            }
        } else {
            this.outputs.write(type, (Object)key, (Object)value);
        }
    }

    public void close() throws IOException, InterruptedException {
        this.outputs.close();
    }
}

