/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;

public class ServerName
implements Comparable<ServerName> {
    private static final short VERSION = 0;
    static final byte[] VERSION_BYTES = Bytes.toBytes((short)0);
    public static final int NON_STARTCODE = -1;
    public static final String SERVERNAME_SEPARATOR = ",";
    public static Pattern SERVERNAME_PATTERN = Pattern.compile("[^,]+,[\\d]+,[\\d]+$");
    public static final String UNKNOWN_SERVERNAME = "#unknown#";
    private final String servername;
    private final String hostname;
    private final int port;
    private final long startcode;
    private byte[] bytes;

    public ServerName(String hostname, int port, long startcode) {
        this.hostname = hostname;
        this.port = port;
        this.startcode = startcode;
        this.servername = ServerName.getServerName(hostname, port, startcode);
    }

    public ServerName(String serverName) {
        this(ServerName.parseHostname(serverName), ServerName.parsePort(serverName), ServerName.parseStartcode(serverName));
    }

    public ServerName(String hostAndPort, long startCode) {
        this(Addressing.parseHostname(hostAndPort), Addressing.parsePort(hostAndPort), startCode);
    }

    public static String parseHostname(String serverName) {
        if (serverName == null || serverName.length() <= 0) {
            throw new IllegalArgumentException("Passed hostname is null or empty");
        }
        int index = serverName.indexOf(SERVERNAME_SEPARATOR);
        return serverName.substring(0, index);
    }

    public static int parsePort(String serverName) {
        String[] split = serverName.split(SERVERNAME_SEPARATOR);
        return Integer.parseInt(split[1]);
    }

    public static long parseStartcode(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    public String toString() {
        return this.getServerName();
    }

    public synchronized byte[] getVersionedBytes() {
        if (this.bytes == null) {
            this.bytes = Bytes.add(VERSION_BYTES, Bytes.toBytes(this.getServerName()));
        }
        return this.bytes;
    }

    public String getServerName() {
        return this.servername;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public long getStartcode() {
        return this.startcode;
    }

    public static String getServerName(String hostName, int port, long startcode) {
        StringBuilder name = new StringBuilder(hostName.length() + 1 + 5 + 1 + 13);
        name.append(hostName);
        name.append(SERVERNAME_SEPARATOR);
        name.append(port);
        name.append(SERVERNAME_SEPARATOR);
        name.append(startcode);
        return name.toString();
    }

    public static String getServerName(String hostAndPort, long startcode) {
        int index = hostAndPort.indexOf(":");
        if (index <= 0) {
            throw new IllegalArgumentException("Expected <hostname> ':' <port>");
        }
        return ServerName.getServerName(hostAndPort.substring(0, index), Integer.parseInt(hostAndPort.substring(index + 1)), startcode);
    }

    public String getHostAndPort() {
        return Addressing.createHostAndPortStr(this.hostname, this.port);
    }

    public static long getServerStartcodeFromServerName(String serverName) {
        int index = serverName.lastIndexOf(SERVERNAME_SEPARATOR);
        return Long.parseLong(serverName.substring(index + 1));
    }

    public static String getServerNameLessStartCode(String inServerName) {
        int index;
        if (inServerName != null && inServerName.length() > 0 && (index = inServerName.lastIndexOf(SERVERNAME_SEPARATOR)) > 0) {
            return inServerName.substring(0, index);
        }
        return inServerName;
    }

    @Override
    public int compareTo(ServerName other) {
        int compare = this.getHostname().toLowerCase().compareTo(other.getHostname().toLowerCase());
        if (compare != 0) {
            return compare;
        }
        compare = this.getPort() - other.getPort();
        if (compare != 0) {
            return compare;
        }
        return (int)(this.getStartcode() - other.getStartcode());
    }

    public int hashCode() {
        return this.getServerName().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof ServerName)) {
            return false;
        }
        return this.compareTo((ServerName)o) == 0;
    }

    public static ServerName findServerWithSameHostnamePort(Collection<ServerName> names, ServerName serverName) {
        for (ServerName sn : names) {
            if (!ServerName.isSameHostnameAndPort(serverName, sn)) continue;
            return sn;
        }
        return null;
    }

    public static boolean isSameHostnameAndPort(ServerName left, ServerName right) {
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.getHostname().equals(right.getHostname()) && left.getPort() == right.getPort();
    }

    public static ServerName parseVersionedServerName(byte[] versionedBytes) {
        short version = Bytes.toShort(versionedBytes);
        if (version == 0) {
            int length = versionedBytes.length - 2;
            return new ServerName(Bytes.toString(versionedBytes, 2, length));
        }
        return new ServerName(Bytes.toString(versionedBytes), -1L);
    }

    public static ServerName parseServerName(String str) {
        return SERVERNAME_PATTERN.matcher(str).matches() ? new ServerName(str) : new ServerName(str, -1L);
    }
}

