/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;

public class FirstKeyOnlyFilter
extends FilterBase {
    private boolean foundKV = false;

    @Override
    public void reset() {
        this.foundKV = false;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(KeyValue v) {
        if (this.foundKV) {
            return Filter.ReturnCode.NEXT_ROW;
        }
        this.foundKV = true;
        return Filter.ReturnCode.INCLUDE;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 0 ? 1 : 0) != 0, (String)"Expected 0 but got: %s", (Object[])new Object[]{filterArguments.size()});
        return new FirstKeyOnlyFilter();
    }

    public void write(DataOutput out) throws IOException {
    }

    public void readFields(DataInput in) throws IOException {
    }
}

