/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;

public class SingleColumnValueExcludeFilter
extends SingleColumnValueFilter {
    public SingleColumnValueExcludeFilter() {
    }

    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, byte[] value) {
        super(family, qualifier, compareOp, value);
    }

    public SingleColumnValueExcludeFilter(byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator) {
        super(family, qualifier, compareOp, comparator);
    }

    @Override
    public boolean hasFilterRow() {
        return true;
    }

    @Override
    public void filterRow(List<KeyValue> kvs) {
        Iterator<KeyValue> it = kvs.iterator();
        while (it.hasNext()) {
            KeyValue kv = it.next();
            if (!kv.matchingColumn(this.columnFamily, this.columnQualifier)) continue;
            it.remove();
        }
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        SingleColumnValueFilter tempFilter = (SingleColumnValueFilter)SingleColumnValueFilter.createFilterFromArguments(filterArguments);
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(tempFilter.getFamily(), tempFilter.getQualifier(), tempFilter.getOperator(), tempFilter.getComparator());
        if (filterArguments.size() == 6) {
            filter.setFilterIfMissing(tempFilter.getFilterIfMissing());
            filter.setLatestVersionOnly(tempFilter.getLatestVersionOnly());
        }
        return filter;
    }
}

