/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaConfigured;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;

public abstract class AbstractHFileWriter
extends SchemaConfigured
implements HFile.Writer {
    protected byte[] lastKeyBuffer = null;
    protected int lastKeyOffset = -1;
    protected int lastKeyLength = -1;
    protected FSDataOutputStream outputStream;
    protected final boolean closeOutputStream;
    protected HFile.FileInfo fileInfo = new HFile.FileInfo();
    protected final int blockSize;
    protected long entryCount = 0L;
    protected long totalKeyLength = 0L;
    protected long totalValueLength = 0L;
    protected long totalUncompressedBytes = 0L;
    protected final RawComparator<byte[]> comparator;
    protected List<byte[]> metaNames = new ArrayList<byte[]>();
    protected List<Writable> metaData = new ArrayList<Writable>();
    protected final Compression.Algorithm compressAlgo;
    protected final HFileDataBlockEncoder blockEncoder;
    protected byte[] firstKeyInBlock = null;
    protected final Path path;
    protected final CacheConfig cacheConf;
    protected final String name;

    public AbstractHFileWriter(CacheConfig cacheConf, FSDataOutputStream outputStream, Path path, int blockSize, Compression.Algorithm compressAlgo, HFileDataBlockEncoder dataBlockEncoder, KeyValue.KeyComparator comparator) {
        super(null, path);
        this.outputStream = outputStream;
        this.path = path;
        this.name = path != null ? path.getName() : outputStream.toString();
        this.blockSize = blockSize;
        this.compressAlgo = compressAlgo == null ? HFile.DEFAULT_COMPRESSION_ALGORITHM : compressAlgo;
        this.blockEncoder = dataBlockEncoder != null ? dataBlockEncoder : NoOpDataBlockEncoder.INSTANCE;
        this.comparator = comparator != null ? comparator : Bytes.BYTES_RAWCOMPARATOR;
        this.closeOutputStream = path != null;
        this.cacheConf = cacheConf;
    }

    protected void finishFileInfo() throws IOException {
        if (this.lastKeyBuffer != null) {
            this.fileInfo.append(HFile.FileInfo.LASTKEY, Arrays.copyOfRange(this.lastKeyBuffer, this.lastKeyOffset, this.lastKeyOffset + this.lastKeyLength), false);
        }
        int avgKeyLen = this.entryCount == 0L ? 0 : (int)(this.totalKeyLength / this.entryCount);
        this.fileInfo.append(HFile.FileInfo.AVG_KEY_LEN, Bytes.toBytes(avgKeyLen), false);
        int avgValueLen = this.entryCount == 0L ? 0 : (int)(this.totalValueLength / this.entryCount);
        this.fileInfo.append(HFile.FileInfo.AVG_VALUE_LEN, Bytes.toBytes(avgValueLen), false);
    }

    @Override
    public void appendFileInfo(byte[] k, byte[] v) throws IOException {
        this.fileInfo.append(k, v, true);
    }

    protected final void writeFileInfo(FixedFileTrailer trailer, DataOutput out) throws IOException {
        trailer.setFileInfoOffset(this.outputStream.getPos());
        this.finishFileInfo();
        this.fileInfo.write(out);
    }

    protected boolean checkKey(byte[] key, int offset, int length) throws IOException {
        boolean isDuplicateKey = false;
        if (key == null || length <= 0) {
            throw new IOException("Key cannot be null or empty");
        }
        if (length > Integer.MAX_VALUE) {
            throw new IOException("Key length " + length + " > " + Integer.MAX_VALUE);
        }
        if (this.lastKeyBuffer != null) {
            int keyComp = this.comparator.compare(this.lastKeyBuffer, this.lastKeyOffset, this.lastKeyLength, key, offset, length);
            if (keyComp > 0) {
                throw new IOException("Added a key not lexically larger than previous key=" + Bytes.toStringBinary(key, offset, length) + ", lastkey=" + Bytes.toStringBinary(this.lastKeyBuffer, this.lastKeyOffset, this.lastKeyLength));
            }
            if (keyComp == 0) {
                isDuplicateKey = true;
            }
        }
        return isDuplicateKey;
    }

    protected void checkValue(byte[] value, int offset, int length) throws IOException {
        if (value == null) {
            throw new IOException("Value cannot be null");
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    public String toString() {
        return "writer=" + (this.path != null ? this.path.toString() : null) + ", name=" + this.name + ", compression=" + this.compressAlgo.getName();
    }

    protected void finishClose(FixedFileTrailer trailer) throws IOException {
        trailer.setMetaIndexCount(this.metaNames.size());
        trailer.setTotalUncompressedBytes(this.totalUncompressedBytes + (long)trailer.getTrailerSize());
        trailer.setEntryCount(this.entryCount);
        trailer.setCompressionCodec(this.compressAlgo);
        trailer.serialize((DataOutputStream)this.outputStream);
        if (this.closeOutputStream) {
            this.outputStream.close();
            this.outputStream = null;
        }
    }

    public static Compression.Algorithm compressionByName(String algoName) {
        if (algoName == null) {
            return HFile.DEFAULT_COMPRESSION_ALGORITHM;
        }
        return Compression.getCompressionAlgorithmByName(algoName);
    }

    protected static FSDataOutputStream createOutputStream(Configuration conf, FileSystem fs, Path path) throws IOException {
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        return FSUtils.create(fs, path, perms);
    }
}

