/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.net.InetAddress;
import org.apache.hadoop.hbase.ipc.VersionedProtocol;
import org.apache.hadoop.hbase.security.User;

public class RequestContext {
    private static ThreadLocal<RequestContext> instance = new ThreadLocal<RequestContext>(){

        @Override
        protected RequestContext initialValue() {
            return new RequestContext(null, null, null);
        }
    };
    private User user;
    private InetAddress remoteAddress;
    private Class<? extends VersionedProtocol> protocol;
    private boolean inRequest;

    public static RequestContext get() {
        return instance.get();
    }

    public static User getRequestUser() {
        RequestContext ctx = instance.get();
        if (ctx != null) {
            return ctx.getUser();
        }
        return null;
    }

    public static String getRequestUserName() {
        User user = RequestContext.getRequestUser();
        if (user != null) {
            return user.getShortName();
        }
        return null;
    }

    public static boolean isInRequestContext() {
        RequestContext ctx = instance.get();
        if (ctx != null) {
            return ctx.isInRequest();
        }
        return false;
    }

    public static void set(User user, InetAddress remoteAddress, Class<? extends VersionedProtocol> protocol) {
        RequestContext ctx = instance.get();
        ctx.user = user;
        ctx.remoteAddress = remoteAddress;
        ctx.protocol = protocol;
        ctx.inRequest = true;
    }

    public static void clear() {
        RequestContext ctx = instance.get();
        ctx.user = null;
        ctx.remoteAddress = null;
        ctx.protocol = null;
        ctx.inRequest = false;
    }

    private RequestContext(User user, InetAddress remoteAddr, Class<? extends VersionedProtocol> protocol) {
        this.user = user;
        this.remoteAddress = remoteAddr;
        this.protocol = protocol;
    }

    public User getUser() {
        return this.user;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Class<? extends VersionedProtocol> getProtocol() {
        return this.protocol;
    }

    public boolean isInRequest() {
        return this.inRequest;
    }
}

