/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.mutable.MutableDouble;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HServerLoad;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.HealthCheckChore;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MasterAddressTracker;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.UnknownRowLockException;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.YouAreDeadException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.Action;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MultiAction;
import org.apache.hadoop.hbase.client.MultiResponse;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Exec;
import org.apache.hadoop.hbase.client.coprocessor.ExecResult;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheColumnFamilySummary;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.ipc.HBaseRPC;
import org.apache.hadoop.hbase.ipc.HBaseRPCErrorHandler;
import org.apache.hadoop.hbase.ipc.HBaseRpcMetrics;
import org.apache.hadoop.hbase.ipc.HBaseServer;
import org.apache.hadoop.hbase.ipc.HMasterRegionInterface;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.ipc.Invocation;
import org.apache.hadoop.hbase.ipc.ProtocolSignature;
import org.apache.hadoop.hbase.ipc.RpcEngine;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.regionserver.CompactSplitThread;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServerCommandLine;
import org.apache.hadoop.hbase.regionserver.HRegionThriftServer;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.LeaseException;
import org.apache.hadoop.hbase.regionserver.LeaseListener;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MXBeanImpl;
import org.apache.hadoop.hbase.regionserver.MemStoreFlusher;
import org.apache.hadoop.hbase.regionserver.MetaLogRoller;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OnlineRegions;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.RSDumpServlet;
import org.apache.hadoop.hbase.regionserver.RSStatusServlet;
import org.apache.hadoop.hbase.regionserver.RegionAlreadyInTransitionException;
import org.apache.hadoop.hbase.regionserver.RegionOpeningState;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerRunningException;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionServerStoppedException;
import org.apache.hadoop.hbase.regionserver.ReplicationService;
import org.apache.hadoop.hbase.regionserver.ReplicationSinkService;
import org.apache.hadoop.hbase.regionserver.ReplicationSourceService;
import org.apache.hadoop.hbase.regionserver.ShutdownHook;
import org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionProgress;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.handler.CloseMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.CloseRootHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenMetaHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.regionserver.handler.OpenRootHandler;
import org.apache.hadoop.hbase.regionserver.metrics.RegionMetricsStorage;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerDynamicMetrics;
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
import org.apache.hadoop.hbase.regionserver.metrics.SchemaMetrics;
import org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.InfoServer;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hadoop.hbase.zookeeper.ClusterId;
import org.apache.hadoop.hbase.zookeeper.ClusterStatusTracker;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.metrics.util.MBeanUtil;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.zookeeper.KeeperException;
import org.codehaus.jackson.map.ObjectMapper;

public class HRegionServer
implements HRegionInterface,
HBaseRPCErrorHandler,
Runnable,
RegionServerServices {
    public static final Log LOG = LogFactory.getLog(HRegionServer.class);
    protected volatile boolean stopped = false;
    private boolean stopping = false;
    protected volatile boolean abortRequested;
    private volatile boolean killed = false;
    protected volatile boolean fsOk = true;
    protected final Configuration conf;
    protected final AtomicBoolean haveRootRegion = new AtomicBoolean(false);
    private HFileSystem fs;
    private boolean useHBaseChecksum;
    private Path rootDir;
    private final Random rand;
    private final ConcurrentSkipListMap<byte[], Boolean> regionsInTransitionInRS = new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR);
    protected final Map<String, HRegion> onlineRegions = new ConcurrentHashMap<String, HRegion>();
    protected final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final int numRetries;
    protected final int threadWakeFrequency;
    private final int msgInterval;
    protected final int numRegionsToReport;
    private final long maxScannerResultSize;
    private HMasterRegionInterface hbaseMaster;
    private RpcEngine rpcEngine;
    RpcServer rpcServer;
    private HBaseServer server;
    private final InetSocketAddress isa;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private Leases leases;
    private AtomicInteger requestCount = new AtomicInteger();
    InfoServer infoServer;
    public static final String REGIONSERVER = "regionserver";
    public static final String REGIONSERVER_CONF = "regionserver_conf";
    private final LinkedList<byte[]> reservedSpace = new LinkedList();
    private RegionServerMetrics metrics;
    private RegionServerDynamicMetrics dynamicMetrics;
    public CompactSplitThread compactSplitThread;
    MemStoreFlusher cacheFlusher;
    Chore compactionChecker;
    Chore periodicFlusher;
    protected volatile HLog hlog;
    protected volatile HLog hlogForMeta;
    LogRoller hlogRoller;
    LogRoller metaHLogRoller;
    private final boolean separateHLogForMeta;
    protected volatile boolean isOnline;
    final Map<String, RegionScanner> scanners = new ConcurrentHashMap<String, RegionScanner>();
    private ZooKeeperWatcher zooKeeper;
    private MasterAddressTracker masterAddressManager;
    private CatalogTracker catalogTracker;
    private ClusterStatusTracker clusterStatusTracker;
    private SplitLogWorker splitLogWorker;
    private final Sleeper sleeper;
    private final int rpcTimeout;
    private ExecutorService service;
    private ReplicationSourceService replicationSourceHandler;
    private ReplicationSinkService replicationSinkHandler;
    private final RegionServerAccounting regionServerAccounting;
    private final CacheConfig cacheConfig;
    private volatile HRegionThriftServer thriftServer;
    private ServerName serverNameFromMasterPOV;
    private int webuiport = -1;
    private final long startcode;
    private TableDescriptors tableDescriptors;
    private static final String OPEN = "OPEN";
    private static final String CLOSE = "CLOSE";
    private ObjectName mxBean = null;
    private ClusterId clusterId = null;
    private RegionServerCoprocessorHost rsHost;
    private HealthCheckChore healthCheckChore;
    RegionServerSnapshotManager snapshotManager;
    Map<String, Integer> rowlocks = new ConcurrentHashMap<String, Integer>();

    public HRegionServer(Configuration conf) throws IOException, InterruptedException {
        this.conf = conf;
        HConnectionManager.setServerSideHConnectionRetries(this.conf, LOG);
        this.isOnline = false;
        HRegionServer.checkCodecs(this.conf);
        this.useHBaseChecksum = conf.getBoolean("hbase.regionserver.checksum.verify", false);
        this.separateHLogForMeta = conf.getBoolean("hbase.regionserver.separate.hlog.for.meta", false);
        this.numRetries = conf.getInt("hbase.client.retries.number", 10);
        this.threadWakeFrequency = conf.getInt("hbase.server.thread.wakefrequency", 10000);
        this.msgInterval = conf.getInt("hbase.regionserver.msginterval", 3000);
        this.sleeper = new Sleeper(this.msgInterval, this);
        this.maxScannerResultSize = conf.getLong(HConstants.HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE_KEY, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_MAX_RESULT_SIZE);
        this.numRegionsToReport = conf.getInt("hbase.regionserver.numregionstoreport", 10);
        this.rpcTimeout = conf.getInt(HConstants.HBASE_RPC_SHORTOPERATION_TIMEOUT_KEY, HConstants.DEFAULT_HBASE_RPC_SHORTOPERATION_TIMEOUT);
        this.abortRequested = false;
        this.stopped = false;
        String hostname = conf.get("hbase.regionserver.ipc.address", Strings.domainNamePointerToHostName(DNS.getDefaultHost((String)conf.get("hbase.regionserver.dns.interface", "default"), (String)conf.get("hbase.regionserver.dns.nameserver", "default"))));
        int port = conf.getInt("hbase.regionserver.port", 60020);
        InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
        if (initialIsa.getAddress() == null) {
            throw new IllegalArgumentException("Failed resolve of " + initialIsa);
        }
        this.rand = new Random(initialIsa.hashCode());
        this.rpcServer = HBaseRPC.getServer(this, new Class[]{HRegionInterface.class, HBaseRPCErrorHandler.class, OnlineRegions.class}, initialIsa.getHostName(), initialIsa.getPort(), conf.getInt("hbase.regionserver.handler.count", 10), conf.getInt("hbase.regionserver.metahandler.count", 10), conf.getBoolean("hbase.rpc.verbose", false), conf, 10);
        if (this.rpcServer instanceof HBaseServer) {
            this.server = (HBaseServer)this.rpcServer;
        }
        this.isa = this.rpcServer.getListenerAddress();
        this.rpcServer.setErrorHandler(this);
        this.rpcServer.setQosFunction(new QosFunction());
        this.startcode = System.currentTimeMillis();
        ZKUtil.loginClient(this.conf, "hbase.zookeeper.client.keytab.file", "hbase.zookeeper.client.kerberos.principal", this.isa.getHostName());
        User.login(this.conf, "hbase.regionserver.keytab.file", "hbase.regionserver.kerberos.principal", this.isa.getHostName());
        this.regionServerAccounting = new RegionServerAccounting();
        this.cacheConfig = new CacheConfig(conf);
        this.uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                HRegionServer.this.abort("Uncaught exception in service thread " + t.getName(), e);
            }
        };
    }

    private static void checkCodecs(Configuration c) throws IOException {
        String[] codecs = c.getStrings("hbase.regionserver.codecs", (String[])null);
        if (codecs == null) {
            return;
        }
        for (String codec : codecs) {
            if (CompressionTest.testCompression(codec)) continue;
            throw new IOException("Compression codec " + codec + " not supported, aborting RS construction");
        }
    }

    private void preRegistrationInitialization() {
        try {
            this.initializeZooKeeper();
            this.clusterId = new ClusterId(this.zooKeeper, this);
            if (this.clusterId.hasId()) {
                this.conf.set("hbase.cluster.id", this.clusterId.getId());
            }
            this.initializeThreads();
            int nbBlocks = this.conf.getInt("hbase.regionserver.nbreservationblocks", 4);
            for (int i = 0; i < nbBlocks; ++i) {
                this.reservedSpace.add(new byte[0x500000]);
            }
            this.rpcEngine = HBaseRPC.getProtocolEngine(this.conf);
        }
        catch (Throwable t) {
            this.rpcServer.stop();
            this.abort("Initialization of RS failed.  Hence aborting RS.", t);
        }
    }

    private void initializeZooKeeper() throws IOException, InterruptedException {
        this.zooKeeper = new ZooKeeperWatcher(this.conf, "regionserver:" + this.isa.getPort(), this);
        this.masterAddressManager = new MasterAddressTracker(this.zooKeeper, this);
        this.masterAddressManager.start();
        this.blockAndCheckIfStopped(this.masterAddressManager);
        this.clusterStatusTracker = new ClusterStatusTracker(this.zooKeeper, this);
        this.clusterStatusTracker.start();
        this.blockAndCheckIfStopped(this.clusterStatusTracker);
        this.catalogTracker = new CatalogTracker(this.zooKeeper, this.conf, this);
        this.catalogTracker.start();
        try {
            this.snapshotManager = new RegionServerSnapshotManager(this);
        }
        catch (KeeperException e) {
            this.abort("Failed to reach zk cluster when creating snapshot handler.");
        }
    }

    private void blockAndCheckIfStopped(ZooKeeperNodeTracker tracker) throws IOException, InterruptedException {
        while (tracker.blockUntilAvailable(this.msgInterval, false) == null) {
            if (!this.stopped) continue;
            throw new IOException("Received the shutdown message while waiting.");
        }
    }

    private boolean isClusterUp() {
        return this.clusterStatusTracker.isClusterUp();
    }

    private void initializeThreads() throws IOException {
        this.cacheFlusher = new MemStoreFlusher(this.conf, this);
        this.compactSplitThread = new CompactSplitThread(this);
        int multiplier = this.conf.getInt("hbase.server.thread.wakefrequency.multiplier", 1000);
        this.compactionChecker = new CompactionChecker(this, this.threadWakeFrequency * multiplier, (Stoppable)this);
        this.periodicFlusher = new PeriodicMemstoreFlusher(this.threadWakeFrequency, this);
        int sleepTime = this.conf.getInt("hbase.node.health.script.frequency", 10000);
        if (this.isHealthCheckerConfigured()) {
            this.healthCheckChore = new HealthCheckChore(sleepTime, this, this.getConfiguration());
        }
        this.leases = new Leases((int)this.conf.getLong(HConstants.HBASE_REGIONSERVER_LEASE_PERIOD_KEY, HConstants.DEFAULT_HBASE_REGIONSERVER_LEASE_PERIOD), this.threadWakeFrequency);
        if (this.conf.getBoolean("hbase.regionserver.export.thrift", false)) {
            this.thriftServer = new HRegionThriftServer(this, this.conf);
            this.thriftServer.start();
            LOG.info((Object)"Started Thrift API from Region Server.");
        }
    }

    @Override
    public void run() {
        block45: {
            try {
                this.preRegistrationInitialization();
            }
            catch (Throwable e) {
                this.abort("Fatal exception during initialization", e);
            }
            try {
                while (this.keepLooping()) {
                    MapWritable w = this.reportForDuty();
                    if (w == null) {
                        LOG.warn((Object)"reportForDuty failed; sleeping and then retrying.");
                        this.sleeper.sleep();
                        continue;
                    }
                    this.handleReportForDutyResponse(w);
                    break;
                }
                this.registerMBean();
                this.snapshotManager.start();
                long lastMsg = 0L;
                long oldRequestCount = -1L;
                while (!this.stopped && this.isHealthy()) {
                    long now;
                    if (!this.isClusterUp()) {
                        if (this.isOnlineRegionsEmpty()) {
                            this.stop("Exiting; cluster shutdown set and not carrying any regions");
                        } else if (!this.stopping) {
                            this.stopping = true;
                            LOG.info((Object)"Closing user regions");
                            this.closeUserRegions(this.abortRequested);
                        } else if (this.stopping) {
                            boolean allUserRegionsOffline = this.areAllUserRegionsOffline();
                            if (allUserRegionsOffline) {
                                if (oldRequestCount == (long)this.requestCount.get()) {
                                    this.stop("Stopped; only catalog regions remaining online");
                                    break;
                                }
                                oldRequestCount = this.requestCount.get();
                            } else {
                                this.closeUserRegions(this.abortRequested);
                            }
                            LOG.debug((Object)("Waiting on " + this.getOnlineRegionsAsPrintableString()));
                        }
                    }
                    if ((now = System.currentTimeMillis()) - lastMsg >= (long)this.msgInterval) {
                        this.doMetrics();
                        this.tryRegionServerReport();
                        lastMsg = System.currentTimeMillis();
                    }
                    if (this.stopped) continue;
                    this.sleeper.sleep();
                }
            }
            catch (Throwable t) {
                if (this.checkOOME(t)) break block45;
                this.abort("Unhandled exception: " + t.getMessage(), t);
            }
        }
        if (this.mxBean != null) {
            MBeanUtil.unregisterMBean((ObjectName)this.mxBean);
            this.mxBean = null;
        }
        if (this.thriftServer != null) {
            this.thriftServer.shutdown();
        }
        this.leases.closeAfterLeasesExpire();
        this.rpcServer.stop();
        if (this.splitLogWorker != null) {
            this.splitLogWorker.stop();
        }
        if (this.infoServer != null) {
            LOG.info((Object)"Stopping infoServer");
            try {
                this.infoServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.cacheConfig.isBlockCacheEnabled()) {
            this.cacheConfig.getBlockCache().shutdown();
        }
        if (this.cacheFlusher != null) {
            this.cacheFlusher.interruptIfNecessary();
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.interruptIfNecessary();
        }
        if (this.hlogRoller != null) {
            this.hlogRoller.interruptIfNecessary();
        }
        if (this.metaHLogRoller != null) {
            this.metaHLogRoller.interruptIfNecessary();
        }
        if (this.compactionChecker != null) {
            this.compactionChecker.interrupt();
        }
        if (this.healthCheckChore != null) {
            this.healthCheckChore.interrupt();
        }
        try {
            if (this.snapshotManager != null) {
                this.snapshotManager.stop(this.abortRequested || this.killed);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to close snapshot handler cleanly", (Throwable)e);
        }
        if (!this.killed) {
            if (this.abortRequested) {
                if (this.fsOk) {
                    this.closeUserRegions(this.abortRequested);
                }
                LOG.info((Object)("aborting server " + this.serverNameFromMasterPOV));
            } else {
                this.closeUserRegions(this.abortRequested);
                this.closeAllScanners();
                LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV));
            }
        }
        if (this.catalogTracker != null) {
            this.catalogTracker.stop();
        }
        if (!this.killed && this.containsMetaTableRegions() && (!this.abortRequested || this.fsOk)) {
            if (this.compactSplitThread != null) {
                this.compactSplitThread.join();
                this.compactSplitThread = null;
            }
            this.closeMetaTableRegions(this.abortRequested);
        }
        if (!this.killed && this.fsOk) {
            this.waitOnAllRegionsToClose(this.abortRequested);
            LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV + "; all regions closed."));
        }
        if (!this.killed && this.fsOk) {
            this.closeWAL(!this.abortRequested);
        }
        this.hbaseMaster = null;
        this.rpcEngine.close();
        this.leases.close();
        if (!this.killed) {
            this.join();
        }
        try {
            this.deleteMyEphemeralNode();
        }
        catch (KeeperException e) {
            LOG.warn((Object)"Failed deleting my ephemeral node", (Throwable)e);
        }
        this.zooKeeper.close();
        LOG.info((Object)("stopping server " + this.serverNameFromMasterPOV + "; zookeeper connection closed."));
        LOG.info((Object)(Thread.currentThread().getName() + " exiting"));
    }

    private boolean containsMetaTableRegions() {
        return this.onlineRegions.containsKey(HRegionInfo.ROOT_REGIONINFO.getEncodedName()) || this.onlineRegions.containsKey(HRegionInfo.FIRST_META_REGIONINFO.getEncodedName());
    }

    private boolean areAllUserRegionsOffline() {
        if (this.getNumberOfOnlineRegions() > 2) {
            return false;
        }
        boolean allUserRegionsOffline = true;
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            if (e.getValue().getRegionInfo().isMetaTable()) continue;
            allUserRegionsOffline = false;
            break;
        }
        return allUserRegionsOffline;
    }

    void tryRegionServerReport() throws IOException {
        HServerLoad hsl = this.buildServerLoad();
        this.requestCount.set(0);
        try {
            this.hbaseMaster.regionServerReport(this.serverNameFromMasterPOV.getVersionedBytes(), hsl);
        }
        catch (IOException ioe) {
            if (ioe instanceof RemoteException) {
                ioe = ((RemoteException)((Object)ioe)).unwrapRemoteException();
            }
            if (ioe instanceof YouAreDeadException) {
                throw ioe;
            }
            this.getMaster();
        }
    }

    HServerLoad buildServerLoad() {
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        TreeMap<byte[], HServerLoad.RegionLoad> regionLoads = new TreeMap<byte[], HServerLoad.RegionLoad>(Bytes.BYTES_COMPARATOR);
        for (HRegion region : regions) {
            regionLoads.put(region.getRegionName(), this.createRegionLoad(region));
        }
        MemoryUsage memory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        return new HServerLoad(this.requestCount.get(), (int)this.metrics.getRequests(), (int)(memory.getUsed() / 1024L / 1024L), (int)(memory.getMax() / 1024L / 1024L), regionLoads, this.hlog.getCoprocessorHost().getCoprocessors());
    }

    String getOnlineRegionsAsPrintableString() {
        StringBuilder sb = new StringBuilder();
        for (HRegion r : this.onlineRegions.values()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(r.getRegionInfo().getEncodedName());
        }
        return sb.toString();
    }

    private void waitOnAllRegionsToClose(boolean abort) {
        int lastCount = -1;
        long previousLogTime = 0L;
        HashSet<String> closedRegions = new HashSet<String>();
        while (!this.isOnlineRegionsEmpty()) {
            int count = this.getNumberOfOnlineRegions();
            if (count != lastCount && System.currentTimeMillis() > previousLogTime + 1000L) {
                previousLogTime = System.currentTimeMillis();
                lastCount = count;
                LOG.info((Object)("Waiting on " + count + " regions to close"));
                if (count < 10 && LOG.isDebugEnabled()) {
                    LOG.debug(this.onlineRegions);
                }
            }
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (this.regionsInTransitionInRS.containsKey(hri.getEncodedNameAsBytes()) || closedRegions.contains(hri.getEncodedName())) continue;
                closedRegions.add(hri.getEncodedName());
                this.closeRegion(hri, abort, false);
            }
            if (this.regionsInTransitionInRS.isEmpty()) {
                if (this.isOnlineRegionsEmpty()) break;
                LOG.info((Object)"We were exiting though online regions are not empty, because some regions failed closing");
                break;
            }
            Threads.sleep(200L);
        }
    }

    private void closeWAL(boolean delete) {
        if (this.hlogForMeta != null) {
            try {
                this.hlogForMeta.close();
            }
            catch (Throwable e) {
                LOG.error((Object)"Metalog close and delete failed", RemoteExceptionHandler.checkThrowable(e));
            }
        }
        if (this.hlog != null) {
            try {
                if (delete) {
                    this.hlog.closeAndDelete();
                } else {
                    this.hlog.close();
                }
            }
            catch (Throwable e) {
                LOG.error((Object)"Close and delete failed", RemoteExceptionHandler.checkThrowable(e));
            }
        }
    }

    private void closeAllScanners() {
        for (Map.Entry<String, RegionScanner> e : this.scanners.entrySet()) {
            try {
                e.getValue().close();
            }
            catch (IOException ioe) {
                LOG.warn((Object)("Closing scanner " + e.getKey()), (Throwable)ioe);
            }
        }
    }

    protected void handleReportForDutyResponse(MapWritable c) throws IOException {
        try {
            for (Map.Entry e : c.entrySet()) {
                String key = ((Writable)e.getKey()).toString();
                if (key.equals("hbase.regionserver.hostname.seen.by.master")) {
                    String hostnameFromMasterPOV = ((Writable)e.getValue()).toString();
                    this.serverNameFromMasterPOV = new ServerName(hostnameFromMasterPOV, this.isa.getPort(), this.startcode);
                    LOG.info((Object)("Master passed us hostname to use. Was=" + this.isa.getHostName() + ", Now=" + this.serverNameFromMasterPOV.getHostname()));
                    continue;
                }
                String value = ((Writable)e.getValue()).toString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Config from master: " + key + "=" + value));
                }
                this.conf.set(key, value);
            }
            if (this.conf.get("mapred.task.id") == null) {
                this.conf.set("mapred.task.id", "hb_rs_" + this.serverNameFromMasterPOV.toString());
            }
            this.createMyEphemeralNode();
            this.conf.set("fs.defaultFS", this.conf.get("hbase.rootdir"));
            this.fs = new HFileSystem(this.conf, this.useHBaseChecksum);
            this.rootDir = new Path(this.conf.get("hbase.rootdir"));
            this.tableDescriptors = new FSTableDescriptors((FileSystem)this.fs, this.rootDir, true);
            this.hlog = this.setupWALAndReplication();
            this.metrics = new RegionServerMetrics();
            this.dynamicMetrics = RegionServerDynamicMetrics.newInstance(this);
            this.rsHost = new RegionServerCoprocessorHost(this, this.conf);
            this.startServiceThreads();
            LOG.info((Object)("Serving as " + this.serverNameFromMasterPOV + ", RPC listening on " + this.isa + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId())));
            this.isOnline = true;
        }
        catch (Throwable e) {
            LOG.warn((Object)"Exception in region server : ", e);
            this.isOnline = false;
            this.stop("Failed initialization");
            throw this.convertThrowableToIOE(this.cleanup(e, "Failed init"), "Region server startup failed");
        }
        finally {
            this.sleeper.skipSleepCycle();
        }
    }

    private String getMyEphemeralNodePath() {
        return ZKUtil.joinZNode(this.zooKeeper.rsZNode, this.getServerName().toString());
    }

    private void createMyEphemeralNode() throws KeeperException {
        ZKUtil.createEphemeralNodeAndWatch(this.zooKeeper, this.getMyEphemeralNodePath(), HConstants.EMPTY_BYTE_ARRAY);
    }

    private void deleteMyEphemeralNode() throws KeeperException {
        ZKUtil.deleteNode(this.zooKeeper, this.getMyEphemeralNodePath());
    }

    @Override
    public RegionServerAccounting getRegionServerAccounting() {
        return this.regionServerAccounting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HServerLoad.RegionLoad createRegionLoad(HRegion r) {
        byte[] name = r.getRegionName();
        int stores = 0;
        int storefiles = 0;
        int storeUncompressedSizeMB = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.memstoreSize.get() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        int rootIndexSizeKB = 0;
        int totalStaticIndexSizeKB = 0;
        int totalStaticBloomSizeKB = 0;
        long totalCompactingKVs = 0L;
        long currentCompactedKVs = 0L;
        Map<byte[], Store> map = r.stores;
        synchronized (map) {
            stores += r.stores.size();
            for (Store store : r.stores.values()) {
                storefiles += store.getStorefilesCount();
                storeUncompressedSizeMB += (int)(store.getStoreSizeUncompressed() / 1024L / 1024L);
                storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
                storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
                CompactionProgress progress = store.getCompactionProgress();
                if (progress != null) {
                    totalCompactingKVs += progress.totalCompactingKVs;
                    currentCompactedKVs += progress.currentCompactedKVs;
                }
                rootIndexSizeKB += (int)(store.getStorefilesIndexSize() / 1024L);
                totalStaticIndexSizeKB += (int)(store.getTotalStaticIndexSize() / 1024L);
                totalStaticBloomSizeKB += (int)(store.getTotalStaticBloomSize() / 1024L);
            }
        }
        return new HServerLoad.RegionLoad(name, stores, storefiles, storeUncompressedSizeMB, storefileSizeMB, memstoreSizeMB, storefileIndexSizeMB, rootIndexSizeKB, totalStaticIndexSizeKB, totalStaticBloomSizeKB, (int)r.readRequestsCount.get(), (int)r.writeRequestsCount.get(), totalCompactingKVs, currentCompactedKVs);
    }

    public HServerLoad.RegionLoad createRegionLoad(String encodedRegionName) {
        HRegion r = null;
        r = this.onlineRegions.get(encodedRegionName);
        return r != null ? this.createRegionLoad(r) : null;
    }

    private Throwable cleanup(Throwable t) {
        return this.cleanup(t, null);
    }

    private Throwable cleanup(Throwable t, String msg) {
        if (t instanceof NotServingRegionException) {
            LOG.debug((Object)("NotServingRegionException; " + t.getMessage()));
            return t;
        }
        if (msg == null) {
            LOG.error((Object)"", RemoteExceptionHandler.checkThrowable(t));
        } else {
            LOG.error((Object)msg, RemoteExceptionHandler.checkThrowable(t));
        }
        if (!this.checkOOME(t)) {
            this.checkFileSystem();
        }
        return t;
    }

    private IOException convertThrowableToIOE(Throwable t) {
        return this.convertThrowableToIOE(t, null);
    }

    private IOException convertThrowableToIOE(Throwable t, String msg) {
        return t instanceof IOException ? (IOException)t : (msg == null || msg.length() == 0 ? new IOException(t) : new IOException(msg, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkOOME(Throwable e) {
        boolean stop = false;
        try {
            if (e instanceof OutOfMemoryError || e.getCause() != null && e.getCause() instanceof OutOfMemoryError || e.getMessage() != null && e.getMessage().contains("java.lang.OutOfMemoryError")) {
                stop = true;
                LOG.fatal((Object)"Run out of memory; HRegionServer will abort itself immediately", e);
            }
        }
        finally {
            if (stop) {
                Runtime.getRuntime().halt(1);
            }
        }
        return stop;
    }

    public boolean checkFileSystem() {
        if (this.fsOk && this.fs != null) {
            try {
                FSUtils.checkFileSystemAvailable((FileSystem)this.fs);
            }
            catch (IOException e) {
                this.abort("File System not available", e);
                this.fsOk = false;
            }
        }
        return this.fsOk;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    private HLog setupWALAndReplication() throws IOException {
        Path oldLogDir = new Path(this.rootDir, ".oldlogs");
        Path logdir = new Path(this.rootDir, HLog.getHLogDirectoryName(this.serverNameFromMasterPOV.toString()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("logdir=" + logdir));
        }
        if (this.fs.exists(logdir)) {
            throw new RegionServerRunningException("Region server has already created directory at " + this.serverNameFromMasterPOV.toString());
        }
        HRegionServer.createNewReplicationInstance(this.conf, this, (FileSystem)this.fs, logdir, oldLogDir);
        return this.instantiateHLog(logdir, oldLogDir);
    }

    private synchronized HLog getMetaWAL() throws IOException {
        if (this.hlogForMeta == null) {
            String logName = HLog.getHLogDirectoryName(this.serverNameFromMasterPOV.toString());
            Path logdir = new Path(this.rootDir, logName);
            Path oldLogDir = new Path(this.rootDir, ".oldlogs");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("logdir=" + logdir));
            }
            this.hlogForMeta = new HLog(this.fs.getBackingFs(), logdir, oldLogDir, this.conf, this.getMetaWALActionListeners(), false, this.serverNameFromMasterPOV.toString(), true);
        }
        return this.hlogForMeta;
    }

    protected HLog instantiateHLog(Path logdir, Path oldLogDir) throws IOException {
        return new HLog(this.fs.getBackingFs(), logdir, oldLogDir, this.conf, this.getWALActionListeners(), this.serverNameFromMasterPOV.toString());
    }

    protected List<WALActionsListener> getWALActionListeners() {
        ArrayList<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
        this.hlogRoller = new LogRoller(this, this);
        listeners.add(this.hlogRoller);
        if (this.replicationSourceHandler != null && this.replicationSourceHandler.getWALActionsListener() != null) {
            listeners.add(this.replicationSourceHandler.getWALActionsListener());
        }
        return listeners;
    }

    protected List<WALActionsListener> getMetaWALActionListeners() {
        ArrayList<WALActionsListener> listeners = new ArrayList<WALActionsListener>();
        MetaLogRoller tmpLogRoller = new MetaLogRoller(this, this);
        String n = Thread.currentThread().getName();
        Threads.setDaemonThreadRunning(tmpLogRoller.getThread(), n + "MetaLogRoller", this.uncaughtExceptionHandler);
        this.metaHLogRoller = tmpLogRoller;
        tmpLogRoller = null;
        listeners.add(this.metaHLogRoller);
        return listeners;
    }

    protected LogRoller getLogRoller() {
        return this.hlogRoller;
    }

    protected void doMetrics() {
        try {
            this.metrics();
        }
        catch (Throwable e) {
            LOG.warn((Object)"Failed metrics", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void metrics() {
        this.metrics.regions.set(this.onlineRegions.size());
        this.metrics.incrementRequests(this.requestCount.get());
        this.metrics.requests.intervalHeartBeat();
        int stores = 0;
        int storefiles = 0;
        long memstoreSize = 0L;
        int readRequestsCount = 0;
        int writeRequestsCount = 0;
        long storefileIndexSize = 0L;
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        long totalStaticIndexSize = 0L;
        long totalStaticBloomSize = 0L;
        long numPutsWithoutWAL = 0L;
        long dataInMemoryWithoutWAL = 0L;
        long updatesBlockedMs = 0L;
        HashMap<String, MutableDouble> tempVals = new HashMap<String, MutableDouble>();
        for (Map.Entry<String, HRegion> entry : this.onlineRegions.entrySet()) {
            HRegion r = entry.getValue();
            memstoreSize += r.memstoreSize.get();
            numPutsWithoutWAL += r.numPutsWithoutWAL.get();
            dataInMemoryWithoutWAL += r.dataInMemoryWithoutWAL.get();
            readRequestsCount = (int)((long)readRequestsCount + r.readRequestsCount.get());
            writeRequestsCount = (int)((long)writeRequestsCount + r.writeRequestsCount.get());
            updatesBlockedMs += r.updatesBlockedMs.get();
            Map<byte[], Store> map = r.stores;
            synchronized (map) {
                stores += r.stores.size();
                for (Map.Entry<byte[], Store> ee : r.stores.entrySet()) {
                    Store store = ee.getValue();
                    SchemaMetrics schemaMetrics = store.getSchemaMetrics();
                    long tmpStorefiles = store.getStorefilesCount();
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.STORE_FILE_COUNT, tmpStorefiles);
                    storefiles = (int)((long)storefiles + tmpStorefiles);
                    long tmpStorefileIndexSize = store.getStorefilesIndexSize();
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.STORE_FILE_INDEX_SIZE, (long)((double)tmpStorefileIndexSize / 1048576.0));
                    storefileIndexSize += tmpStorefileIndexSize;
                    long tmpStorefilesSize = store.getStorefilesSize();
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.STORE_FILE_SIZE_MB, (long)((double)tmpStorefilesSize / 1048576.0));
                    long tmpStaticBloomSize = store.getTotalStaticBloomSize();
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.STATIC_BLOOM_SIZE_KB, (long)((double)tmpStaticBloomSize / 1024.0));
                    totalStaticBloomSize += tmpStaticBloomSize;
                    long tmpStaticIndexSize = store.getTotalStaticIndexSize();
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.STATIC_INDEX_SIZE_KB, (long)((double)tmpStaticIndexSize / 1024.0));
                    totalStaticIndexSize += tmpStaticIndexSize;
                    schemaMetrics.accumulateStoreMetric(tempVals, SchemaMetrics.StoreMetricType.MEMSTORE_SIZE_MB, (long)((double)store.getMemStoreSize() / 1048576.0));
                }
            }
            hdfsBlocksDistribution.add(r.getHDFSBlocksDistribution());
        }
        for (Map.Entry<String, HRegion> entry : tempVals.entrySet()) {
            RegionMetricsStorage.setNumericMetric(entry.getKey(), ((MutableDouble)entry.getValue()).longValue());
        }
        this.metrics.stores.set(stores);
        this.metrics.storefiles.set(storefiles);
        this.metrics.memstoreSizeMB.set((int)(memstoreSize / 0x100000L));
        this.metrics.mbInMemoryWithoutWAL.set((int)(dataInMemoryWithoutWAL / 0x100000L));
        this.metrics.numPutsWithoutWAL.set(numPutsWithoutWAL);
        this.metrics.storefileIndexSizeMB.set((int)(storefileIndexSize / 0x100000L));
        this.metrics.rootIndexSizeKB.set((int)(storefileIndexSize / 1024L));
        this.metrics.totalStaticIndexSizeKB.set((int)(totalStaticIndexSize / 1024L));
        this.metrics.totalStaticBloomSizeKB.set((int)(totalStaticBloomSize / 1024L));
        this.metrics.readRequestsCount.set((long)readRequestsCount);
        this.metrics.writeRequestsCount.set((long)writeRequestsCount);
        this.metrics.compactionQueueSize.set(this.compactSplitThread.getCompactionQueueSize());
        this.metrics.flushQueueSize.set(this.cacheFlusher.getFlushQueueSize());
        this.metrics.updatesBlockedSeconds.update(updatesBlockedMs > 0L ? updatesBlockedMs / 1000L : 0L);
        long updatesBlockedMsHigherWater = this.cacheFlusher.getUpdatesBlockedMsHighWater().get();
        this.metrics.updatesBlockedSecondsHighWater.update(updatesBlockedMsHigherWater > 0L ? updatesBlockedMsHigherWater / 1000L : 0L);
        BlockCache blockCache = this.cacheConfig.getBlockCache();
        if (blockCache != null) {
            this.metrics.blockCacheCount.set(blockCache.size());
            this.metrics.blockCacheFree.set(blockCache.getFreeSize());
            this.metrics.blockCacheSize.set(blockCache.getCurrentSize());
            CacheStats cacheStats = blockCache.getStats();
            this.metrics.blockCacheHitCount.set(cacheStats.getHitCount());
            this.metrics.blockCacheMissCount.set(cacheStats.getMissCount());
            this.metrics.blockCacheEvictedCount.set(blockCache.getEvictedCount());
            double ratio = blockCache.getStats().getHitRatio();
            int percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitRatio.set(percent);
            ratio = blockCache.getStats().getHitCachingRatio();
            percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitCachingRatio.set(percent);
            cacheStats.rollMetricsPeriod();
            ratio = cacheStats.getHitRatioPastNPeriods();
            percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitRatioPastNPeriods.set(percent);
            ratio = cacheStats.getHitCachingRatioPastNPeriods();
            percent = (int)(ratio * 100.0);
            this.metrics.blockCacheHitCachingRatioPastNPeriods.set(percent);
        }
        float localityIndex = hdfsBlocksDistribution.getBlockLocalityIndex(this.getServerName().getHostname());
        int percent = (int)(localityIndex * 100.0f);
        this.metrics.hdfsBlocksLocalityIndex.set(percent);
    }

    public RegionServerMetrics getMetrics() {
        return this.metrics;
    }

    public MasterAddressTracker getMasterAddressManager() {
        return this.masterAddressManager;
    }

    private void startServiceThreads() throws IOException {
        String n = Thread.currentThread().getName();
        this.service = new ExecutorService(this.getServerName().toString());
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_REGION, this.conf.getInt("hbase.regionserver.executor.openregion.threads", 3));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_ROOT, this.conf.getInt("hbase.regionserver.executor.openroot.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_OPEN_META, this.conf.getInt("hbase.regionserver.executor.openmeta.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_REGION, this.conf.getInt("hbase.regionserver.executor.closeregion.threads", 3));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_ROOT, this.conf.getInt("hbase.regionserver.executor.closeroot.threads", 1));
        this.service.startExecutorService(ExecutorService.ExecutorType.RS_CLOSE_META, this.conf.getInt("hbase.regionserver.executor.closemeta.threads", 1));
        Threads.setDaemonThreadRunning(this.hlogRoller.getThread(), n + ".logRoller", this.uncaughtExceptionHandler);
        Threads.setDaemonThreadRunning(this.cacheFlusher.getThread(), n + ".cacheFlusher", this.uncaughtExceptionHandler);
        Threads.setDaemonThreadRunning(this.compactionChecker.getThread(), n + ".compactionChecker", this.uncaughtExceptionHandler);
        Threads.setDaemonThreadRunning(this.periodicFlusher.getThread(), n + ".periodicFlusher", this.uncaughtExceptionHandler);
        if (this.healthCheckChore != null) {
            Threads.setDaemonThreadRunning(this.healthCheckChore.getThread(), n + ".healthChecker", this.uncaughtExceptionHandler);
        }
        this.leases.setName(n + ".leaseChecker");
        this.leases.start();
        this.webuiport = this.putUpWebUI();
        if (this.replicationSourceHandler == this.replicationSinkHandler && this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else if (this.replicationSourceHandler != null) {
            this.replicationSourceHandler.startReplicationService();
        } else if (this.replicationSinkHandler != null) {
            this.replicationSinkHandler.startReplicationService();
        }
        this.rpcServer.start();
        this.splitLogWorker = new SplitLogWorker(this.zooKeeper, this.getConfiguration(), this.getServerName().toString());
        this.splitLogWorker.start();
    }

    private int putUpWebUI() throws IOException {
        int port = this.conf.getInt("hbase.regionserver.info.port", 60030);
        if (port < 0) {
            return port;
        }
        String addr = this.conf.get("hbase.regionserver.info.bindAddress", "0.0.0.0");
        boolean auto = this.conf.getBoolean("hbase.regionserver.info.port.auto", false);
        while (true) {
            try {
                this.infoServer = new InfoServer(REGIONSERVER, addr, port, false, this.conf);
                this.infoServer.addServlet("status", "/rs-status", RSStatusServlet.class);
                this.infoServer.addServlet("dump", "/dump", RSDumpServlet.class);
                this.infoServer.setAttribute(REGIONSERVER, this);
                this.infoServer.setAttribute(REGIONSERVER_CONF, this.conf);
                this.infoServer.start();
            }
            catch (BindException e) {
                if (!auto) {
                    throw e;
                }
                LOG.info((Object)("Failed binding http info server to port: " + port));
                ++port;
                continue;
            }
            break;
        }
        return port;
    }

    private boolean isHealthy() {
        if (!this.fsOk) {
            return false;
        }
        if (!(this.leases.isAlive() && this.cacheFlusher.isAlive() && this.hlogRoller.isAlive() && this.compactionChecker.isAlive() || !this.periodicFlusher.isAlive())) {
            this.stop("One or more threads are no longer alive -- stop");
            return false;
        }
        if (this.metaHLogRoller != null && !this.metaHLogRoller.isAlive()) {
            this.stop("Meta HLog roller thread is no longer alive -- stop");
            return false;
        }
        return true;
    }

    @Override
    public HLog getWAL() {
        try {
            return this.getWAL(null);
        }
        catch (IOException e) {
            LOG.warn((Object)("getWAL threw exception " + e));
            return null;
        }
    }

    @Override
    public HLog getWAL(HRegionInfo regionInfo) throws IOException {
        if (this.separateHLogForMeta && regionInfo != null && regionInfo.isMetaTable()) {
            return this.getMetaWAL();
        }
        return this.hlog;
    }

    @Override
    public CatalogTracker getCatalogTracker() {
        return this.catalogTracker;
    }

    @Override
    public void stop(String msg) {
        try {
            if (this.rsHost != null) {
                this.rsHost.preStop(msg);
            }
            this.stopped = true;
            LOG.info((Object)("STOPPED: " + msg));
            this.sleeper.skipSleepCycle();
        }
        catch (IOException exp) {
            LOG.warn((Object)"The region server did not stop", (Throwable)exp);
        }
    }

    public void waitForServerOnline() {
        while (!this.isOnline() && !this.isStopped()) {
            this.sleeper.sleep();
        }
    }

    @Override
    public void postOpenDeployTasks(HRegion r, CatalogTracker ct, boolean daughter) throws KeeperException, IOException {
        this.checkOpen();
        LOG.info((Object)("Post open deploy tasks for region=" + r.getRegionNameAsString() + ", daughter=" + daughter));
        for (Store s : r.getStores().values()) {
            if (!s.hasReferences() && !s.needsCompaction()) continue;
            this.getCompactionRequester().requestCompaction(r, s, "Opening Region", null);
        }
        if (r.getRegionInfo().isRootRegion()) {
            RootLocationEditor.setRootLocation(this.getZooKeeper(), this.serverNameFromMasterPOV);
        } else if (r.getRegionInfo().isMetaRegion()) {
            MetaEditor.updateMetaLocation(ct, r.getRegionInfo(), this.serverNameFromMasterPOV);
        } else if (daughter) {
            MetaEditor.addDaughter(ct, r.getRegionInfo(), this.serverNameFromMasterPOV);
        } else {
            MetaEditor.updateRegionLocation(ct, r.getRegionInfo(), this.serverNameFromMasterPOV);
        }
        LOG.info((Object)("Done with post open deploy task for region=" + r.getRegionNameAsString() + ", daughter=" + daughter));
    }

    public HBaseRpcMetrics getRpcMetrics() {
        return this.rpcServer.getRpcMetrics();
    }

    @Override
    public RpcServer getRpcServer() {
        return this.rpcServer;
    }

    @Override
    public void abort(String reason, Throwable cause) {
        String msg = "ABORTING region server " + this + ": " + reason;
        if (cause != null) {
            LOG.fatal((Object)msg, cause);
        } else {
            LOG.fatal((Object)msg);
        }
        this.abortRequested = true;
        this.reservedSpace.clear();
        LOG.fatal((Object)("RegionServer abort: loaded coprocessors are: " + CoprocessorHost.getLoadedCoprocessors()));
        if (this.metrics != null) {
            LOG.info((Object)("Dump of metrics: " + this.metrics));
        }
        try {
            if (cause != null) {
                msg = msg + "\nCause:\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)cause);
            }
            if (this.hbaseMaster != null) {
                this.hbaseMaster.reportRSFatalError(this.serverNameFromMasterPOV.getVersionedBytes(), msg);
            }
        }
        catch (Throwable t) {
            LOG.warn((Object)"Unable to report fatal error to master", t);
        }
        this.stop(reason);
    }

    public void abort(String reason) {
        this.abort(reason, null);
    }

    @Override
    public boolean isAborted() {
        return this.abortRequested;
    }

    protected void kill() {
        this.killed = true;
        this.abort("Simulated kill");
    }

    protected void join() {
        Threads.shutdown(this.compactionChecker.getThread());
        Threads.shutdown(this.periodicFlusher.getThread());
        Threads.shutdown(this.cacheFlusher.getThread());
        if (this.healthCheckChore != null) {
            Threads.shutdown(this.healthCheckChore.getThread());
        }
        if (this.hlogRoller != null) {
            Threads.shutdown(this.hlogRoller.getThread());
        }
        if (this.metaHLogRoller != null) {
            Threads.shutdown(this.metaHLogRoller.getThread());
        }
        if (this.compactSplitThread != null) {
            this.compactSplitThread.join();
        }
        if (this.service != null) {
            this.service.shutdown();
        }
        if (this.replicationSourceHandler != null && this.replicationSourceHandler == this.replicationSinkHandler) {
            this.replicationSourceHandler.stopReplicationService();
        } else if (this.replicationSourceHandler != null) {
            this.replicationSourceHandler.stopReplicationService();
        } else if (this.replicationSinkHandler != null) {
            this.replicationSinkHandler.stopReplicationService();
        }
    }

    ReplicationSourceService getReplicationSourceService() {
        return this.replicationSourceHandler;
    }

    ReplicationSinkService getReplicationSinkService() {
        return this.replicationSinkHandler;
    }

    private ServerName getMaster() {
        ServerName masterServerName = null;
        long previousLogTime = 0L;
        HMasterRegionInterface master = null;
        InetSocketAddress masterIsa = null;
        while (this.keepLooping() && master == null) {
            masterServerName = this.masterAddressManager.getMasterAddress();
            if (masterServerName == null) {
                if (!this.keepLooping()) {
                    LOG.debug((Object)"No master found and cluster is stopped; bailing out");
                    return null;
                }
                LOG.debug((Object)"No master found; retry");
                previousLogTime = System.currentTimeMillis();
                this.sleeper.sleep();
                continue;
            }
            masterIsa = new InetSocketAddress(masterServerName.getHostname(), masterServerName.getPort());
            LOG.info((Object)("Attempting connect to Master server at " + masterServerName));
            try {
                master = HBaseRPC.waitForProxy(this.rpcEngine, HMasterRegionInterface.class, 29L, masterIsa, this.conf, -1, this.rpcTimeout, this.rpcTimeout);
            }
            catch (IOException e) {
                IOException iOException = e = e instanceof RemoteException ? ((RemoteException)((Object)e)).unwrapRemoteException() : e;
                if (e instanceof ServerNotRunningYetException) {
                    if (System.currentTimeMillis() > previousLogTime + 1000L) {
                        LOG.info((Object)"Master isn't available yet, retrying");
                        previousLogTime = System.currentTimeMillis();
                    }
                } else if (System.currentTimeMillis() > previousLogTime + 1000L) {
                    LOG.warn((Object)"Unable to connect to master. Retrying. Error was:", (Throwable)e);
                    previousLogTime = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        LOG.info((Object)("Connected to master at " + masterIsa));
        this.hbaseMaster = master;
        return masterServerName;
    }

    private boolean keepLooping() {
        return !this.stopped && this.isClusterUp();
    }

    private MapWritable reportForDuty() throws IOException {
        MapWritable result = null;
        ServerName masterServerName = this.getMaster();
        if (masterServerName == null) {
            return result;
        }
        try {
            this.requestCount.set(0);
            LOG.info((Object)("Telling master at " + masterServerName + " that we are up " + "with port=" + this.isa.getPort() + ", startcode=" + this.startcode));
            long now = EnvironmentEdgeManager.currentTimeMillis();
            int port = this.isa.getPort();
            result = this.hbaseMaster.regionServerStartup(port, this.startcode, now);
        }
        catch (RemoteException e) {
            IOException ioe = e.unwrapRemoteException();
            if (ioe instanceof ClockOutOfSyncException) {
                LOG.fatal((Object)"Master rejected startup because clock is out of sync", (Throwable)ioe);
                throw ioe;
            }
            LOG.warn((Object)"remote error telling master we are up", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn((Object)"error telling master we are up", (Throwable)e);
        }
        return result;
    }

    protected void closeAllRegions(boolean abort) {
        this.closeUserRegions(abort);
        this.closeMetaTableRegions(abort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeMetaTableRegions(boolean abort) {
        HRegion meta = null;
        HRegion root = null;
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegionInfo hri = e.getValue().getRegionInfo();
                if (hri.isRootRegion()) {
                    root = e.getValue();
                } else if (hri.isMetaRegion()) {
                    meta = e.getValue();
                }
                if (meta == null || root == null) continue;
                break;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (meta != null) {
            this.closeRegion(meta.getRegionInfo(), abort, false);
        }
        if (root != null) {
            this.closeRegion(root.getRegionInfo(), abort, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeUserRegions(boolean abort) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
                HRegion r = e.getValue();
                if (r.getRegionInfo().isMetaTable() || !r.isAvailable()) continue;
                this.closeRegion(r.getRegionInfo(), abort, false);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    @QosPriority(priority=100)
    public HRegionInfo getRegionInfo(byte[] regionName) throws NotServingRegionException, IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        return this.getRegion(regionName).getRegionInfo();
    }

    @Override
    public Result getClosestRowBefore(byte[] regionName, byte[] row, byte[] family) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            Result r = region.getClosestRowBefore(row, family);
            return r;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public Result get(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.get(get2, this.getLockFromId(get2.getLockId()));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean exists(byte[] regionName, Get get2) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            boolean result;
            Boolean result2;
            HRegion region = this.getRegion(regionName);
            Integer lock = this.getLockFromId(get2.getLockId());
            if (region.getCoprocessorHost() != null && (result2 = region.getCoprocessorHost().preExists(get2)) != null) {
                return result2;
            }
            Result r = region.get(get2, lock);
            boolean bl = result = r != null && !r.isEmpty();
            if (region.getCoprocessorHost() != null) {
                result = region.getCoprocessorHost().postExists(get2, result);
            }
            return result;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void put(byte[] regionName, Put put2) throws IOException {
        if (put2.getRow() == null) {
            throw new IllegalArgumentException("update has null row");
        }
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            boolean writeToWAL = put2.getWriteToWAL();
            region.put(put2, this.getLockFromId(put2.getLockId()), writeToWAL);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int put(byte[] regionName, List<Put> puts) throws IOException {
        this.checkOpen();
        HRegion region = null;
        int i = 0;
        try {
            region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Pair[] putsWithLocks = new Pair[puts.size()];
            for (Put p : puts) {
                Integer lock = this.getLockFromId(p.getLockId());
                putsWithLocks[i++] = new Pair<Put, Integer>(p, lock);
            }
            this.requestCount.addAndGet(puts.size());
            OperationStatus[] codes = region.batchMutate(putsWithLocks);
            for (i = 0; i < codes.length; ++i) {
                if (codes[i].getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) continue;
                return i;
            }
            return -1;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    private boolean checkAndMutate(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Writable w, Integer lock) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        try {
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            return region.checkAndMutate(row, family, qualifier, compareOp, comparator, w, lock, true);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean checkAndPut(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Put put2) throws IOException {
        Boolean result;
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to checkAndPut regionName is null");
        }
        HRegion region = this.getRegion(regionName);
        Integer lock = this.getLockFromId(put2.getLockId());
        BinaryComparator comparator = new BinaryComparator(value);
        if (region.getCoprocessorHost() != null && (result = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, put2)) != null) {
            return result;
        }
        boolean result2 = this.checkAndMutate(regionName, row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, put2, lock);
        if (region.getCoprocessorHost() != null) {
            result2 = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, put2, result2);
        }
        return result2;
    }

    @Override
    public boolean checkAndPut(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Put put2) throws IOException {
        Boolean result;
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to checkAndPut regionName is null");
        }
        HRegion region = this.getRegion(regionName);
        Integer lock = this.getLockFromId(put2.getLockId());
        if (region.getCoprocessorHost() != null && (result = region.getCoprocessorHost().preCheckAndPut(row, family, qualifier, compareOp, comparator, put2)) != null) {
            return result;
        }
        boolean result2 = this.checkAndMutate(regionName, row, family, qualifier, compareOp, comparator, put2, lock);
        if (region.getCoprocessorHost() != null) {
            result2 = region.getCoprocessorHost().postCheckAndPut(row, family, qualifier, compareOp, comparator, put2, result2);
        }
        return result2;
    }

    @Override
    public boolean checkAndDelete(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, byte[] value, Delete delete) throws IOException {
        Boolean result;
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to checkAndDelete regionName is null");
        }
        HRegion region = this.getRegion(regionName);
        Integer lock = this.getLockFromId(delete.getLockId());
        BinaryComparator comparator = new BinaryComparator(value);
        if (region.getCoprocessorHost() != null && (result = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, delete)) != null) {
            return result;
        }
        boolean result2 = this.checkAndMutate(regionName, row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, delete, lock);
        if (region.getCoprocessorHost() != null) {
            result2 = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, CompareFilter.CompareOp.EQUAL, comparator, delete, result2);
        }
        return result2;
    }

    @Override
    public List<String> getStoreFileList(byte[] regionName, byte[] columnFamily) throws IllegalArgumentException {
        return this.getStoreFileList(regionName, new byte[][]{columnFamily});
    }

    @Override
    public List<String> getStoreFileList(byte[] regionName, byte[][] columnFamilies) throws IllegalArgumentException {
        HRegion region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("No region: " + new String(regionName) + " available");
        }
        return region.getStoreFileList(columnFamilies);
    }

    @Override
    public List<String> getStoreFileList(byte[] regionName) throws IllegalArgumentException {
        HRegion region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("No region: " + new String(regionName) + " available");
        }
        Set<byte[]> columnFamilies = region.getStores().keySet();
        int nCF = columnFamilies.size();
        return region.getStoreFileList((byte[][])columnFamilies.toArray((T[])new byte[nCF][]));
    }

    @Override
    public void flushRegion(byte[] regionName) throws IllegalArgumentException, IOException {
        HRegion region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("No region : " + new String(regionName) + " available");
        }
        boolean needsCompaction = region.flushcache();
        if (needsCompaction) {
            this.compactSplitThread.requestCompaction(region, "Compaction through user triggered flush");
        }
    }

    @Override
    public void flushRegion(byte[] regionName, long ifOlderThanTS) throws IllegalArgumentException, IOException {
        boolean needsCompaction;
        HRegion region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("No region : " + new String(regionName) + " available");
        }
        if (region.getLastFlushTime() < ifOlderThanTS && (needsCompaction = region.flushcache())) {
            this.compactSplitThread.requestCompaction(region, "Compaction through user triggered flush");
        }
    }

    @Override
    public long getLastFlushTime(byte[] regionName) {
        HRegion region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new IllegalArgumentException("No region : " + new String(regionName) + " available");
        }
        return region.getLastFlushTime();
    }

    @Override
    public boolean checkAndDelete(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, WritableByteArrayComparable comparator, Delete delete) throws IOException {
        Boolean result;
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to checkAndDelete regionName is null");
        }
        HRegion region = this.getRegion(regionName);
        Integer lock = this.getLockFromId(delete.getLockId());
        if (region.getCoprocessorHost() != null && (result = region.getCoprocessorHost().preCheckAndDelete(row, family, qualifier, compareOp, comparator, delete)) != null) {
            return result;
        }
        boolean result2 = this.checkAndMutate(regionName, row, family, qualifier, compareOp, comparator, delete, lock);
        if (region.getCoprocessorHost() != null) {
            result2 = region.getCoprocessorHost().postCheckAndDelete(row, family, qualifier, compareOp, comparator, delete, result2);
        }
        return result2;
    }

    @Override
    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (scan == null) {
            npe = new NullPointerException("scan is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to openScanner", npe);
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion r = this.getRegion(regionName);
            r.checkRow(scan.getStartRow(), "Scan");
            scan.setLoadColumnFamiliesOnDemand(r.isLoadingCfsOnDemandDefault() || scan.doLoadColumnFamiliesOnDemand());
            r.prepareScanner(scan);
            RegionScanner s = null;
            if (r.getCoprocessorHost() != null) {
                s = r.getCoprocessorHost().preScannerOpen(scan);
            }
            if (s == null) {
                s = r.getScanner(scan);
            }
            if (r.getCoprocessorHost() != null) {
                RegionScanner savedScanner = r.getCoprocessorHost().postScannerOpen(scan, s);
                if (savedScanner == null) {
                    LOG.warn((Object)"PostScannerOpen impl returning null. Check the RegionObserver implementation.");
                } else {
                    s = savedScanner;
                }
            }
            return this.addScanner(s);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Failed openScanner"));
        }
    }

    protected long addScanner(RegionScanner s) throws Leases.LeaseStillHeldException {
        long scannerId = -1L;
        scannerId = this.rand.nextLong();
        String scannerName = String.valueOf(scannerId);
        this.scanners.put(scannerName, s);
        this.leases.createLease(scannerName, new ScannerListener(scannerName));
        return scannerId;
    }

    @Override
    public Result next(long scannerId) throws IOException {
        Result[] res = this.next(scannerId, 1);
        if (res == null || res.length == 0) {
            return null;
        }
        return res[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result[] next(long scannerId, int nbRows) throws IOException {
        String scannerName = String.valueOf(scannerId);
        Result[] s = this.scanners.get(scannerName);
        if (s == null) {
            LOG.info((Object)("Client tried to access missing scanner " + scannerName));
            throw new UnknownScannerException("Name: " + scannerName);
        }
        try {
            this.checkOpen();
        }
        catch (IOException e) {
            try {
                this.leases.cancelLease(scannerName);
            }
            catch (LeaseException le) {
                LOG.info((Object)("Server shutting down and client tried to access missing scanner " + scannerName));
            }
            throw e;
        }
        Leases.Lease lease = null;
        try {
            Result[] resultArray;
            try {
                lease = this.leases.removeLease(scannerName);
            }
            catch (LeaseException le) {
                LOG.info((Object)("Client tried to access missing scanner " + scannerName + " (no lease)"));
                throw new UnknownScannerException("No lease for " + scannerName + ": " + le.getMessage());
            }
            ArrayList<Result> results = new ArrayList<Result>(nbRows);
            long currentScanResultSize = 0L;
            ArrayList<KeyValue> values = new ArrayList<KeyValue>();
            HRegion region = this.getRegion(s.getRegionInfo().getRegionName());
            if (region != null && region.getCoprocessorHost() != null) {
                Boolean bypass = region.getCoprocessorHost().preScannerNext((InternalScanner)s, results, nbRows);
                if (!results.isEmpty()) {
                    for (Result r : results) {
                        if (this.maxScannerResultSize >= Long.MAX_VALUE) continue;
                        for (KeyValue kv : r.raw()) {
                            currentScanResultSize += kv.heapSize();
                        }
                    }
                }
                if (bypass != null) {
                    resultArray = s.isFilterDone() && results.isEmpty() ? null : results.toArray(new Result[0]);
                    return resultArray;
                }
            }
            MultiVersionConsistencyControl.setThreadReadPoint(s.getMvccReadPoint());
            region.startRegionOperation();
            try {
                resultArray = s;
                synchronized (s) {
                    int i;
                    for (i = 0; i < nbRows && currentScanResultSize < this.maxScannerResultSize; ++i) {
                        boolean moreRows = s.nextRaw(values, "nextsize");
                        if (!values.isEmpty()) {
                            if (this.maxScannerResultSize < Long.MAX_VALUE) {
                                for (KeyValue kv : values) {
                                    currentScanResultSize += kv.heapSize();
                                }
                            }
                            results.add(new Result(values));
                        }
                        if (!moreRows) break;
                        values.clear();
                    }
                    // ** MonitorExit[var13_17] (shouldn't be in output)
                    this.requestCount.addAndGet(i);
                    region.readRequestsCount.add((long)i);
                    region.setOpMetricsReadRequestCount(region.readRequestsCount.get());
                }
            }
            finally {
                region.closeRegionOperation();
            }
            {
                if (region != null && region.getCoprocessorHost() != null) {
                    region.getCoprocessorHost().postScannerNext((InternalScanner)s, results, nbRows, true);
                }
                Result[] resultArray2 = s.isFilterDone() && results.isEmpty() ? null : results.toArray(new Result[0]);
                return resultArray2;
            }
        }
        catch (Throwable t) {
            if (t instanceof NotServingRegionException) {
                this.scanners.remove(scannerName);
            }
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
        finally {
            if (this.scanners.containsKey(scannerName) && lease != null) {
                this.leases.addLease(lease);
            }
        }
    }

    @Override
    public void close(long scannerId) throws IOException {
        try {
            this.checkOpen();
            this.requestCount.incrementAndGet();
            String scannerName = String.valueOf(scannerId);
            RegionScanner s = this.scanners.get(scannerName);
            HRegion region = null;
            if (s != null && (region = this.getRegion(s.getRegionInfo().getRegionName())) != null && region.getCoprocessorHost() != null && region.getCoprocessorHost().preScannerClose(s)) {
                return;
            }
            s = this.scanners.remove(scannerName);
            if (s != null) {
                s.close();
                this.leases.cancelLease(scannerName);
                if (region != null && region.getCoprocessorHost() != null) {
                    region.getCoprocessorHost().postScannerClose(s);
                }
            }
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public void delete(byte[] regionName, Delete delete) throws IOException {
        this.checkOpen();
        try {
            boolean writeToWAL = delete.getWriteToWAL();
            this.requestCount.incrementAndGet();
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            Integer lid = this.getLockFromId(delete.getLockId());
            region.delete(delete, lid, writeToWAL);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public int delete(byte[] regionName, List<Delete> deletes) throws IOException {
        this.checkOpen();
        int i = 0;
        HRegion region = null;
        try {
            region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            int size = deletes.size();
            Integer[] locks = new Integer[size];
            for (Delete delete : deletes) {
                this.requestCount.incrementAndGet();
                locks[i] = this.getLockFromId(delete.getLockId());
                region.delete(delete, locks[i], delete.getWriteToWAL());
                ++i;
            }
        }
        catch (WrongRegionException ex) {
            LOG.debug((Object)("Batch deletes: " + i), (Throwable)ex);
            return i;
        }
        catch (NotServingRegionException ex) {
            return i;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
        return -1;
    }

    @Override
    public long lockRow(byte[] regionName, byte[] row) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (row == null) {
            npe = new NullPointerException("row to lock is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to lockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().preLockRow(regionName, row);
            }
            Integer r = region.obtainRowLock(row);
            long lockId = this.addRowLock(r, region);
            LOG.debug((Object)("Row lock " + lockId + " explicitly acquired by client"));
            return lockId;
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t, "Error obtaining row lock (fsOk: " + this.fsOk + ")"));
        }
    }

    protected long addRowLock(Integer r, HRegion region) throws Leases.LeaseStillHeldException {
        long lockId = -1L;
        lockId = this.rand.nextLong();
        String lockName = String.valueOf(lockId);
        this.rowlocks.put(lockName, r);
        this.leases.createLease(lockName, new RowLockListener(lockName, region));
        return lockId;
    }

    Integer getLockFromId(long lockId) throws IOException {
        if (lockId == -1L) {
            return null;
        }
        String lockName = String.valueOf(lockId);
        Integer rl = this.rowlocks.get(lockName);
        if (rl == null) {
            throw new UnknownRowLockException("Invalid row lock");
        }
        this.leases.renewLease(lockName);
        return rl;
    }

    @Override
    @QosPriority(priority=100)
    public void unlockRow(byte[] regionName, long lockId) throws IOException {
        this.checkOpen();
        NullPointerException npe = null;
        if (regionName == null) {
            npe = new NullPointerException("regionName is null");
        } else if (lockId == -1L) {
            npe = new NullPointerException("lockId is null");
        }
        if (npe != null) {
            IOException io = new IOException("Invalid arguments to unlockRow");
            io.initCause(npe);
            throw io;
        }
        this.requestCount.incrementAndGet();
        try {
            String lockName;
            Integer r;
            HRegion region = this.getRegion(regionName);
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().preUnLockRow(regionName, lockId);
            }
            if ((r = this.rowlocks.remove(lockName = String.valueOf(lockId))) == null) {
                throw new UnknownRowLockException(lockName);
            }
            region.releaseRowLock(r);
            this.leases.cancelLease(lockName);
            LOG.debug((Object)("Row lock " + lockId + " has been explicitly released by client"));
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    @Override
    public boolean bulkLoadHFiles(List<Pair<byte[], String>> familyPaths, byte[] regionName) throws IOException {
        this.checkOpen();
        HRegion region = this.getRegion(regionName);
        boolean bypass = false;
        if (region.getCoprocessorHost() != null) {
            bypass = region.getCoprocessorHost().preBulkLoadHFile(familyPaths);
        }
        boolean loaded = false;
        if (!bypass) {
            loaded = region.bulkLoadHFiles(familyPaths);
        }
        if (region.getCoprocessorHost() != null) {
            loaded = region.getCoprocessorHost().postBulkLoadHFile(familyPaths, loaded);
        }
        return loaded;
    }

    @Override
    @QosPriority(priority=100)
    public RegionOpeningState openRegion(HRegionInfo region) throws IOException {
        return this.openRegion(region, -1);
    }

    @Override
    @QosPriority(priority=100)
    public RegionOpeningState openRegion(HRegionInfo region, int versionOfOfflineNode) throws IOException {
        return this.openRegion(region, versionOfOfflineNode, null);
    }

    private RegionOpeningState openRegion(HRegionInfo region, int versionOfOfflineNode, Map<String, HTableDescriptor> htds) throws IOException {
        boolean isNewRit;
        this.checkOpen();
        HRegion onlineRegion = this.getFromOnlineRegions(region.getEncodedName());
        if (null != onlineRegion) {
            Pair<HRegionInfo, ServerName> p = MetaReader.getRegion(this.catalogTracker, region.getRegionName());
            if (this.getServerName().equals(p.getSecond())) {
                LOG.warn((Object)("Attempted open of " + region.getEncodedName() + " but already online on this server"));
                return RegionOpeningState.ALREADY_OPENED;
            }
            LOG.warn((Object)("The region " + region.getEncodedName() + " is online on this server but META does not have this server."));
            this.removeFromOnlineRegions(region.getEncodedName());
        }
        if (!(isNewRit = this.addRegionsInTransition(region, OPEN))) {
            LOG.info((Object)("Receiving OPEN for the region:" + region.getRegionNameAsString() + " , which we are already trying to OPEN" + " - ignoring this new request for this region."));
            return RegionOpeningState.OPENED;
        }
        try {
            LOG.info((Object)("Received request to open region: " + region.getRegionNameAsString()));
            HTableDescriptor htd = null;
            if (htds == null) {
                htd = this.tableDescriptors.get(region.getTableName());
            } else {
                htd = htds.get(region.getTableNameAsString());
                if (htd == null) {
                    htd = this.tableDescriptors.get(region.getTableName());
                    htds.put(region.getTableNameAsString(), htd);
                }
            }
            int version = this.transitionZookeeperOfflineToOpening(region, versionOfOfflineNode);
            if (region.isRootRegion()) {
                this.service.submit(new OpenRootHandler(this, this, region, htd, version));
            } else if (region.isMetaRegion()) {
                this.service.submit(new OpenMetaHandler(this, this, region, htd, version));
            } else {
                this.service.submit(new OpenRegionHandler(this, this, region, htd, version));
            }
        }
        catch (IOException ie) {
            this.removeFromRegionsInTransition(region);
            throw ie;
        }
        return RegionOpeningState.OPENED;
    }

    int transitionZookeeperOfflineToOpening(HRegionInfo hri, int versionOfOfflineNode) throws IOException {
        int version = -1;
        try {
            version = ZKAssign.transitionNode(this.zooKeeper, hri, this.getServerName(), EventHandler.EventType.M_ZK_REGION_OFFLINE, EventHandler.EventType.RS_ZK_REGION_OPENING, versionOfOfflineNode);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Error transition from OFFLINE to OPENING for region=" + hri.getEncodedName()), (Throwable)e);
        }
        if (version == -1) {
            throw new IOException("Failed transition from OFFLINE to OPENING for region=" + hri.getEncodedName());
        }
        return version;
    }

    protected boolean addRegionsInTransition(HRegionInfo region, String currentAction) throws RegionAlreadyInTransitionException {
        boolean isOpen = currentAction.equals(OPEN);
        Boolean action = this.regionsInTransitionInRS.putIfAbsent(region.getEncodedNameAsBytes(), isOpen);
        if (action == null) {
            return true;
        }
        if (isOpen && action.booleanValue()) {
            return false;
        }
        throw new RegionAlreadyInTransitionException("Received:" + currentAction + " for the region:" + region.getRegionNameAsString() + ", which we are already trying to " + (action != false ? OPEN : CLOSE) + ".");
    }

    @Override
    @QosPriority(priority=100)
    public void openRegions(List<HRegionInfo> regions) throws IOException {
        this.checkOpen();
        LOG.info((Object)("Received request to open " + regions.size() + " region(s)"));
        HashMap<String, HTableDescriptor> htds = new HashMap<String, HTableDescriptor>(regions.size());
        for (HRegionInfo region : regions) {
            this.openRegion(region, -1, htds);
        }
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(HRegionInfo region) throws IOException {
        return this.closeRegion(region, true, -1);
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(HRegionInfo region, int versionOfClosingNode) throws IOException {
        return this.closeRegion(region, true, versionOfClosingNode);
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(HRegionInfo region, boolean zk) throws IOException {
        return this.closeRegion(region, zk, -1);
    }

    @QosPriority(priority=100)
    protected boolean closeRegion(HRegionInfo region, boolean zk, int versionOfClosingNode) throws IOException {
        this.checkOpen();
        HRegion actualRegion = this.getFromOnlineRegions(region.getEncodedName());
        if (actualRegion != null && actualRegion.getCoprocessorHost() != null) {
            actualRegion.getCoprocessorHost().preClose(false);
        }
        LOG.info((Object)("Received close region: " + region.getRegionNameAsString() + ". Version of ZK closing node:" + versionOfClosingNode));
        boolean hasit = this.onlineRegions.containsKey(region.getEncodedName());
        if (!hasit) {
            LOG.warn((Object)("Received close for region we are not serving; " + region.getEncodedName()));
            throw new NotServingRegionException("Received close for " + region.getRegionNameAsString() + " but we are not serving it");
        }
        return this.closeRegion(region, false, zk, versionOfClosingNode);
    }

    @Override
    @QosPriority(priority=100)
    public boolean closeRegion(byte[] encodedRegionName, boolean zk) throws IOException {
        return this.closeRegion(encodedRegionName, false, zk);
    }

    protected boolean closeRegion(HRegionInfo region, boolean abort, boolean zk) {
        return this.closeRegion(region, abort, zk, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeRegion(HRegionInfo region, boolean abort, boolean zk, int versionOfClosingNode) {
        HRegion actualRegion = this.getFromOnlineRegions(region.getEncodedName());
        if (actualRegion != null && actualRegion.getCoprocessorHost() != null) {
            try {
                actualRegion.getCoprocessorHost().preClose(abort);
            }
            catch (IOException e) {
                LOG.warn((Object)e);
                return false;
            }
        }
        try {
            this.addRegionsInTransition(region, CLOSE);
        }
        catch (RegionAlreadyInTransitionException rate) {
            LOG.warn((Object)("Received close for region we are already opening or closing; " + region.getEncodedName()));
            return false;
        }
        boolean success = false;
        try {
            CloseRegionHandler crh = null;
            crh = region.isRootRegion() ? new CloseRootHandler(this, this, region, abort, zk, versionOfClosingNode) : (region.isMetaRegion() ? new CloseMetaHandler(this, this, region, abort, zk, versionOfClosingNode) : new CloseRegionHandler(this, this, region, abort, zk, versionOfClosingNode));
            this.service.submit(crh);
            success = true;
        }
        finally {
            if (!success) {
                this.removeFromRegionsInTransition(region);
            }
        }
        return true;
    }

    protected boolean closeRegion(byte[] encodedRegionName, boolean abort, boolean zk) throws IOException {
        String encodedRegionNameStr = Bytes.toString(encodedRegionName);
        HRegion region = this.getFromOnlineRegions(encodedRegionNameStr);
        if (null != region) {
            return this.closeRegion(region.getRegionInfo(), abort, zk);
        }
        LOG.error((Object)("The specified region name" + encodedRegionNameStr + " does not exist to close the region."));
        return false;
    }

    @Override
    @QosPriority(priority=100)
    public void flushRegion(HRegionInfo regionInfo) throws NotServingRegionException, IOException {
        this.checkOpen();
        LOG.info((Object)("Flushing " + regionInfo.getRegionNameAsString()));
        HRegion region = this.getRegion(regionInfo.getRegionName());
        boolean needsCompaction = region.flushcache();
        if (needsCompaction) {
            this.compactSplitThread.requestCompaction(region, "Compaction through user triggered flush");
        }
    }

    @Override
    @QosPriority(priority=100)
    public void splitRegion(HRegionInfo regionInfo) throws NotServingRegionException, IOException {
        this.splitRegion(regionInfo, null);
    }

    @Override
    public void splitRegion(HRegionInfo regionInfo, byte[] splitPoint) throws NotServingRegionException, IOException {
        this.checkOpen();
        HRegion region = this.getRegion(regionInfo.getRegionName());
        region.flushcache();
        region.forceSplit(splitPoint);
        this.compactSplitThread.requestSplit(region, region.checkSplit());
    }

    @Override
    @QosPriority(priority=100)
    public void compactRegion(HRegionInfo regionInfo, boolean major) throws NotServingRegionException, IOException {
        this.compactRegion(regionInfo, major, null);
    }

    @Override
    @QosPriority(priority=100)
    public void compactRegion(HRegionInfo regionInfo, boolean major, byte[] family) throws NotServingRegionException, IOException {
        this.checkOpen();
        HRegion region = this.getRegion(regionInfo.getRegionName());
        Store store = null;
        if (family != null && (store = region.getStore(family)) == null) {
            throw new IOException("column family " + Bytes.toString(family) + " does not exist in region " + new String(region.getRegionNameAsString()));
        }
        if (major) {
            if (family != null) {
                store.triggerMajorCompaction();
            } else {
                region.triggerMajorCompaction();
            }
        }
        String familyLogMsg = family != null ? " for column family: " + Bytes.toString(family) : "";
        LOG.trace((Object)("User-triggered compaction requested for region " + region.getRegionNameAsString() + familyLogMsg));
        String log = "User-triggered " + (major ? "major " : "") + "compaction" + familyLogMsg;
        if (family != null) {
            this.compactSplitThread.requestCompaction(region, store, log, 1, null);
        } else {
            this.compactSplitThread.requestCompaction(region, log, 1, null);
        }
    }

    public InfoServer getInfoServer() {
        return this.infoServer;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public boolean isStopping() {
        return this.stopping;
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.lock.writeLock();
    }

    @Override
    @QosPriority(priority=100)
    public List<HRegionInfo> getOnlineRegions() throws IOException {
        this.checkOpen();
        ArrayList<HRegionInfo> list = new ArrayList<HRegionInfo>(this.onlineRegions.size());
        for (Map.Entry<String, HRegion> e : this.onlineRegions.entrySet()) {
            list.add(e.getValue().getRegionInfo());
        }
        Collections.sort(list);
        return list;
    }

    public int getNumberOfOnlineRegions() {
        return this.onlineRegions.size();
    }

    boolean isOnlineRegionsEmpty() {
        return this.onlineRegions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRegionStats(String encodedRegionName) throws IOException {
        HRegion r = null;
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            r = this.onlineRegions.get(encodedRegionName);
        }
        if (r == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        int stores = 0;
        int storefiles = 0;
        int storefileSizeMB = 0;
        int memstoreSizeMB = (int)(r.memstoreSize.get() / 1024L / 1024L);
        int storefileIndexSizeMB = 0;
        long totalCompactingKVs = 0L;
        long currentCompactedKVs = 0L;
        Map<byte[], Store> map2 = r.stores;
        synchronized (map2) {
            stores += r.stores.size();
            for (Store store : r.stores.values()) {
                storefiles += store.getStorefilesCount();
                storefileSizeMB += (int)(store.getStorefilesSize() / 1024L / 1024L);
                storefileIndexSizeMB += (int)(store.getStorefilesIndexSize() / 1024L / 1024L);
            }
        }
        TreeMap<String, Integer> map3 = new TreeMap<String, Integer>();
        map3.put("stores", stores);
        map3.put("storefiles", storefiles);
        map3.put("storefileSizeMB", storefileIndexSizeMB);
        map3.put("memstoreSizeMB", memstoreSizeMB);
        StringWriter w = new StringWriter();
        mapper.writeValue((Writer)w, map3);
        w.close();
        return Bytes.toBytes(w.toString());
    }

    public Collection<HRegion> getOnlineRegionsLocalContext() {
        Collection<HRegion> regions = this.onlineRegions.values();
        return Collections.unmodifiableCollection(regions);
    }

    @Override
    public void addToOnlineRegions(HRegion region) {
        this.onlineRegions.put(region.getRegionInfo().getEncodedName(), region);
    }

    @Override
    public boolean removeFromOnlineRegions(String encodedName) {
        HRegion toReturn = null;
        toReturn = this.onlineRegions.remove(encodedName);
        this.dynamicMetrics.clear();
        return toReturn != null;
    }

    public SortedMap<Long, HRegion> getCopyOfOnlineRegionsSortedBySize() {
        TreeMap<Long, HRegion> sortedRegions = new TreeMap<Long, HRegion>(new Comparator<Long>(){

            @Override
            public int compare(Long a, Long b) {
                return -1 * a.compareTo(b);
            }
        });
        for (HRegion region : this.onlineRegions.values()) {
            sortedRegions.put(region.memstoreSize.get(), region);
        }
        return sortedRegions;
    }

    @Override
    public HRegion getFromOnlineRegions(String encodedRegionName) {
        HRegion r = null;
        r = this.onlineRegions.get(encodedRegionName);
        return r;
    }

    public HRegion getOnlineRegion(byte[] regionName) {
        return this.getFromOnlineRegions(HRegionInfo.encodeRegionName(regionName));
    }

    public AtomicInteger getRequestCount() {
        return this.requestCount;
    }

    public long getStartcode() {
        return this.startcode;
    }

    @Override
    public FlushRequester getFlushRequester() {
        return this.cacheFlusher;
    }

    protected HRegion getRegion(byte[] regionName) throws NotServingRegionException {
        HRegion region = null;
        region = this.getOnlineRegion(regionName);
        if (region == null) {
            throw new NotServingRegionException("Region is not online: " + Bytes.toStringBinary(regionName));
        }
        return region;
    }

    protected HRegionInfo[] getMostLoadedRegions() {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>();
        for (HRegion r : this.onlineRegions.values()) {
            if (!r.isAvailable()) continue;
            if (regions.size() >= this.numRegionsToReport) break;
            regions.add(r.getRegionInfo());
        }
        return regions.toArray(new HRegionInfo[regions.size()]);
    }

    protected void checkOpen() throws IOException {
        if (this.stopped || this.abortRequested) {
            throw new RegionServerStoppedException("Server " + this.getServerName() + " not running" + (this.abortRequested ? ", aborting" : ""));
        }
        if (!this.fsOk) {
            throw new RegionServerStoppedException("File system not available");
        }
    }

    @Override
    @QosPriority(priority=100)
    public ProtocolSignature getProtocolSignature(String protocol, long version, int clientMethodsHashCode) throws IOException {
        if (protocol.equals(HRegionInterface.class.getName())) {
            return new ProtocolSignature(29L, null);
        }
        throw new IOException("Unknown protocol: " + protocol);
    }

    @Override
    @QosPriority(priority=100)
    public long getProtocolVersion(String protocol, long clientVersion) throws IOException {
        if (protocol.equals(HRegionInterface.class.getName())) {
            return 29L;
        }
        throw new IOException("Unknown protocol: " + protocol);
    }

    @Override
    public Leases getLeases() {
        return this.leases;
    }

    protected Path getRootDir() {
        return this.rootDir;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    public HServerInfo getServerInfo() {
        try {
            return this.getHServerInfo();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void mutateRow(byte[] regionName, RowMutations rm) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to mutateRow regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            if (!region.getRegionInfo().isMetaTable()) {
                this.cacheFlusher.reclaimMemStoreMemory();
            }
            region.mutateRow(rm);
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    public Result append(byte[] regionName, Append append) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to increment regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            Result resVal;
            HRegion region = this.getRegion(regionName);
            Integer lock = this.getLockFromId(append.getLockId());
            Append appVal = append;
            if (region.getCoprocessorHost() != null && (resVal = region.getCoprocessorHost().preAppend(appVal)) != null) {
                return resVal;
            }
            resVal = region.append(appVal, lock, append.getWriteToWAL());
            if (region.getCoprocessorHost() != null) {
                region.getCoprocessorHost().postAppend(appVal, resVal);
            }
            return resVal;
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    public Result increment(byte[] regionName, Increment increment2) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to increment regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            Result resVal;
            HRegion region = this.getRegion(regionName);
            Integer lock = this.getLockFromId(increment2.getLockId());
            Increment incVal = increment2;
            if (region.getCoprocessorHost() != null && (resVal = region.getCoprocessorHost().preIncrement(incVal)) != null) {
                return resVal;
            }
            resVal = region.increment(incVal, lock, increment2.getWriteToWAL());
            if (region.getCoprocessorHost() != null) {
                resVal = region.getCoprocessorHost().postIncrement(incVal, resVal);
            }
            return resVal;
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    public long incrementColumnValue(byte[] regionName, byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkOpen();
        if (regionName == null) {
            throw new IOException("Invalid arguments to incrementColumnValue regionName is null");
        }
        this.requestCount.incrementAndGet();
        try {
            Long amountVal;
            HRegion region = this.getRegion(regionName);
            if (region.getCoprocessorHost() != null && (amountVal = region.getCoprocessorHost().preIncrementColumnValue(row, family, qualifier, amount, writeToWAL)) != null) {
                return amountVal;
            }
            long retval = region.incrementColumnValue(row, family, qualifier, amount, writeToWAL);
            if (region.getCoprocessorHost() != null) {
                retval = region.getCoprocessorHost().postIncrementColumnValue(row, family, qualifier, amount, writeToWAL, retval);
            }
            return retval;
        }
        catch (IOException e) {
            this.checkFileSystem();
            throw e;
        }
    }

    @Override
    @QosPriority(priority=100)
    public HServerInfo getHServerInfo() throws IOException {
        this.checkOpen();
        return new HServerInfo(new HServerAddress(this.isa), this.startcode, this.webuiport);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <R> MultiResponse multi(MultiAction<R> multi) throws IOException {
        this.checkOpen();
        MultiResponse response = new MultiResponse();
        for (Map.Entry e : multi.actions.entrySet()) {
            byte[] regionName = e.getKey();
            List actionsForRegion = e.getValue();
            Collections.sort(actionsForRegion);
            ArrayList mutations = new ArrayList();
            for (Action a : actionsForRegion) {
                Row action = a.getAction();
                int n = a.getOriginalIndex();
                try {
                    if (action instanceof Delete || action instanceof Put) {
                        mutations.add(a);
                        continue;
                    }
                    if (action instanceof Get) {
                        response.add(regionName, n, this.get(regionName, (Get)action));
                        continue;
                    }
                    if (action instanceof Exec) {
                        ExecResult execResult = this.execCoprocessor(regionName, (Exec)action);
                        response.add(regionName, new Pair<Integer, Object>(a.getOriginalIndex(), execResult.getValue()));
                        continue;
                    }
                    if (action instanceof Increment) {
                        response.add(regionName, n, this.increment(regionName, (Increment)action));
                        continue;
                    }
                    if (action instanceof Append) {
                        response.add(regionName, n, this.append(regionName, (Append)action));
                        continue;
                    }
                    if (action instanceof RowMutations) {
                        this.mutateRow(regionName, (RowMutations)action);
                        response.add(regionName, n, new Result());
                        continue;
                    }
                    LOG.debug((Object)"Error: invalid Action, row must be a Get, Delete, Put, Exec, Increment, or Append.");
                    throw new DoNotRetryIOException("Invalid Action, row must be a Get, Delete, Put, Exec, Increment, or Append.");
                }
                catch (IOException iOException) {
                    response.add(regionName, n, iOException);
                }
            }
            if (mutations.isEmpty()) continue;
            try {
                void var12_20;
                HRegion region = this.getRegion(regionName);
                if (!region.getRegionInfo().isMetaTable()) {
                    this.cacheFlusher.reclaimMemStoreMemory();
                }
                ArrayList mutationsWithLocks = Lists.newArrayListWithCapacity((int)mutations.size());
                for (Action action : mutations) {
                    Integer lock;
                    Mutation m = (Mutation)action.getAction();
                    try {
                        lock = this.getLockFromId(m.getLockId());
                    }
                    catch (UnknownRowLockException ex) {
                        response.add(regionName, action.getOriginalIndex(), ex);
                        continue;
                    }
                    mutationsWithLocks.add(new Pair<Mutation, Integer>(m, lock));
                }
                this.requestCount.addAndGet(mutations.size());
                OperationStatus[] operationStatusArray = region.batchMutate(mutationsWithLocks.toArray(new Pair[0]));
                boolean bl = false;
                while (var12_20 < operationStatusArray.length) {
                    OperationStatus code = operationStatusArray[var12_20];
                    Action theAction = (Action)mutations.get((int)var12_20);
                    Object result = null;
                    if (code.getOperationStatusCode() == HConstants.OperationStatusCode.SUCCESS) {
                        result = new Result();
                    } else if (code.getOperationStatusCode() == HConstants.OperationStatusCode.SANITY_CHECK_FAILURE) {
                        result = new DoNotRetryIOException(code.getExceptionMsg());
                    } else if (code.getOperationStatusCode() == HConstants.OperationStatusCode.BAD_FAMILY) {
                        result = new NoSuchColumnFamilyException(code.getExceptionMsg());
                    }
                    response.add(regionName, theAction.getOriginalIndex(), result);
                    ++var12_20;
                }
            }
            catch (IOException ioe) {
                for (Action action : mutations) {
                    response.add(regionName, action.getOriginalIndex(), ioe);
                }
            }
        }
        return response;
    }

    @Override
    public ExecResult execCoprocessor(byte[] regionName, Exec call) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        try {
            HRegion region = this.getRegion(regionName);
            return region.exec(call);
        }
        catch (Throwable t) {
            throw this.convertThrowableToIOE(this.cleanup(t));
        }
    }

    public String toString() {
        return this.getServerName().toString();
    }

    public int getThreadWakeFrequency() {
        return this.threadWakeFrequency;
    }

    @Override
    public ZooKeeperWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public ServerName getServerName() {
        return this.serverNameFromMasterPOV == null ? new ServerName(this.isa.getHostName(), this.isa.getPort(), this.startcode) : this.serverNameFromMasterPOV;
    }

    @Override
    public CompactionRequestor getCompactionRequester() {
        return this.compactSplitThread;
    }

    public ZooKeeperWatcher getZooKeeperWatcher() {
        return this.zooKeeper;
    }

    public RegionServerCoprocessorHost getCoprocessorHost() {
        return this.rsHost;
    }

    @Override
    public boolean removeFromRegionsInTransition(HRegionInfo hri) {
        return this.regionsInTransitionInRS.remove(hri.getEncodedNameAsBytes());
    }

    @Override
    public boolean containsKeyInRegionsInTransition(HRegionInfo hri) {
        return this.regionsInTransitionInRS.containsKey(hri.getEncodedNameAsBytes());
    }

    public ExecutorService getExecutorService() {
        return this.service;
    }

    private static void createNewReplicationInstance(Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        String sinkClassname;
        if (!conf.getBoolean("hbase.replication", false)) {
            return;
        }
        String sourceClassname = conf.get("hbase.replication.source.service", "org.apache.hadoop.hbase.replication.regionserver.Replication");
        if (sourceClassname.equals(sinkClassname = conf.get("hbase.replication.sink.service", "org.apache.hadoop.hbase.replication.regionserver.Replication"))) {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)((Object)server.replicationSourceHandler);
        } else {
            server.replicationSourceHandler = (ReplicationSourceService)HRegionServer.newReplicationInstance(sourceClassname, conf, server, fs, logDir, oldLogDir);
            server.replicationSinkHandler = (ReplicationSinkService)HRegionServer.newReplicationInstance(sinkClassname, conf, server, fs, logDir, oldLogDir);
        }
    }

    private static ReplicationService newReplicationInstance(String classname, Configuration conf, HRegionServer server, FileSystem fs, Path logDir, Path oldLogDir) throws IOException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(classname, true, classLoader);
        }
        catch (ClassNotFoundException nfe) {
            throw new IOException("Cound not find class for " + classname);
        }
        ReplicationService service = (ReplicationService)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        service.initialize(server, fs, logDir, oldLogDir);
        return service;
    }

    public static Thread startRegionServer(HRegionServer hrs) throws IOException {
        return HRegionServer.startRegionServer(hrs, REGIONSERVER + hrs.isa.getPort());
    }

    public static Thread startRegionServer(HRegionServer hrs, String name) throws IOException {
        Thread t = new Thread(hrs);
        t.setName(name);
        t.start();
        ShutdownHook.install(hrs.getConfiguration(), FileSystem.get((Configuration)hrs.getConfiguration()), hrs, t);
        return t;
    }

    public static HRegionServer constructRegionServer(Class<? extends HRegionServer> regionServerClass, Configuration conf2) {
        try {
            Constructor<? extends HRegionServer> c = regionServerClass.getConstructor(Configuration.class);
            return c.newInstance(conf2);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed construction of Regionserver: " + regionServerClass.toString(), e);
        }
    }

    @Override
    @QosPriority(priority=5)
    public void replicateLogEntries(HLog.Entry[] entries) throws IOException {
        this.checkOpen();
        if (this.replicationSinkHandler == null) {
            return;
        }
        this.replicationSinkHandler.replicateLogEntries(entries);
    }

    public static void main(String[] args) throws Exception {
        VersionInfo.logVersion();
        Configuration conf = HBaseConfiguration.create();
        Class regionServerClass = conf.getClass("hbase.regionserver.impl", HRegionServer.class);
        new HRegionServerCommandLine(regionServerClass).doMain(args);
    }

    @Override
    public List<BlockCacheColumnFamilySummary> getBlockCacheColumnFamilySummaries() throws IOException {
        BlockCache c = new CacheConfig(this.conf).getBlockCache();
        return c.getBlockCacheColumnFamilySummaries(this.conf);
    }

    @Override
    public byte[][] rollHLogWriter() throws IOException, FailedLogCloseException {
        HLog wal = this.getWAL();
        return wal.rollWriter(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<HRegion> getOnlineRegions(byte[] tableName) {
        ArrayList<HRegion> tableRegions = new ArrayList<HRegion>();
        Map<String, HRegion> map = this.onlineRegions;
        synchronized (map) {
            for (HRegion region : this.onlineRegions.values()) {
                HRegionInfo regionInfo = region.getRegionInfo();
                if (!Bytes.equals(regionInfo.getTableName(), tableName)) continue;
                tableRegions.add(region);
            }
        }
        return tableRegions;
    }

    public String[] getCoprocessors() {
        TreeSet<String> coprocessors = new TreeSet<String>(this.hlog.getCoprocessorHost().getCoprocessors());
        Collection<HRegion> regions = this.getOnlineRegionsLocalContext();
        for (HRegion region : regions) {
            coprocessors.addAll(region.getCoprocessorHost().getCoprocessors());
        }
        return coprocessors.toArray(new String[0]);
    }

    void registerMBean() {
        MXBeanImpl mxBeanInfo = MXBeanImpl.init(this);
        this.mxBean = MBeanUtil.registerMBean((String)"RegionServer", (String)"RegionServer", (Object)mxBeanInfo);
        LOG.info((Object)"Registered RegionServer MXBean");
    }

    @Override
    public String getCompactionState(byte[] regionName) throws IOException {
        this.checkOpen();
        this.requestCount.incrementAndGet();
        HRegion region = this.getRegion(regionName);
        HRegionInfo info = region.getRegionInfo();
        return CompactionRequest.getCompactionState(info.getRegionId()).name();
    }

    public long getResponseQueueSize() {
        if (this.server != null) {
            return this.server.getResponseQueueSize();
        }
        return 0L;
    }

    private boolean isHealthCheckerConfigured() {
        String healthScriptLocation = this.conf.get("hbase.node.health.script.location");
        return StringUtils.isNotBlank((String)healthScriptLocation);
    }

    public CompactSplitThread getCompactSplitThread() {
        return this.compactSplitThread;
    }

    private class RowLockListener
    implements LeaseListener {
        private final String lockName;
        private final HRegion region;

        RowLockListener(String lockName, HRegion region) {
            this.lockName = lockName;
            this.region = region;
        }

        @Override
        public void leaseExpired() {
            LOG.info((Object)("Row Lock " + this.lockName + " lease expired"));
            Integer r = HRegionServer.this.rowlocks.remove(this.lockName);
            if (r != null) {
                this.region.releaseRowLock(r);
            }
        }
    }

    private class ScannerListener
    implements LeaseListener {
        private final String scannerName;

        ScannerListener(String n) {
            this.scannerName = n;
        }

        @Override
        public void leaseExpired() {
            RegionScanner s = HRegionServer.this.scanners.remove(this.scannerName);
            if (s != null) {
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired on region " + s.getRegionInfo().getRegionNameAsString()));
                try {
                    HRegion region = HRegionServer.this.getRegion(s.getRegionInfo().getRegionName());
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().preScannerClose(s);
                    }
                    s.close();
                    if (region != null && region.getCoprocessorHost() != null) {
                        region.getCoprocessorHost().postScannerClose(s);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Closing scanner for " + s.getRegionInfo().getRegionNameAsString()), (Throwable)e);
                }
            } else {
                LOG.info((Object)("Scanner " + this.scannerName + " lease expired"));
            }
        }
    }

    class PeriodicMemstoreFlusher
    extends Chore {
        final HRegionServer server;
        static final int RANGE_OF_DELAY = 20000;
        static final int MIN_DELAY_TIME = 3000;

        public PeriodicMemstoreFlusher(int cacheFlushInterval, HRegionServer server) {
            super(server.getServerName() + "-MemstoreFlusherChore", cacheFlushInterval, server);
            this.server = server;
        }

        @Override
        protected void chore() {
            for (HRegion r : this.server.onlineRegions.values()) {
                FlushRequester requester;
                if (r == null || !r.shouldFlush() || (requester = this.server.getFlushRequester()) == null) continue;
                long randomDelay = HRegionServer.this.rand.nextInt(20000) + 3000;
                LOG.info((Object)(this.getName() + " requesting flush for region " + r.getRegionNameAsString() + " after a delay of " + randomDelay));
                requester.requestDelayedFlush(r, randomDelay);
            }
        }
    }

    private static class CompactionChecker
    extends Chore {
        private final HRegionServer instance;
        private final int majorCompactPriority;
        private static final int DEFAULT_PRIORITY = Integer.MAX_VALUE;

        CompactionChecker(HRegionServer h, int sleepTime, Stoppable stopper) {
            super("CompactionChecker", sleepTime, h);
            this.instance = h;
            LOG.info((Object)("Runs every " + org.apache.hadoop.util.StringUtils.formatTime((long)sleepTime)));
            this.majorCompactPriority = this.instance.conf.getInt("hbase.regionserver.compactionChecker.majorCompactPriority", Integer.MAX_VALUE);
        }

        @Override
        protected void chore() {
            for (HRegion r : this.instance.onlineRegions.values()) {
                if (r == null) continue;
                for (Store s : r.getStores().values()) {
                    try {
                        if (s.needsCompaction()) {
                            this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests compaction", null);
                            continue;
                        }
                        if (!s.isMajorCompaction()) continue;
                        if (this.majorCompactPriority == Integer.MAX_VALUE || this.majorCompactPriority > r.getCompactPriority()) {
                            this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use default priority", null);
                            continue;
                        }
                        this.instance.compactSplitThread.requestCompaction(r, s, this.getName() + " requests major compaction; use configured priority", this.majorCompactPriority, null);
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Failed major compaction check on " + r), (Throwable)e);
                    }
                }
            }
        }
    }

    class QosFunction
    implements Function<Writable, Integer> {
        private final Map<String, Integer> annotatedQos;

        public QosFunction() {
            HashMap<String, Integer> qosMap = new HashMap<String, Integer>();
            for (Method m : HRegionServer.class.getMethods()) {
                QosPriority p = m.getAnnotation(QosPriority.class);
                if (p == null) continue;
                qosMap.put(m.getName(), p.priority());
            }
            this.annotatedQos = qosMap;
        }

        public boolean isMetaTable(byte[] regionName) {
            HRegion region;
            try {
                region = HRegionServer.this.getRegion(regionName);
            }
            catch (NotServingRegionException ignored) {
                return false;
            }
            return region.getRegionInfo().isMetaTable();
        }

        public Integer apply(Writable from) {
            if (!(from instanceof Invocation)) {
                return 0;
            }
            Invocation inv = (Invocation)from;
            String methodName = inv.getMethodName();
            Integer priorityByAnnotation = this.annotatedQos.get(methodName);
            if (priorityByAnnotation != null) {
                return priorityByAnnotation;
            }
            if (methodName.equals("next") || methodName.equals("close")) {
                Long scannerId;
                try {
                    scannerId = (Long)inv.getParameters()[0];
                }
                catch (ClassCastException ignored) {
                    return 0;
                }
                String scannerIdString = Long.toString(scannerId);
                RegionScanner scanner = HRegionServer.this.scanners.get(scannerIdString);
                if (scanner != null && scanner.getRegionInfo().isMetaTable()) {
                    return 100;
                }
            } else if (inv.getParameterClasses().length != 0) {
                if (inv.getParameterClasses()[0] == byte[].class) {
                    if (this.isMetaTable((byte[])inv.getParameters()[0])) {
                        return 100;
                    }
                } else if (inv.getParameterClasses()[0] == MultiAction.class) {
                    MultiAction ma = (MultiAction)inv.getParameters()[0];
                    Set<byte[]> regions = ma.getRegions();
                    for (byte[] region : regions) {
                        if (!this.isMetaTable(region)) continue;
                        return 100;
                    }
                }
            }
            return 0;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface QosPriority {
        public int priority() default 0;
    }
}

