/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.LongCombiner;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;

public class CountingIterator
implements SortedKeyValueIterator<Key, Value> {
    private SortedKeyValueIterator<Key, Value> source;

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source = source;
    }

    public boolean hasTop() {
        return this.source.hasTop();
    }

    public void next() throws IOException {
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
    }

    public Key getTopKey() {
        return (Key)this.source.getTopKey();
    }

    public Value getTopValue() {
        try {
            long count = 0L;
            while (this.source.hasTop()) {
                ++count;
                this.source.next();
            }
            return new Value(LongCombiner.FIXED_LEN_ENCODER.encode((Object)count));
        }
        catch (IOException e) {
            throw new VertexiumAccumuloIteratorException("could not iterate", e);
        }
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        throw new UnsupportedOperationException();
    }
}

