/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.iterator.model;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.data.Value;
import org.apache.hadoop.io.Text;
import org.vertexium.accumulo.iterator.model.FetchHint;
import org.vertexium.accumulo.iterator.model.HiddenProperty;
import org.vertexium.accumulo.iterator.model.Property;
import org.vertexium.accumulo.iterator.model.PropertyColumnQualifier;
import org.vertexium.accumulo.iterator.model.PropertyMetadata;
import org.vertexium.accumulo.iterator.model.SoftDeletedProperty;
import org.vertexium.accumulo.iterator.model.VertexiumAccumuloIteratorException;
import org.vertexium.accumulo.iterator.util.DataOutputStreamUtils;

public abstract class ElementData {
    public static final byte[] HEADER = new byte[]{86, 69, 82, 84, 49};
    public static final byte TYPE_ID_VERTEX = 1;
    public static final byte TYPE_ID_EDGE = 2;
    public static final int PROP_START = 1;
    public static final int PROP_END = 2;
    public Text id;
    public long timestamp;
    public Text visibility;
    public List<Text> hiddenVisibilities = new ArrayList<Text>();
    public long softDeleteTimestamp;
    public List<SoftDeletedProperty> softDeletedProperties = new ArrayList<SoftDeletedProperty>();
    public List<HiddenProperty> hiddenProperties = new ArrayList<HiddenProperty>();
    public Map<String, PropertyMetadata> propertyMetadata = new HashMap<String, PropertyMetadata>();
    public final Map<String, PropertyColumnQualifier> propertyColumnQualifiers = new HashMap<String, PropertyColumnQualifier>();
    public final Map<String, byte[]> propertyValues = new HashMap<String, byte[]>();
    public final Map<String, Text> propertyVisibilities = new HashMap<String, Text>();
    public final Map<String, Long> propertyTimestamps = new HashMap<String, Long>();

    public void clear() {
        this.id = null;
        this.visibility = null;
        this.timestamp = 0L;
        this.softDeleteTimestamp = 0L;
        this.hiddenVisibilities.clear();
        this.softDeletedProperties.clear();
        this.hiddenProperties.clear();
        this.propertyMetadata.clear();
        this.propertyColumnQualifiers.clear();
        this.propertyValues.clear();
        this.propertyVisibilities.clear();
        this.propertyTimestamps.clear();
    }

    public final Value encode(EnumSet<FetchHint> fetchHints) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(out);
        this.encode(dout, fetchHints);
        return new Value(out.toByteArray());
    }

    protected void encode(DataOutputStream out, EnumSet<FetchHint> fetchHints) throws IOException {
        this.encodeHeader(out);
        DataOutputStreamUtils.encodeText(out, this.id);
        out.writeLong(this.timestamp);
        DataOutputStreamUtils.encodeText(out, this.visibility);
        DataOutputStreamUtils.encodeTextList(out, this.hiddenVisibilities);
        this.encodeProperties(out, fetchHints);
    }

    private void encodeHeader(DataOutputStream out) throws IOException {
        out.write(HEADER);
        out.write(this.getTypeId());
    }

    protected abstract byte getTypeId();

    private void encodeProperties(final DataOutputStream out, EnumSet<FetchHint> fetchHints) throws IOException {
        this.iterateProperties(new PropertyDataHandler(){

            @Override
            public void handle(String propertyKey, String propertyName, byte[] propertyValue, Text propertyVisibility, long propertyTimestamp, Set<Text> propertyHiddenVisibilities, PropertyMetadata metadata) throws IOException {
                out.write(1);
                DataOutputStreamUtils.encodeString(out, propertyKey);
                DataOutputStreamUtils.encodeString(out, propertyName);
                DataOutputStreamUtils.encodeText(out, propertyVisibility);
                out.writeLong(propertyTimestamp);
                out.writeInt(propertyValue.length);
                out.write(propertyValue);
                DataOutputStreamUtils.encodeTextList(out, propertyHiddenVisibilities);
                DataOutputStreamUtils.encodePropertyMetadata(out, metadata);
            }
        }, fetchHints);
        out.write(2);
    }

    private void iterateProperties(PropertyDataHandler propertyDataHandler, EnumSet<FetchHint> fetchHints) throws IOException {
        boolean includeHidden = fetchHints.contains((Object)FetchHint.INCLUDE_HIDDEN);
        for (Map.Entry<String, byte[]> propertyValueEntry : this.propertyValues.entrySet()) {
            String key = propertyValueEntry.getKey();
            PropertyColumnQualifier propertyColumnQualifier = this.propertyColumnQualifiers.get(key);
            String propertyKey = propertyColumnQualifier.getPropertyKey();
            String propertyName = propertyColumnQualifier.getPropertyName();
            byte[] propertyValue = propertyValueEntry.getValue();
            Text propertyVisibility = this.propertyVisibilities.get(key);
            String propertyVisibilityString = propertyVisibility.toString();
            long propertyTimestamp = this.propertyTimestamps.get(key);
            Set<Text> propertyHiddenVisibilities = this.getPropertyHiddenVisibilities(propertyKey, propertyName, propertyVisibilityString);
            if (!includeHidden && this.isHidden(propertyKey, propertyName, propertyVisibilityString) || this.isPropertyDeleted(propertyKey, propertyName, propertyTimestamp, propertyVisibility)) continue;
            PropertyMetadata metadata = this.propertyMetadata.get(key);
            propertyDataHandler.handle(propertyKey, propertyName, propertyValue, propertyVisibility, propertyTimestamp, propertyHiddenVisibilities, metadata);
        }
    }

    public Iterable<Property> getProperties(EnumSet<FetchHint> fetchHints) {
        final ArrayList<Property> results = new ArrayList<Property>();
        try {
            this.iterateProperties(new PropertyDataHandler(){

                @Override
                public void handle(String propertyKey, String propertyName, byte[] propertyValue, Text propertyVisibility, long propertyTimestamp, Set<Text> propertyHiddenVisibilities, PropertyMetadata metadata) throws IOException {
                    results.add(new Property(propertyKey, propertyName, propertyValue, propertyVisibility.toString(), propertyTimestamp, propertyHiddenVisibilities, metadata));
                }
            }, fetchHints);
        }
        catch (IOException ex) {
            throw new VertexiumAccumuloIteratorException("Could not get properties", ex);
        }
        return results;
    }

    private Set<Text> getPropertyHiddenVisibilities(String propertyKey, String propertyName, String propertyVisibility) {
        HashSet<Text> hiddenVisibilities = null;
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            if (hiddenVisibilities == null) {
                hiddenVisibilities = new HashSet<Text>();
            }
            hiddenVisibilities.add(hiddenProperty.getHiddenVisibility());
        }
        return hiddenVisibilities;
    }

    private boolean isHidden(String propertyKey, String propertyName, String propertyVisibility) {
        for (HiddenProperty hiddenProperty : this.hiddenProperties) {
            if (!hiddenProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return true;
        }
        return false;
    }

    private boolean isPropertyDeleted(String propertyKey, String propertyName, long propertyTimestamp, Text propertyVisibility) {
        for (SoftDeletedProperty softDeletedProperty : this.softDeletedProperties) {
            if (!softDeletedProperty.matches(propertyKey, propertyName, propertyVisibility)) continue;
            return softDeletedProperty.getTimestamp() >= propertyTimestamp;
        }
        return false;
    }

    private static interface PropertyDataHandler {
        public void handle(String var1, String var2, byte[] var3, Text var4, long var5, Set<Text> var7, PropertyMetadata var8) throws IOException;
    }
}

