/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.count;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;

public class CountRequest
extends BroadcastOperationRequest<CountRequest> {
    public static final float DEFAULT_MIN_SCORE = -1.0f;
    private float minScore = -1.0f;
    @Nullable
    protected String routing;
    @Nullable
    private String preference;
    private BytesReference source;
    private boolean sourceUnsafe;
    private String[] types = Strings.EMPTY_ARRAY;
    long nowInMillis;
    private int terminateAfter = 0;

    CountRequest() {
    }

    public CountRequest(String ... indices) {
        super(indices);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    @Override
    protected void beforeStart() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
    }

    float minScore() {
        return this.minScore;
    }

    public CountRequest minScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    BytesReference source() {
        return this.source;
    }

    public CountRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        this.sourceUnsafe = false;
        return this;
    }

    public CountRequest source(Map querySource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(querySource);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + querySource + "]", e);
        }
    }

    public CountRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public CountRequest source(String querySource) {
        this.source = new BytesArray(querySource);
        this.sourceUnsafe = false;
        return this;
    }

    public CountRequest source(byte[] querySource) {
        return this.source(querySource, 0, querySource.length, false);
    }

    public CountRequest source(byte[] querySource, int offset, int length, boolean unsafe) {
        return this.source(new BytesArray(querySource, offset, length), unsafe);
    }

    public CountRequest source(BytesReference querySource, boolean unsafe) {
        this.source = querySource;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public CountRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public CountRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public CountRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public CountRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public CountRequest terminateAfter(int terminateAfterCount) {
        if (terminateAfterCount <= 0) {
            throw new ElasticsearchIllegalArgumentException("terminateAfter must be > 0");
        }
        this.terminateAfter = terminateAfterCount;
        return this;
    }

    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.minScore = in.readFloat();
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        this.sourceUnsafe = false;
        this.source = in.readBytesReference();
        this.types = in.readStringArray();
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.terminateAfter = in.readVInt();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeFloat(this.minScore);
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        out.writeBytesReference(this.source);
        out.writeStringArray(this.types);
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeVInt(this.terminateAfter);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", source[" + sSource + "]";
    }
}

