/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.indexedscripts.put;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;

public class PutIndexedScriptRequest
extends ActionRequest<PutIndexedScriptRequest>
implements IndicesRequest {
    private String scriptLang;
    private String id;
    private BytesReference source;
    private boolean sourceUnsafe;
    private IndexRequest.OpType opType = IndexRequest.OpType.INDEX;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private XContentType contentType = Requests.INDEX_CONTENT_TYPE;

    public PutIndexedScriptRequest() {
    }

    public PutIndexedScriptRequest(String scriptLang) {
        this.scriptLang = scriptLang;
    }

    public PutIndexedScriptRequest(String scriptLang, String id) {
        this.scriptLang = scriptLang;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scriptLang == null) {
            validationException = ValidateActions.addValidationError("scriptType is missing", validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        if (!this.versionType.validateVersionForWrites(this.version)) {
            validationException = ValidateActions.addValidationError("illegal version value [" + this.version + "] for version type [" + this.versionType.name() + "]", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return new String[]{".scripts"};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public PutIndexedScriptRequest contentType(XContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public String scriptLang() {
        return this.scriptLang;
    }

    public PutIndexedScriptRequest scriptLang(String scriptLang) {
        this.scriptLang = scriptLang;
        return this;
    }

    public String id() {
        return this.id;
    }

    public PutIndexedScriptRequest id(String id) {
        this.id = id;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference safeSource() {
        if (this.sourceUnsafe) {
            this.source = this.source.copyBytesArray();
            this.sourceUnsafe = false;
        }
        return this.source;
    }

    public Map<String, Object> sourceAsMap() {
        return XContentHelper.convertToMap(this.source, false).v2();
    }

    public PutIndexedScriptRequest source(Map source) throws ElasticsearchGenerationException {
        return this.source(source, this.contentType);
    }

    public PutIndexedScriptRequest source(Map source, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public PutIndexedScriptRequest source(String source) {
        this.source = new BytesArray(source.getBytes(Charsets.UTF_8));
        this.sourceUnsafe = false;
        return this;
    }

    public PutIndexedScriptRequest source(XContentBuilder sourceBuilder) {
        this.source = sourceBuilder.bytes();
        this.sourceUnsafe = false;
        return this;
    }

    public PutIndexedScriptRequest source(Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(this.contentType);
            builder.startObject();
            for (int i = 0; i < source.length; ++i) {
                builder.field(source[i++].toString(), source[i]);
            }
            builder.endObject();
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public PutIndexedScriptRequest source(BytesReference source, boolean unsafe) {
        this.source = source;
        this.sourceUnsafe = unsafe;
        return this;
    }

    public PutIndexedScriptRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public PutIndexedScriptRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    public PutIndexedScriptRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = new BytesArray(source, offset, length);
        this.sourceUnsafe = unsafe;
        return this;
    }

    public PutIndexedScriptRequest opType(IndexRequest.OpType opType) {
        this.opType = opType;
        return this;
    }

    public PutIndexedScriptRequest create(boolean create) {
        if (create) {
            return this.opType(IndexRequest.OpType.CREATE);
        }
        return this.opType(IndexRequest.OpType.INDEX);
    }

    public IndexRequest.OpType opType() {
        return this.opType;
    }

    public PutIndexedScriptRequest version(long version) {
        this.version = version;
        return this;
    }

    public long version() {
        return this.version;
    }

    public PutIndexedScriptRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.scriptLang = in.readString();
        this.id = in.readOptionalString();
        this.source = in.readBytesReference();
        this.sourceUnsafe = false;
        this.opType = IndexRequest.OpType.fromId(in.readByte());
        this.version = Versions.readVersion(in);
        this.versionType = VersionType.fromValue(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scriptLang);
        out.writeOptionalString(this.id);
        out.writeBytesReference(this.source);
        out.writeByte(this.opType.id());
        Versions.writeVersion(this.version, out);
        out.writeByte(this.versionType.getValue());
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[.scripts][" + this.scriptLang + "][" + this.id + "], source[" + sSource + "]}";
    }
}

