/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.util.AbstractArray;
import org.elasticsearch.common.util.BigArrays;

abstract class AbstractBigArray
extends AbstractArray {
    private static final long EMPTY_SIZE = RamUsageEstimator.shallowSizeOfInstance(AbstractBigArray.class) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private final PageCacheRecycler recycler;
    private Recycler.V<?>[] cache;
    private final int pageShift;
    private final int pageMask;
    protected long size;

    protected AbstractBigArray(int pageSize, BigArrays bigArrays, boolean clearOnResize) {
        super(bigArrays, clearOnResize);
        this.recycler = bigArrays.recycler;
        Preconditions.checkArgument(pageSize >= 128, "pageSize must be >= 128");
        Preconditions.checkArgument((pageSize & pageSize - 1) == 0, "pageSize must be a power of two");
        this.pageShift = Integer.numberOfTrailingZeros(pageSize);
        this.pageMask = pageSize - 1;
        this.size = 0L;
        this.cache = this.recycler != null ? new Recycler.V[16] : null;
    }

    final int numPages(long capacity) {
        long numPages = capacity + (long)this.pageMask >>> this.pageShift;
        Preconditions.checkArgument(numPages <= Integer.MAX_VALUE, "pageSize=" + (this.pageMask + 1) + " is too small for such as capacity: " + capacity);
        return (int)numPages;
    }

    final int pageSize() {
        return this.pageMask + 1;
    }

    final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    final int indexInPage(long index) {
        return (int)(index & (long)this.pageMask);
    }

    @Override
    public final long size() {
        return this.size;
    }

    public abstract void resize(long var1);

    protected abstract int numBytesPerElement();

    public final long ramBytesUsed() {
        return ((long)this.pageIndex(this.size - 1L) + 1L) * (long)this.pageSize() * (long)this.numBytesPerElement();
    }

    private static <T> T[] grow(T[] array, int minSize) {
        if (array.length < minSize) {
            int newLen = ArrayUtil.oversize((int)minSize, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            array = Arrays.copyOf(array, newLen);
        }
        return array;
    }

    private <T> T registerNewPage(Recycler.V<T> v, int page, int expectedSize) {
        this.cache = AbstractBigArray.grow(this.cache, page + 1);
        assert (this.cache[page] == null);
        this.cache[page] = v;
        assert (Array.getLength(v.v()) == expectedSize);
        return v.v();
    }

    protected final byte[] newBytePage(int page) {
        if (this.recycler != null) {
            Recycler.V<byte[]> v = this.recycler.bytePage(this.clearOnResize);
            return this.registerNewPage(v, page, 16384);
        }
        return new byte[16384];
    }

    protected final int[] newIntPage(int page) {
        if (this.recycler != null) {
            Recycler.V<int[]> v = this.recycler.intPage(this.clearOnResize);
            return this.registerNewPage(v, page, 4096);
        }
        return new int[4096];
    }

    protected final long[] newLongPage(int page) {
        if (this.recycler != null) {
            Recycler.V<long[]> v = this.recycler.longPage(this.clearOnResize);
            return this.registerNewPage(v, page, 2048);
        }
        return new long[2048];
    }

    protected final float[] newFloatPage(int page) {
        if (this.recycler != null) {
            Recycler.V<float[]> v = this.recycler.floatPage(this.clearOnResize);
            return this.registerNewPage(v, page, 4096);
        }
        return new float[4096];
    }

    protected final double[] newDoublePage(int page) {
        if (this.recycler != null) {
            Recycler.V<double[]> v = this.recycler.doublePage(this.clearOnResize);
            return this.registerNewPage(v, page, 2048);
        }
        return new double[2048];
    }

    protected final Object[] newObjectPage(int page) {
        if (this.recycler != null) {
            Recycler.V<Object[]> v = this.recycler.objectPage();
            return this.registerNewPage(v, page, BigArrays.OBJECT_PAGE_SIZE);
        }
        return new Object[BigArrays.OBJECT_PAGE_SIZE];
    }

    protected final void releasePage(int page) {
        if (this.recycler != null) {
            this.cache[page].close();
            this.cache[page] = null;
        }
    }

    @Override
    protected final void doClose() {
        if (this.recycler != null) {
            Releasables.close(this.cache);
            this.cache = null;
        }
    }
}

