/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.util.Set;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;

public class AckClusterStatePublishResponseHandler
extends BlockingClusterStatePublishResponseHandler {
    private static final ESLogger logger = ESLoggerFactory.getLogger(AckClusterStatePublishResponseHandler.class.getName());
    private final Discovery.AckListener ackListener;

    public AckClusterStatePublishResponseHandler(Set<DiscoveryNode> publishingToNodes, Discovery.AckListener ackListener) {
        super(publishingToNodes);
        this.ackListener = ackListener;
    }

    @Override
    public void onResponse(DiscoveryNode node) {
        super.onResponse(node);
        this.onNodeAck(this.ackListener, node, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(DiscoveryNode node, Throwable t) {
        try {
            super.onFailure(node, t);
        }
        finally {
            this.onNodeAck(this.ackListener, node, t);
        }
    }

    private void onNodeAck(Discovery.AckListener ackListener, DiscoveryNode node, Throwable t) {
        try {
            ackListener.onNodeAck(node, t);
        }
        catch (Throwable t1) {
            logger.debug("error while processing ack for node [{}]", t1, node);
        }
    }
}

