/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.weighted;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.Weigher;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.SegmentReaderUtils;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.CachedFilter;
import org.elasticsearch.common.lucene.search.NoCacheFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.filter.support.CacheKeyFilter;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardUtils;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.cache.filter.IndicesFilterCache;

public class WeightedFilterCache
extends AbstractIndexComponent
implements FilterCache,
AtomicReader.CoreClosedListener,
IndexReader.ReaderClosedListener {
    final IndicesFilterCache indicesFilterCache;
    IndexService indexService;
    final ConcurrentMap<Object, Boolean> seenReaders = ConcurrentCollections.newConcurrentMap();

    @Inject
    public WeightedFilterCache(Index index, @IndexSettings Settings indexSettings, IndicesFilterCache indicesFilterCache) {
        super(index, indexSettings);
        this.indicesFilterCache = indicesFilterCache;
    }

    @Override
    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    @Override
    public String type() {
        return "weighted";
    }

    @Override
    public void close() throws ElasticsearchException {
        this.clear("close");
    }

    public void onClose(IndexReader reader) {
        this.clear(reader.getCoreCacheKey());
    }

    @Override
    public void clear(String reason) {
        this.logger.debug("full cache clear, reason [{}]", reason);
        for (Object readerKey : this.seenReaders.keySet()) {
            Boolean removed = (Boolean)this.seenReaders.remove(readerKey);
            if (removed == null) {
                return;
            }
            this.indicesFilterCache.addReaderKeyToClean(readerKey);
        }
    }

    @Override
    public void clear(String reason, String[] keys) {
        this.logger.debug("clear keys [], reason [{}]", reason, keys);
        BytesRefBuilder spare = new BytesRefBuilder();
        for (String key : keys) {
            byte[] keyBytes = Strings.toUTF8Bytes(key, spare);
            for (Object readerKey : this.seenReaders.keySet()) {
                this.indicesFilterCache.cache().invalidate(new FilterCacheKey(readerKey, new CacheKeyFilter.Key(keyBytes)));
            }
        }
    }

    public void onClose(Object coreKey) {
        this.clear(coreKey);
    }

    @Override
    public void clear(Object coreCacheKey) {
        Boolean removed = (Boolean)this.seenReaders.remove(coreCacheKey);
        if (removed == null) {
            return;
        }
        this.indicesFilterCache.addReaderKeyToClean(coreCacheKey);
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (filterToCache == null) {
            return null;
        }
        if (filterToCache instanceof NoCacheFilter) {
            return filterToCache;
        }
        if (CachedFilter.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    public static class FilterCacheKey {
        private final Object readerKey;
        private final Object filterKey;
        @Nullable
        public RemovalListener<FilterCacheKey, DocIdSet> removalListener;

        public FilterCacheKey(Object readerKey, Object filterKey) {
            this.readerKey = readerKey;
            this.filterKey = filterKey;
        }

        public Object readerKey() {
            return this.readerKey;
        }

        public Object filterKey() {
            return this.filterKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            FilterCacheKey that = (FilterCacheKey)o;
            return this.readerKey().equals(that.readerKey()) && this.filterKey.equals(that.filterKey);
        }

        public int hashCode() {
            return this.readerKey().hashCode() + 31 * this.filterKey.hashCode();
        }
    }

    public static class FilterCacheValueWeigher
    implements Weigher<FilterCacheKey, DocIdSet> {
        private final int minimumEntrySize;

        public FilterCacheValueWeigher(int minimumEntrySize) {
            this.minimumEntrySize = minimumEntrySize;
        }

        @Override
        public int weigh(FilterCacheKey key, DocIdSet value) {
            int weight = (int)Math.min(DocIdSets.sizeInBytes(value), Integer.MAX_VALUE);
            return Math.max(weight, this.minimumEntrySize);
        }
    }

    static class FilterCacheFilterWrapper
    extends CachedFilter {
        private final Filter filter;
        private final WeightedFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, WeightedFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            Object filterKey = this.filter;
            if (this.filter instanceof CacheKeyFilter) {
                filterKey = ((CacheKeyFilter)this.filter).cacheKey();
            }
            FilterCacheKey cacheKey = new FilterCacheKey(context.reader().getCoreCacheKey(), filterKey);
            Cache<FilterCacheKey, DocIdSet> innerCache = this.cache.indicesFilterCache.cache();
            DocIdSet cacheValue = innerCache.getIfPresent(cacheKey);
            if (cacheValue == null) {
                IndexShard shard;
                Boolean previous;
                if (!this.cache.seenReaders.containsKey(context.reader().getCoreCacheKey()) && (previous = this.cache.seenReaders.putIfAbsent(context.reader().getCoreCacheKey(), Boolean.TRUE)) == null) {
                    SegmentReaderUtils.registerCoreListener(context.reader(), this.cache);
                }
                cacheValue = DocIdSets.toCacheable(context.reader(), this.filter.getDocIdSet(context, null));
                ShardId shardId = ShardUtils.extractShardId(context.reader());
                if (shardId != null && (shard = this.cache.indexService.shard(shardId.id())) != null) {
                    cacheKey.removalListener = shard.filterCache();
                    shard.filterCache().onCached(DocIdSets.sizeInBytes(cacheValue));
                }
                innerCache.put(cacheKey, cacheValue);
            }
            return DocIdSets.isEmpty(cacheValue) ? null : cacheValue;
        }

        public String toString() {
            return "cache(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)((Object)o)).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }
    }
}

