/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramParser;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class DateHistogramBuilder
extends ValuesSourceAggregationBuilder<DateHistogramBuilder> {
    private Object interval;
    private Histogram.Order order;
    private Long minDocCount;
    private Object extendedBoundsMin;
    private Object extendedBoundsMax;
    private String preZone;
    private String postZone;
    private boolean preZoneAdjustLargeInterval;
    private String format;
    private String preOffset;
    private String postOffset;
    private float factor = 1.0f;

    public DateHistogramBuilder(String name) {
        super(name, InternalDateHistogram.TYPE.name());
    }

    public DateHistogramBuilder interval(long interval) {
        this.interval = interval;
        return this;
    }

    public DateHistogramBuilder interval(DateHistogram.Interval interval) {
        this.interval = interval;
        return this;
    }

    public DateHistogramBuilder order(Histogram.Order order) {
        this.order = order;
        return this;
    }

    public DateHistogramBuilder minDocCount(long minDocCount) {
        this.minDocCount = minDocCount;
        return this;
    }

    public DateHistogramBuilder preZone(String preZone) {
        this.preZone = preZone;
        return this;
    }

    public DateHistogramBuilder postZone(String postZone) {
        this.postZone = postZone;
        return this;
    }

    public DateHistogramBuilder preZoneAdjustLargeInterval(boolean preZoneAdjustLargeInterval) {
        this.preZoneAdjustLargeInterval = preZoneAdjustLargeInterval;
        return this;
    }

    public DateHistogramBuilder preOffset(String preOffset) {
        this.preOffset = preOffset;
        return this;
    }

    public DateHistogramBuilder postOffset(String postOffset) {
        this.postOffset = postOffset;
        return this;
    }

    public DateHistogramBuilder factor(float factor) {
        this.factor = factor;
        return this;
    }

    public DateHistogramBuilder format(String format) {
        this.format = format;
        return this;
    }

    public DateHistogramBuilder extendedBounds(Long min, Long max) {
        this.extendedBoundsMin = min;
        this.extendedBoundsMax = max;
        return this;
    }

    public DateHistogramBuilder extendedBounds(String min, String max) {
        this.extendedBoundsMin = min;
        this.extendedBoundsMax = max;
        return this;
    }

    public DateHistogramBuilder extendedBounds(DateTime min, DateTime max) {
        this.extendedBoundsMin = min;
        this.extendedBoundsMax = max;
        return this;
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.interval == null) {
            throw new SearchSourceBuilderException("[interval] must be defined for histogram aggregation [" + this.getName() + "]");
        }
        if (this.interval instanceof Number) {
            this.interval = TimeValue.timeValueMillis(((Number)this.interval).longValue()).toString();
        }
        builder.field("interval", this.interval);
        if (this.minDocCount != null) {
            builder.field("min_doc_count", this.minDocCount);
        }
        if (this.order != null) {
            builder.field("order");
            this.order.toXContent(builder, params);
        }
        if (this.preZone != null) {
            builder.field("pre_zone", this.preZone);
        }
        if (this.postZone != null) {
            builder.field("post_zone", this.postZone);
        }
        if (this.preZoneAdjustLargeInterval) {
            builder.field("pre_zone_adjust_large_interval", true);
        }
        if (this.preOffset != null) {
            builder.field("pre_offset", this.preOffset);
        }
        if (this.postOffset != null) {
            builder.field("post_offset", this.postOffset);
        }
        if (this.factor != 1.0f) {
            builder.field("factor", this.factor);
        }
        if (this.format != null) {
            builder.field("format", this.format);
        }
        if (this.extendedBoundsMin != null || this.extendedBoundsMax != null) {
            builder.startObject(DateHistogramParser.EXTENDED_BOUNDS.getPreferredName());
            if (this.extendedBoundsMin != null) {
                builder.field("min", this.extendedBoundsMin);
            }
            if (this.extendedBoundsMax != null) {
                builder.field("max", this.extendedBoundsMax);
            }
            builder.endObject();
        }
        return builder;
    }
}

