/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.inmemory;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.vertexium.Authorizations;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.EdgeBuilderBase;
import org.vertexium.Element;
import org.vertexium.Graph;
import org.vertexium.HistoricalPropertyValue;
import org.vertexium.Metadata;
import org.vertexium.Property;
import org.vertexium.VertexBuilder;
import org.vertexium.VertexiumException;
import org.vertexium.Visibility;
import org.vertexium.inmemory.InMemoryGraph;
import org.vertexium.inmemory.InMemoryTableEdge;
import org.vertexium.inmemory.InMemoryTableElement;
import org.vertexium.mutation.AlterPropertyVisibility;
import org.vertexium.mutation.EdgeMutation;
import org.vertexium.mutation.ExistingElementMutation;
import org.vertexium.mutation.ExistingElementMutationImpl;
import org.vertexium.mutation.PropertyDeleteMutation;
import org.vertexium.mutation.PropertySoftDeleteMutation;
import org.vertexium.property.MutableProperty;
import org.vertexium.property.MutablePropertyImpl;
import org.vertexium.util.ConvertingIterable;
import org.vertexium.util.FilterIterable;
import org.vertexium.util.IncreasingTime;

public abstract class InMemoryElement<TElement extends InMemoryElement>
implements Element {
    private final String id;
    private Property idProperty;
    private Property edgeLabelProperty;
    private InMemoryGraph graph;
    protected final InMemoryTableElement<TElement> inMemoryTableElement;
    private final boolean includeHidden;
    private final Long endTime;
    private final Authorizations authorizations;

    protected InMemoryElement(InMemoryGraph graph, String id, InMemoryTableElement<TElement> inMemoryTableElement, boolean includeHidden, Long endTime, Authorizations authorizations) {
        this.graph = graph;
        this.id = id;
        this.includeHidden = includeHidden;
        this.endTime = endTime;
        this.authorizations = authorizations;
        this.inMemoryTableElement = inMemoryTableElement;
    }

    public String getId() {
        return this.id;
    }

    protected Property getIdProperty() {
        if (this.idProperty == null) {
            this.idProperty = new MutablePropertyImpl("", "__ID__", (Object)this.getId(), null, Long.valueOf(this.getTimestamp()), null, null);
        }
        return this.idProperty;
    }

    protected Property getEdgeLabelProperty() {
        if (this.edgeLabelProperty == null && this instanceof Edge) {
            String edgeLabel = ((Edge)this).getLabel();
            this.edgeLabelProperty = new MutablePropertyImpl("", "__edgeLabel", (Object)edgeLabel, null, Long.valueOf(this.getTimestamp()), null, null);
        }
        return this.edgeLabelProperty;
    }

    public Visibility getVisibility() {
        return this.inMemoryTableElement.getVisibility();
    }

    public long getTimestamp() {
        return this.inMemoryTableElement.getTimestamp();
    }

    public void deleteProperty(String key, String name, Authorizations authorizations) {
        this.deleteProperty(key, name, null, authorizations);
    }

    public void deleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        this.getGraph().deleteProperty(this, this.inMemoryTableElement, key, name, visibility, authorizations);
    }

    public void deleteProperties(String name, Authorizations authorizations) {
        for (Property p : this.getProperties(name)) {
            this.deleteProperty(p.getKey(), p.getName(), p.getVisibility(), authorizations);
        }
    }

    public void softDeleteProperty(String key, String name, Authorizations authorizations) {
        Property property = this.getProperty(key, name);
        if (property != null) {
            this.getGraph().softDeleteProperty(this.inMemoryTableElement, property, null, authorizations);
        }
    }

    public void softDeleteProperty(String key, String name, Visibility visibility, Authorizations authorizations) {
        this.softDeleteProperty(key, name, null, visibility, authorizations);
    }

    protected void softDeleteProperty(String key, String name, Long timestamp, Visibility visibility, Authorizations authorizations) {
        Property property = this.getProperty(key, name, visibility);
        if (property != null) {
            this.getGraph().softDeleteProperty(this.inMemoryTableElement, property, timestamp, authorizations);
        }
    }

    public void softDeleteProperties(String name, Authorizations authorizations) {
        Iterable<Property> properties = this.getProperties(name);
        for (Property property : properties) {
            this.getGraph().softDeleteProperty(this.inMemoryTableElement, property, null, authorizations);
        }
    }

    public void markPropertyHidden(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(property.getKey(), property.getName(), property.getVisibility(), timestamp, visibility, authorizations);
    }

    public void markPropertyHidden(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyHidden(property, null, visibility, authorizations);
    }

    public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, this.inMemoryTableElement, key, name, propertyVisibility, timestamp, visibility, authorizations);
    }

    public void markPropertyHidden(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyHidden(this, this.inMemoryTableElement, key, name, propertyVisibility, null, visibility, authorizations);
    }

    public void markPropertyVisible(Property property, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, this.inMemoryTableElement, property.getKey(), property.getName(), property.getVisibility(), timestamp, visibility, authorizations);
    }

    public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, this.inMemoryTableElement, key, name, propertyVisibility, null, visibility, authorizations);
    }

    public void markPropertyVisible(String key, String name, Visibility propertyVisibility, Long timestamp, Visibility visibility, Authorizations authorizations) {
        this.getGraph().markPropertyVisible(this, this.inMemoryTableElement, key, name, propertyVisibility, timestamp, visibility, authorizations);
    }

    public void markPropertyVisible(Property property, Visibility visibility, Authorizations authorizations) {
        this.markPropertyVisible(property, null, visibility, authorizations);
    }

    public Iterable<Object> getPropertyValues(String name) {
        return new ConvertingIterable<Property, Object>(this.getProperties(name)){

            protected Object convert(Property o) {
                return o.getValue();
            }
        };
    }

    public Iterable<Object> getPropertyValues(String key, String name) {
        return new ConvertingIterable<Property, Object>(this.getProperties(key, name)){

            protected Object convert(Property o) {
                return o.getValue();
            }
        };
    }

    public Object getPropertyValue(String name) {
        Property p = this.getProperty(name);
        return p == null ? null : p.getValue();
    }

    public Object getPropertyValue(String key, String name) {
        Property p = this.getProperty(key, name);
        return p == null ? null : p.getValue();
    }

    public Object getPropertyValue(String name, int index) {
        Iterator<Object> values = this.getPropertyValues(name).iterator();
        while (values.hasNext() && index >= 0) {
            Object v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }

    public Object getPropertyValue(String key, String name, int index) {
        Iterator<Object> values = this.getPropertyValues(key, name).iterator();
        while (values.hasNext() && index >= 0) {
            Object v = values.next();
            if (index == 0) {
                return v;
            }
            --index;
        }
        return null;
    }

    public void setProperty(String name, Object value, Visibility visibility, Authorizations authorizations) {
        this.addPropertyValue("", name, value, visibility, authorizations);
    }

    public void setProperty(String name, Object value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.addPropertyValue("", name, value, metadata, visibility, authorizations);
    }

    public void addPropertyValue(String key, String name, Object value, Visibility visibility, Authorizations authorizations) {
        this.addPropertyValue(key, name, value, null, visibility, authorizations);
    }

    public Property getProperty(String key, String name) {
        return this.getProperty(key, name, null);
    }

    public Property getProperty(String key, String name, Visibility visibility) {
        if ("__ID__".equals(name)) {
            return this.getIdProperty();
        }
        if ("__edgeLabel".equals(name) && this instanceof Edge) {
            return this.getEdgeLabelProperty();
        }
        for (Property p : this.getProperties()) {
            if (!p.getKey().equals(key) || !p.getName().equals(name)) continue;
            if (visibility == null) {
                return p;
            }
            if (!visibility.equals((Object)p.getVisibility())) continue;
            return p;
        }
        return null;
    }

    public Property getProperty(String name, Visibility visibility) {
        return this.getProperty("", name, visibility);
    }

    public Property getProperty(String name) {
        Iterator<Property> propertiesWithName = this.getProperties(name).iterator();
        if (propertiesWithName.hasNext()) {
            return propertiesWithName.next();
        }
        return null;
    }

    public Iterable<Property> getProperties(final String name) {
        if ("__ID__".equals(name)) {
            ArrayList<Property> result = new ArrayList<Property>();
            result.add(this.getIdProperty());
            return result;
        }
        if ("__edgeLabel".equals(name) && this instanceof Edge) {
            ArrayList<Property> result = new ArrayList<Property>();
            result.add(this.getEdgeLabelProperty());
            return result;
        }
        return new FilterIterable<Property>(this.getProperties()){

            protected boolean isIncluded(Property property) {
                return property.getName().equals(name);
            }
        };
    }

    public Iterable<Property> getProperties(final String key, final String name) {
        if ("__ID__".equals(name)) {
            ArrayList<Property> result = new ArrayList<Property>();
            result.add(this.getIdProperty());
            return result;
        }
        if ("__edgeLabel".equals(name) && this instanceof Edge) {
            ArrayList<Property> result = new ArrayList<Property>();
            result.add(this.getEdgeLabelProperty());
            return result;
        }
        return new FilterIterable<Property>(this.getProperties()){

            protected boolean isIncluded(Property property) {
                return property.getName().equals(name) && property.getKey().equals(key);
            }
        };
    }

    public void addPropertyValue(String key, String name, Object value, Metadata metadata, Visibility visibility, Authorizations authorizations) {
        this.addPropertyValue(key, name, value, metadata, visibility, null, true, authorizations);
    }

    public void addPropertyValue(String key, String name, Object value, Metadata metadata, Visibility visibility, Long timestamp, boolean indexAfterAdd, Authorizations authorizations) {
        this.getGraph().addPropertyValue(this, this.inMemoryTableElement, key, name, value, metadata, visibility, timestamp, authorizations);
        if (indexAfterAdd) {
            this.getGraph().getSearchIndex().addElement((Graph)this.getGraph(), (Element)this, authorizations);
        }
    }

    public boolean isHidden(Authorizations authorizations) {
        return this.inMemoryTableElement.isHidden(authorizations);
    }

    public Iterable<Property> getProperties() {
        return this.inMemoryTableElement.getProperties(this.includeHidden, this.endTime, this.authorizations);
    }

    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Long startTime, Long endTime, Authorizations authorizations) {
        return this.inMemoryTableElement.getHistoricalPropertyValues(key, name, visibility, startTime, endTime, authorizations);
    }

    public Iterable<HistoricalPropertyValue> getHistoricalPropertyValues(String key, String name, Visibility visibility, Authorizations authorizations) {
        return this.getHistoricalPropertyValues(key, name, visibility, null, null, authorizations);
    }

    public abstract <T extends Element> ExistingElementMutation<T> prepareMutation();

    public void mergeProperties(Element element) {
    }

    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    public InMemoryGraph getGraph() {
        return this.graph;
    }

    void updatePropertiesInternal(VertexBuilder edgeBuilder) {
        this.updatePropertiesInternal(edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes());
    }

    void updatePropertiesInternal(EdgeBuilderBase edgeBuilder) {
        this.updatePropertiesInternal(edgeBuilder.getProperties(), edgeBuilder.getPropertyDeletes(), edgeBuilder.getPropertySoftDeletes());
    }

    protected void updatePropertiesInternal(Iterable<Property> properties, Iterable<PropertyDeleteMutation> propertyDeleteMutations, Iterable<PropertySoftDeleteMutation> propertySoftDeleteMutations) {
        long timestamp = IncreasingTime.currentTimeMillis();
        for (Property property : properties) {
            this.addPropertyValue(property.getKey(), property.getName(), property.getValue(), property.getMetadata(), property.getVisibility(), property.getTimestamp(), false, this.authorizations);
        }
        for (PropertyDeleteMutation propertyDeleteMutation : propertyDeleteMutations) {
            this.deleteProperty(propertyDeleteMutation.getKey(), propertyDeleteMutation.getName(), propertyDeleteMutation.getVisibility(), this.authorizations);
        }
        for (PropertySoftDeleteMutation propertySoftDeleteMutation : propertySoftDeleteMutations) {
            this.softDeleteProperty(propertySoftDeleteMutation.getKey(), propertySoftDeleteMutation.getName(), timestamp, propertySoftDeleteMutation.getVisibility(), this.authorizations);
        }
    }

    protected <T extends Element> void saveExistingElementMutation(ExistingElementMutationImpl<T> mutation, Authorizations authorizations) {
        EdgeMutation edgeMutation;
        if (mutation.getElement() != this) {
            throw new VertexiumException("cannot save mutation from another element");
        }
        this.graph.alterElementPropertyMetadata(this.inMemoryTableElement, mutation.getSetPropertyMetadatas(), authorizations);
        this.graph.alterElementPropertyVisibilities(this.inMemoryTableElement, mutation.getAlterPropertyVisibilities(), authorizations);
        Iterable properties = mutation.getProperties();
        Iterable propertyDeleteMutations = mutation.getPropertyDeletes();
        Iterable propertySoftDeleteMutations = mutation.getPropertySoftDeletes();
        this.overridePropertyTimestamps(properties);
        this.updatePropertiesInternal(properties, propertyDeleteMutations, propertySoftDeleteMutations);
        InMemoryGraph graph = this.getGraph();
        if (mutation.getNewElementVisibility() != null) {
            graph.alterElementVisibility(this.inMemoryTableElement, mutation.getNewElementVisibility());
        }
        if (mutation instanceof EdgeMutation && (edgeMutation = (EdgeMutation)mutation).getNewEdgeLabel() != null) {
            graph.alterEdgeLabel((InMemoryTableEdge)this.inMemoryTableElement, edgeMutation.getNewEdgeLabel());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Element) {
            Element objElem = (Element)obj;
            return this.getId().equals(objElem.getId());
        }
        return super.equals(obj);
    }

    public String toString() {
        if (this instanceof Edge) {
            Edge edge = (Edge)this;
            return this.getId() + ":[" + edge.getVertexId(Direction.OUT) + "-" + edge.getLabel() + "->" + edge.getVertexId(Direction.IN) + "]";
        }
        return this.getId();
    }

    protected void saveMutationToSearchIndex(Element element, List<AlterPropertyVisibility> alterPropertyVisibilities, Authorizations authorizations) {
        if (alterPropertyVisibilities != null && alterPropertyVisibilities.size() > 0) {
            for (AlterPropertyVisibility apv : alterPropertyVisibilities) {
                Visibility existingVisibility = apv.getExistingVisibility();
                this.getGraph().getSearchIndex().deleteProperty((Graph)this.getGraph(), element, apv.getKey(), apv.getName(), existingVisibility, authorizations);
            }
            this.getGraph().getSearchIndex().flush();
        }
        this.getGraph().getSearchIndex().addElement((Graph)this.getGraph(), element, authorizations);
    }

    public boolean canRead(Authorizations authorizations) {
        return this.inMemoryTableElement.canRead(authorizations);
    }

    public Iterable<Visibility> getHiddenVisibilities() {
        return this.inMemoryTableElement.getHiddenVisibilities();
    }

    private void overridePropertyTimestamps(Iterable<Property> properties) {
        for (Property property : properties) {
            if (!(property instanceof MutableProperty)) continue;
            ((MutableProperty)property).setTimestamp(IncreasingTime.currentTimeMillis());
        }
    }
}

