/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.fate.zookeeper;

import java.nio.charset.Charset;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZooReservation {
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public static boolean attempt(IZooReaderWriter zk, String path, String reservationID, String debugInfo) throws KeeperException, InterruptedException {
        if (reservationID.contains(":")) {
            throw new IllegalArgumentException();
        }
        while (true) {
            try {
                zk.putPersistentData(path, (reservationID + ":" + debugInfo).getBytes(UTF8), ZooUtil.NodeExistsPolicy.FAIL);
                return true;
            }
            catch (KeeperException.NodeExistsException nee) {
                byte[] zooData;
                Stat stat = new Stat();
                try {
                    zooData = zk.getData(path, stat);
                }
                catch (KeeperException.NoNodeException nne) {
                    continue;
                }
                String idInZoo = new String(zooData, UTF8).split(":")[0];
                return idInZoo.equals(reservationID);
            }
            break;
        }
    }

    public static void release(IZooReaderWriter zk, String path, String reservationID) throws KeeperException, InterruptedException {
        byte[] zooData;
        Stat stat = new Stat();
        try {
            zooData = zk.getData(path, stat);
        }
        catch (KeeperException.NoNodeException e) {
            Logger.getLogger(ZooReservation.class).debug((Object)("Node does not exist " + path));
            return;
        }
        String zooDataStr = new String(zooData, UTF8);
        String idInZoo = zooDataStr.split(":")[0];
        if (!idInZoo.equals(reservationID)) {
            throw new IllegalStateException("Tried to release reservation " + path + " with data mismatch " + reservationID + " " + zooDataStr);
        }
        zk.recursiveDelete(path, stat.getVersion(), ZooUtil.NodeMissingPolicy.SKIP);
    }
}

