/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.engine.connector.Connection;
import org.restlet.engine.connector.ConnectionController;
import org.restlet.engine.connector.ServerConnectionHelper;
import org.restlet.engine.io.IoUtils;

public class ServerConnectionController
extends ConnectionController {
    private final CountDownLatch latch = new CountDownLatch(1);

    public ServerConnectionController(ServerConnectionHelper helper) {
        super(helper);
    }

    public void await() throws InterruptedException {
        if (!this.latch.await(IoUtils.TIMEOUT_MS, TimeUnit.MILLISECONDS)) {
            this.getHelper().getLogger().warning("The calling thread timed out while waiting for the controller to be ready to accept connections.");
        }
    }

    protected ServerConnectionHelper getHelper() {
        return (ServerConnectionHelper)super.getHelper();
    }

    protected void onSelected(SelectionKey key) throws IOException {
        if (!key.isAcceptable()) {
            super.onSelected(key);
        } else if (!this.isOverloaded()) {
            try {
                SocketChannel socketChannel = this.getHelper().getServerSocketChannel().accept();
                if (socketChannel != null) {
                    socketChannel.configureBlocking(false);
                    int connectionsCount = this.getHelper().getConnections().size();
                    if (this.getHelper().getMaxTotalConnections() == -1 || connectionsCount <= this.getHelper().getMaxTotalConnections()) {
                        Connection connection = this.getHelper().checkout(socketChannel, this, (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress());
                        connection.open();
                        this.getHelper().getConnections().add(connection);
                        if (this.getHelper().getLogger().isLoggable(Level.FINE)) {
                            this.getHelper().getLogger().fine("Connection from \"" + connection.getSocketAddress() + "\" accepted. New count: " + this.getHelper().getConnections().size());
                        }
                    } else {
                        socketChannel.close();
                        this.getHelper().getLogger().info("Maximum number of concurrent connections reached. New connection rejected.");
                    }
                }
            }
            catch (ClosedByInterruptException ex) {
                this.getHelper().getLogger().log(Level.FINE, "ServerSocket channel was closed by interrupt", ex);
                throw ex;
            }
            catch (AsynchronousCloseException ace) {
                this.getHelper().getLogger().log(Level.FINE, "The server socket was closed", ace);
            }
            catch (SocketException se) {
                this.getHelper().getLogger().log(Level.FINE, "The server socket was closed", se);
            }
            catch (IOException ex) {
                this.getHelper().getLogger().log(Level.WARNING, "Unexpected error while accepting new connection", ex);
            }
        }
    }

    protected void doInit() {
        super.doInit();
        try {
            this.getHelper().getServerSocketChannel().register(this.getSelector(), 16);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.WARNING, "Unexpected error while registering an NIO selection key", ioe);
        }
        this.latch.countDown();
    }
}

