/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapOutputFile;
import org.apache.hadoop.mapreduce.TaskID;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MROutputFiles
extends MapOutputFile {
    private LocalDirAllocator lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");

    @Override
    public Path getOutputFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out", this.getConf());
    }

    @Override
    public Path getOutputFileForWrite(long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out", size, this.getConf());
    }

    @Override
    public Path getOutputFileForWriteInVolume(Path existing) {
        return new Path(existing.getParent(), "file.out");
    }

    @Override
    public Path getOutputIndexFile() throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/file.out.index", this.getConf());
    }

    @Override
    public Path getOutputIndexFileForWrite(long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/file.out.index", size, this.getConf());
    }

    @Override
    public Path getOutputIndexFileForWriteInVolume(Path existing) {
        return new Path(existing.getParent(), "file.out.index");
    }

    @Override
    public Path getSpillFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out", this.getConf());
    }

    @Override
    public Path getSpillFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out", size, this.getConf());
    }

    @Override
    public Path getSpillIndexFile(int spillNumber) throws IOException {
        return this.lDirAlloc.getLocalPathToRead("output/spill" + spillNumber + ".out.index", this.getConf());
    }

    @Override
    public Path getSpillIndexFileForWrite(int spillNumber, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite("output/spill" + spillNumber + ".out.index", size, this.getConf());
    }

    @Override
    public Path getInputFile(int mapId) throws IOException {
        return this.lDirAlloc.getLocalPathToRead(String.format("%s/map_%d.out", "output", mapId), this.getConf());
    }

    @Override
    public Path getInputFileForWrite(TaskID mapId, long size) throws IOException {
        return this.lDirAlloc.getLocalPathForWrite(String.format("%s/map_%d.out", "output", mapId.getId()), size, this.getConf());
    }

    @Override
    public void removeAll() throws IOException {
        ((JobConf)this.getConf()).deleteLocalFiles("output");
    }

    @Override
    public void setConf(Configuration conf) {
        if (!(conf instanceof JobConf)) {
            conf = new JobConf(conf);
        }
        super.setConf(conf);
    }
}

