/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.lang.reflect.Array;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.CacheConfig;
import org.cache2k.CacheEntry;
import org.cache2k.CacheException;
import org.cache2k.CacheMisconfigurationException;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.ClosableIterator;
import org.cache2k.EntryExpiryCalculator;
import org.cache2k.ExceptionExpiryCalculator;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.PropagatedCacheException;
import org.cache2k.RefreshController;
import org.cache2k.StorageConfiguration;
import org.cache2k.ValueWithExpiryTime;
import org.cache2k.impl.CacheClosedException;
import org.cache2k.impl.CacheIntegrityError;
import org.cache2k.impl.CacheLockSpinsExceededError;
import org.cache2k.impl.CacheManagerImpl;
import org.cache2k.impl.CacheRefreshThreadPool;
import org.cache2k.impl.CacheStorageException;
import org.cache2k.impl.CacheUsageExcpetion;
import org.cache2k.impl.CanCheckIntegrity;
import org.cache2k.impl.ClosableConcurrentHashEntryIterator;
import org.cache2k.impl.Entry;
import org.cache2k.impl.ExceptionWrapper;
import org.cache2k.impl.Hash;
import org.cache2k.impl.IntegrityState;
import org.cache2k.impl.LruCache;
import org.cache2k.impl.PassingStorageAdapter;
import org.cache2k.impl.StorageAdapter;
import org.cache2k.impl.threading.Futures;
import org.cache2k.impl.threading.LimitedPooledExecutor;
import org.cache2k.impl.timer.GlobalTimerService;
import org.cache2k.impl.timer.TimerService;
import org.cache2k.impl.util.Log;
import org.cache2k.impl.util.ThreadDump;
import org.cache2k.impl.util.TunableConstants;
import org.cache2k.impl.util.TunableFactory;
import org.cache2k.impl.util.Util;
import org.cache2k.storage.PurgeableStorage;
import org.cache2k.storage.StorageEntry;

public abstract class BaseCache<E extends Entry, K, T>
implements Cache<K, T>,
CanCheckIntegrity,
Iterable<CacheEntry<K, T>>,
StorageAdapter.Parent {
    static final Random SEED_RANDOM = new Random(new SecureRandom().nextLong());
    static int cacheCnt = 0;
    protected static final Tunable TUNABLE = TunableFactory.get(Tunable.class);
    static final EntryExpiryCalculator<?, ValueWithExpiryTime> ENTRY_EXPIRY_CALCULATOR_FROM_VALUE = new EntryExpiryCalculator<Object, ValueWithExpiryTime>(){

        public long calculateExpiryTime(Object _key, ValueWithExpiryTime _value, long _fetchTime, CacheEntry<Object, ValueWithExpiryTime> _oldEntry) {
            return _value.getCacheExpiryTime();
        }
    };
    protected int hashSeed;
    protected int maxSize;
    protected String name;
    protected CacheManagerImpl manager;
    protected CacheSourceWithMetaInfo<K, T> source;
    protected long maxLinger;
    protected long exceptionMaxLinger;
    protected EntryExpiryCalculator<K, T> entryExpiryCalculator;
    protected ExceptionExpiryCalculator<K> exceptionExpiryCalculator;
    protected Info info;
    protected long clearedTime;
    protected long startedTime;
    protected long touchedTime;
    protected int timerCancelCount;
    protected long keyMutationCount;
    protected long putCnt;
    protected long putNewEntryCnt;
    protected long removedCnt;
    protected long expiredKeptCnt;
    protected long expiredRemoveCnt;
    protected long evictedCnt;
    protected long refreshCnt;
    protected long suppressedExceptionCnt;
    protected long fetchExceptionCnt;
    protected long peekHitNotFreshCnt;
    protected long peekMissCnt;
    protected long fetchCnt;
    protected long fetchButHitCnt;
    protected long bulkGetCnt;
    protected long fetchMillis;
    protected long refreshHitCnt;
    protected long newEntryCnt;
    protected long loadNonFreshCnt;
    protected long loadHitCnt;
    protected long loadNonFreshAndFetchedCnt;
    protected long refreshSubmitFailedCnt;
    protected long internalExceptionCnt;
    protected int evictedButInHashCnt;
    protected long loadMissCnt;
    protected long virginEvictCnt;
    protected int maximumBulkFetchSize;
    protected final Object lock;
    protected CacheRefreshThreadPool refreshPool;
    protected Hash<E> mainHashCtrl;
    protected E[] mainHash;
    protected Hash<E> refreshHashCtrl;
    protected E[] refreshHash;
    protected ExperimentalBulkCacheSource<K, T> experimentalBulkCacheSource;
    protected BulkCacheSource<K, T> bulkCacheSource;
    protected Timer timer;
    protected Futures.WaitForAllFuture<?> shutdownWaitFuture;
    protected boolean shutdownInitiated;
    protected boolean evictionNeeded;
    protected Class keyType;
    protected Class valueType;
    protected StorageAdapter storage;
    protected TimerService timerService;
    protected boolean waitForClear;
    private int featureBits;
    private static final int SHARP_TIMEOUT_FEATURE = 1;
    private static final int KEEP_AFTER_EXPIRED = 2;
    private static final int SUPPRESS_EXCEPTIONS = 4;
    static final byte INSERT_STAT_NO_UPDATE = 0;
    static final byte INSERT_STAT_UPDATE = 1;
    static final byte INSERT_STAT_PUT = 2;

    public BaseCache() {
        this.hashSeed = BaseCache.TUNABLE.disableHashRandomization ? BaseCache.TUNABLE.hashSeed : SEED_RANDOM.nextInt();
        this.maxSize = 5000;
        this.maxLinger = 600000L;
        this.exceptionMaxLinger = 60000L;
        this.clearedTime = 0L;
        this.timerCancelCount = 0;
        this.keyMutationCount = 0L;
        this.putCnt = 0L;
        this.putNewEntryCnt = 0L;
        this.removedCnt = 0L;
        this.expiredKeptCnt = 0L;
        this.expiredRemoveCnt = 0L;
        this.evictedCnt = 0L;
        this.refreshCnt = 0L;
        this.suppressedExceptionCnt = 0L;
        this.fetchExceptionCnt = 0L;
        this.peekHitNotFreshCnt = 0L;
        this.peekMissCnt = 0L;
        this.fetchCnt = 0L;
        this.fetchButHitCnt = 0L;
        this.bulkGetCnt = 0L;
        this.fetchMillis = 0L;
        this.refreshHitCnt = 0L;
        this.newEntryCnt = 0L;
        this.loadNonFreshCnt = 0L;
        this.loadHitCnt = 0L;
        this.refreshSubmitFailedCnt = 0L;
        this.internalExceptionCnt = 0L;
        this.evictedButInHashCnt = 0;
        this.loadMissCnt = 0L;
        this.virginEvictCnt = 0L;
        this.maximumBulkFetchSize = 100;
        this.lock = new Object();
        this.shutdownInitiated = false;
        this.evictionNeeded = false;
        this.timerService = GlobalTimerService.getInstance();
        this.waitForClear = false;
        this.featureBits = 0;
    }

    protected final boolean hasSharpTimeout() {
        return (this.featureBits & 1) > 0;
    }

    protected final boolean hasKeepAfterExpired() {
        return (this.featureBits & 2) > 0;
    }

    protected final boolean hasSuppressExceptions() {
        return (this.featureBits & 4) > 0;
    }

    protected final void setFeatureBit(int _bitmask, boolean _flag) {
        this.featureBits = _flag ? (this.featureBits |= _bitmask) : (this.featureBits &= ~_bitmask);
    }

    protected final boolean hasBackgroundRefreshAndServesExpiredValues() {
        return this.refreshPool != null;
    }

    protected String getCompleteName() {
        if (this.manager != null) {
            return this.manager.getName() + ":" + this.name;
        }
        return this.name;
    }

    protected Log getLog() {
        return Log.getLog(Cache.class.getName() + '/' + this.getCompleteName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetStorage(StorageAdapter _from, StorageAdapter to) {
        Object object = this.lock;
        synchronized (object) {
            this.storage = to;
        }
    }

    public void setCacheConfig(CacheConfig c) {
        long _expiryMillis;
        this.valueType = c.getValueType();
        this.keyType = c.getKeyType();
        if (this.name != null) {
            throw new IllegalStateException("already configured");
        }
        this.setName(c.getName());
        this.maxSize = c.getMaxSize();
        if (c.getHeapEntryCapacity() >= 0) {
            this.maxSize = c.getHeapEntryCapacity();
        }
        if (c.isBackgroundRefresh()) {
            this.refreshPool = CacheRefreshThreadPool.getInstance();
        }
        if ((_expiryMillis = c.getExpiryMillis()) == Long.MAX_VALUE || _expiryMillis < 0L) {
            this.maxLinger = -1L;
        } else if (_expiryMillis >= 0L) {
            this.maxLinger = _expiryMillis;
        }
        long _exceptionExpiryMillis = c.getExceptionExpiryMillis();
        this.exceptionMaxLinger = _exceptionExpiryMillis == -1L ? (this.maxLinger == -1L ? -1L : this.maxLinger / 10L) : _exceptionExpiryMillis;
        this.setFeatureBit(2, c.isKeepDataAfterExpired());
        this.setFeatureBit(1, c.isSharpExpiry());
        this.setFeatureBit(4, c.isSuppressExceptions());
        List _stores = c.getStorageModules();
        if (_stores.size() == 1) {
            StorageConfiguration cfg = (StorageConfiguration)_stores.get(0);
            if (cfg.getEntryCapacity() < 0) {
                cfg.setEntryCapacity(c.getMaxSize());
            }
            this.storage = new PassingStorageAdapter(this, c, (StorageConfiguration)_stores.get(0));
        } else if (_stores.size() > 1) {
            throw new UnsupportedOperationException("no aggregation support yet");
        }
        if (ValueWithExpiryTime.class.isAssignableFrom(c.getValueType()) && this.entryExpiryCalculator == null) {
            this.entryExpiryCalculator = ENTRY_EXPIRY_CALCULATOR_FROM_VALUE;
        }
    }

    public void setEntryExpiryCalculator(EntryExpiryCalculator<K, T> v) {
        this.entryExpiryCalculator = v;
    }

    public void setExceptionExpiryCalculator(ExceptionExpiryCalculator<K> v) {
        this.exceptionExpiryCalculator = v;
    }

    public void setRefreshController(final RefreshController<T> lc) {
        this.entryExpiryCalculator = new EntryExpiryCalculator<K, T>(){

            public long calculateExpiryTime(K _key, T _value, long _fetchTime, CacheEntry<K, T> _oldEntry) {
                if (_oldEntry != null) {
                    return lc.calculateNextRefreshTime(_oldEntry.getValue(), _value, _oldEntry.getLastModification(), _fetchTime);
                }
                return lc.calculateNextRefreshTime(null, _value, 0L, _fetchTime);
            }
        };
    }

    public void setSource(CacheSourceWithMetaInfo<K, T> eg) {
        this.source = eg;
    }

    public void setSource(final CacheSource<K, T> g) {
        if (g != null) {
            this.source = new CacheSourceWithMetaInfo<K, T>(){

                public T get(K key, long _currentTime, T _previousValue, long _timeLastFetched) throws Throwable {
                    return g.get(key);
                }
            };
        }
    }

    public void setExperimentalBulkCacheSource(ExperimentalBulkCacheSource<K, T> g) {
        this.experimentalBulkCacheSource = g;
        if (this.source == null) {
            this.source = new CacheSourceWithMetaInfo<K, T>(){

                public T get(K key, long _currentTime, T _previousValue, long _timeLastFetched) throws Throwable {
                    Object[] ka = (Object[])Array.newInstance(BaseCache.this.keyType, 1);
                    ka[0] = key;
                    Object[] ra = (Object[])Array.newInstance(BaseCache.this.valueType, 1);
                    BitSet _fetched = new BitSet(1);
                    BaseCache.this.experimentalBulkCacheSource.getBulk(ka, ra, _fetched, 0, 1);
                    return ra[0];
                }
            };
        }
    }

    public void setBulkCacheSource(BulkCacheSource<K, T> s) {
        this.bulkCacheSource = s;
        if (this.source == null) {
            this.source = new CacheSourceWithMetaInfo<K, T>(){

                public T get(final K key, long _currentTime, final T _previousValue, final long _timeLastFetched) throws Throwable {
                    final CacheEntry entry = new CacheEntry<K, T>(){

                        public K getKey() {
                            return key;
                        }

                        public T getValue() {
                            return _previousValue;
                        }

                        public Throwable getException() {
                            return null;
                        }

                        public long getLastModification() {
                            return _timeLastFetched;
                        }
                    };
                    AbstractList _entryList = new AbstractList<CacheEntry<K, T>>(){

                        @Override
                        public CacheEntry<K, T> get(int index) {
                            return entry;
                        }

                        @Override
                        public int size() {
                            return 1;
                        }
                    };
                    return BaseCache.this.bulkCacheSource.getValues((List)_entryList, _currentTime).get(0);
                }
            };
        }
    }

    public void setName(String n) {
        if (n == null) {
            n = this.getClass().getSimpleName() + "#" + cacheCnt++;
        }
        this.name = n;
    }

    public void setExpirySeconds(int s) {
        if (s < 0 || s == Integer.MAX_VALUE) {
            this.maxLinger = -1L;
            return;
        }
        this.maxLinger = s * 1000;
    }

    public String getName() {
        return this.name;
    }

    public void setCacheManager(CacheManagerImpl cm) {
        this.manager = cm;
    }

    public StorageAdapter getStorage() {
        return this.storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.lock;
        synchronized (object) {
            if (this.name == null) {
                this.name = "" + cacheCnt++;
            }
            if (this.storage == null && this.maxSize == 0) {
                throw new IllegalArgumentException("maxElements must be >0");
            }
            if (this.storage != null) {
                this.bulkCacheSource = null;
                this.storage.open();
            }
            this.initializeHeapCache();
            this.initTimer();
            if (this.refreshPool != null && this.source == null) {
                throw new CacheMisconfigurationException("backgroundRefresh, but no source");
            }
            if (this.refreshPool != null && this.timer == null) {
                if (this.maxLinger == 0L) {
                    this.getLog().warn("Background refresh is enabled, but elements are fetched always. Disable background refresh!");
                } else {
                    this.getLog().warn("Background refresh is enabled, but elements are eternal. Disable background refresh!");
                }
                this.refreshPool.destroy();
                this.refreshPool = null;
            }
        }
    }

    boolean isNeedingTimer() {
        return this.maxLinger > 0L || this.entryExpiryCalculator != null || this.exceptionMaxLinger > 0L || this.exceptionExpiryCalculator != null;
    }

    private void initTimer() {
        if (this.isNeedingTimer()) {
            if (this.timer == null) {
                this.timer = new Timer(this.name, true);
            }
        } else if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClearWithStorage() {
        boolean _untouchedHeapCache;
        StorageClearTask t = new StorageClearTask();
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.waitForClear = true;
            boolean bl = _untouchedHeapCache = this.touchedTime == this.clearedTime && this.getLocalSize() == 0;
            if (!this.storage.checkStorageStillDisconnectedForClear()) {
                t.allLocalEntries = this.iterateAllHeapEntries();
                t.allLocalEntries.setStopOnClear(false);
            }
            t.storage = this.storage;
            t.storage.disconnectStorageForClear();
        }
        try {
            if (_untouchedHeapCache) {
                FutureTask<Void> f = new FutureTask<Void>(t);
                this.updateShutdownWaitFuture(f);
                f.run();
            } else {
                this.updateShutdownWaitFuture(this.manager.getThreadPool().execute(t));
            }
        }
        catch (Exception ex) {
            throw new CacheStorageException(ex);
        }
        object = this.lock;
        synchronized (object) {
            if (this.isClosed()) {
                throw new CacheClosedException();
            }
            this.clearLocalCache();
            this.waitForClear = false;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateShutdownWaitFuture(Future<?> f) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownWaitFuture == null || this.shutdownWaitFuture.isDone()) {
                this.shutdownWaitFuture = new Futures.WaitForAllFuture(f);
            } else {
                this.shutdownWaitFuture.add(f);
            }
        }
    }

    protected void checkClosed() {
        if (this.isClosed()) {
            throw new CacheClosedException();
        }
        while (this.waitForClear) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        if (this.storage != null) {
            this.processClearWithStorage();
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.clearLocalCache();
        }
    }

    protected final void clearLocalCache() {
        ClosableConcurrentHashEntryIterator<Entry> it = this.iterateAllHeapEntries();
        int _count = 0;
        while (it.hasNext()) {
            Entry e = (Entry)it.next();
            e.removedFromList();
            this.cancelExpiryTimer(e);
            ++_count;
        }
        this.removedCnt += (long)this.getLocalSize();
        this.initializeHeapCache();
        this.touchedTime = this.clearedTime = System.currentTimeMillis();
    }

    protected void initializeHeapCache() {
        if (this.mainHashCtrl != null) {
            this.mainHashCtrl.cleared();
            this.refreshHashCtrl.cleared();
        }
        this.mainHashCtrl = new Hash();
        this.refreshHashCtrl = new Hash();
        this.mainHash = this.mainHashCtrl.init(this.newEntry().getClass());
        this.refreshHash = this.refreshHashCtrl.init(this.newEntry().getClass());
        if (this.startedTime == 0L) {
            this.startedTime = System.currentTimeMillis();
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
            this.initTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimingStatistics() {
        Object object = this.lock;
        synchronized (object) {
            this.fetchCnt = 0L;
            this.fetchMillis = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Future<Void> cancelTimerJobs() {
        Object object = this.lock;
        synchronized (object) {
            Future<Void> f;
            if (this.timer != null) {
                this.timer.cancel();
            }
            Future<Void> _waitFuture = new Futures.BusyWaitFuture<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean isDone() {
                    Object object = BaseCache.this.lock;
                    synchronized (object) {
                        return BaseCache.this.getFetchesInFlight() == 0;
                    }
                }
            };
            if (this.storage != null && (f = this.storage.cancelTimerJobs()) != null) {
                _waitFuture = new Futures.WaitForAllFuture(_waitFuture, f);
            }
            return _waitFuture;
        }
    }

    public void purge() {
        if (this.storage != null) {
            this.storage.purge();
        }
    }

    public void flush() {
        if (this.storage != null) {
            this.storage.flush();
        }
    }

    protected boolean isClosed() {
        return this.shutdownInitiated;
    }

    public void destroy() {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownInitiated) {
                return;
            }
            this.shutdownInitiated = true;
        }
        Future<Void> _await = this.cancelTimerJobs();
        try {
            _await.get(BaseCache.TUNABLE.waitForTimerJobsSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            int _fetchesInFlight;
            Object object2 = this.lock;
            synchronized (object2) {
                _fetchesInFlight = this.getFetchesInFlight();
            }
            if (_fetchesInFlight > 0) {
                this.getLog().warn("Fetches still in progress after " + BaseCache.TUNABLE.waitForTimerJobsSeconds + " seconds. " + "fetchesInFlight=" + _fetchesInFlight);
            } else {
                this.getLog().warn("timeout waiting for timer jobs termination (" + BaseCache.TUNABLE.waitForTimerJobsSeconds + " seconds)", ex);
                this.getLog().warn("Thread dump:\n" + ThreadDump.generateThredDump());
            }
            this.getLog().warn("State: " + this.toString());
        }
        catch (Exception ex) {
            this.getLog().warn("exception waiting for timer jobs termination", ex);
        }
        Object ex = this.lock;
        synchronized (ex) {
            this.mainHashCtrl.close();
            this.refreshHashCtrl.close();
        }
        try {
            Futures.WaitForAllFuture<?> _future = this.shutdownWaitFuture;
            if (_future != null) {
                _future.get();
            }
        }
        catch (Exception ex2) {
            throw new CacheException((Throwable)ex2);
        }
        Future<Void> _waitForStorage = null;
        if (this.storage != null) {
            _waitForStorage = this.storage.shutdown();
        }
        if (_waitForStorage != null) {
            try {
                _waitForStorage.get();
            }
            catch (Exception ex2) {
                StorageAdapter.rethrow("shutdown", ex2);
            }
        }
        Object object3 = this.lock;
        synchronized (object3) {
            this.storage = null;
        }
        object3 = this.lock;
        synchronized (object3) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            if (this.refreshPool != null) {
                this.refreshPool.destroy();
                this.refreshPool = null;
            }
            this.refreshHash = null;
            this.mainHash = null;
            this.source = null;
            if (this.manager != null) {
                this.manager.cacheDestroyed(this);
                this.manager = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ClosableIterator<Entry> iterateLocalAndStorage() {
        if (this.storage == null) {
            Object object = this.lock;
            synchronized (object) {
                return this.iterateAllHeapEntries();
            }
        }
        return this.storage.iterateAll();
    }

    @Override
    public ClosableIterator<CacheEntry<K, T>> iterator() {
        return new IteratorFilterEntry2Entry(this.iterateLocalAndStorage());
    }

    protected static void removeFromList(Entry e) {
        ((Entry)e.prev).next = e.next;
        ((Entry)e.next).prev = e.prev;
        e.removedFromList();
    }

    protected static void insertInList(Entry _head, Entry e) {
        e.prev = _head;
        e.next = _head.next;
        ((Entry)e.next).prev = e;
        _head.next = e;
    }

    protected static final int getListEntryCount(Entry _head) {
        Object e = _head.next;
        int cnt = 0;
        while (e != _head) {
            ++cnt;
            if (e == null) {
                return -cnt;
            }
            e = ((Entry)e).next;
        }
        return cnt;
    }

    protected static final <E extends Entry> void moveToFront(E _head, E e) {
        BaseCache.removeFromList(e);
        BaseCache.insertInList(_head, e);
    }

    protected static final <E extends Entry> E insertIntoTailCyclicList(E _head, E e) {
        if (_head == null) {
            return e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        _head.prev = e;
        ((Entry)e.prev).next = e;
        return _head;
    }

    protected static final <E extends Entry> E insertAfterHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return e.shortCircuit();
        }
        e.prev = _head;
        e.next = _head.next;
        ((Entry)_head.next).prev = e;
        _head.next = e;
        return _head;
    }

    protected static final <E extends Entry> E insertIntoHeadCyclicList(E _head, E e) {
        if (_head == null) {
            return e.shortCircuit();
        }
        e.next = _head;
        e.prev = _head.prev;
        ((Entry)_head.prev).next = e;
        _head.prev = e;
        return e;
    }

    protected static <E extends Entry> E removeFromCyclicList(E _head, E e) {
        Object _eNext;
        if (e.next == e) {
            e.removedFromList();
            return null;
        }
        ((Entry)e.prev).next = _eNext = e.next;
        ((Entry)e.next).prev = e.prev;
        e.removedFromList();
        return e == _head ? _eNext : _head;
    }

    protected static Entry removeFromCyclicList(Entry e) {
        Object _eNext;
        ((Entry)e.prev).next = _eNext = e.next;
        ((Entry)e.next).prev = e.prev;
        e.removedFromList();
        return _eNext == e ? null : (Entry)_eNext;
    }

    protected static int getCyclicListEntryCount(Entry e) {
        if (e == null) {
            return 0;
        }
        Entry _head = e;
        int cnt = 0;
        do {
            ++cnt;
            e = e.next;
            if (e != null) continue;
            return -cnt;
        } while (e != _head);
        return cnt;
    }

    protected static boolean checkCyclicListIntegrity(Entry e) {
        if (e == null) {
            return true;
        }
        Entry _head = e;
        do {
            if (e.next == null) {
                return false;
            }
            if (((Entry)e.next).prev == null) {
                return false;
            }
            if (((Entry)e.next).prev == e) continue;
            return false;
        } while ((e = e.next) != _head);
        return true;
    }

    protected abstract void recordHit(E var1);

    protected abstract void insertIntoReplacementList(E var1);

    protected abstract E newEntry();

    protected E findEvictionCandidate() {
        return null;
    }

    protected void removeEntryFromReplacementList(E e) {
        BaseCache.removeFromList(e);
    }

    protected E checkForGhost(K key, int hc) {
        return null;
    }

    protected E lookupEntryUnsynchronized(K key, int hc) {
        return null;
    }

    public T get(K key) {
        return this.returnValue((Entry<E, K, T>)this.getEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry<K, T> returnEntry(final Entry<E, K, T> e) {
        if (e == null) {
            return null;
        }
        Entry<E, K, T> entry = e;
        synchronized (entry) {
            final K _key = e.getKey();
            final T _value = e.getValue();
            final Throwable _exception = e.getException();
            final long _lastModification = e.getLastModification();
            CacheEntry ce = new CacheEntry<K, T>(){

                public K getKey() {
                    return _key;
                }

                public T getValue() {
                    return _value;
                }

                public Throwable getException() {
                    return _exception;
                }

                public long getLastModification() {
                    return _lastModification;
                }

                public String toString() {
                    long _expiry = e.getValueExpiryTime();
                    return "CacheEntry(key=" + this.getKey() + ", " + "value=" + this.getValue() + ", " + (this.getException() != null ? "exception=" + e.getException() + ", " : "") + "updated=" + Util.formatMillis(this.getLastModification()) + ", " + "expiry=" + (_expiry != 0L ? Util.formatMillis(_expiry) : "-") + ", " + "flags=" + (_expiry == 0L ? Long.valueOf(e.nextRefreshTime) : "-") + ")";
                }
            };
            return ce;
        }
    }

    public CacheEntry<K, T> getEntry(K key) {
        return this.returnEntry((Entry<E, K, T>)this.getEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected E getEntryInternal(K key) {
        E e;
        while (true) {
            if (((Entry)(e = this.lookupOrNewEntrySynchronized(key))).hasFreshData()) {
                return e;
            }
            E e2 = e;
            synchronized (e2) {
                ((Entry)e).waitForFetch();
                if (((Entry)e).hasFreshData()) {
                    return e;
                }
                if (!((Entry)e).isRemovedState()) break;
            }
        }
        {
            ((Entry)e).startFetch();
        }
        boolean _finished = false;
        try {
            ((Entry)e).finishFetch(this.fetch(e));
            _finished = true;
        }
        finally {
            ((Entry)e).ensureFetchAbort(_finished);
        }
        this.evictEventually();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Entry insertEntryFromStorage(StorageEntry se, boolean _needsFetch) {
        E e;
        block9: {
            int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
            while (true) {
                if (_spinCount-- <= 0) {
                    throw new CacheLockSpinsExceededError();
                }
                e = this.lookupOrNewEntrySynchronized(se.getKey());
                if (((Entry)e).hasFreshData()) {
                    return e;
                }
                E e2 = e;
                synchronized (e2) {
                    if (((Entry)e).isDataValidState()) break block9;
                    if (!((Entry)e).isRemovedState()) break;
                }
            }
            {
                if (((Entry)e).isFetchInProgress()) {
                    ((Entry)e).waitForFetch();
                    return e;
                }
                ((Entry)e).startFetch();
            }
        }
        boolean _finished = false;
        try {
            ((Entry)e).finishFetch(this.insertEntryFromStorage(se, e, _needsFetch));
            _finished = true;
        }
        finally {
            ((Entry)e).ensureFetchAbort(_finished);
        }
        this.evictEventually();
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void lockAndRunForPurge(Object key, PurgeableStorage.PurgeAction _action) {
        boolean _virgin;
        E e;
        int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            e = this.lookupOrNewEntrySynchronized(key);
            if (((Entry)e).hasFreshData()) {
                return;
            }
            E e2 = e;
            synchronized (e2) {
                ((Entry)e).waitForFetch();
                if (((Entry)e).isDataValidState()) {
                    return;
                }
                if (!((Entry)e).isRemovedState()) break;
            }
        }
        {
            _virgin = ((Entry)e).isVirgin();
            ((Entry)e).startFetch();
        }
        boolean _finished = false;
        try {
            StorageEntry se = _action.checkAndPurge(key);
            E e3 = e;
            synchronized (e3) {
                if (_virgin) {
                    ((Entry)e).finishFetch(0L);
                    this.evictEntryFromHeap(e);
                } else {
                    ((Entry)e).finishFetch(5L);
                    this.evictEntryFromHeap(e);
                }
            }
            _finished = true;
            return;
        }
        finally {
            ((Entry)e).ensureFetchAbort(_finished);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void evictEventually() {
        int _spinCount = BaseCache.TUNABLE.maximumEvictSpins;
        Object _previousCandidate = null;
        while (this.evictionNeeded) {
            boolean _shouldStore;
            E e;
            if (_spinCount-- <= 0) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                if (this.getLocalSize() <= this.maxSize) {
                    this.evictionNeeded = false;
                    return;
                }
                e = this.findEvictionCandidate();
            }
            E e2 = e;
            synchronized (e2) {
                if (((Entry)e).isRemovedState()) {
                    continue;
                }
                if (((Entry)e).isPinned()) {
                    if (e != _previousCandidate) {
                        _previousCandidate = e;
                        continue;
                    }
                    return;
                }
                boolean _storeEvenImmediatelyExpired = this.hasKeepAfterExpired() && (((Entry)e).isDataValidState() || ((Entry)e).isExpiredState() || ((Entry)e).nextRefreshTime == 3L);
                boolean bl = _shouldStore = this.storage != null && (_storeEvenImmediatelyExpired || ((Entry)e).hasFreshData());
                if (_shouldStore) {
                    ((Entry)e).startFetch();
                } else {
                    this.evictEntryFromHeap(e);
                }
            }
            if (!_shouldStore) continue;
            try {
                this.storage.evict((Entry)e);
            }
            finally {
                e2 = e;
                synchronized (e2) {
                    ((Entry)e).finishFetch(8L);
                    this.evictEntryFromHeap(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evictEntryFromHeap(E e) {
        Object object = this.lock;
        synchronized (object) {
            if (((Entry)e).isRemovedFromReplacementList()) {
                if (this.removeEntryFromHash(e)) {
                    --this.evictedButInHashCnt;
                    ++this.evictedCnt;
                }
            } else if (this.removeEntry(e)) {
                ++this.evictedCnt;
            }
            this.evictionNeeded = this.getLocalSize() > this.maxSize;
        }
        e.notifyAll();
    }

    protected boolean removeEntry(E e) {
        if (!((Entry)e).isRemovedFromReplacementList()) {
            this.removeEntryFromReplacementList(e);
        }
        return this.removeEntryFromHash(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected E peekEntryInternal(K key) {
        boolean _hasFreshData;
        E e;
        block16: {
            int hc = this.modifiedHash(key.hashCode());
            int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
            while (true) {
                if (_spinCount-- <= 0) {
                    throw new CacheLockSpinsExceededError();
                }
                e = this.lookupEntryUnsynchronized(key, hc);
                if (e == null) {
                    Object object = this.lock;
                    // MONITORENTER : object
                    e = this.lookupEntry(key, hc);
                    if (e == null && this.storage != null) {
                        e = this.newEntry(key, hc);
                    }
                    // MONITOREXIT : object
                }
                if (e == null) {
                    ++this.peekMissCnt;
                    return null;
                }
                if (((Entry)e).hasFreshData()) {
                    return e;
                }
                _hasFreshData = false;
                if (this.storage == null) break block16;
                E e2 = e;
                // MONITORENTER : e2
                ((Entry)e).waitForFetch();
                if (!((Entry)e).isRemovedState()) break;
                // MONITOREXIT : e2
            }
            if (((Entry)e).hasFreshData()) {
                // MONITOREXIT : e2
                return e;
            }
            boolean _needsLoad = this.conditionallyStartProcess(e);
            // MONITOREXIT : e2
            if (_needsLoad) {
                boolean _finished = false;
                try {
                    long t = this.fetchWithStorage(e, false);
                    ((Entry)e).finishFetch(t);
                    _hasFreshData = ((Entry)e).hasFreshData(System.currentTimeMillis(), t);
                    _finished = true;
                }
                finally {
                    ((Entry)e).ensureFetchAbort(_finished);
                }
            }
        }
        this.evictEventually();
        if (_hasFreshData) {
            return e;
        }
        ++this.peekHitNotFreshCnt;
        return null;
    }

    public boolean contains(K key) {
        E e = this.peekEntryInternal(key);
        return e != null;
    }

    public T peek(K key) {
        E e = this.peekEntryInternal(key);
        if (e != null) {
            return this.returnValue((Entry<E, K, T>)e);
        }
        return null;
    }

    public CacheEntry<K, T> peekEntry(K key) {
        return this.returnEntry((Entry<E, K, T>)this.peekEntryInternal(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean putIfAbsent(K key, T value) {
        E e;
        if (this.storage == null) {
            E e2;
            int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
            while (true) {
                if (_spinCount-- <= 0) {
                    throw new CacheLockSpinsExceededError();
                }
                E e3 = e2 = this.lookupOrNewEntrySynchronized(key);
                // MONITORENTER : e3
                if (!((Entry)e2).isRemovedState()) break;
                // MONITOREXIT : e3
            }
            long t = System.currentTimeMillis();
            if (((Entry)e2).hasFreshData(t)) {
                // MONITOREXIT : e3
                return false;
            }
            Object object = this.lock;
            // MONITORENTER : object
            ++this.peekHitNotFreshCnt;
            // MONITOREXIT : object
            ((Entry)e2).nextRefreshTime = this.insertOnPut(e2, value, t, t);
            // MONITOREXIT : e3
            return true;
        }
        int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            E e4 = e = this.lookupOrNewEntrySynchronized(key);
            // MONITORENTER : e4
            ((Entry)e).waitForFetch();
            if (!((Entry)e).isRemovedState()) break;
            // MONITOREXIT : e4
        }
        long t = System.currentTimeMillis();
        if (((Entry)e).hasFreshData(t)) {
            // MONITOREXIT : e4
            return false;
        }
        ((Entry)e).startFetch();
        // MONITOREXIT : e4
        if (((Entry)e).isVirgin()) {
            long _result = this.fetchWithStorage(e, false);
            long now = System.currentTimeMillis();
            if (((Entry)e).hasFreshData(now, _result)) {
                ((Entry)e).finishFetch(_result);
                return false;
            }
            ((Entry)e).nextRefreshTime = 9L;
        }
        ((Entry)e).finishFetch(this.insertOnPut(e, value, t, t));
        this.evictEventually();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(K key, T value) {
        E e;
        int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            E e2 = e = this.lookupOrNewEntrySynchronized(key);
            synchronized (e2) {
                if (((Entry)e).isRemovedState()) {
                    continue;
                }
                if (!((Entry)e).isFetchInProgress()) break;
                ((Entry)e).waitForFetch();
            }
        }
        {
            ((Entry)e).startFetch();
        }
        boolean _finished = false;
        try {
            long t = System.currentTimeMillis();
            ((Entry)e).finishFetch(this.insertOnPut(e, value, t, t));
            _finished = true;
        }
        finally {
            ((Entry)e).ensureFetchAbort(_finished);
        }
        this.evictEventually();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeWithFlag(K key) {
        boolean _hasFreshData;
        E e;
        if (this.storage == null) {
            E e2 = this.lookupEntrySynchronized(key);
            if (e2 == null) return false;
            E e3 = e2;
            synchronized (e3) {
                ((Entry)e2).waitForFetch();
                if (((Entry)e2).isRemovedState()) return false;
                Object object = this.lock;
                synchronized (object) {
                    boolean f = ((Entry)e2).hasFreshData();
                    if (!this.removeEntry(e2)) return false;
                    ++this.removedCnt;
                    return f;
                }
            }
        }
        int _spinCount = BaseCache.TUNABLE.maximumEntryLockSpins;
        while (true) {
            if (_spinCount-- <= 0) {
                throw new CacheLockSpinsExceededError();
            }
            E f = e = this.lookupOrNewEntrySynchronized(key);
            synchronized (f) {
                ((Entry)e).waitForFetch();
                if (!((Entry)e).isRemovedState()) break;
            }
        }
        {
            _hasFreshData = ((Entry)e).hasFreshData();
            ((Entry)e).startFetch();
        }
        boolean _finished = false;
        try {
            if (!_hasFreshData && ((Entry)e).isVirgin()) {
                long t = this.fetchWithStorage(e, false);
                _hasFreshData = ((Entry)e).hasFreshData(System.currentTimeMillis(), t);
            }
            if (_hasFreshData) {
                this.storage.remove(key);
            }
            E e4 = e;
            synchronized (e4) {
                ((Entry)e).finishFetch(5L);
                if (_hasFreshData) {
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.removeEntry(e)) {
                            ++this.removedCnt;
                        }
                    }
                }
            }
            _finished = true;
            return _hasFreshData;
        }
        finally {
            ((Entry)e).ensureFetchAbort(_finished);
        }
    }

    public void remove(K key) {
        this.removeWithFlag(key);
    }

    public void prefetch(final K key) {
        if (this.refreshPool == null || this.lookupEntrySynchronized(key) != null) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BaseCache.this.get(key);
            }
        };
        this.refreshPool.submit(r);
    }

    public void prefetch(final List<K> keys, final int _startIndex, final int _endIndexExclusive) {
        if (keys.size() == 0 || _startIndex == _endIndexExclusive) {
            return;
        }
        if (keys.size() <= _endIndexExclusive) {
            throw new IndexOutOfBoundsException("end > size");
        }
        if (_startIndex > _endIndexExclusive) {
            throw new IndexOutOfBoundsException("start > end");
        }
        if (_startIndex > 0) {
            throw new IndexOutOfBoundsException("end < 0");
        }
        AbstractSet ks = new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    int idx;
                    {
                        this.idx = _startIndex;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.idx < _endIndexExclusive;
                    }

                    @Override
                    public K next() {
                        return keys.get(this.idx++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return _endIndexExclusive - _startIndex;
            }
        };
        this.prefetch(ks);
    }

    public void prefetch(final Set<K> keys) {
        if (this.refreshPool == null) {
            this.getAll(keys);
            return;
        }
        boolean _complete = true;
        for (K k : keys) {
            if (this.lookupEntryUnsynchronized(k, this.modifiedHash(k.hashCode())) != null) continue;
            _complete = false;
            break;
        }
        if (_complete) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                BaseCache.this.getAll(keys);
            }
        };
        this.refreshPool.submit(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E lookupOrNewEntrySynchronized(K key) {
        int hc = this.modifiedHash(key.hashCode());
        E e = this.lookupEntryUnsynchronized(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                e = this.lookupEntry(key, hc);
                if (e == null) {
                    e = this.newEntry(key, hc);
                }
            }
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T returnValue(Entry<E, K, T> e) {
        Object v = e.value;
        if (v instanceof ExceptionWrapper) {
            ExceptionWrapper w = (ExceptionWrapper)v;
            if (w.additionalExceptionMessage == null) {
                Entry<E, K, T> entry = e;
                synchronized (entry) {
                    long t = e.getValueExpiryTime();
                    w.additionalExceptionMessage = "(expiry=" + (t > 0L ? Util.formatMillis(t) : "none") + ") " + w.getException();
                }
            }
            throw new PropagatedCacheException(w.additionalExceptionMessage, w.getException());
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected E lookupEntrySynchronized(K key) {
        int hc = this.modifiedHash(key.hashCode());
        E e = this.lookupEntryUnsynchronized(key, hc);
        if (e == null) {
            Object object = this.lock;
            synchronized (object) {
                e = this.lookupEntry(key, hc);
            }
        }
        return e;
    }

    protected E lookupEntry(K key, int hc) {
        Entry e = Hash.lookup(this.mainHash, key, (int)hc);
        if (e != null) {
            this.recordHit(e);
            return (E)e;
        }
        e = this.refreshHashCtrl.remove((Entry[])this.refreshHash, key, hc);
        if (e != null) {
            ++this.refreshHitCnt;
            this.mainHash = this.mainHashCtrl.insert((Entry[])this.mainHash, e);
            this.recordHit(e);
            return (E)e;
        }
        return null;
    }

    protected E newEntry(K key, int hc) {
        E e;
        if (this.getLocalSize() >= this.maxSize) {
            this.evictionNeeded = true;
        }
        if ((e = this.checkForGhost(key, hc)) == null) {
            e = this.newEntry();
            ((Entry)e).key = key;
            ((Entry)e).hashCode = hc;
            this.insertIntoReplacementList(e);
        }
        this.mainHash = this.mainHashCtrl.insert((Entry[])this.mainHash, (Entry)e);
        ++this.newEntryCnt;
        return e;
    }

    private boolean removeEntryFromHash(E e) {
        boolean f = this.mainHashCtrl.remove((Entry[])this.mainHash, (Entry)e) || this.refreshHashCtrl.remove((Entry[])this.refreshHash, (Entry)e);
        this.checkForHashCodeChange((Entry)e);
        this.cancelExpiryTimer((Entry)e);
        if (((Entry)e).isVirgin()) {
            ++this.virginEvictCnt;
        }
        ((Entry)e).setRemovedState();
        return f;
    }

    private void cancelExpiryTimer(Entry e) {
        if (e.task != null) {
            e.task.cancel();
            ++this.timerCancelCount;
            if (this.timerCancelCount >= 10000) {
                this.timer.purge();
                this.timerCancelCount = 0;
            }
            e.task = null;
        }
    }

    private void checkForHashCodeChange(Entry e) {
        if (this.modifiedHash(e.key.hashCode()) != e.hashCode && !e.isStale()) {
            if (this.keyMutationCount == 0L) {
                this.getLog().warn("Key mismatch! Key hashcode changed! keyClass=" + e.key.getClass().getName());
                try {
                    String s = e.key.toString();
                    if (s != null) {
                        this.getLog().warn("Key mismatch! key.toString(): " + s);
                    }
                }
                catch (Throwable t) {
                    this.getLog().warn("Key mismatch! key.toString() threw exception", t);
                }
            }
            ++this.keyMutationCount;
        }
    }

    static <K, T> long calcNextRefreshTime(K _key, T _newObject, long now, Entry _entry, EntryExpiryCalculator<K, T> ec, long _maxLinger, ExceptionExpiryCalculator<K> _exceptionEc, long _exceptionMaxLinger) {
        if (!(_newObject instanceof ExceptionWrapper)) {
            if (_maxLinger == 0L) {
                return 0L;
            }
            if (ec != null) {
                long t = ec.calculateExpiryTime(_key, _newObject, now, (CacheEntry)_entry);
                return BaseCache.limitExpiryToMaxLinger(now, _maxLinger, t);
            }
            if (_maxLinger > 0L) {
                return _maxLinger + now;
            }
            return -1L;
        }
        if (_exceptionMaxLinger == 0L) {
            return 0L;
        }
        if (_exceptionEc != null) {
            long t = _exceptionEc.calculateExpiryTime(_key, ((ExceptionWrapper)_newObject).getException(), now);
            return BaseCache.limitExpiryToMaxLinger(now, _exceptionMaxLinger, t);
        }
        if (_exceptionMaxLinger > 0L) {
            return _exceptionMaxLinger + now;
        }
        return _exceptionMaxLinger;
    }

    static long limitExpiryToMaxLinger(long now, long _maxLinger, long t) {
        if (_maxLinger > 0L) {
            long _tMaximum = _maxLinger + now;
            if (t > _tMaximum) {
                return _tMaximum;
            }
            if (t < -1L && -t > _tMaximum) {
                return -_tMaximum;
            }
        }
        return t;
    }

    protected long calcNextRefreshTime(K _key, T _newObject, long now, Entry _entry) {
        return BaseCache.calcNextRefreshTime(_key, _newObject, now, _entry, this.entryExpiryCalculator, this.maxLinger, this.exceptionExpiryCalculator, this.exceptionMaxLinger);
    }

    protected long fetch(E e) {
        if (this.storage != null) {
            return this.fetchWithStorage(e, true);
        }
        return this.fetchFromSource(e);
    }

    protected boolean conditionallyStartProcess(E e) {
        if (!((Entry)e).isVirgin()) {
            return false;
        }
        ((Entry)e).startFetch();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long fetchWithStorage(E e, boolean _needsFetch) {
        if (!((Entry)e).isVirgin()) {
            if (_needsFetch) {
                return this.fetchFromSource(e);
            }
            return 5L;
        }
        StorageEntry se = this.storage.get(((Entry)e).key);
        if (se == null) {
            if (_needsFetch) {
                Object object = this.lock;
                synchronized (object) {
                    ++this.loadMissCnt;
                }
                return this.fetchFromSource(e);
            }
            Object object = this.lock;
            synchronized (object) {
                this.touchedTime = System.currentTimeMillis();
                ++this.loadNonFreshCnt;
            }
            return 5L;
        }
        return this.insertEntryFromStorage(se, e, _needsFetch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long insertEntryFromStorage(StorageEntry se, E e, boolean _needsFetch) {
        boolean _fetchAlways;
        boolean _expired;
        ((Entry)e).setLastModificationFromStorage(se.getCreatedOrUpdated());
        long now = System.currentTimeMillis();
        Object v = se.getValueOrException();
        long _nextRefreshTime = this.maxLinger == 0L ? 0L : Long.MAX_VALUE;
        long _expiryTimeFromStorage = se.getValueExpiryTime();
        boolean bl = _expired = _expiryTimeFromStorage != 0L && _expiryTimeFromStorage <= now;
        if (!_expired && this.timer != null) {
            _nextRefreshTime = this.calcNextRefreshTime(se.getKey(), v, se.getCreatedOrUpdated(), null);
            _expired = _nextRefreshTime > 32L && _nextRefreshTime <= now;
        }
        boolean bl2 = _fetchAlways = this.timer == null && this.maxLinger == 0L;
        if (_expired || _fetchAlways) {
            if (_needsFetch) {
                ((Entry)e).value = se.getValueOrException();
                ((Entry)e).setLoadedNonValidAndFetch();
                return this.fetchFromSource(e);
            }
            Object object = this.lock;
            synchronized (object) {
                this.touchedTime = now;
                ++this.loadNonFreshCnt;
            }
            return 5L;
        }
        return this.insert(e, se.getValueOrException(), 0L, now, (byte)1, _nextRefreshTime);
    }

    protected long fetchFromSource(E e) {
        Object v;
        long t0 = System.currentTimeMillis();
        try {
            if (this.source == null) {
                throw new CacheUsageExcpetion("source not set");
            }
            v = ((Entry)e).isVirgin() || ((Entry)e).hasException() ? this.source.get(((Entry)e).key, t0, null, ((Entry)e).getLastModification()) : this.source.get(((Entry)e).key, t0, ((Entry)e).getValue(), ((Entry)e).getLastModification());
            ((Entry)e).setLastModification(t0);
        }
        catch (Throwable _ouch) {
            v = new ExceptionWrapper(_ouch);
        }
        long t = System.currentTimeMillis();
        return this.insertFetched(e, v, t0, t);
    }

    protected final long insertFetched(E e, T v, long t0, long t) {
        return this.insert(e, v, t0, t, (byte)1);
    }

    protected final long insertOnPut(E e, T v, long t0, long t) {
        ((Entry)e).setLastModification(t0);
        return this.insert(e, v, t0, t, (byte)2);
    }

    protected final long insert(E e, T v, long t0, long t, byte _updateStatistics) {
        long _nextRefreshTime;
        long l = _nextRefreshTime = this.maxLinger == 0L ? 0L : Long.MAX_VALUE;
        if (this.timer != null) {
            _nextRefreshTime = ((Entry)e).isVirgin() || ((Entry)e).hasException() ? this.calcNextRefreshTime(((Entry)e).getKey(), v, t0, null) : this.calcNextRefreshTime(((Entry)e).getKey(), v, t0, (Entry)e);
        }
        return this.insert(e, v, t0, t, _updateStatistics, _nextRefreshTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long insert(E e, T _value, long t0, long t, byte _updateStatistics, long _nextRefreshTime) {
        long _nextRefreshTimeWithState;
        boolean _suppressException;
        if (_nextRefreshTime == -1L) {
            _nextRefreshTime = Long.MAX_VALUE;
        }
        boolean bl = _suppressException = _value instanceof ExceptionWrapper && this.hasSuppressExceptions() && ((Entry)e).getValue() != Entry.INITIAL_VALUE && !((Entry)e).hasException();
        if (!_suppressException) {
            ((Entry)e).value = _value;
        }
        CacheStorageException _storageException = null;
        if (this.storage != null && ((Entry)e).isDirty() && (_nextRefreshTime != 0L || this.hasKeepAfterExpired())) {
            try {
                this.storage.put((Entry)e, _nextRefreshTime);
            }
            catch (CacheStorageException ex) {
                _storageException = ex;
            }
            catch (Throwable ex) {
                _storageException = new CacheStorageException(ex);
            }
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkClosed();
            this.touchedTime = t;
            if (_updateStatistics == 1) {
                if (t0 == 0L) {
                    ++this.loadHitCnt;
                } else {
                    if (_suppressException) {
                        ++this.suppressedExceptionCnt;
                        ++this.fetchExceptionCnt;
                    } else if (_value instanceof ExceptionWrapper) {
                        Log log = this.getLog();
                        if (log.isDebugEnabled()) {
                            log.debug("caught exception, expires at: " + Util.formatMillis(_nextRefreshTime), ((ExceptionWrapper)_value).getException());
                        }
                        ++this.fetchExceptionCnt;
                    }
                    ++this.fetchCnt;
                    this.fetchMillis += t - t0;
                    if (((Entry)e).isGettingRefresh()) {
                        ++this.refreshCnt;
                    }
                    if (((Entry)e).isLoadedNonValidAndFetch()) {
                        ++this.loadNonFreshAndFetchedCnt;
                    } else if (!((Entry)e).isVirgin()) {
                        ++this.fetchButHitCnt;
                    }
                }
            } else if (_updateStatistics == 2) {
                ++this.putCnt;
                if (((Entry)e).isVirgin()) {
                    ++this.putNewEntryCnt;
                }
                if (((Entry)e).nextRefreshTime == 9L) {
                    ++this.peekHitNotFreshCnt;
                }
            }
            if (_storageException != null) {
                throw _storageException;
            }
            _nextRefreshTimeWithState = this.stopStartTimer(_nextRefreshTime, e, t);
        }
        return _nextRefreshTimeWithState;
    }

    protected long stopStartTimer(long _nextRefreshTime, E e, long now) {
        if (((Entry)e).task != null) {
            ((Entry)e).task.cancel();
        }
        if (this.hasSharpTimeout() && _nextRefreshTime > 32L) {
            _nextRefreshTime = -_nextRefreshTime;
        }
        if (this.timer != null && (_nextRefreshTime > 32L || _nextRefreshTime < -1L)) {
            if (_nextRefreshTime < -1L) {
                long _timerTime = -_nextRefreshTime - BaseCache.TUNABLE.sharpExpirySafetyGapMillis;
                if (_timerTime >= now) {
                    MyTimerTask tt = new MyTimerTask();
                    tt.entry = e;
                    this.timer.schedule((TimerTask)tt, new Date(_timerTime));
                    ((Entry)e).task = tt;
                    _nextRefreshTime = -_nextRefreshTime;
                }
            } else {
                MyTimerTask tt = new MyTimerTask();
                tt.entry = e;
                this.timer.schedule((TimerTask)tt, new Date(_nextRefreshTime));
                ((Entry)e).task = tt;
            }
        } else {
            _nextRefreshTime = _nextRefreshTime == Long.MAX_VALUE ? 16L : 3L;
        }
        return _nextRefreshTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timerEvent(E e, long _executionTime) {
        Object object;
        if (((Entry)e).isRemovedFromReplacementList()) {
            return;
        }
        if (this.refreshPool != null) {
            object = this.lock;
            synchronized (object) {
                if (this.isClosed()) {
                    return;
                }
                if (((Entry)e).task == null) {
                    return;
                }
                if (((Entry)e).isRemovedFromReplacementList()) {
                    return;
                }
                if (this.mainHashCtrl.remove((Entry[])this.mainHash, (Entry)e)) {
                    this.refreshHash = this.refreshHashCtrl.insert((Entry[])this.refreshHash, (Entry)e);
                    if (((Entry)e).hashCode != this.modifiedHash(((Entry)e).key.hashCode())) {
                        Object object2 = this.lock;
                        synchronized (object2) {
                            E e2 = e;
                            synchronized (e2) {
                                if (!((Entry)e).isRemovedState() && this.removeEntryFromHash(e)) {
                                    ++this.expiredRemoveCnt;
                                }
                            }
                        }
                        return;
                    }
                    Runnable r = new Runnable((Entry)e){
                        final /* synthetic */ Entry val$e;
                        {
                            this.val$e = entry;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Entry entry = this.val$e;
                            synchronized (entry) {
                                if (this.val$e.isRemovedFromReplacementList() || this.val$e.isRemovedState() || this.val$e.isFetchInProgress()) {
                                    return;
                                }
                                this.val$e.setGettingRefresh();
                            }
                            try {
                                long t = BaseCache.this.fetch(this.val$e);
                                this.val$e.finishFetch(t);
                            }
                            catch (CacheClosedException ignore) {
                            }
                            catch (Throwable ex) {
                                this.val$e.ensureFetchAbort(false);
                                Object object = BaseCache.this.lock;
                                synchronized (object) {
                                    ++BaseCache.this.internalExceptionCnt;
                                }
                                BaseCache.this.getLog().warn("Refresh exception", ex);
                                try {
                                    BaseCache.this.expireEntry(this.val$e);
                                }
                                catch (CacheClosedException cacheClosedException) {
                                    // empty catch block
                                }
                            }
                        }
                    };
                    boolean _submitOkay = this.refreshPool.submit(r);
                    if (_submitOkay) {
                        return;
                    }
                    ++this.refreshSubmitFailedCnt;
                }
            }
        }
        if (_executionTime < ((Entry)e).nextRefreshTime) {
            E e3 = e;
            synchronized (e3) {
                if (!((Entry)e).isRemovedState()) {
                    long t = System.currentTimeMillis();
                    if (t < ((Entry)e).nextRefreshTime) {
                        ((Entry)e).nextRefreshTime = -((Entry)e).nextRefreshTime;
                        return;
                    }
                    try {
                        this.expireEntry(e);
                    }
                    catch (CacheClosedException ignore) {
                        // empty catch block
                    }
                }
            }
            return;
        }
        object = e;
        synchronized (object) {
            long t = System.currentTimeMillis();
            if (t >= ((Entry)e).nextRefreshTime) {
                try {
                    this.expireEntry(e);
                }
                catch (CacheClosedException ignore) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expireEntry(E e) {
        E e2 = e;
        synchronized (e2) {
            if (((Entry)e).isRemovedState() || ((Entry)e).isExpiredState()) {
                return;
            }
            if (((Entry)e).isFetchInProgress()) {
                ((Entry)e).nextRefreshTime = 7L;
                return;
            }
            ((Entry)e).setExpiredState();
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                if (this.hasKeepAfterExpired()) {
                    ++this.expiredKeptCnt;
                } else if (this.removeEntry(e)) {
                    ++this.expiredRemoveCnt;
                }
            }
        }
    }

    protected final ClosableConcurrentHashEntryIterator<Entry> iterateAllHeapEntries() {
        return new ClosableConcurrentHashEntryIterator(this.mainHashCtrl, this.mainHash, this.refreshHashCtrl, this.refreshHash);
    }

    public void removeAllAtOnce(Set<K> _keys) {
    }

    public Map<K, T> getAll(K[] _keys) {
        return this.getAll(new HashSet<K>(Arrays.asList(_keys)));
    }

    public Map<K, T> getAll(final Set<? extends K> _keys) {
        Object[] ka = new Object[_keys.size()];
        int i = 0;
        for (K k : _keys) {
            ka[i++] = k;
        }
        Object[] va = new Object[ka.length];
        this.getBulk(ka, va, new BitSet(), 0, ka.length);
        return new AbstractMap<K, T>(){

            @Override
            public T get(Object key) {
                if (this.containsKey(key)) {
                    return BaseCache.this.get(key);
                }
                return null;
            }

            @Override
            public boolean containsKey(Object key) {
                return _keys.contains(key);
            }

            @Override
            public Set<Map.Entry<K, T>> entrySet() {
                return new AbstractSet<Map.Entry<K, T>>(){

                    @Override
                    public Iterator<Map.Entry<K, T>> iterator() {
                        return new Iterator<Map.Entry<K, T>>(){
                            Iterator<? extends K> it;
                            {
                                this.it = _keys.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it.hasNext();
                            }

                            @Override
                            public Map.Entry<K, T> next() {
                                final Object k = this.it.next();
                                final Object t = BaseCache.this.get(k);
                                return new Map.Entry<K, T>(){

                                    @Override
                                    public K getKey() {
                                        return k;
                                    }

                                    @Override
                                    public T getValue() {
                                        return t;
                                    }

                                    @Override
                                    public T setValue(T value) {
                                        throw new UnsupportedOperationException();
                                    }
                                };
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return _keys.size();
                    }
                };
            }
        };
    }

    public void getBulk(K[] _keys, T[] _result, BitSet _fetched, int s, int e) {
        this.sequentialGetFallBack(_keys, _result, _fetched, s, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sequentialFetch(E[] ea, K[] _keys, T[] _result, BitSet _fetched, int s, int end) {
        for (int i = s; i < end; ++i) {
            E e = ea[i];
            if (e == null || ((Entry)e).isDataValidState()) continue;
            E e2 = e;
            synchronized (e2) {
                if (!((Entry)e).isDataValidState()) {
                    this.fetch(e);
                }
                _result[i] = ((Entry)e).getValue();
                continue;
            }
        }
    }

    final void sequentialGetFallBack(K[] _keys, T[] _result, BitSet _fetched, int s, int e) {
        for (int i = s; i < e; ++i) {
            if (_fetched.get(i)) continue;
            try {
                _result[i] = this.get(_keys[i]);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
    }

    public abstract long getHitCnt();

    protected final int calculateHashEntryCount() {
        return Hash.calcEntryCount(this.mainHash) + Hash.calcEntryCount(this.refreshHash);
    }

    protected final int getLocalSize() {
        return this.mainHashCtrl.size + this.refreshHashCtrl.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getTotalEntryCount() {
        Object object = this.lock;
        synchronized (object) {
            if (this.storage != null) {
                return this.storage.getTotalEntryCount();
            }
            return this.getLocalSize();
        }
    }

    public long getExpiredCnt() {
        return this.expiredRemoveCnt + this.expiredKeptCnt;
    }

    public long getFetchesBecauseOfNewEntries() {
        return this.fetchCnt - this.fetchButHitCnt;
    }

    protected int getFetchesInFlight() {
        long _fetchesBecauseOfNoEntries = this.getFetchesBecauseOfNewEntries();
        return (int)(this.newEntryCnt - this.putNewEntryCnt - this.virginEvictCnt - this.loadNonFreshCnt - this.loadHitCnt - _fetchesBecauseOfNoEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return new IntegrityState().checkEquals("newEntryCnt - virginEvictCnt == getFetchesBecauseOfNewEntries() + getFetchesInFlight() + putNewEntryCnt + loadNonFreshCnt + loadHitCnt", this.newEntryCnt - this.virginEvictCnt, this.getFetchesBecauseOfNewEntries() + (long)this.getFetchesInFlight() + this.putNewEntryCnt + this.loadNonFreshCnt + this.loadHitCnt).checkLessOrEquals("getFetchesInFlight() <= 100", this.getFetchesInFlight(), 100).checkEquals("newEntryCnt == getSize() + evictedCnt + expiredRemoveCnt + removeCnt", this.newEntryCnt, (long)this.getLocalSize() + this.evictedCnt + this.expiredRemoveCnt + this.removedCnt).checkEquals("newEntryCnt == getSize() + evictedCnt + getExpiredCnt() - expiredKeptCnt + removeCnt", this.newEntryCnt, (long)this.getLocalSize() + this.evictedCnt + this.getExpiredCnt() - this.expiredKeptCnt + this.removedCnt).checkEquals("mainHashCtrl.size == Hash.calcEntryCount(mainHash)", this.mainHashCtrl.size, Hash.calcEntryCount(this.mainHash)).checkEquals("refreshHashCtrl.size == Hash.calcEntryCount(refreshHash)", this.refreshHashCtrl.size, Hash.calcEntryCount(this.refreshHash)).check("!!evictionNeeded | (getSize() <= maxSize)", this.evictionNeeded | this.getLocalSize() <= this.maxSize).check("storage => storage.getAlert() < 2", this.storage == null || this.storage.getAlert() < 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void checkIntegrity() {
        Object object = this.lock;
        synchronized (object) {
            IntegrityState is = this.getIntegrityState();
            if (is.getStateFlags() > 0L) {
                throw new CacheIntegrityError(is.getStateDescriptor(), is.getFailingChecks(), this.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Info getInfo() {
        Object object = this.lock;
        synchronized (object) {
            long t = System.currentTimeMillis();
            if (this.info != null && this.info.creationTime + (long)(this.info.creationDeltaMs * 17) + 333L > t) {
                return this.info;
            }
            this.info = this.getLatestInfo(t);
        }
        return this.info;
    }

    public final Info getLatestInfo() {
        return this.getLatestInfo(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Info getLatestInfo(long t) {
        Object object = this.lock;
        synchronized (object) {
            this.info = new Info();
            this.info.creationTime = t;
            this.info.creationDeltaMs = (int)(System.currentTimeMillis() - t);
            return this.info;
        }
    }

    protected String getExtraStatistics() {
        return "";
    }

    static String timestampToString(long t) {
        if (t == 0L) {
            return "-";
        }
        return Util.formatMillis(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            Info fo = this.getLatestInfo();
            return "Cache{" + this.name + "}" + "(" + "size=" + fo.getSize() + ", " + "maxSize=" + fo.getMaxSize() + ", " + "usageCnt=" + fo.getUsageCnt() + ", " + "missCnt=" + fo.getMissCnt() + ", " + "fetchCnt=" + fo.getFetchCnt() + ", " + "fetchButHitCnt=" + this.fetchButHitCnt + ", " + "heapHitCnt=" + fo.hitCnt + ", " + "virginEvictCnt=" + this.virginEvictCnt + ", " + "fetchesInFlightCnt=" + fo.getFetchesInFlightCnt() + ", " + "newEntryCnt=" + fo.getNewEntryCnt() + ", " + "bulkGetCnt=" + fo.getBulkGetCnt() + ", " + "refreshCnt=" + fo.getRefreshCnt() + ", " + "refreshSubmitFailedCnt=" + fo.getRefreshSubmitFailedCnt() + ", " + "refreshHitCnt=" + fo.getRefreshHitCnt() + ", " + "putCnt=" + fo.getPutCnt() + ", " + "putNewEntryCnt=" + fo.getPutNewEntryCnt() + ", " + "expiredCnt=" + fo.getExpiredCnt() + ", " + "evictedCnt=" + fo.getEvictedCnt() + ", " + "removedCnt=" + fo.getRemovedCnt() + ", " + "storageLoadCnt=" + fo.getStorageLoadCnt() + ", " + "storageMissCnt=" + fo.getStorageMissCnt() + ", " + "storageHitCnt=" + fo.getStorageHitCnt() + ", " + "hitRate=" + fo.getDataHitString() + ", " + "collisionCnt=" + fo.getCollisionCnt() + ", " + "collisionSlotCnt=" + fo.getCollisionSlotCnt() + ", " + "longestCollisionSize=" + fo.getLongestCollisionSize() + ", " + "hashQuality=" + fo.getHashQualityInteger() + ", " + "msecs/fetch=" + (fo.getMillisPerFetch() >= 0.0 ? Double.valueOf(fo.getMillisPerFetch()) : "-") + ", " + "created=" + BaseCache.timestampToString(fo.getStarted()) + ", " + "cleared=" + BaseCache.timestampToString(fo.getCleared()) + ", " + "touched=" + BaseCache.timestampToString(fo.getTouched()) + ", " + "fetchExceptionCnt=" + fo.getFetchExceptionCnt() + ", " + "suppressedExceptionCnt=" + fo.getSuppressedExceptionCnt() + ", " + "internalExceptionCnt=" + fo.getInternalExceptionCnt() + ", " + "keyMutationCnt=" + fo.getKeyMutationCnt() + ", " + "infoCreated=" + BaseCache.timestampToString(fo.getInfoCreated()) + ", " + "infoCreationDeltaMs=" + fo.getInfoCreationDeltaMs() + ", " + "impl=\"" + this.getClass().getSimpleName() + "\"" + this.getExtraStatistics() + ", " + "integrityState=" + fo.getIntegrityDescriptor() + ")";
        }
    }

    protected final int modifiedHash(int h) {
        h ^= this.hashSeed;
        h ^= h >>> 7;
        h ^= h >>> 15;
        return h;
    }

    public static class Tunable
    extends TunableConstants {
        public Class<? extends BaseCache> defaultImplementation = LruCache.class;
        public boolean logSourceExceptions = false;
        public int waitForTimerJobsSeconds = 5;
        public int maximumEntryLockSpins = 333333;
        public int maximumEvictSpins = 5;
        public int initialHashSize = 64;
        public int hashLoadPercent = 64;
        public boolean disableHashRandomization = false;
        public int hashSeed = 0;
        public long sharpExpirySafetyGapMillis = 666L;
    }

    protected class MyTimerTask
    extends TimerTask {
        E entry;

        protected MyTimerTask() {
        }

        @Override
        public void run() {
            BaseCache.this.timerEvent(this.entry, this.scheduledExecutionTime());
        }
    }

    static class CollisionInfo {
        int collisionCnt;
        int collisionSlotCnt;
        int longestCollisionSize;

        CollisionInfo() {
        }
    }

    public class Info {
        int size;
        long creationTime;
        int creationDeltaMs;
        long missCnt;
        long storageMissCnt;
        long storageLoadCnt;
        long newEntryCnt;
        long hitCnt;
        long usageCnt;
        CollisionInfo collisionInfo;
        String extraStatistics;
        int fetchesInFlight;
        IntegrityState integrityState;

        public Info() {
            this.size = BaseCache.this.getLocalSize();
            this.missCnt = BaseCache.this.fetchCnt - BaseCache.this.refreshCnt + BaseCache.this.peekHitNotFreshCnt + BaseCache.this.peekMissCnt;
            this.storageMissCnt = BaseCache.this.loadMissCnt + BaseCache.this.loadNonFreshCnt + BaseCache.this.loadNonFreshAndFetchedCnt;
            this.storageLoadCnt = this.storageMissCnt + BaseCache.this.loadHitCnt;
            this.newEntryCnt = BaseCache.this.newEntryCnt - BaseCache.this.virginEvictCnt;
            this.hitCnt = BaseCache.this.getHitCnt();
            this.usageCnt = this.hitCnt + this.newEntryCnt + BaseCache.this.peekMissCnt;
            this.fetchesInFlight = BaseCache.this.getFetchesInFlight();
            this.collisionInfo = new CollisionInfo();
            Hash.calcHashCollisionInfo(this.collisionInfo, BaseCache.this.mainHash);
            Hash.calcHashCollisionInfo(this.collisionInfo, BaseCache.this.refreshHash);
            this.extraStatistics = BaseCache.this.getExtraStatistics();
            if (this.extraStatistics.startsWith(", ")) {
                this.extraStatistics = this.extraStatistics.substring(2);
            }
            this.integrityState = BaseCache.this.getIntegrityState();
        }

        String percentString(double d) {
            String s = Double.toString(d);
            return (s.length() > 5 ? s.substring(0, 5) : s) + "%";
        }

        public String getName() {
            return BaseCache.this.name;
        }

        public String getImplementation() {
            return BaseCache.this.getClass().getSimpleName();
        }

        public int getSize() {
            return this.size;
        }

        public int getMaxSize() {
            return BaseCache.this.maxSize;
        }

        public long getStorageHitCnt() {
            return BaseCache.this.loadHitCnt;
        }

        public long getStorageLoadCnt() {
            return this.storageLoadCnt;
        }

        public long getStorageMissCnt() {
            return this.storageMissCnt;
        }

        public long getReadUsageCnt() {
            return this.usageCnt - BaseCache.this.putCnt;
        }

        public long getUsageCnt() {
            return this.usageCnt;
        }

        public long getMissCnt() {
            return this.missCnt;
        }

        public long getNewEntryCnt() {
            return this.newEntryCnt;
        }

        public long getFetchCnt() {
            return BaseCache.this.fetchCnt;
        }

        public int getFetchesInFlightCnt() {
            return this.fetchesInFlight;
        }

        public long getBulkGetCnt() {
            return BaseCache.this.bulkGetCnt;
        }

        public long getRefreshCnt() {
            return BaseCache.this.refreshCnt;
        }

        public long getInternalExceptionCnt() {
            return BaseCache.this.internalExceptionCnt;
        }

        public long getRefreshSubmitFailedCnt() {
            return BaseCache.this.refreshSubmitFailedCnt;
        }

        public long getSuppressedExceptionCnt() {
            return BaseCache.this.suppressedExceptionCnt;
        }

        public long getFetchExceptionCnt() {
            return BaseCache.this.fetchExceptionCnt;
        }

        public long getRefreshHitCnt() {
            return BaseCache.this.refreshHitCnt;
        }

        public long getExpiredCnt() {
            return BaseCache.this.getExpiredCnt();
        }

        public long getEvictedCnt() {
            return BaseCache.this.evictedCnt - BaseCache.this.virginEvictCnt;
        }

        public long getRemovedCnt() {
            return BaseCache.this.removedCnt;
        }

        public long getPutNewEntryCnt() {
            return BaseCache.this.putNewEntryCnt;
        }

        public long getPutCnt() {
            return BaseCache.this.putCnt;
        }

        public long getKeyMutationCnt() {
            return BaseCache.this.keyMutationCount;
        }

        public double getDataHitRate() {
            long cnt = this.getReadUsageCnt();
            return cnt == 0L ? 100.0 : (double)(cnt - this.missCnt) * 100.0 / (double)cnt;
        }

        public String getDataHitString() {
            return this.percentString(this.getDataHitRate());
        }

        public double getEntryHitRate() {
            return this.usageCnt == 0L ? 100.0 : (double)(this.usageCnt - this.newEntryCnt + BaseCache.this.putCnt) * 100.0 / (double)this.usageCnt;
        }

        public String getEntryHitString() {
            return this.percentString(this.getEntryHitRate());
        }

        public int getCollisionPercentage() {
            return (this.size - this.collisionInfo.collisionCnt) * 100 / this.size;
        }

        public int getSlotsPercentage() {
            return this.collisionInfo.collisionSlotCnt * 100 / this.collisionInfo.collisionCnt;
        }

        public int getHq0() {
            return Math.max(0, 105 - this.collisionInfo.longestCollisionSize * 5);
        }

        public int getHq1() {
            int _metricPercentageBase = 60;
            int m = this.getCollisionPercentage() * 40 / 100 + 60;
            m = Math.min(100, m);
            m = Math.max(0, m);
            return m;
        }

        public int getHq2() {
            int _metricPercentageBase = 80;
            int m = this.getSlotsPercentage() * 20 / 100 + 80;
            m = Math.min(100, m);
            m = Math.max(0, m);
            return m;
        }

        public int getHashQualityInteger() {
            int v;
            if (this.size == 0 || this.collisionInfo.collisionSlotCnt == 0) {
                return 100;
            }
            int _metric0 = this.getHq0();
            int _metric1 = this.getHq1();
            int _metric2 = this.getHq2();
            if (_metric1 < _metric0) {
                v = _metric0;
                _metric0 = _metric1;
                _metric1 = v;
            }
            if (_metric2 < _metric0) {
                v = _metric0;
                _metric0 = _metric2;
                _metric2 = v;
            }
            if (_metric2 < _metric1) {
                v = _metric1;
                _metric1 = _metric2;
                _metric2 = v;
            }
            if (_metric0 <= 0) {
                return 0;
            }
            _metric0 += (_metric1 - 50) * 5 / _metric0;
            _metric0 += (_metric2 - 50) * 2 / _metric0;
            _metric0 = Math.max(0, _metric0);
            _metric0 = Math.min(100, _metric0);
            return _metric0;
        }

        public double getMillisPerFetch() {
            return BaseCache.this.fetchCnt == 0L ? -1.0 : (double)BaseCache.this.fetchMillis * 1.0 / (double)BaseCache.this.fetchCnt;
        }

        public long getFetchMillis() {
            return BaseCache.this.fetchMillis;
        }

        public int getCollisionCnt() {
            return this.collisionInfo.collisionCnt;
        }

        public int getCollisionSlotCnt() {
            return this.collisionInfo.collisionSlotCnt;
        }

        public int getLongestCollisionSize() {
            return this.collisionInfo.longestCollisionSize;
        }

        public String getIntegrityDescriptor() {
            return this.integrityState.getStateDescriptor();
        }

        public long getStarted() {
            return BaseCache.this.startedTime;
        }

        public long getCleared() {
            return BaseCache.this.clearedTime;
        }

        public long getTouched() {
            return BaseCache.this.touchedTime;
        }

        public long getInfoCreated() {
            return this.creationTime;
        }

        public int getInfoCreationDeltaMs() {
            return this.creationDeltaMs;
        }

        public int getHealth() {
            if (BaseCache.this.storage != null && BaseCache.this.storage.getAlert() == 2) {
                return 2;
            }
            if (this.integrityState.getStateFlags() > 0L || this.getHashQualityInteger() < 5) {
                return 2;
            }
            if (BaseCache.this.storage != null && BaseCache.this.storage.getAlert() == 1) {
                return 1;
            }
            if (this.getHashQualityInteger() < 30 || this.getKeyMutationCnt() > 0L || this.getInternalExceptionCnt() > 0L) {
                return 1;
            }
            return 0;
        }

        public String getExtraStatistics() {
            return this.extraStatistics;
        }
    }

    class IteratorFilterEntry2Entry
    implements ClosableIterator<CacheEntry<K, T>> {
        ClosableIterator<Entry> iterator;
        Entry entry;

        IteratorFilterEntry2Entry(ClosableIterator<Entry> it) {
            this.iterator = it;
        }

        public boolean hasNext() {
            while (this.iterator.hasNext()) {
                this.entry = (Entry)this.iterator.next();
                if (!this.entry.hasFreshData()) continue;
                return true;
            }
            return false;
        }

        public void close() {
            if (this.iterator != null) {
                this.iterator.close();
                this.iterator = null;
            }
        }

        public CacheEntry<K, T> next() {
            return BaseCache.this.returnEntry(this.entry);
        }

        public void remove() {
            BaseCache.this.remove(this.entry.getKey());
        }
    }

    class StorageClearTask
    implements LimitedPooledExecutor.NeverRunInCallingTask<Void> {
        ClosableConcurrentHashEntryIterator<Entry> allLocalEntries;
        StorageAdapter storage;

        StorageClearTask() {
        }

        @Override
        public Void call() {
            try {
                if (this.allLocalEntries != null) {
                    this.waitForEntryOperations();
                }
                this.storage.clearAndReconnect();
                this.storage = null;
                return null;
            }
            catch (Throwable t) {
                if (this.allLocalEntries != null) {
                    this.allLocalEntries.close();
                }
                BaseCache.this.getLog().warn("clear exception, when signalling storage", t);
                this.storage.disable(t);
                throw new CacheStorageException(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForEntryOperations() {
            ClosableConcurrentHashEntryIterator<Entry> it = this.allLocalEntries;
            while (it.hasNext()) {
                Entry e;
                Entry entry = e = (Entry)it.next();
                synchronized (entry) {
                }
            }
        }
    }
}

