/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.cache2k.BulkCacheSource;
import org.cache2k.Cache;
import org.cache2k.CacheBuilder;
import org.cache2k.CacheConfig;
import org.cache2k.CacheManager;
import org.cache2k.CacheSource;
import org.cache2k.CacheSourceWithMetaInfo;
import org.cache2k.ExperimentalBulkCacheSource;
import org.cache2k.RefreshController;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheManagerImpl;

public class CacheBuilderImpl<K, T>
extends CacheBuilder<K, T> {
    String deriveNameFromStackTrace() {
        Exception ex = new Exception();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (e.getClassName().startsWith(((Object)((Object)this)).getClass().getPackage().getName())) continue;
            int idx = e.getClassName().lastIndexOf(46);
            String _simpleClassName = e.getClassName().substring(idx + 1);
            String _methodName = e.getMethodName();
            if (_methodName.equals("<init>")) {
                _methodName = "INIT";
            }
            if (_methodName == null || _methodName.length() <= 0) continue;
            return _simpleClassName + "." + _methodName + "" + "." + e.getLineNumber();
        }
        return null;
    }

    Object getConstructorParameter(Class<?> c) {
        if (CacheConfig.class.isAssignableFrom(c)) {
            return this.config;
        }
        if (RefreshController.class.isAssignableFrom(c)) {
            return this.refreshController;
        }
        if (CacheSource.class.isAssignableFrom(c)) {
            return this.cacheSource;
        }
        if (CacheSourceWithMetaInfo.class.isAssignableFrom(c)) {
            return this.cacheSourceWithMetaInfo;
        }
        if (ExperimentalBulkCacheSource.class.isAssignableFrom(c)) {
            return this.experimentalBulkCacheSource;
        }
        if (BulkCacheSource.class.isAssignableFrom(c)) {
            return this.bulkCacheSource;
        }
        return null;
    }

    Constructor<?> findConstructor(Class<?> c) {
        for (Constructor<?> ctr : c.getConstructors()) {
            Class<?>[] pt = ctr.getParameterTypes();
            if (pt == null || pt.length <= 0 || !CacheConfig.class.isAssignableFrom(pt[0])) continue;
            return ctr;
        }
        return null;
    }

    void confiugreViaSettersDirect(BaseCache c) {
        if (this.cacheSource != null) {
            c.setSource(this.cacheSource);
        }
        if (this.cacheSourceWithMetaInfo != null) {
            c.setSource(this.cacheSourceWithMetaInfo);
        }
        if (this.refreshController != null) {
            c.setRefreshController(this.refreshController);
        }
        if (this.entryExpiryCalculator != null) {
            c.setEntryExpiryCalculator(this.entryExpiryCalculator);
        }
        if (this.exceptionExpiryCalculator != null) {
            c.setExceptionExpiryCalculator(this.exceptionExpiryCalculator);
        }
        if (this.config != null) {
            c.setCacheConfig(this.config);
        }
        if (this.bulkCacheSource != null) {
            c.setBulkCacheSource(this.bulkCacheSource);
        }
        if (this.experimentalBulkCacheSource != null) {
            c.setExperimentalBulkCacheSource(this.experimentalBulkCacheSource);
        }
    }

    void configureViaSetters(Object o) {
        if (o instanceof BaseCache) {
            this.confiugreViaSettersDirect((BaseCache)o);
            return;
        }
        try {
            for (Method m : o.getClass().getMethods()) {
                Object p;
                Class<?>[] ps = m.getParameterTypes();
                if (ps == null || ps.length != 1 || !m.getName().startsWith("set") || (p = this.getConstructorParameter(ps[0])) == null) continue;
                m.invoke(o, p);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to configure cache", ex);
        }
    }

    protected Cache<K, T> constructImplementationAndFillParameters(Class<?> cls) {
        if (!Cache.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Specified impl not a cache" + cls.getName());
        }
        try {
            Cache _cache;
            Constructor<?> ctr = this.findConstructor(cls);
            if (ctr != null) {
                Class<?>[] pt = ctr.getParameterTypes();
                Object[] _args = new Object[pt.length];
                for (int i = 0; i < _args.length; ++i) {
                    _args[i] = this.getConstructorParameter(pt[i]);
                }
                _cache = (Cache)ctr.newInstance(_args);
            } else {
                _cache = (Cache)cls.newInstance();
            }
            return _cache;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not able to instantiate cache implementation", e);
        }
    }

    public Cache<K, T> build() {
        this.config = this.createConfiguration();
        if (this.config.getName() == null) {
            this.config.setName(this.deriveNameFromStackTrace());
        }
        Class _implClass = BaseCache.TUNABLE.defaultImplementation;
        if (this.config.getImplementation() != null) {
            _implClass = this.config.getImplementation();
        }
        Cache<K, T> _cache = this.constructImplementationAndFillParameters(_implClass);
        CacheManagerImpl cm = null;
        if (_cache instanceof BaseCache) {
            cm = (CacheManagerImpl)CacheManager.getInstance();
            ((BaseCache)_cache).setCacheManager(cm);
        }
        this.configureViaSetters(_cache);
        if (cm != null) {
            cm.newCache(_cache);
        }
        if (_cache instanceof BaseCache) {
            ((BaseCache)_cache).init();
        }
        return _cache;
    }
}

