/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.cache2k.impl.CacheStorageException;
import org.cache2k.storage.CacheStorage;
import org.cache2k.storage.FlushableStorage;
import org.cache2k.storage.PurgeableStorage;
import org.cache2k.storage.StorageEntry;

public class ClearStorageBuffer
implements CacheStorage,
FlushableStorage,
PurgeableStorage {
    long operationsCnt = 0L;
    long operationsAtTransferStart = 0L;
    long sentOperationsCnt = 0L;
    long sendingStart = 0L;
    long microRate = 0L;
    long microWaitRest = 0L;
    boolean shouldStop = false;
    List<Op> operations = new ArrayList<Op>();
    Map<Object, StorageEntry> key2entry = new HashMap<Object, StorageEntry>();
    CacheStorage forwardStorage;
    CacheStorage nextStorage;
    Future<Void> clearThreadFuture;
    Throwable exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(FlushableStorage.FlushContext ctx, long now) throws Exception {
        boolean _forward;
        OpFlush op = null;
        Object object = this;
        synchronized (object) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                op = new OpFlush();
                this.addOp(op);
            }
        }
        if (_forward) {
            ((FlushableStorage)this.forwardStorage).flush(ctx, now);
        }
        object = op;
        synchronized (object) {
            op.wait();
            if (this.exception != null) {
                throw new CacheStorageException(this.exception);
            }
        }
        ((FlushableStorage)this.forwardStorage).flush(ctx, System.currentTimeMillis());
    }

    @Override
    public PurgeableStorage.PurgeResult purge(PurgeableStorage.PurgeContext ctx, long _valueExpiryTime, long _entryExpiryTime) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        boolean _forward;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                this.addOp(new OpClose());
            }
        }
        if (_forward) {
            this.forwardStorage.close();
        }
    }

    @Override
    public void clear() throws Exception {
        throw new IllegalStateException("never called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(StorageEntry e) throws Exception {
        boolean _forward;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                e = new CopyStorageEntry(e);
                this.key2entry.put(e.getKey(), e);
                this.addOp(new OpPut(e));
            }
        }
        if (_forward) {
            this.forwardStorage.put(e);
        } else {
            this.throttle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageEntry get(Object key) throws Exception {
        boolean _forward;
        StorageEntry e = null;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                this.addOp(new OpGet(key));
                e = this.key2entry.get(key);
            }
        }
        if (_forward) {
            e = this.forwardStorage.get(key);
        } else {
            this.throttle();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) throws Exception {
        boolean _forward;
        StorageEntry e = null;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                this.addOp(new OpRemove(key));
                e = this.key2entry.remove(key);
            }
        }
        if (_forward) {
            return this.forwardStorage.remove(key);
        }
        this.throttle();
        return e != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) throws Exception {
        boolean _forward;
        boolean b = false;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                this.addOp(new OpContains(key));
                b = this.key2entry.containsKey(key);
            }
        }
        if (_forward) {
            b = this.forwardStorage.contains(key);
        } else {
            this.throttle();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(CacheStorage.VisitContext ctx, CacheStorage.EntryFilter f, CacheStorage.EntryVisitor v) throws Exception {
        boolean _forward;
        ArrayList<StorageEntry> l = null;
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            boolean bl = _forward = this.forwardStorage != null;
            if (!_forward) {
                l = new ArrayList<StorageEntry>(this.key2entry.size());
                for (StorageEntry e : this.key2entry.values()) {
                    if (f != null && !f.shouldInclude(e.getKey())) continue;
                    l.add(e);
                }
            }
        }
        if (_forward) {
            this.forwardStorage.visit(ctx, f, v);
        } else {
            for (StorageEntry e : l) {
                if (ctx.shouldStop()) {
                    return;
                }
                v.visit(e);
            }
        }
    }

    @Override
    public int getEntryCount() {
        return this.key2entry.size();
    }

    private void addOp(Op op) {
        ++this.operationsCnt;
        this.operations.add(op);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void throttle() {
        long _waitMicros;
        if (this.sentOperationsCnt == 0L) {
            return;
        }
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            if (this.operationsCnt % 7L == 0L) {
                long _factor = 1000000L;
                long _refilledSinceTransferStart = this.operationsCnt - this.operationsAtTransferStart;
                if (_refilledSinceTransferStart > this.sentOperationsCnt) {
                    _factor = _refilledSinceTransferStart * 1000000L / this.sentOperationsCnt;
                }
                long _delta = System.currentTimeMillis() - this.sendingStart;
                this.microRate = _delta * _factor / this.sentOperationsCnt;
            }
            _waitMicros = this.microRate + this.microRate * 3L / 100L + this.microWaitRest;
            this.microWaitRest = _waitMicros % 1000000L;
        }
        try {
            long _millis = _waitMicros / 1000000L;
            Thread.sleep(_millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransfer() {
        ClearStorageBuffer clearStorageBuffer = this;
        synchronized (clearStorageBuffer) {
            this.sendingStart = System.currentTimeMillis();
            this.operationsAtTransferStart = this.operationsCnt;
        }
    }

    public boolean isTransferringToStorage() {
        return this.sendingStart > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transfer() throws Exception {
        CacheStorage _target = this.getOriginalStorage();
        block3: while (true) {
            List<Op> _workList;
            ClearStorageBuffer clearStorageBuffer = this;
            synchronized (clearStorageBuffer) {
                if (this.shouldStop) {
                    return;
                }
                if (this.operations.size() == 0) {
                    this.forwardStorage = this.nextStorage;
                    return;
                }
                _workList = this.operations;
                this.operations = new ArrayList<Op>();
            }
            Iterator<Op> i$ = _workList.iterator();
            do {
                if (!i$.hasNext()) continue block3;
                Op op = i$.next();
                ++this.sentOperationsCnt;
                op.execute(_target);
            } while (!this.shouldStop || this.exception == null);
            break;
        }
        throw new CacheStorageException(this.exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableOnFailure(Throwable t) {
        this.exception = t;
        this.shouldStop = true;
        Iterator<Op> i$ = this.operations.iterator();
        while (i$.hasNext()) {
            Op op;
            Op op2 = op = i$.next();
            synchronized (op2) {
                op.notifyAll();
            }
        }
        CacheStorage _storage = this.nextStorage;
        if (_storage instanceof ClearStorageBuffer) {
            ((ClearStorageBuffer)_storage).disableOnFailure(t);
        }
    }

    CacheStorage getOriginalStorage() {
        if (this.nextStorage instanceof ClearStorageBuffer) {
            return ((ClearStorageBuffer)this.nextStorage).getOriginalStorage();
        }
        return this.nextStorage;
    }

    void waitForAll() throws Exception {
        if (this.clearThreadFuture != null && !this.clearThreadFuture.isDone()) {
            this.clearThreadFuture.get();
        }
        if (this.nextStorage instanceof ClearStorageBuffer) {
            ((ClearStorageBuffer)this.nextStorage).waitForAll();
        }
    }

    CacheStorage getNextStorage() {
        return this.nextStorage;
    }

    static class CopyStorageEntry
    implements StorageEntry {
        Object key;
        Object value;
        long expiryTime;
        long createdOrUpdated;
        long lastUsed;
        long maxIdleTime;

        CopyStorageEntry(StorageEntry e) {
            this.key = e.getKey();
            this.value = e.getValueOrException();
            this.expiryTime = e.getValueExpiryTime();
            this.createdOrUpdated = e.getCreatedOrUpdated();
            this.lastUsed = e.getEntryExpiryTime();
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValueOrException() {
            return this.value;
        }

        @Override
        public long getCreatedOrUpdated() {
            return this.createdOrUpdated;
        }

        @Override
        public long getValueExpiryTime() {
            return this.expiryTime;
        }

        @Override
        public long getEntryExpiryTime() {
            return this.lastUsed;
        }
    }

    static class OpFlush
    extends Op {
        OpFlush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void execute(CacheStorage _target) throws Exception {
            OpFlush opFlush = this;
            synchronized (opFlush) {
                this.notify();
            }
        }

        public String toString() {
            return "OpFlush";
        }
    }

    static class OpClose
    extends Op {
        OpClose() {
        }

        @Override
        void execute(CacheStorage _target) throws Exception {
            _target.close();
        }

        public String toString() {
            return "OpClose";
        }
    }

    static class OpGet
    extends Op {
        Object key;

        OpGet(Object key) {
            this.key = key;
        }

        @Override
        void execute(CacheStorage _target) throws Exception {
            _target.get(this.key);
        }

        public String toString() {
            return "OpGet(key=" + this.key + ")";
        }
    }

    static class OpContains
    extends Op {
        Object key;

        OpContains(Object key) {
            this.key = key;
        }

        @Override
        void execute(CacheStorage _target) throws Exception {
            _target.contains(this.key);
        }

        public String toString() {
            return "OpContains(key=" + this.key + ")";
        }
    }

    static class OpRemove
    extends Op {
        Object key;

        OpRemove(Object key) {
            this.key = key;
        }

        @Override
        void execute(CacheStorage _target) throws Exception {
            _target.remove(this.key);
        }

        public String toString() {
            return "OpRemove(key=" + this.key + ")";
        }
    }

    static class OpPut
    extends Op {
        StorageEntry entry;

        OpPut(StorageEntry entry) {
            this.entry = entry;
        }

        @Override
        void execute(CacheStorage _target) throws Exception {
            _target.put(this.entry);
        }

        public String toString() {
            return "OpPut(key=" + this.entry.getKey() + ", value=" + this.entry.getValueOrException() + ")";
        }
    }

    static abstract class Op {
        Op() {
        }

        abstract void execute(CacheStorage var1) throws Exception;
    }
}

