/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.timer;

import org.cache2k.impl.timer.BaseTimerTask;
import org.cache2k.impl.timer.TimerPayloadListener;

public final class PayloadTask<T>
extends BaseTimerTask {
    T payload;
    TimerPayloadListener<T> listener;

    public PayloadTask(long time, T payload, TimerPayloadListener<T> listener) {
        super(time);
        this.payload = payload;
        this.listener = listener;
    }

    @Override
    protected boolean fire(long now) {
        TimerPayloadListener<T> l = this.listener;
        T pl = this.payload;
        if (l != null && pl != null) {
            l.fire(pl, this.time);
            return true;
        }
        return false;
    }

    @Override
    public void cancel() {
        this.listener = null;
        this.payload = null;
    }

    @Override
    public boolean isCancelled() {
        return this.listener == null;
    }
}

