/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.storage;

import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.cache2k.StorageConfiguration;
import org.cache2k.impl.ExceptionWrapper;
import org.cache2k.impl.util.TunableConstants;
import org.cache2k.impl.util.TunableFactory;
import org.cache2k.storage.ByteBufferInputStream;
import org.cache2k.storage.CacheStorage;
import org.cache2k.storage.CacheStorageContext;
import org.cache2k.storage.CacheStorageProviderWithVoidConfig;
import org.cache2k.storage.EntryExpiryUpdateableStorage;
import org.cache2k.storage.FlushableStorage;
import org.cache2k.storage.FreeSpaceMap;
import org.cache2k.storage.Marshaller;
import org.cache2k.storage.MarshallerFactory;
import org.cache2k.storage.SimpleSingleFileStorage;
import org.cache2k.storage.StandardMarshaller;
import org.cache2k.storage.StorageEntry;

public class ImageFileStorage
implements CacheStorage,
FlushableStorage,
EntryExpiryUpdateableStorage {
    static final int CHECKSUM_BYTES = 16;
    static final int DESCRIPTOR_COUNT = 2;
    static final String DESCRIPTOR_MAGIC = "CACHE2K STORAGE 00";
    static final Marshaller DESCRIPTOR_MARSHALLER;
    static final Marshaller DEFAULT_MARSHALLER;
    boolean dataLost = false;
    Tunable tunable = TunableFactory.get(Tunable.class);
    Marshaller keyMarshaller = DEFAULT_MARSHALLER;
    Marshaller valueMarshaller = DEFAULT_MARSHALLER;
    Marshaller universalMarshaller = DEFAULT_MARSHALLER;
    Marshaller exceptionMarshaller = DEFAULT_MARSHALLER;
    RandomAccessFile file;
    ByteBuffer buffer;
    public final FreeSpaceMap freeMap = new FreeSpaceMap();
    Map<Object, HeapEntry> values;
    final Object valuesLock = new Object();
    final Object commitLock = new Object();
    HashMap<Object, HeapEntry> newBufferEntries;
    HashMap<Object, HeapEntry> deletedBufferEntries;
    HashMap<Object, HeapEntry> entriesInEarlierIndex;
    HashMap<Object, HeapEntry> committedEntries;
    SlotBucket justUnusedSlots = new SlotBucket();
    Queue<SlotBucket> slotsToFreeQueue = new ArrayDeque<SlotBucket>();
    BufferDescriptor descriptor;
    String fileName;
    boolean readOnly;
    int entryCapacity = Integer.MAX_VALUE;
    long missCount = 0L;
    long hitCount = 0L;
    long putCount = 0L;
    long evictCount = 0L;
    long removeCount = 0L;
    long freedLastCommit = 0L;
    CacheStorageContext context;
    static final byte[] ZERO_LENGTH_BYTE_ARRAY;
    static final int TYPE_MASK = 3;
    static final int TYPE_NULL = 0;
    static final int TYPE_VALUE = 1;
    static final int TYPE_EXCEPTION = 2;
    static final int TYPE_UNIVERSAL = 3;
    static final int FLAG_HAS_VALUE_EXPIRY_TIME = 4;
    static final int FLAG_HAS_ENTRY_EXPIRY_TIME = 8;
    static final int FLAG_HAS_CREATED_OR_UPDATED = 32;

    public ImageFileStorage(Tunable t) throws IOException, ClassNotFoundException {
        this.tunable = t;
    }

    public ImageFileStorage() {
    }

    public void open(CacheStorageContext ctx, StorageConfiguration cfg) throws IOException {
        this.context = ctx;
        if (ctx.getProperties() != null) {
            this.tunable = TunableFactory.get(ctx.getProperties(), Tunable.class);
        }
        if (cfg.getStorageName() != null) {
            this.fileName = cfg.getStorageName();
        }
        if (this.fileName == null) {
            this.fileName = "cache2k-storage:" + ctx.getManagerName() + ":" + ctx.getCacheName();
        }
        if (cfg.getLocation() != null && cfg.getLocation().length() > 0) {
            File f = new File(cfg.getLocation());
            if (!f.isDirectory()) {
                throw new IllegalArgumentException("location is not directory");
            }
            this.fileName = f.getPath() + File.separator + this.fileName;
        }
        this.entryCapacity = cfg.getEntryCapacity();
        this.readOnly = cfg.isReadOnly();
        this.reopen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reopen() throws IOException {
        try {
            if (this.readOnly) {
                this.file = null;
                try {
                    this.file = new RandomAccessFile(this.fileName + ".img", "r");
                }
                catch (FileNotFoundException ignore) {}
            } else {
                this.file = new RandomAccessFile(this.fileName + ".img", "rw");
            }
            this.resetBufferFromFile();
            FreeSpaceMap ignore = this.freeMap;
            synchronized (ignore) {
                this.freeMap.init();
                this.freeMap.freeSpace(0L, (int)this.getFileLength());
            }
            this.values = this.entryCapacity == Integer.MAX_VALUE ? new HashMap<Object, HeapEntry>() : new LinkedHashMap<Object, HeapEntry>(100, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Object, HeapEntry> _eldest) {
                    if (ImageFileStorage.this.getEntryCount() > ImageFileStorage.this.entryCapacity) {
                        ImageFileStorage.this.evict(_eldest.getValue());
                        return true;
                    }
                    return false;
                }
            };
            this.newBufferEntries = new HashMap();
            this.deletedBufferEntries = new HashMap();
            this.justUnusedSlots = new SlotBucket();
            this.slotsToFreeQueue = new ArrayDeque<SlotBucket>();
            this.entriesInEarlierIndex = this.createEarlierIndexEntryHash();
            this.committedEntries = new HashMap();
            BufferDescriptor d = this.readLatestIntactBufferDescriptor();
            if (d != null) {
                try {
                    this.descriptor = d;
                    this.initializeFromDisk();
                }
                catch (IOException ex) {
                    System.err.println(this.fileName + " got IOException: " + ex);
                    d = null;
                    this.descriptor = null;
                }
            }
            if (d == null) {
                if (this.buffer.capacity() > 0) {
                    this.dataLost = true;
                }
                this.initializeNewStorage();
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    private long getFileLength() throws IOException {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    private void initializeFromDisk() throws IOException, ClassNotFoundException {
        MarshallerFactory _factory = this.context.getMarshallerFactory();
        this.keyMarshaller = _factory.createMarshaller(this.descriptor.keyMarshallerParameters);
        this.valueMarshaller = _factory.createMarshaller(this.descriptor.valueMarshallerParameters);
        this.exceptionMarshaller = _factory.createMarshaller(this.descriptor.exceptionMarshallerParameters);
        this.readIndex();
    }

    private void initializeNewStorage() throws IOException {
        this.descriptor = new BufferDescriptor();
        this.descriptor.storageCreated = System.currentTimeMillis();
        CacheStorageContext ctx = this.context;
        this.keyMarshaller = ctx.getMarshallerFactory().createMarshaller(ctx.getKeyType());
        this.valueMarshaller = ctx.getMarshallerFactory().createMarshaller(ctx.getValueType());
        this.exceptionMarshaller = ctx.getMarshallerFactory().createMarshaller(Throwable.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.commitLock;
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            Object object2 = this.valuesLock;
            synchronized (object2) {
                boolean _empty = this.values.size() == 0;
                this.fastClose();
                if (_empty) {
                    this.removeFiles();
                }
            }
        }
    }

    @Override
    public void clear() throws IOException {
        long _counters = this.putCount + this.missCount + this.hitCount + this.removeCount + this.evictCount;
        if (this.file != null) {
            this.fastClose();
        }
        this.removeFiles();
        this.reopen();
        try {
            Thread.sleep(7L);
        }
        catch (InterruptedException ignore) {
            // empty catch block
        }
        long _counters2 = this.putCount + this.missCount + this.hitCount + this.removeCount + this.evictCount;
        if (_counters2 != _counters) {
            throw new IllegalStateException("detected operations while clearing.");
        }
    }

    private void removeFiles() {
        boolean _deleted;
        boolean _ignore;
        for (int i = 0; i < 2; ++i) {
            _ignore = new File(this.fileName + "-" + i + ".dsc").delete();
        }
        int idx = this.descriptor.lastIndexFile;
        do {
            _deleted = new File(this.fileName + "-" + idx + ".idx").delete();
            if (--idx > 0) continue;
            idx = this.tunable.highestIndexNumber;
        } while (_deleted);
        _ignore = new File(this.fileName + ".img").delete();
    }

    private void resetBufferFromFile() throws IOException {
        this.buffer = !this.readOnly ? this.file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.file.length()) : (this.file == null ? ByteBuffer.allocate(0) : this.file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.file.length()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fastClose() throws IOException {
        Object object = this.valuesLock;
        synchronized (object) {
            this.values = null;
            this.freeMap.init();
            this.buffer = null;
            this.file.close();
            this.file = null;
            this.justUnusedSlots = null;
            this.slotsToFreeQueue = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageEntry get(Object key) throws IOException, ClassNotFoundException {
        HeapEntry be;
        Object object = this.valuesLock;
        synchronized (object) {
            be = this.values.get(key);
            if (be == null) {
                ++this.missCount;
                return null;
            }
            ++this.hitCount;
        }
        return this.returnEntry(be);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object key) throws IOException {
        Object object = this.valuesLock;
        synchronized (object) {
            if (!this.values.containsKey(key)) {
                ++this.missCount;
                return false;
            }
            ++this.hitCount;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key) throws IOException, ClassNotFoundException {
        Object object = this.valuesLock;
        synchronized (object) {
            HeapEntry be = this.values.remove(key);
            if (be == null) {
                return false;
            }
            this.reallyRemove(be);
            ++this.removeCount;
        }
        return true;
    }

    private void reallyRemove(HeapEntry be) {
        this.deletedBufferEntries.put(be.key, be);
        this.newBufferEntries.remove(be.key);
        this.justUnusedSlots.add(be);
    }

    private void evict(HeapEntry be) {
        this.reallyRemove(be);
        ++this.evictCount;
    }

    private DiskEntry returnEntry(HeapEntry be) throws IOException, ClassNotFoundException {
        ByteBuffer bb = this.buffer.duplicate();
        bb.position((int)be.position);
        DiskEntry e = new DiskEntry();
        e.entryExpiryTime = be.entryExpireTime;
        e.key = be.key;
        e.readMetaInfo(bb, this.descriptor.storageCreated);
        int _type = e.getValueTypeNumber();
        if (_type == 0) {
            return e;
        }
        bb.limit((int)(be.position + (long)be.size));
        e.value = _type == 1 ? this.valueMarshaller.unmarshall(bb) : new ExceptionWrapper((Throwable)this.exceptionMarshaller.unmarshall(bb));
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(StorageEntry e) throws IOException, ClassNotFoundException {
        Object object;
        int _type;
        Object o = e.getValueOrException();
        byte[] _marshalledValue = ZERO_LENGTH_BYTE_ARRAY;
        int _neededSize = 0;
        if (o == null) {
            _type = 0;
        } else {
            if (o instanceof ExceptionWrapper) {
                _type = 2;
                _marshalledValue = this.exceptionMarshaller.marshall(((ExceptionWrapper)o).getException());
            } else if (this.valueMarshaller.supports(o)) {
                _type = 1;
                _marshalledValue = this.valueMarshaller.marshall(o);
            } else {
                _type = 3;
                _marshalledValue = this.universalMarshaller.marshall(o);
            }
            _neededSize = _marshalledValue.length;
        }
        FreeSpaceMap.Slot s = this.reserveSpace(_neededSize += DiskEntry.calculateMetaInfoSize(e, this.descriptor.storageCreated, _type));
        ByteBuffer bb = this.buffer.duplicate();
        bb.position((int)s.position);
        DiskEntry.writeMetaInfo(bb, e, this.descriptor.storageCreated, _type);
        int _usedSize = (int)((long)bb.position() - s.position) + _marshalledValue.length;
        HeapEntry _newEntry = new HeapEntry(e.getKey(), s.position, _usedSize, e.getEntryExpiryTime());
        if (s.size != _usedSize) {
            s.size -= _usedSize;
            s.position += (long)_usedSize;
            object = this.freeMap;
            synchronized (object) {
                this.freeMap.put(s);
            }
        }
        bb.put(_marshalledValue);
        object = this.valuesLock;
        synchronized (object) {
            HeapEntry be = this.values.get(e.getKey());
            if (be != null) {
                this.justUnusedSlots.add(be);
            }
            this.deletedBufferEntries.remove(e.getKey());
            this.newBufferEntries.put(e.getKey(), _newEntry);
            this.values.put(e.getKey(), _newEntry);
            ++this.putCount;
        }
    }

    long calcSize(Collection<HeapEntry> set) {
        long v = 0L;
        if (set != null) {
            for (HeapEntry e : set) {
                v += (long)e.size;
            }
        }
        return v;
    }

    long calculateSpaceToFree() {
        long s = this.justUnusedSlots.getSpaceToFree();
        for (SlotBucket b : this.slotsToFreeQueue) {
            s += b.getSpaceToFree();
        }
        return s;
    }

    long calculateUsedSpace() {
        long s = 0L;
        s += this.calcSize(this.values.values());
        return s += this.calculateSpaceToFree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEntryCount() {
        Object object = this.valuesLock;
        synchronized (object) {
            return this.values.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFreeSpace() {
        FreeSpaceMap freeSpaceMap = this.freeMap;
        synchronized (freeSpaceMap) {
            return this.freeMap.getFreeSpace();
        }
    }

    public long getTotalValueSpace() {
        return this.buffer.capacity();
    }

    public int getUncommittedEntryCount() {
        return this.newBufferEntries.size() + this.deletedBufferEntries.size();
    }

    public boolean isDataLost() {
        return this.dataLost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FreeSpaceMap.Slot reserveSpace(int _neededSpace) throws IOException {
        FreeSpaceMap freeSpaceMap = this.freeMap;
        synchronized (freeSpaceMap) {
            FreeSpaceMap.Slot s = this.freeMap.findFree(_neededSpace);
            if (s != null) {
                return s;
            }
            if (this.readOnly) {
                throw new ReadOnlyBufferException();
            }
            long _length = this.file.length();
            s = this.freeMap.reserveSlotEndingAt(_length);
            if (s != null) {
                s.size += (_neededSpace -= s.size);
            } else {
                s = new FreeSpaceMap.Slot(_length, _neededSpace);
            }
            if (this.tunable.extensionSize >= 2) {
                s.size += this.tunable.extensionSize - 1;
                s.size -= s.size % this.tunable.extensionSize;
            }
            this.file.setLength(s.getNextPosition());
            this.resetBufferFromFile();
            return s;
        }
    }

    void readIndex() throws IOException, ClassNotFoundException {
        KeyIndexReader r = new KeyIndexReader();
        r.readKeyIndex();
        this.recalculateFreeSpaceMapAndRemoveDeletedEntries();
    }

    BufferDescriptor readLatestIntactBufferDescriptor() throws IOException, ClassNotFoundException {
        BufferDescriptor bd = null;
        for (int i = 0; i < 2; ++i) {
            try {
                BufferDescriptor bd2 = this.readDescriptor(i);
                if (bd2 == null || bd != null && bd.descriptorVersion >= bd2.descriptorVersion) continue;
                bd = bd2;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferDescriptor readDescriptor(int idx) throws IOException, ClassNotFoundException {
        File f = new File(this.fileName + "-" + idx + ".dsc");
        if (!f.exists()) {
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        try {
            for (int i = 0; i < DESCRIPTOR_MAGIC.length(); ++i) {
                if (DESCRIPTOR_MAGIC.charAt(i) == raf.read()) continue;
                BufferDescriptor bufferDescriptor = null;
                return bufferDescriptor;
            }
            byte[] _checkSumFirstBytes = new byte[16];
            raf.read(_checkSumFirstBytes);
            byte[] _serializedDescriptorObject = new byte[(int)(raf.length() - raf.getFilePointer())];
            raf.read(_serializedDescriptorObject);
            byte[] _refSum = this.calcCheckSum(_serializedDescriptorObject);
            for (int i = 0; i < 16; ++i) {
                if (_checkSumFirstBytes[i] == _refSum[i]) continue;
                BufferDescriptor bufferDescriptor = null;
                return bufferDescriptor;
            }
            BufferDescriptor bufferDescriptor = (BufferDescriptor)DESCRIPTOR_MARSHALLER.unmarshall(_serializedDescriptorObject);
            return bufferDescriptor;
        }
        finally {
            raf.close();
        }
    }

    void writeDescriptor() throws IOException {
        int idx = (int)(this.descriptor.descriptorVersion % 2L);
        RandomAccessFile raf = new RandomAccessFile(this.fileName + "-" + idx + ".dsc", "rw");
        raf.setLength(0L);
        for (int i = 0; i < DESCRIPTOR_MAGIC.length(); ++i) {
            raf.write(DESCRIPTOR_MAGIC.charAt(i));
        }
        byte[] _serializedDescriptorObject = DESCRIPTOR_MARSHALLER.marshall(this.descriptor);
        byte[] _checkSum = this.calcCheckSum(_serializedDescriptorObject);
        raf.write(_checkSum, 0, 16);
        raf.write(_serializedDescriptorObject);
        raf.close();
        ++this.descriptor.descriptorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recalculateFreeSpaceMapAndRemoveDeletedEntries() {
        FreeSpaceMap freeSpaceMap = this.freeMap;
        synchronized (freeSpaceMap) {
            HashSet<Object> _deletedKey = new HashSet<Object>();
            for (HeapEntry heapEntry : this.values.values()) {
                if (heapEntry.position < 0L) {
                    _deletedKey.add(heapEntry.key);
                    continue;
                }
                this.freeMap.allocateSpace(heapEntry.position, heapEntry.size);
            }
            for (HeapEntry heapEntry : _deletedKey) {
                this.values.remove(heapEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(FlushableStorage.FlushContext ctx, long now) throws IOException {
        Object object = this.commitLock;
        synchronized (object) {
            CommitWorker _worker;
            byte _earliestIndexBefore = this.descriptor.earliestIndexFile;
            if (this.isClosed()) {
                throw new IllegalStateException("storage closed");
            }
            Object object2 = this.valuesLock;
            synchronized (object2) {
                if (this.newBufferEntries.size() == 0 && this.deletedBufferEntries.size() == 0) {
                    return;
                }
                _worker = new CommitWorker();
                _worker.timestamp = now;
                _worker.newEntries = this.newBufferEntries;
                _worker.deletedEntries = this.deletedBufferEntries;
                _worker.workerFreeSlots = this.justUnusedSlots;
                this.justUnusedSlots = new SlotBucket();
                this.newBufferEntries = new HashMap();
                this.deletedBufferEntries = new HashMap();
                this.descriptor.entryCount = this.getEntryCount();
                this.descriptor.writtenTime = now;
            }
            this.file.getChannel().force(false);
            _worker.write();
            if (this.descriptor.keyMarshallerParameters == null) {
                this.descriptor.keyMarshallerParameters = this.keyMarshaller.getFactoryParameters();
                this.descriptor.valueMarshallerParameters = this.valueMarshaller.getFactoryParameters();
                this.descriptor.exceptionMarshallerParameters = this.exceptionMarshaller.getFactoryParameters();
                this.descriptor.keyType = this.context.getKeyType().getName();
                this.descriptor.valueType = this.context.getValueType().getName();
            }
            this.writeDescriptor();
            _worker.freeSpace();
            if (_earliestIndexBefore >= 0 && _earliestIndexBefore != this.descriptor.earliestIndexFile) {
                boolean _ignore = new File(this.generateIndexFileName(_earliestIndexBefore)).delete();
            }
            this.truncateFile();
        }
    }

    public boolean isClosed() {
        return this.file == null;
    }

    static void sortOut(Map<Object, HeapEntry> map, Set<Object> _keys) {
        for (Object k : _keys) {
            map.remove(k);
        }
    }

    private LinkedHashMap<Object, HeapEntry> createEarlierIndexEntryHash() {
        return new LinkedHashMap<Object, HeapEntry>(8, 0.75f, true);
    }

    String generateIndexFileName(byte _fileNo) {
        return this.fileName + "-" + _fileNo + ".idx";
    }

    byte[] calcCheckSum(byte[] ba) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("sha1");
            byte[] out = md.digest(ba);
            return out;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException("sha1 missing, never happens?!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(CacheStorage.VisitContext ctx, CacheStorage.EntryFilter f, final CacheStorage.EntryVisitor v) throws Exception {
        ArrayList<HeapEntry> _allEntries;
        Object object = this.valuesLock;
        synchronized (object) {
            _allEntries = new ArrayList<HeapEntry>(this.values.size());
            for (HeapEntry e : this.values.values()) {
                if (f != null && !f.shouldInclude(e.key)) continue;
                _allEntries.add(e);
            }
        }
        ExecutorService ex = ctx.getExecutorService();
        for (HeapEntry e : _allEntries) {
            if (ctx.shouldStop()) break;
            final HeapEntry be = e;
            Callable<Void> r = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    v.visit(ImageFileStorage.this.returnEntry(be));
                    return null;
                }
            };
            ex.submit(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateEntryExpireTime(Object key, long _millis) throws Exception {
        Object object = this.valuesLock;
        synchronized (object) {
            HeapEntry e = this.values.get(key);
            if (e != null) {
                e.entryExpireTime = _millis;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void truncateFile() throws IOException {
        FreeSpaceMap freeSpaceMap = this.freeMap;
        synchronized (freeSpaceMap) {
            FreeSpaceMap.Slot s = this.freeMap.getHighestSlot();
            if (s != null && s.getNextPosition() == this.file.length()) {
                this.freeMap.allocateSpace(s);
                this.context.getLog().info("Truncating file from size " + this.file.length() + " to " + s.getPosition());
                this.file.setLength(s.getPosition());
                this.file.getChannel().force(true);
                this.resetBufferFromFile();
            }
        }
    }

    public long getPutCnt() {
        return this.putCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long _smallestSlot;
        long _largestSlot;
        long _freeSlots;
        long _freeSpace;
        long _totalValueSpace;
        long _spaceToFree;
        if (this.isClosed()) {
            return "DirectFileStorage(fileName=" + this.fileName + ", CLOSED)";
        }
        FreeSpaceMap _freeMapCopy = this.freeMap;
        Map<Object, HeapEntry> _valuesCopy = this.values;
        if (_freeMapCopy == null || _valuesCopy == null) {
            return "DirectFileStorage(fileName=" + this.fileName + ", UNKOWN)";
        }
        Object object = this.commitLock;
        synchronized (object) {
            Object object2 = this.valuesLock;
            synchronized (object2) {
                _spaceToFree = this.calculateSpaceToFree();
                _totalValueSpace = this.getTotalValueSpace();
            }
        }
        FreeSpaceMap freeSpaceMap = _freeMapCopy;
        synchronized (freeSpaceMap) {
            _freeSpace = _freeMapCopy.getFreeSpace();
            _freeSlots = _freeMapCopy.getSlotCount();
            _largestSlot = _freeMapCopy.getSizeOfLargestSlot();
            _smallestSlot = _freeMapCopy.getSizeOfSmallestSlot();
        }
        return "DirectFileStorage(fileName=" + this.fileName + ", " + "entryCapacity=" + this.entryCapacity + ", " + "entryCnt=" + _valuesCopy.size() + ", " + "totalSpace=" + this.getTotalValueSpace() + ", " + "usedSpace=" + (_totalValueSpace - _freeSpace) + ", " + "freeSpace=" + _freeSpace + ", " + "spaceToFree=" + _spaceToFree + ", " + "freeSlots=" + _freeSlots + ", " + "smallestSlot=" + _smallestSlot + ", " + "largestSlot=" + _largestSlot + ", " + "hitCnt=" + this.hitCount + ", " + "missCnt=" + this.missCount + ", " + "putCnt=" + this.putCount + ", " + "evictCnt=" + this.evictCount + ", " + "removeCnt=" + this.removeCount + ", " + "bufferDescriptor=" + this.descriptor + ")";
    }

    public static long readCompressedLong(ByteBuffer b) {
        short s = b.getShort();
        if (s >= 0) {
            return s;
        }
        long v = s & Short.MAX_VALUE;
        s = b.getShort();
        if (s >= 0) {
            return v | (long)s << 15;
        }
        v |= ((long)s & 0x7FFFL) << 15;
        s = b.getShort();
        if (s >= 0) {
            return v | (long)s << 30;
        }
        v |= ((long)s & 0x7FFFL) << 30;
        s = b.getShort();
        if (s >= 0) {
            return v | (long)s << 45;
        }
        v |= ((long)s & 0x7FFFL) << 45;
        s = b.getShort();
        return v | (long)s << 60;
    }

    public static void writeCompressedLong(ByteBuffer b, long v) {
        long s = v & 0x7FFFL;
        while (s != v) {
            b.putShort((short)(s | 0x8000L));
            s = (v >>>= 15) & 0x7FFFL;
        }
        b.putShort((short)v);
    }

    public static int calculateCompressedLongSize(long v) {
        int cnt = 1;
        long s = v & 0x7FFFL;
        while (s != v) {
            ++cnt;
            s = (v >>>= 15) & 0x7FFFL;
        }
        return cnt << 1;
    }

    static {
        DEFAULT_MARSHALLER = DESCRIPTOR_MARSHALLER = new StandardMarshaller();
        ZERO_LENGTH_BYTE_ARRAY = new byte[0];
    }

    public static class Provider
    extends CacheStorageProviderWithVoidConfig
    implements SimpleSingleFileStorage {
        public ImageFileStorage create(CacheStorageContext ctx, StorageConfiguration cfg) throws IOException {
            ImageFileStorage img = new ImageFileStorage();
            img.open(ctx, cfg);
            return img;
        }
    }

    public static class Tunable
    extends TunableConstants {
        public int indexFileFactor = 3;
        public int rewriteCompleteFactor = 3;
        public int rewritePartialFactor = 2;
        public byte highestIndexNumber = (byte)127;
        public int extensionSize = 4096;
        public int freeSpaceAfterMillis = 15000;
    }

    public static class SlotBucket
    implements Iterable<FreeSpaceMap.Slot> {
        long time;
        Collection<FreeSpaceMap.Slot> slots = new ArrayList<FreeSpaceMap.Slot>();

        public void add(HeapEntry be) {
            this.add(be.position, be.size);
        }

        public void add(FreeSpaceMap.Slot s) {
            this.slots.add(s);
        }

        public void add(long _position, int _size) {
            this.add(new FreeSpaceMap.Slot(_position, _size));
        }

        public long getSpaceToFree() {
            long n = 0L;
            for (FreeSpaceMap.Slot s : this.slots) {
                n += (long)s.size;
            }
            return n;
        }

        @Override
        public Iterator<FreeSpaceMap.Slot> iterator() {
            return this.slots.iterator();
        }
    }

    static class DiskEntry
    implements StorageEntry {
        Object key;
        Object value;
        int flags;
        long valueExpiryTime;
        long createdOrUpdated;
        long entryExpiryTime;

        DiskEntry() {
        }

        public int getValueTypeNumber() {
            return this.flags & 3;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValueOrException() {
            return this.value;
        }

        @Override
        public long getCreatedOrUpdated() {
            return this.createdOrUpdated;
        }

        @Override
        public long getValueExpiryTime() {
            return this.valueExpiryTime;
        }

        @Override
        public long getEntryExpiryTime() {
            return this.entryExpiryTime;
        }

        void readMetaInfo(ByteBuffer bb, long _timeReference) {
            this.flags = bb.get();
            if ((this.flags & 0x20) > 0) {
                this.createdOrUpdated = ImageFileStorage.readCompressedLong(bb) + _timeReference;
                if ((this.flags & 4) > 0) {
                    this.valueExpiryTime = ImageFileStorage.readCompressedLong(bb) + this.createdOrUpdated;
                }
                if ((this.flags & 8) > 0) {
                    this.entryExpiryTime = ImageFileStorage.readCompressedLong(bb) + this.createdOrUpdated;
                }
                return;
            }
            if ((this.flags & 4) > 0) {
                this.valueExpiryTime = ImageFileStorage.readCompressedLong(bb) + _timeReference;
            }
            if ((this.flags & 8) > 0) {
                this.entryExpiryTime = ImageFileStorage.readCompressedLong(bb) + _timeReference;
            }
        }

        static void writeMetaInfo(ByteBuffer bb, StorageEntry e, long _timeReference, int _type) {
            int _flags = _type | (e.getEntryExpiryTime() != 0L ? 8 : 0) | (e.getCreatedOrUpdated() != 0L ? 32 : 0) | (e.getValueExpiryTime() != 0L ? 4 : 0);
            bb.put((byte)_flags);
            if ((_flags & 0x20) > 0) {
                ImageFileStorage.writeCompressedLong(bb, e.getCreatedOrUpdated() - _timeReference);
                if ((_flags & 4) > 0) {
                    ImageFileStorage.writeCompressedLong(bb, e.getValueExpiryTime() - e.getCreatedOrUpdated());
                }
                if ((_flags & 8) > 0) {
                    ImageFileStorage.writeCompressedLong(bb, e.getEntryExpiryTime() - e.getCreatedOrUpdated());
                }
                return;
            }
            if ((_flags & 4) > 0) {
                ImageFileStorage.writeCompressedLong(bb, e.getValueExpiryTime() - _timeReference);
            }
            if ((_flags & 8) > 0) {
                ImageFileStorage.writeCompressedLong(bb, e.getEntryExpiryTime() - _timeReference);
            }
        }

        static int calculateMetaInfoSize(StorageEntry e, long _timeReference, int _type) {
            int _flags = _type | (e.getEntryExpiryTime() != 0L ? 8 : 0) | (e.getValueExpiryTime() != 0L ? 4 : 0) | (e.getCreatedOrUpdated() != 0L ? 32 : 0);
            int cnt = 1;
            if ((_flags & 0x20) > 0) {
                cnt += ImageFileStorage.calculateCompressedLongSize(e.getCreatedOrUpdated() - _timeReference);
                if ((_flags & 4) > 0) {
                    cnt += ImageFileStorage.calculateCompressedLongSize(e.getValueExpiryTime() - e.getCreatedOrUpdated());
                }
                if ((_flags & 8) > 0) {
                    cnt += ImageFileStorage.calculateCompressedLongSize(e.getEntryExpiryTime() - e.getCreatedOrUpdated());
                }
                return cnt;
            }
            if ((_flags & 4) > 0) {
                cnt += ImageFileStorage.calculateCompressedLongSize(e.getValueExpiryTime() - _timeReference);
            }
            if ((_flags & 8) > 0) {
                cnt += ImageFileStorage.calculateCompressedLongSize(e.getEntryExpiryTime() - _timeReference);
            }
            return cnt;
        }

        public String toString() {
            return "DiskEntry(key=\"" + this.key + "\"" + ", " + "valueExpiryTime=" + this.valueExpiryTime + ", " + "entryExpiryTime=" + this.entryExpiryTime + ")";
        }
    }

    static class HeapEntry {
        Object key;
        long position;
        int size;
        long entryExpireTime;
        byte indexFileNumber = (byte)-1;

        HeapEntry(ObjectInput in) throws IOException, ClassNotFoundException {
            this.position = in.readLong();
            this.size = in.readInt();
            this.key = in.readObject();
            this.entryExpireTime = in.readLong();
        }

        HeapEntry(Object _key, long _position, int _size, long _entryExpireTime) {
            this.key = _key;
            this.position = _position;
            this.size = _size;
            this.entryExpireTime = _entryExpireTime;
        }

        void write(ObjectOutput out) throws IOException {
            out.writeLong(this.position);
            out.writeInt(this.size);
            out.writeObject(this.key);
            out.writeLong(this.entryExpireTime);
        }

        void writeDeleted(ObjectOutput out) throws IOException {
            out.writeLong(0L);
            out.writeInt(-1);
            out.writeObject(this.key);
            out.writeLong(0L);
        }

        boolean isDeleted() {
            return this.size < 0;
        }

        public String toString() {
            return "IndexEntry{key=" + this.key + ", position=" + this.position + ", size=" + this.size + '}';
        }
    }

    static class IndexChunkDescriptor {
        byte lastIndexFile;
        long lastKeyIndexPosition;
        int elementCount;

        IndexChunkDescriptor() {
        }

        void read(ByteBuffer buf) {
            this.lastIndexFile = buf.get();
            this.lastKeyIndexPosition = buf.getLong();
            this.elementCount = buf.getInt();
        }

        void write(DataOutput buf) throws IOException {
            buf.write(this.lastIndexFile);
            buf.writeLong(this.lastKeyIndexPosition);
            buf.writeInt(this.elementCount);
        }
    }

    static class BufferDescriptor
    implements Serializable {
        boolean clean = false;
        byte lastIndexFile = (byte)-1;
        byte earliestIndexFile = (byte)-1;
        long lastKeyIndexPosition = -1L;
        int indexEntries = 0;
        int entryCount = 0;
        int freeSpace = 0;
        long storageCreated;
        long descriptorVersion = 0L;
        long writtenTime;
        MarshallerFactory.Parameters keyMarshallerParameters;
        MarshallerFactory.Parameters valueMarshallerParameters;
        MarshallerFactory.Parameters exceptionMarshallerParameters;
        String keyType;
        String keyMarshallerType;
        String valueType;
        String valueMarshallerType;

        BufferDescriptor() {
        }

        public String toString() {
            return "BufferDescriptor{clean=" + this.clean + ", lastIndexFile=" + this.lastIndexFile + ", earliestIndexFile=" + this.earliestIndexFile + ", lastKeyIndexPosition=" + this.lastKeyIndexPosition + ", elementCount=" + this.entryCount + ", freeSpace=" + this.freeSpace + ", descriptorVersion=" + this.descriptorVersion + ", writtenTime=" + this.writtenTime + ", keyType='" + this.keyType + '\'' + ", keyMarshallerType='" + this.keyMarshallerType + '\'' + ", valueType='" + this.valueType + '\'' + ", valueMarshallerType='" + this.valueMarshallerType + '\'' + '}';
        }
    }

    class KeyIndexReader {
        byte currentlyReadingIndexFile = (byte)-1;
        RandomAccessFile randomAccessFile;
        ByteBuffer indexBuffer;
        Set<Object> readKeys = new HashSet<Object>();

        KeyIndexReader() {
        }

        void readKeyIndex() throws IOException, ClassNotFoundException {
            ImageFileStorage.this.entriesInEarlierIndex = new LinkedHashMap<Object, HeapEntry>();
            ImageFileStorage.this.committedEntries = new HashMap();
            byte _fileNo = ImageFileStorage.this.descriptor.lastIndexFile;
            long _keyPosition = ImageFileStorage.this.descriptor.lastKeyIndexPosition;
            while (true) {
                IndexChunkDescriptor d = this.readChunk(_fileNo, _keyPosition);
                if (this.readCompleted()) break;
                if (_fileNo != d.lastIndexFile) {
                    for (HeapEntry e : ImageFileStorage.this.committedEntries.values()) {
                        e.indexFileNumber = _fileNo;
                        ImageFileStorage.this.entriesInEarlierIndex.put(e.key, e);
                    }
                }
                _fileNo = d.lastIndexFile;
                _keyPosition = d.lastKeyIndexPosition;
            }
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
            if (ImageFileStorage.this.entriesInEarlierIndex == ImageFileStorage.this.committedEntries) {
                ImageFileStorage.this.entriesInEarlierIndex = new HashMap();
            }
        }

        private boolean readCompleted() {
            return ImageFileStorage.this.values.size() >= ImageFileStorage.this.descriptor.entryCount || ImageFileStorage.this.values.size() >= ImageFileStorage.this.entryCapacity;
        }

        void openFile(byte _fileNo) throws IOException {
            if (this.randomAccessFile != null) {
                this.randomAccessFile.close();
            }
            ImageFileStorage.this.entriesInEarlierIndex = new HashMap();
            this.randomAccessFile = new RandomAccessFile(ImageFileStorage.this.generateIndexFileName(_fileNo), "r");
            this.indexBuffer = this.randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, this.randomAccessFile.length());
            this.currentlyReadingIndexFile = _fileNo;
        }

        IndexChunkDescriptor readChunk(byte _fileNo, long _position) throws IOException, ClassNotFoundException {
            if (this.currentlyReadingIndexFile != _fileNo) {
                this.openFile(_fileNo);
            }
            this.indexBuffer.position((int)_position);
            IndexChunkDescriptor d = new IndexChunkDescriptor();
            d.read(this.indexBuffer);
            ObjectInput in = ImageFileStorage.this.keyMarshaller.startInput(new ByteBufferInputStream(this.indexBuffer));
            int cnt = d.elementCount;
            int _readCnt = this.readKeys.size();
            do {
                HeapEntry e = new HeapEntry(in);
                if (this.readKeys.contains(e.key)) continue;
                e.indexFileNumber = _fileNo;
                this.readKeys.add(e.key);
                ImageFileStorage.this.entriesInEarlierIndex.put(e.key, e);
                if (!e.isDeleted()) {
                    ImageFileStorage.this.values.put(e.key, e);
                }
                if (this.readCompleted()) break;
            } while (--cnt > 0);
            in.close();
            if (_readCnt == this.readKeys.size()) {
                throw new IOException("no new data, at index: " + _fileNo + "/" + _position);
            }
            return d;
        }
    }

    class CommitWorker {
        long timestamp;
        RandomAccessFile randomAccessFile;
        HashMap<Object, HeapEntry> newEntries;
        HashMap<Object, HeapEntry> deletedEntries;
        HashMap<Object, HeapEntry> rewriteEntries = new HashMap();
        SlotBucket workerFreeSlots;
        byte indexFileNo;
        long position;
        boolean forceNewFile = false;

        CommitWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void write() throws IOException {
            this.indexFileNo = ImageFileStorage.this.descriptor.lastIndexFile;
            this.checkForEntriesToRewrite();
            this.checkStartNewIndex();
            if (this.forceNewFile) {
                for (HeapEntry e : ImageFileStorage.this.committedEntries.values()) {
                    e.indexFileNumber = this.indexFileNo;
                    ImageFileStorage.this.entriesInEarlierIndex.put(e.key, e);
                }
                ImageFileStorage.this.committedEntries = new HashMap();
                ImageFileStorage.this.descriptor.indexEntries = 0;
            }
            try {
                this.openFile();
                this.writeIndexChunk();
            }
            finally {
                if (this.randomAccessFile != null) {
                    this.randomAccessFile.close();
                }
            }
            this.updateCommittedEntries();
            ImageFileStorage.sortOut(ImageFileStorage.this.entriesInEarlierIndex, ImageFileStorage.this.committedEntries.keySet());
            ImageFileStorage.this.descriptor.indexEntries += this.totalEntriesToWrite();
            ImageFileStorage.this.descriptor.lastKeyIndexPosition = this.position;
            ImageFileStorage.this.descriptor.lastIndexFile = this.indexFileNo;
            Iterator<HeapEntry> it = ImageFileStorage.this.entriesInEarlierIndex.values().iterator();
            if (it.hasNext()) {
                HeapEntry _earliestEntry = it.next();
                ImageFileStorage.this.descriptor.earliestIndexFile = _earliestEntry.indexFileNumber;
            } else {
                ImageFileStorage.this.descriptor.earliestIndexFile = this.indexFileNo;
            }
        }

        private int totalEntriesToWrite() {
            return this.newEntries.size() + this.deletedEntries.size() + this.rewriteEntries.size();
        }

        void writeIndexChunk() throws IOException {
            IndexChunkDescriptor d = new IndexChunkDescriptor();
            d.lastIndexFile = ImageFileStorage.this.descriptor.lastIndexFile;
            d.lastKeyIndexPosition = ImageFileStorage.this.descriptor.lastKeyIndexPosition;
            d.elementCount = this.totalEntriesToWrite();
            d.write(this.randomAccessFile);
            FileOutputStream out = new FileOutputStream(this.randomAccessFile.getFD());
            ObjectOutput oos = ImageFileStorage.this.keyMarshaller.startOutput(out);
            for (HeapEntry e : this.newEntries.values()) {
                e.write(oos);
            }
            for (HeapEntry e : this.deletedEntries.values()) {
                e.writeDeleted(oos);
            }
            for (HeapEntry e : this.rewriteEntries.values()) {
                e.write(oos);
            }
            oos.close();
            out.close();
        }

        void openFile() throws IOException {
            if (this.indexFileNo == -1 || this.forceNewFile) {
                this.position = 0L;
                this.indexFileNo = this.indexFileNo == ImageFileStorage.this.tunable.highestIndexNumber ? (byte)0 : (byte)(this.indexFileNo + 1);
                String _name = ImageFileStorage.this.generateIndexFileName(this.indexFileNo);
                this.randomAccessFile = new RandomAccessFile(_name, "rw");
                this.randomAccessFile.seek(0L);
                this.randomAccessFile.setLength(0L);
            } else {
                String _name = ImageFileStorage.this.generateIndexFileName(this.indexFileNo);
                this.randomAccessFile = new RandomAccessFile(_name, "rw");
                this.position = this.randomAccessFile.length();
                this.randomAccessFile.seek(this.position);
            }
        }

        private void checkForEntriesToRewrite() {
            if (ImageFileStorage.this.entriesInEarlierIndex.size() > 0) {
                ImageFileStorage.sortOut(ImageFileStorage.this.entriesInEarlierIndex, this.newEntries.keySet());
                ImageFileStorage.sortOut(ImageFileStorage.this.entriesInEarlierIndex, this.deletedEntries.keySet());
                int _writeCnt = this.newEntries.size() + this.deletedEntries.size();
                if (_writeCnt * ImageFileStorage.this.tunable.rewriteCompleteFactor >= ImageFileStorage.this.entriesInEarlierIndex.size()) {
                    this.rewriteEntries = ImageFileStorage.this.entriesInEarlierIndex;
                    ImageFileStorage.this.entriesInEarlierIndex = ImageFileStorage.this.createEarlierIndexEntryHash();
                } else {
                    this.rewriteEntries = new HashMap();
                    Iterator<HeapEntry> it = ImageFileStorage.this.entriesInEarlierIndex.values().iterator();
                    for (int cnt = _writeCnt * ImageFileStorage.this.tunable.rewritePartialFactor; cnt > 0 && it.hasNext(); --cnt) {
                        HeapEntry e = it.next();
                        this.rewriteEntries.put(e.key, e);
                    }
                    ImageFileStorage.sortOut(ImageFileStorage.this.entriesInEarlierIndex, this.rewriteEntries.keySet());
                }
            }
        }

        void checkStartNewIndex() {
            int _totalEntriesInIndexFile = ImageFileStorage.this.descriptor.indexEntries + this.totalEntriesToWrite();
            if (_totalEntriesInIndexFile > ImageFileStorage.this.descriptor.entryCount * ImageFileStorage.this.tunable.indexFileFactor) {
                this.forceNewFile = true;
            }
        }

        void updateCommittedEntries() {
            ImageFileStorage.this.committedEntries.putAll(this.newEntries);
            for (Object k : this.deletedEntries.keySet()) {
                ImageFileStorage.this.committedEntries.put(k, new HeapEntry(k, 0L, -1, 0L));
            }
            ImageFileStorage.this.committedEntries.putAll(this.rewriteEntries);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void freeSpace() {
            this.workerFreeSlots.time = this.timestamp;
            ImageFileStorage.this.slotsToFreeQueue.add(this.workerFreeSlots);
            SlotBucket b = ImageFileStorage.this.slotsToFreeQueue.peek();
            long _freed = 0L;
            while (b.time + (long)ImageFileStorage.this.tunable.freeSpaceAfterMillis <= this.timestamp) {
                b = ImageFileStorage.this.slotsToFreeQueue.remove();
                FreeSpaceMap freeSpaceMap = ImageFileStorage.this.freeMap;
                synchronized (freeSpaceMap) {
                    for (FreeSpaceMap.Slot s : b) {
                        ImageFileStorage.this.freeMap.freeSpace(s);
                        _freed += (long)s.getSize();
                    }
                }
                b = ImageFileStorage.this.slotsToFreeQueue.peek();
            }
            ImageFileStorage.this.freedLastCommit = _freed;
        }
    }
}

