/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.cli.model;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.vertexium.Direction;
import org.vertexium.Edge;
import org.vertexium.FetchHint;
import org.vertexium.Property;
import org.vertexium.Vertex;
import org.vertexium.cli.VertexiumScript;
import org.vertexium.cli.model.LazyEdge;
import org.vertexium.cli.model.LazyVertexProperty;
import org.vertexium.cli.model.ModelBase;
import org.vertexium.util.IterableUtils;

public class LazyVertex
extends ModelBase {
    private final String vertexId;

    public LazyVertex(String vertexId) {
        this.vertexId = vertexId;
    }

    public String toString() {
        Vertex v = this.getV();
        if (v == null) {
            return null;
        }
        return LazyVertex.toString(v);
    }

    public static String toString(Vertex v) {
        LazyEdge lazyEdge;
        String otherVertexId;
        String edgeIndexString;
        boolean isHidden;
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.println("@|bold " + v.getId() + "|@");
        writer.println("  @|bold hidden:|@ " + v.isHidden(LazyVertex.getAuthorizations()));
        writer.println("  @|bold visibility:|@ " + v.getVisibility());
        writer.println("  @|bold timestamp:|@ " + VertexiumScript.timestampToString(v.getTimestamp()));
        writer.println("  @|bold hidden visibilities:|@");
        List hiddenVisibilities = IterableUtils.toList((Iterable)v.getHiddenVisibilities());
        if (hiddenVisibilities.size() == 0) {
            writer.println("    none");
        } else {
            for (Object hiddenVisibility : hiddenVisibilities) {
                writer.println("    " + hiddenVisibility.getVisibilityString());
            }
        }
        writer.println("  @|bold properties:|@");
        VertexiumScript.getContextProperties().clear();
        int propIndex = 0;
        for (Property prop : v.getProperties()) {
            String propertyIndexString = "p" + propIndex;
            String valueString = VertexiumScript.valueToString(prop.getValue(), false);
            isHidden = prop.isHidden(LazyVertex.getAuthorizations());
            writer.println("    @|bold " + propertyIndexString + ":|@ " + prop.getName() + ":" + prop.getKey() + "[" + prop.getVisibility().getVisibilityString() + "] " + "= " + valueString + (isHidden ? " @|red (hidden)|@" : ""));
            LazyVertexProperty lazyProperty = new LazyVertexProperty(v.getId(), prop.getKey(), prop.getName(), prop.getVisibility());
            VertexiumScript.getContextProperties().put(propertyIndexString, lazyProperty);
            ++propIndex;
        }
        VertexiumScript.getContextEdges().clear();
        int edgeIndex = 0;
        writer.println("  @|bold out edges:|@");
        for (Edge edge : v.getEdges(Direction.OUT, FetchHint.ALL_INCLUDING_HIDDEN, LazyVertex.getTime(), LazyVertex.getAuthorizations())) {
            edgeIndexString = "e" + edgeIndex;
            isHidden = edge.isHidden(LazyVertex.getAuthorizations());
            try {
                otherVertexId = edge.getOtherVertexId(v.getId());
                writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> " + otherVertexId + (isHidden ? " @|red (hidden)|@" : ""));
            }
            catch (Exception ex) {
                writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> @|red " + ex.getMessage() + "|@" + (isHidden ? " @|red (hidden)|@" : ""));
            }
            lazyEdge = new LazyEdge(edge.getId());
            VertexiumScript.getContextEdges().put(edgeIndexString, lazyEdge);
            ++edgeIndex;
        }
        writer.println("  @|bold in edges:|@");
        for (Edge edge : v.getEdges(Direction.IN, FetchHint.ALL_INCLUDING_HIDDEN, LazyVertex.getTime(), LazyVertex.getAuthorizations())) {
            edgeIndexString = "e" + edgeIndex;
            isHidden = edge.isHidden(LazyVertex.getAuthorizations());
            try {
                otherVertexId = edge.getOtherVertexId(v.getId());
                writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> " + otherVertexId + (isHidden ? " @|red (hidden)|@" : ""));
            }
            catch (Exception ex) {
                writer.println("    @|bold " + edgeIndexString + ":|@ " + edge.getId() + ": " + edge.getLabel() + " -> @|red " + ex.getMessage() + "|@" + (isHidden ? " @|red (hidden)|@" : ""));
            }
            lazyEdge = new LazyEdge(edge.getId());
            VertexiumScript.getContextEdges().put(edgeIndexString, lazyEdge);
            ++edgeIndex;
        }
        return out.toString();
    }

    private Vertex getV() {
        return this.getGraph().getVertex(this.getId(), FetchHint.ALL_INCLUDING_HIDDEN, LazyVertex.getTime(), LazyVertex.getAuthorizations());
    }

    public String getId() {
        return this.vertexId;
    }

    public void delete() {
        this.getGraph().deleteVertex(this.getV(), LazyVertex.getAuthorizations());
        this.getGraph().flush();
    }
}

