/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.internal.io;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;

public class Serialization {
    private SerializationFactory serializationFactory;

    public Serialization(Configuration conf) {
        this.serializationFactory = new SerializationFactory(conf);
    }

    public <T> T copy(T orig, T copy) {
        Deserializer deserializer;
        Serializer serializer;
        if (copy != null && orig.getClass() != copy.getClass()) {
            throw new IllegalArgumentException(orig.getClass() + " != " + copy.getClass());
        }
        Class<?> clazz = orig.getClass();
        String errorMsg = "No applicable class implementing Serialization in conf at io.serializations: " + clazz;
        try {
            serializer = this.serializationFactory.getSerializer(clazz);
            deserializer = this.serializationFactory.getDeserializer(clazz);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(errorMsg, e);
        }
        Preconditions.checkState((serializer != null ? 1 : 0) != 0, (Object)errorMsg);
        Preconditions.checkState((deserializer != null ? 1 : 0) != 0, (Object)errorMsg);
        try {
            DataOutputBuffer outputBuffer = new DataOutputBuffer();
            serializer.open((OutputStream)outputBuffer);
            serializer.serialize(orig);
            DataInputBuffer inputBuffer = new DataInputBuffer();
            inputBuffer.reset(outputBuffer.getData(), outputBuffer.getLength());
            deserializer.open((InputStream)inputBuffer);
            return (T)deserializer.deserialize(copy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <T> T copy(T orig) {
        return this.copy(orig, null);
    }

    public <T> T copyWithConf(T orig, Configuration conf) {
        this.serializationFactory = new SerializationFactory(conf);
        return this.copy(orig);
    }
}

