/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit.types;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mrunit.internal.io.Serialization;
import org.apache.hadoop.mrunit.types.Pair;

public class KeyValueReuseList<K, V>
extends ArrayList<Pair<K, V>> {
    private static final long serialVersionUID = 1192028416166671770L;
    private final K keyContainer;
    private final V valueContainer;
    private final Serialization serialization;

    public KeyValueReuseList(K keyContainer, V valueContainer, Configuration conf) {
        this.serialization = new Serialization(conf);
        this.keyContainer = keyContainer;
        this.valueContainer = valueContainer;
    }

    public K getCurrentKey() {
        return this.keyContainer;
    }

    public KeyValueReuseList<K, V> clone(Configuration conf) {
        K key = this.serialization.copy(this.keyContainer);
        V value = this.serialization.copy(this.valueContainer);
        KeyValueReuseList<K, V> clone = new KeyValueReuseList<K, V>(key, value, conf);
        for (Pair pair : this) {
            clone.add(new Pair(this.serialization.copy(pair.getFirst()), this.serialization.copy(pair.getSecond())));
        }
        return clone;
    }

    public Iterator<V> valueIterator() {
        return new Iterator<V>(){
            private K key;
            private V value;
            private final Iterator<Pair<K, V>> delegate;
            {
                this.key = KeyValueReuseList.this.keyContainer;
                this.value = KeyValueReuseList.this.valueContainer;
                this.delegate = KeyValueReuseList.this.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public V next() {
                Pair p = this.delegate.next();
                this.key = KeyValueReuseList.this.serialization.copy(p.getFirst(), this.key);
                this.value = KeyValueReuseList.this.serialization.copy(p.getSecond(), this.value);
                return this.value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

