/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.util.Comparator;
import net.fortytwo.ripple.ListNode;

public class ListMemoizer<T, M> {
    private final Comparator<T> comparator;
    private ListMemoizerHelper helper;

    public ListMemoizer(Comparator<T> comparator) {
        this.comparator = comparator;
        this.helper = null;
    }

    public M get(ListNode<T> list) {
        if (null == list) {
            throw new IllegalArgumentException("null key");
        }
        return null == this.helper ? null : (M)this.helper.get(list);
    }

    public boolean put(ListNode<T> list, M memo) {
        if (null == list) {
            throw new IllegalArgumentException("null key");
        }
        if (list.isNil()) {
            throw new IllegalArgumentException("the empty list cannot be memoized");
        }
        if (null == this.helper) {
            this.helper = new ListMemoizerHelper(list, memo);
            return true;
        }
        return this.helper.put(list, memo);
    }

    public boolean remove(ListNode<T> list) {
        if (null == list) {
            throw new IllegalArgumentException("null key");
        }
        return !list.isNil() && null != this.helper && this.helper.remove(list);
    }

    private class ListMemoizerHelper {
        private final T first;
        private M memo;
        private ListMemoizerHelper left;
        private ListMemoizerHelper right;
        private ListMemoizerHelper rest;

        public ListMemoizerHelper(ListNode<T> list, M memo) {
            this.first = list.getFirst();
            this.left = null;
            this.right = null;
            ListNode r = list.getRest();
            if (r.isNil()) {
                this.rest = null;
                this.memo = memo;
            } else {
                this.rest = new ListMemoizerHelper(r, memo);
                this.memo = null;
            }
        }

        public boolean remove(ListNode<T> list) {
            int cmp = ListMemoizer.this.comparator.compare(this.first, list.getFirst());
            if (0 == cmp) {
                ListNode r = list.getRest();
                if (r.isNil()) {
                    if (null != this.memo) {
                        this.memo = null;
                        return true;
                    }
                    return false;
                }
                return null != this.rest && this.rest.remove(r);
            }
            if (cmp < 0) {
                return null != this.left && this.left.remove(list);
            }
            return null != this.right && this.right.remove(list);
        }

        public boolean put(ListNode<T> list, M memo) {
            int cmp = ListMemoizer.this.comparator.compare(this.first, list.getFirst());
            if (0 == cmp) {
                ListNode r = list.getRest();
                if (r.isNil()) {
                    if (null == this.memo) {
                        this.memo = memo;
                        return true;
                    }
                    return false;
                }
                if (null == this.rest) {
                    this.rest = new ListMemoizerHelper(r, memo);
                    return true;
                }
                return this.rest.put(r, memo);
            }
            if (cmp < 0) {
                if (null == this.left) {
                    this.left = new ListMemoizerHelper(list, memo);
                    return true;
                }
                return this.left.put(list, memo);
            }
            if (null == this.right) {
                this.right = new ListMemoizerHelper(list, memo);
                return true;
            }
            return this.right.put(list, memo);
        }

        public M get(ListNode<T> list) {
            if (list.isNil()) {
                return null;
            }
            int cmp = ListMemoizer.this.comparator.compare(this.first, list.getFirst());
            if (0 == cmp) {
                ListNode r = list.getRest();
                if (r.isNil()) {
                    return this.memo;
                }
                return null == this.rest ? null : (Object)this.rest.get(r);
            }
            if (cmp < 0) {
                return null == this.left ? null : (Object)this.left.get(list);
            }
            return null == this.right ? null : (Object)this.right.get(list);
        }

        private int compare(ListMemoizerHelper first, ListMemoizerHelper second) {
            if (null == first) {
                return null == second ? 0 : -1;
            }
            if (null == second) {
                return 1;
            }
            return first.compareTo(second);
        }

        private int compareTo(ListMemoizerHelper other) {
            int cmp = ListMemoizer.this.comparator.compare(this.first, other.first);
            if (0 != cmp) {
                return cmp;
            }
            cmp = this.compare(this.left, other.left);
            if (0 != cmp) {
                return cmp;
            }
            cmp = this.compare(this.rest, other.rest);
            if (0 != cmp) {
                return cmp;
            }
            cmp = this.compare(this.right, other.right);
            return cmp;
        }
    }
}

