/*
 * Decompiled with CFR 0.152.
 */
package net.fortytwo.ripple;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.fortytwo.ripple.RippleException;

public final class StringUtils {
    private static final String UTF_8 = "UTF-8";
    private static final int FOUR = 4;
    private static final int EIGHT = 8;
    private static final int SIXTEEN = 16;
    private static final MessageDigest SHA1_DIGEST;
    private static final MessageDigest MD5_DIGEST;

    private StringUtils() {
    }

    public static String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String escapeURIString(String s) {
        StringBuilder sb = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\\': {
                    sb.append("\\\\");
                    continue block4;
                }
                case '>': {
                    sb.append("\\>");
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeString(String s) throws RippleException {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('\\' == c) {
                switch (s.charAt(++i)) {
                    case '\\': {
                        sb.append('\\');
                        continue block10;
                    }
                    case '\'': {
                        sb.append('\'');
                        continue block10;
                    }
                    case '\"': {
                        sb.append('\"');
                        continue block10;
                    }
                    case 't': {
                        sb.append('\t');
                        continue block10;
                    }
                    case 'n': {
                        sb.append('\n');
                        continue block10;
                    }
                    case 'r': {
                        sb.append('\r');
                        continue block10;
                    }
                    case 'u': {
                        String seq = s.substring(i + 1, i + 4 + 1);
                        sb.append(StringUtils.toUnicodeChar(seq));
                        i += 4;
                        continue block10;
                    }
                    case 'U': {
                        String seq = s.substring(i + 1, i + 8 + 1);
                        sb.append(StringUtils.toUnicodeChar(seq));
                        i += 8;
                        continue block10;
                    }
                    default: {
                        throw new RippleException("bad escape sequence: \\" + s.charAt(i) + " at character " + (i - 1) + " in string: " + s);
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unescapeUriString(String s) throws RippleException {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('\\' == c) {
                switch (s.charAt(++i)) {
                    case '\\': {
                        sb.append('\\');
                        continue block6;
                    }
                    case '>': {
                        sb.append('>');
                        continue block6;
                    }
                    case 'u': {
                        String seq = s.substring(i + 1, i + 4 + 1);
                        sb.append(StringUtils.toUnicodeChar(seq));
                        i += 4;
                        continue block6;
                    }
                    case 'U': {
                        String seq = s.substring(i + 1, i + 8 + 1);
                        sb.append(StringUtils.toUnicodeChar(seq));
                        i += 8;
                        continue block6;
                    }
                    default: {
                        throw new RippleException("bad escape sequence: \\" + s.charAt(i + 1));
                    }
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String percentEncode(String s) throws RippleException {
        return StringUtils.urlEncode(s).replaceAll("\\+", "%20");
    }

    public static String percentDecode(String s) throws RippleException {
        return StringUtils.urlDecode(s);
    }

    private static String urlEncode(String s) throws RippleException {
        try {
            return URLEncoder.encode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RippleException(e);
        }
    }

    private static String urlDecode(String s) throws RippleException {
        try {
            return URLDecoder.decode(s, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RippleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sha1SumOf(String plaintext) throws RippleException {
        try {
            MessageDigest messageDigest = SHA1_DIGEST;
            synchronized (messageDigest) {
                SHA1_DIGEST.update(plaintext.getBytes(UTF_8));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RippleException(e);
        }
        byte[] digest = SHA1_DIGEST.digest();
        String coded = "";
        for (byte b : digest) {
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            hex = hex.substring(hex.length() - 2);
            coded = coded + hex;
        }
        return coded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String md5SumOf(String plaintext) throws RippleException {
        try {
            MessageDigest messageDigest = MD5_DIGEST;
            synchronized (messageDigest) {
                MD5_DIGEST.update(plaintext.getBytes(UTF_8));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RippleException(e);
        }
        byte[] digest = MD5_DIGEST.digest();
        String coded = "";
        for (byte b : digest) {
            String hex = Integer.toHexString(b);
            if (hex.length() == 1) {
                hex = "0" + hex;
            }
            hex = hex.substring(hex.length() - 2);
            coded = coded + hex;
        }
        return coded;
    }

    private static char toUnicodeChar(String unicode) throws RippleException {
        try {
            return (char)Integer.parseInt(unicode, 16);
        }
        catch (NumberFormatException e) {
            throw new RippleException(e);
        }
    }

    static {
        try {
            SHA1_DIGEST = MessageDigest.getInstance("SHA");
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

